/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.network;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.network.ConnectionQuotaEntity;
import org.apache.kafka.network.ConnectionThrottledException;
import org.apache.kafka.network.GenericConnectionQuotaEntity;
import org.apache.kafka.network.TenantConnectionThrottledException;

public class TenantQuotaEntity
implements ConnectionQuotaEntity,
GenericConnectionQuotaEntity {
    private final String lkc;

    public TenantQuotaEntity(String lkc) {
        this.lkc = lkc;
    }

    @Override
    public String rateSensorName() {
        return "Connection-Accept-Rate-" + this.lkc;
    }

    @Override
    public String countSensorName() {
        return "Connection-Count-" + this.lkc;
    }

    @Override
    public long sensorExpiration() {
        return INACTIVE_SENSOR_EXPIRATION_TIME_SECONDS;
    }

    @Override
    public String quotaMetricName() {
        return "connection-tokens";
    }

    @Override
    public String countMetricName() {
        return "authenticated-unthrottled-connection-count";
    }

    @Override
    public Map<String, String> metricTags() {
        return Collections.singletonMap("tenant", this.lkc);
    }

    @Override
    public String domain() {
        return "tenant";
    }

    @Override
    public String entityName() {
        return this.lkc;
    }

    @Override
    public ConnectionThrottledException throttledException(String entity, long startThrottleTimeMs, long throttleTimeMs) {
        return new TenantConnectionThrottledException(entity, startThrottleTimeMs, throttleTimeMs);
    }
}

