/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.security;

import java.util.Collection;
import java.util.Properties;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;

public class CredentialProvider {
    public final DelegationTokenCache tokenCache;
    public final CredentialCache credentialCache = new CredentialCache();

    public CredentialProvider(Collection<String> scramMechanisms, DelegationTokenCache tokenCache) {
        this.tokenCache = tokenCache;
        ScramCredentialUtils.createCache((CredentialCache)this.credentialCache, scramMechanisms);
    }

    public void updateCredentials(String username, Properties config) {
        for (ScramMechanism mechanism : ScramMechanism.values()) {
            CredentialCache.Cache cache = this.credentialCache.cache(mechanism.mechanismName(), ScramCredential.class);
            if (cache == null) continue;
            String c = config.getProperty(mechanism.mechanismName());
            if (c == null) {
                cache.remove(username);
                continue;
            }
            cache.put(username, (Object)ScramCredentialUtils.credentialFromString((String)c));
        }
    }

    public void updateCredential(org.apache.kafka.clients.admin.ScramMechanism mechanism, String name, ScramCredential credential) {
        CredentialCache.Cache cache = this.credentialCache.cache(mechanism.mechanismName(), ScramCredential.class);
        cache.put(name, (Object)credential);
    }

    public void removeCredentials(org.apache.kafka.clients.admin.ScramMechanism mechanism, String name) {
        CredentialCache.Cache cache = this.credentialCache.cache(mechanism.mechanismName(), ScramCredential.class);
        if (cache != null) {
            cache.remove(name);
        }
    }

    public CredentialCache credentialCache() {
        return this.credentialCache;
    }
}

