/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.config;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.server.config.BrokerBackpressureConfig;
import org.apache.kafka.server.config.DiskUsageBasedThrottlingConfig;

public class ClientQuotaManagerConfig {
    public static final int INACTIVE_SENSOR_EXPIRATION_TIME_SECONDS = 3600;
    public static final double NANOS_TO_PERCENTAGE_PER_SECOND = 100.0 / (double)TimeUnit.SECONDS.toNanos(1L);
    public static final BrokerBackpressureConfig DEFAULT_BROKER_BACKPRESSURE_CONFIG = new BrokerBackpressureConfig();
    public static final DiskUsageBasedThrottlingConfig DEFAULT_DISK_USAGE_BASED_THROTTLING_CONFIG = new DiskUsageBasedThrottlingConfig();
    public static final double DEFAULT_BROKER_QUOTA_LIMIT = 9.223372036854776E18;
    public static final long DEFAULT_CONSUMPTION_REPORTING_INTEVAL_MS = 0L;
    public static final int DEFAULT_MIN_REPORTED_USAGE = 0;
    public final int numQuotaSamples;
    public final int quotaWindowSizeSeconds;
    public final BrokerBackpressureConfig brokerBackpressureConfig;
    public final DiskUsageBasedThrottlingConfig diskUsageBasedThrottlingConfig;
    public final double brokerQuotaLimit;
    public final long consumptionReportingIntervalMs;
    public final int minReportedUsage;
    public final long maxThrottleTimeMs;

    public ClientQuotaManagerConfig(int numQuotaSamples, int quotaWindowSizeSeconds, BrokerBackpressureConfig brokerBackpressureConfig, DiskUsageBasedThrottlingConfig diskUsageBasedThrottlingConfig, double brokerQuotaLimit, long consumptionReportingIntervalMs, int minReportedUsage, long maxThrottleTimeMs) {
        this.numQuotaSamples = numQuotaSamples;
        this.quotaWindowSizeSeconds = quotaWindowSizeSeconds;
        this.brokerBackpressureConfig = brokerBackpressureConfig;
        this.diskUsageBasedThrottlingConfig = diskUsageBasedThrottlingConfig;
        this.brokerQuotaLimit = brokerQuotaLimit;
        this.consumptionReportingIntervalMs = consumptionReportingIntervalMs;
        this.minReportedUsage = minReportedUsage;
        this.maxThrottleTimeMs = maxThrottleTimeMs;
    }

    public ClientQuotaManagerConfig() {
        this(11);
    }

    public ClientQuotaManagerConfig(BrokerBackpressureConfig brokerBackpressureConfig) {
        this(brokerBackpressureConfig, 9.223372036854776E18);
    }

    public ClientQuotaManagerConfig(BrokerBackpressureConfig brokerBackpressureConfig, double brokerQuotaLimit) {
        this(11, brokerBackpressureConfig, brokerQuotaLimit);
    }

    public ClientQuotaManagerConfig(int numQuotaSamples, BrokerBackpressureConfig brokerBackpressureConfig, double brokerQuotaLimit) {
        this(numQuotaSamples, 1, brokerBackpressureConfig, DEFAULT_DISK_USAGE_BASED_THROTTLING_CONFIG, brokerQuotaLimit, 0L, 0, Long.MAX_VALUE);
    }

    public ClientQuotaManagerConfig(int numQuotaSamples) {
        this(numQuotaSamples, 9.223372036854776E18);
    }

    public ClientQuotaManagerConfig(int numQuotaSamples, double brokerQuotaLimit) {
        this(numQuotaSamples, DEFAULT_BROKER_BACKPRESSURE_CONFIG, brokerQuotaLimit);
    }

    public ClientQuotaManagerConfig(int numQuotaSamples, int quotaWindowSizeSeconds) {
        this(numQuotaSamples, quotaWindowSizeSeconds, Long.MAX_VALUE);
    }

    public ClientQuotaManagerConfig(int numQuotaSamples, int quotaWindowSizeSeconds, long maxThrottleTimeMs) {
        this(numQuotaSamples, quotaWindowSizeSeconds, DEFAULT_BROKER_BACKPRESSURE_CONFIG, DEFAULT_DISK_USAGE_BASED_THROTTLING_CONFIG, 9.223372036854776E18, 0L, 0, maxThrottleTimeMs);
    }

    public ClientQuotaManagerConfig(int numQuotaSamples, double brokerQuotaLimit, long consumptionReportingIntervalMs, int minReportedUsage) {
        this(numQuotaSamples, 1, DEFAULT_BROKER_BACKPRESSURE_CONFIG, DEFAULT_DISK_USAGE_BASED_THROTTLING_CONFIG, brokerQuotaLimit, consumptionReportingIntervalMs, minReportedUsage, Long.MAX_VALUE);
    }

    public ClientQuotaManagerConfig(BrokerBackpressureConfig brokerBackpressureConfig, DiskUsageBasedThrottlingConfig diskUsageBasedThrottlingConfig) {
        this(11, brokerBackpressureConfig, diskUsageBasedThrottlingConfig);
    }

    public ClientQuotaManagerConfig(int numQuotaSamples, BrokerBackpressureConfig brokerBackpressureConfig, DiskUsageBasedThrottlingConfig diskUsageBasedThrottlingConfig) {
        this(numQuotaSamples, 1, brokerBackpressureConfig, diskUsageBasedThrottlingConfig, 9.223372036854776E18, 0L, 0, Long.MAX_VALUE);
    }

    public String toString() {
        return "ClientQuotaManagerConfig{numQuotaSamples=" + this.numQuotaSamples + ", quotaWindowSizeSeconds=" + this.quotaWindowSizeSeconds + ", brokerBackpressureConfig=" + this.brokerBackpressureConfig + ", diskUsageBasedThrottlingConfig=" + this.diskUsageBasedThrottlingConfig + ", brokerQuotaLimit=" + this.brokerQuotaLimit + ", consumptionReportingIntervalMs=" + this.consumptionReportingIntervalMs + ", minReportedUsage=" + this.minReportedUsage + ", maxThrottleTimeMs=" + this.maxThrottleTimeMs + '}';
    }
}

