/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.rest.datapreview.extension.util;

import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.SimpleConfig;

public class PreviewRecordTransformer<R extends ConnectRecord<R>>
implements Transformation<R> {
    public static final String EXPECTED_TOTAL_STEPS_CONFIG = "expected.total.steps";
    public static final String EXPECTED_TOTAL_STEPS_CONFIG_DOC = "Expected number of processing steps each connect record will undergo in the absence of errors";
    private Integer expectedTotalSteps;

    public static ConfigDef configDef() {
        return new ConfigDef().define(EXPECTED_TOTAL_STEPS_CONFIG, ConfigDef.Type.INT, ConfigDef.Importance.HIGH, EXPECTED_TOTAL_STEPS_CONFIG_DOC);
    }

    public R apply(R record) {
        Struct value = (Struct)record.value();
        Struct metaData = (Struct)value.get("metadata");
        if (!metaData.getInt32("total_step").equals(this.expectedTotalSteps)) {
            return record;
        }
        if (metaData.getInt32("current_step").equals(this.expectedTotalSteps)) {
            return null;
        }
        Struct newMetaData = new Struct(metaData.schema());
        metaData.schema().fields().forEach(f -> newMetaData.put(f, metaData.get(f)));
        newMetaData.put("total_step", (Object)(this.expectedTotalSteps - 1));
        Struct newValue = new Struct(value.schema());
        value.schema().fields().forEach(f -> newValue.put(f, value.get(f)));
        newValue.put("metadata", (Object)newMetaData);
        return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), record.valueSchema(), (Object)newValue, record.timestamp(), (Iterable)record.headers());
    }

    public ConfigDef config() {
        return PreviewRecordTransformer.configDef();
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
        this.expectedTotalSteps = new SimpleConfig(PreviewRecordTransformer.configDef(), configs).getInt(EXPECTED_TOTAL_STEPS_CONFIG);
    }
}

