/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hub.cli.interaction;

import io.confluent.connect.hub.actions.Installable;
import io.confluent.connect.hub.platform.Installation;
import io.confluent.connect.hub.platform.PlatformInspector;
import io.confluent.connect.hub.utils.IOUtils;
import io.confluent.pluginregistry.rest.entities.PluginLicense;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class AutoPilotInstall
implements Installable {
    private static final String ENFORCING_ANSWER_MSG = "Implicit confirmation of the question: ";
    private static final String ENFORCING_LICENSE_ACCEPTANCE_MSG = "Implicit acceptance of the license below: ";
    private final String component;
    private final String componentDir;
    private final List<String> workerConfigs;
    private final PlatformInspector platformInspector;
    private Installation selectedInstallation;

    public AutoPilotInstall(String component, String componentDir, List<String> workerConfigs, PlatformInspector platformInspector) {
        this.component = component;
        this.componentDir = componentDir;
        this.workerConfigs = workerConfigs;
        this.platformInspector = platformInspector;
    }

    @Override
    public String getComponent() {
        return this.component;
    }

    @Override
    public String getComponentDir() {
        return this.componentDir == null ? this.platformInspector.getComponentDir(this.getSelectedInstallation()) : this.componentDir;
    }

    private Installation getSelectedInstallation() {
        if (this.selectedInstallation == null) {
            Pair<Installation, String> installation = this.platformInspector.detectInstallation();
            this.selectedInstallation = (Installation)installation.getKey();
        }
        return this.selectedInstallation;
    }

    @Override
    public Function<String, Boolean> getForce() {
        return q -> {
            IOUtils.info(ENFORCING_ANSWER_MSG + q, new Object[0]);
            return true;
        };
    }

    @Override
    public List<String> getWorkerConfigs() {
        if (this.workerConfigs == null) {
            List<Pair<String, String>> detectedConfigs = this.platformInspector.detectConfigs(this.getSelectedInstallation());
            List<String> configs = detectedConfigs.stream().map(p -> (String)p.getValue()).collect(Collectors.toList());
            return configs;
        }
        return this.workerConfigs;
    }

    @Override
    public Function<String, Boolean> getThirdPartyConfirmation() {
        return q -> {
            IOUtils.info(ENFORCING_ANSWER_MSG + q, new Object[0]);
            return true;
        };
    }

    @Override
    public Function<PluginLicense, Boolean> getLicenseAcceptedConfirmation() {
        return l -> {
            IOUtils.info(ENFORCING_LICENSE_ACCEPTANCE_MSG, new Object[0]);
            IOUtils.info(l.getName(), new Object[0]);
            IOUtils.info(l.getUrl(), new Object[0]);
            return true;
        };
    }
}

