/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.pluginregistry.rest.entities;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.confluent.pluginregistry.PluginId;
import io.confluent.pluginregistry.PluginType;
import io.confluent.pluginregistry.rest.entities.ConfluentVerified;
import io.confluent.pluginregistry.rest.entities.PluginArchive;
import io.confluent.pluginregistry.rest.entities.PluginDockerImage;
import io.confluent.pluginregistry.rest.entities.PluginFeatures;
import io.confluent.pluginregistry.rest.entities.PluginLicense;
import io.confluent.pluginregistry.rest.entities.PluginOwner;
import io.confluent.pluginregistry.rest.entities.PluginSupport;
import io.confluent.pluginregistry.rest.entities.PluginVersion;
import io.confluent.pluginregistry.rest.entities.Signature;
import io.confluent.pluginregistry.util.JsonUtil;
import io.confluent.pluginregistry.util.ObjectUtil;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@JsonPropertyOrder(value={"name", "version", "manifest_url", "title", "description", "logo", "documentation_url", "source_url", "support", "owner", "archive", "docker_image", "confluent_verified", "features", "license", "component_types", "release_date", "tags", "requirements", "signatures", "last_modified"})
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class PluginManifest
implements Comparable<PluginManifest> {
    @JsonProperty
    private String name;
    private PluginVersion version = new PluginVersion();
    @JsonProperty
    private String title;
    @JsonProperty
    private String description;
    @JsonProperty(value="logo")
    private String logo;
    @JsonProperty(value="documentation_url")
    private String documentationUrl;
    @JsonProperty(value="source_url")
    private String sourceUrl;
    @JsonProperty
    private PluginOwner owner;
    @JsonProperty
    private PluginSupport support;
    @JsonProperty
    private PluginArchive archive;
    @JsonProperty(value="docker_image")
    private PluginDockerImage dockerImage;
    @JsonProperty(value="confluent_verified")
    private ConfluentVerified confluentVerified;
    @JsonProperty(value="features")
    private PluginFeatures pluginFeatures;
    @JsonProperty(value="license")
    private List<PluginLicense> licenses;
    @JsonAlias(value={"plugin_types"})
    @JsonProperty(value="component_types")
    private Set<PluginType> pluginTypes;
    @JsonProperty
    private Set<String> tags;
    @JsonProperty
    private Set<String> requirements;
    @JsonProperty
    private List<Signature> signatures;
    @JsonProperty(value="last_modified")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER, pattern="s")
    private Date lastModified;

    public static PluginManifest fromJson(String json) throws IOException {
        return (PluginManifest)JsonUtil.newObjectMapper().readValue(json, PluginManifest.class);
    }

    public static PluginManifest fromJson(InputStream json) throws IOException {
        return (PluginManifest)JsonUtil.newObjectMapper().readValue(json, PluginManifest.class);
    }

    public PluginManifest() {
    }

    public PluginManifest(String name) {
        this.name = name;
    }

    public PluginManifest(String name, String version, String manifestUrl, String title, String description, String logo, String documentationUrl, String sourceUrl, PluginOwner owner, PluginSupport support, PluginArchive archive, PluginDockerImage dockerImage, ConfluentVerified confluentVerified, PluginFeatures pluginFeatures, List<PluginLicense> licenses, Set<PluginType> pluginTypes, LocalDate releasedDate, Set<String> tags, Set<String> requirements, List<Signature> signatures, Date lastModified) {
        this(name);
        this.version = new PluginVersion(version, manifestUrl, releasedDate);
        this.title = title;
        this.description = description;
        this.logo = logo;
        this.documentationUrl = documentationUrl;
        this.sourceUrl = sourceUrl;
        this.owner = owner;
        this.support = support;
        this.archive = archive;
        this.dockerImage = dockerImage;
        this.confluentVerified = confluentVerified;
        this.pluginFeatures = pluginFeatures;
        this.licenses = licenses;
        this.pluginTypes = pluginTypes;
        this.tags = tags;
        this.requirements = requirements;
        this.signatures = signatures;
        this.lastModified = lastModified;
    }

    public PluginManifest(PluginManifest original) {
        this(original.name);
        this.setVersion(original.version);
        this.setTitle(original.title);
        this.setDescription(original.description);
        this.setLogo(original.logo);
        this.setDocumentationUrl(original.documentationUrl);
        this.setSourceUrl(original.sourceUrl);
        this.setOwner(original.owner);
        this.setSupport(original.support);
        this.setArchive(original.archive);
        this.setDockerImage(original.dockerImage);
        this.setConfluentVerified(original.confluentVerified);
        this.setPluginFeatures(original.pluginFeatures);
        this.setLicenses(original.licenses);
        this.setPluginTypes(original.pluginTypes);
        this.setTags(original.tags);
        this.setRequirements(original.requirements);
        this.setSignatures(original.signatures);
        this.setLastModified(original.lastModified);
    }

    public String toJson() throws IOException {
        return JsonUtil.newObjectMapper().writeValueAsString((Object)this);
    }

    public PluginId getPluginId() {
        String owner = this.owner != null ? this.getOwner().getUsername() : null;
        return new PluginId(owner, this.getName(), this.getVersion());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version != null ? this.version.getVersion() : null;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.getOrCreateVersion().setVersion(version);
    }

    protected void setVersion(PluginVersion version) {
        this.version = version;
    }

    protected PluginVersion getOrCreateVersion() {
        if (this.version == null) {
            this.version = new PluginVersion();
        }
        return this.version;
    }

    @JsonProperty(value="release_date")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    public LocalDate getReleaseDate() {
        return this.version != null ? this.version.getReleaseDate() : null;
    }

    @JsonProperty(value="release_date")
    public void setReleaseDate(LocalDate releasedDate) {
        this.getOrCreateVersion().setReleaseDate(releasedDate);
    }

    @JsonProperty(value="manifest_url")
    public String getManifestUrl() {
        return this.version != null ? this.version.getManifestUrl() : null;
    }

    @JsonProperty(value="manifest_url")
    public void setManifestUrl(String manifestUrl) {
        this.getOrCreateVersion().setManifestUrl(manifestUrl);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    public void setDocumentationUrl(String documentationUrl) {
        this.documentationUrl = documentationUrl;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public PluginOwner getOwner() {
        return this.owner;
    }

    public void setOwner(PluginOwner owner) {
        this.owner = owner != null ? new PluginOwner(owner) : null;
    }

    public PluginSupport getSupport() {
        return this.support;
    }

    public void setSupport(PluginSupport support) {
        this.support = support != null ? new PluginSupport(support) : null;
    }

    public PluginArchive getArchive() {
        return this.archive;
    }

    public void setArchive(PluginArchive archive) {
        this.archive = archive != null ? new PluginArchive(archive) : null;
    }

    public PluginDockerImage getDockerImage() {
        return this.dockerImage;
    }

    public void setDockerImage(PluginDockerImage dockerImage) {
        this.dockerImage = dockerImage != null ? new PluginDockerImage(dockerImage) : null;
    }

    public ConfluentVerified getConfluentVerified() {
        return this.confluentVerified;
    }

    public void setConfluentVerified(ConfluentVerified confluentVerified) {
        this.confluentVerified = confluentVerified;
    }

    public PluginFeatures getPluginFeatures() {
        return this.pluginFeatures;
    }

    public void setPluginFeatures(PluginFeatures pluginFeatures) {
        this.pluginFeatures = pluginFeatures != null ? new PluginFeatures(pluginFeatures) : null;
    }

    public List<PluginLicense> getLicenses() {
        return this.licenses;
    }

    public void setLicenses(List<PluginLicense> licenses) {
        this.licenses = licenses != null ? licenses.stream().map(PluginLicense::new).collect(Collectors.toList()) : null;
    }

    public Set<PluginType> getPluginTypes() {
        return this.pluginTypes;
    }

    public void setPluginTypes(Set<PluginType> pluginTypes) {
        this.pluginTypes = pluginTypes != null ? new HashSet<PluginType>(pluginTypes) : null;
    }

    public void setPluginTypes(PluginType ... pluginTypes) {
        this.pluginTypes = new HashSet<PluginType>(Arrays.asList(pluginTypes));
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags != null ? new HashSet<String>(tags) : null;
    }

    public void setTags(String ... tags) {
        this.tags = new HashSet<String>(Arrays.asList(tags));
    }

    public Set<String> getRequirements() {
        return this.requirements;
    }

    public void setRequirements(Set<String> requirements) {
        this.requirements = requirements != null ? new HashSet<String>(requirements) : null;
    }

    public void setRequirements(String ... requirements) {
        this.requirements = new HashSet<String>(Arrays.asList(requirements));
    }

    public List<Signature> getSignature() {
        return this.signatures;
    }

    public void setSignatures(List<Signature> signatures) {
        this.signatures = signatures != null ? new ArrayList<Signature>(signatures) : null;
    }

    public void setSignatures(Signature ... signatures) {
        this.signatures = signatures != null ? Arrays.asList(signatures) : null;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void addPluginTypes(PluginType ... types) {
        this.pluginTypes = this.addTo(this.pluginTypes, types);
    }

    public void addPluginTypes(Collection<PluginType> types) {
        this.pluginTypes = this.addTo(this.pluginTypes, types);
    }

    public void addTags(String ... tags) {
        this.tags = this.addTo(this.tags, tags);
    }

    public void addTags(Collection<String> tags) {
        this.tags = this.addTo(this.tags, tags);
    }

    public void addRequirements(String ... requirements) {
        this.requirements = this.addTo(this.requirements, requirements);
    }

    public void addRequirements(Collection<String> requirements) {
        this.requirements = this.addTo(this.requirements, requirements);
    }

    private <T> Set<T> addTo(Set<T> set, T ... values) {
        if (values == null) {
            return set;
        }
        if (set == null) {
            set = new HashSet<T>();
        }
        for (T value : values) {
            if (value == null) continue;
            set.add(value);
        }
        return set;
    }

    private <T> Set<T> addTo(Set<T> set, Collection<T> values) {
        if (values == null) {
            return set;
        }
        if (set == null) {
            set = new HashSet<T>();
        }
        set.addAll(values);
        return set;
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginManifest that = (PluginManifest)o;
        return ObjectUtil.equals(this.name, that.name) && ObjectUtil.equals(this.version, that.version) && ObjectUtil.equals(this.title, that.title) && ObjectUtil.equals(this.description, that.description) && ObjectUtil.equals(this.logo, that.logo) && ObjectUtil.equals(this.documentationUrl, that.documentationUrl) && ObjectUtil.equals(this.sourceUrl, that.sourceUrl) && ObjectUtil.equals(this.owner, that.owner) && ObjectUtil.equals(this.archive, that.archive) && ObjectUtil.equals(this.dockerImage, that.dockerImage) && ObjectUtil.equals(this.confluentVerified, that.confluentVerified) && ObjectUtil.equals(this.pluginFeatures, that.pluginFeatures) && ObjectUtil.equals(this.licenses, that.licenses) && ObjectUtil.equals(this.pluginTypes, that.pluginTypes) && ObjectUtil.equals(this.tags, that.tags) && ObjectUtil.equals(this.requirements, that.requirements) && ObjectUtil.equals(this.signatures, that.signatures) && ObjectUtil.equals(this.lastModified, that.lastModified);
    }

    @Override
    public int compareTo(PluginManifest that) {
        String thatOwner;
        if (that == null) {
            return 1;
        }
        String thisOwner = this.owner != null ? this.owner.getUsername() : null;
        int diff = ObjectUtil.compareTo(thisOwner, thatOwner = that.owner != null ? that.owner.getUsername() : null);
        if (diff != 0) {
            return diff;
        }
        diff = ObjectUtil.compareTo(this.name, that.name);
        if (diff != 0) {
            return diff;
        }
        diff = ObjectUtil.compareTo(this.version, that.version);
        return diff;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{name=" + this.name + ",");
        sb.append("version=" + this.getVersion() + ",");
        sb.append("manifest_url=" + this.getManifestUrl() + ",");
        sb.append("title=" + this.getTitle() + ",");
        sb.append("description=" + this.getDescription() + ",");
        sb.append("logo=" + this.getLogo() + ",");
        sb.append("documentation_url=" + this.getDocumentationUrl() + ",");
        sb.append("source_url=" + this.getSourceUrl() + ",");
        sb.append("owner=" + this.getOwner() + ",");
        sb.append("archive=" + this.getArchive() + ",");
        sb.append("docker_image=" + this.getDockerImage() + ",");
        sb.append("license=" + this.licenses + ",");
        sb.append("confluent_verified=" + this.confluentVerified + ",");
        sb.append("features=" + this.pluginFeatures + ",");
        sb.append("component_types=" + this.pluginTypes + ",");
        sb.append("released_date=" + this.getReleaseDate() + ",");
        sb.append("tags=" + this.tags + ",");
        sb.append("requirements=" + this.requirements + ",");
        sb.append("signatures=" + this.signatures + ",");
        sb.append("lastModified=" + this.lastModified + "}");
        return sb.toString();
    }
}

