/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.utils.SecurityUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class InternalRestServerSSL {
    private static final Pattern COMMA_WITH_WHITESPACE = Pattern.compile("\\s*,\\s*");

    public static SslContextFactory.Server createServerSideSslContextFactory(AbstractConfig config, String prefix) {
        Map sslConfigValues = config.valuesWithPrefixAllOrNothing(prefix);
        String securityProviders = config.getString("security.providers");
        boolean useBcfksStore = InternalRestServerSSL.useBcfks(sslConfigValues, securityProviders);
        SecurityUtils.addConfiguredSecurityProviders((Map)sslConfigValues);
        SslContextFactory.Server ssl = new SslContextFactory.Server();
        InternalRestServerSSL.configureSslContextFactoryKeyStore((SslContextFactory)ssl, sslConfigValues, useBcfksStore);
        InternalRestServerSSL.configureSslContextFactoryTrustStore((SslContextFactory)ssl, sslConfigValues, useBcfksStore);
        InternalRestServerSSL.configureSslContextFactoryAlgorithms((SslContextFactory)ssl, sslConfigValues);
        InternalRestServerSSL.configureSslContextFactoryAuthentication(ssl, sslConfigValues);
        return ssl;
    }

    public static boolean useBcfks(Map<String, Object> sslConfigValues, String securityProviders) {
        String sslProvider = (String)sslConfigValues.get("ssl.provider");
        if (sslProvider != null && securityProviders != null) {
            return sslProvider.equalsIgnoreCase("BCJSSE") && securityProviders.toLowerCase(Locale.ROOT).contains("BCFIPS".toLowerCase(Locale.ROOT));
        }
        return false;
    }

    public static void setSecurityStoreProps(SslContextFactory sslContextFactory, Map<String, Object> sslConfigValues, boolean isKeyStore, boolean useBcfksStore, boolean setPathOnly) {
        String storeType = isKeyStore ? (String)InternalRestServerSSL.getOrDefault(sslConfigValues, "ssl.keystore.type", "JKS") : (String)InternalRestServerSSL.getOrDefault(sslConfigValues, "ssl.truststore.type", "JKS");
        boolean isPem = storeType.equals("PEM");
        if (isPem) {
            if (isKeyStore) {
                String sslKeystoreLocation = (String)sslConfigValues.get("ssl.keystore.location");
                Password sslKeyPassword = (Password)sslConfigValues.get("ssl.key.password");
                DefaultSslEngineFactory.FileBasedPemStore fileBasedPemStore = new DefaultSslEngineFactory.FileBasedPemStore(sslKeystoreLocation, sslKeyPassword, true, useBcfksStore);
                sslContextFactory.setKeyStore(fileBasedPemStore.get());
            } else {
                String sslTruststoreLocation = (String)sslConfigValues.get("ssl.truststore.location");
                DefaultSslEngineFactory.FileBasedPemStore fileBasedPemStore = new DefaultSslEngineFactory.FileBasedPemStore(sslTruststoreLocation, null, false, useBcfksStore);
                sslContextFactory.setTrustStore(fileBasedPemStore.get());
            }
        } else if (isKeyStore) {
            String sslKeystoreLocation = (String)sslConfigValues.get("ssl.keystore.location");
            if (sslKeystoreLocation != null) {
                sslContextFactory.setKeyStorePath(sslKeystoreLocation);
            }
            if (!setPathOnly) {
                sslContextFactory.setKeyStoreType(storeType);
                Password sslKeystorePassword = (Password)sslConfigValues.get("ssl.keystore.password");
                if (sslKeystorePassword != null) {
                    sslContextFactory.setKeyStorePassword(sslKeystorePassword.value());
                }
            }
        } else {
            String sslTruststoreLocation = (String)sslConfigValues.get("ssl.truststore.location");
            if (sslTruststoreLocation != null) {
                sslContextFactory.setTrustStorePath(sslTruststoreLocation);
            }
            if (!setPathOnly) {
                sslContextFactory.setTrustStoreType(storeType);
                Password sslTruststorePassword = (Password)sslConfigValues.get("ssl.truststore.password");
                if (sslTruststorePassword != null) {
                    sslContextFactory.setTrustStorePassword(sslTruststorePassword.value());
                }
            }
        }
    }

    private static void configureSslContextFactoryKeyStore(SslContextFactory ssl, Map<String, Object> sslConfigValues, boolean useBcfksStore) {
        Password sslKeyPassword = (Password)sslConfigValues.get("ssl.key.password");
        if (sslKeyPassword != null) {
            ssl.setKeyManagerPassword(sslKeyPassword.value());
        }
        InternalRestServerSSL.setSecurityStoreProps(ssl, sslConfigValues, true, useBcfksStore, false);
    }

    private static Object getOrDefault(Map<String, Object> configMap, String key, Object defaultValue) {
        if (configMap.containsKey(key)) {
            return configMap.get(key);
        }
        return defaultValue;
    }

    private static void configureSslContextFactoryTrustStore(SslContextFactory ssl, Map<String, Object> sslConfigValues, boolean useBcfksStore) {
        InternalRestServerSSL.setSecurityStoreProps(ssl, sslConfigValues, false, useBcfksStore, false);
    }

    private static void configureSslContextFactoryAlgorithms(SslContextFactory ssl, Map<String, Object> sslConfigValues) {
        List sslEnabledProtocols = (List)InternalRestServerSSL.getOrDefault(sslConfigValues, "ssl.enabled.protocols", Arrays.asList(COMMA_WITH_WHITESPACE.split(SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS)));
        ssl.setIncludeProtocols(sslEnabledProtocols.toArray(new String[0]));
        String sslProvider = (String)sslConfigValues.get("ssl.provider");
        if (sslProvider != null) {
            ssl.setProvider(sslProvider);
        }
        ssl.setProtocol((String)InternalRestServerSSL.getOrDefault(sslConfigValues, "ssl.protocol", SslConfigs.DEFAULT_SSL_PROTOCOL));
        List sslCipherSuites = (List)sslConfigValues.get("ssl.cipher.suites");
        if (sslCipherSuites != null) {
            ssl.setIncludeCipherSuites(sslCipherSuites.toArray(new String[0]));
        }
        ssl.setKeyManagerFactoryAlgorithm((String)InternalRestServerSSL.getOrDefault(sslConfigValues, "ssl.keymanager.algorithm", SslConfigs.DEFAULT_SSL_KEYMANGER_ALGORITHM));
        String sslSecureRandomImpl = (String)sslConfigValues.get("ssl.secure.random.implementation");
        if (sslSecureRandomImpl != null) {
            ssl.setSecureRandomAlgorithm(sslSecureRandomImpl);
        }
        ssl.setTrustManagerFactoryAlgorithm((String)InternalRestServerSSL.getOrDefault(sslConfigValues, "ssl.trustmanager.algorithm", SslConfigs.DEFAULT_SSL_TRUSTMANAGER_ALGORITHM));
    }

    private static void configureSslContextFactoryAuthentication(SslContextFactory.Server ssl, Map<String, Object> sslConfigValues) {
        String sslClientAuth;
        switch (sslClientAuth = (String)InternalRestServerSSL.getOrDefault(sslConfigValues, "ssl.client.auth", "none")) {
            case "requested": {
                ssl.setWantClientAuth(true);
                break;
            }
            case "required": {
                ssl.setNeedClientAuth(true);
                break;
            }
            default: {
                ssl.setNeedClientAuth(false);
                ssl.setWantClientAuth(false);
            }
        }
    }
}

