/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.BeginShutdownBrokerHandle;
import io.confluent.rest.InternalRestServer;
import io.confluent.rest.ResponseContainer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public final class RollHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(InternalRestServer.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final BeginShutdownBrokerHandle brokerHandle;

    public RollHandler(BeginShutdownBrokerHandle brokerHandle) {
        this.brokerHandle = brokerHandle;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (target.equals("/status")) {
            log.debug("Handling roll status query");
            this.handleStatusQuery(response);
        } else if (target.equals("/shutdown")) {
            log.debug("Handling roll shutdown request");
            this.handleShutdown(request, response);
        } else if (target.equals("/rollStatus")) {
            this.handleRollStatusQuery(response);
        }
    }

    private void handleStatusQuery(HttpServletResponse response) throws IOException {
        try {
            StatusResponse statusResponse = new StatusResponse(this.brokerHandle.brokerId(), this.brokerHandle.underReplicatedPartitions(), this.brokerHandle.controllerId(), this.brokerHandle.brokerEpoch());
            ResponseContainer.dataResponse(statusResponse).write(OBJECT_MAPPER, response);
        }
        catch (Exception e) {
            log.error("Failed to retrieve and write broker status", (Throwable)e);
            ResponseContainer.ErrorResponse resp = RollHandler.genericErrorResponse("Failed to retrieve and write broker status");
            ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
        }
    }

    private void handleRollStatusQuery(HttpServletResponse response) throws IOException {
        try {
            Tuple2<Boolean, String> brokerRollable = this.brokerHandle.rollable();
            RollStatusResponse rollStatusResponse = new RollStatusResponse(this.brokerHandle.brokerId(), this.brokerHandle.brokerEpoch(), this.brokerHandle.controllerId(), (Boolean)brokerRollable._1, (String)brokerRollable._2);
            ResponseContainer.dataResponse(rollStatusResponse).write(OBJECT_MAPPER, response);
        }
        catch (Exception e) {
            log.error("Failed to retrieve and write broker roll status", (Throwable)e);
            ResponseContainer.ErrorResponse resp = RollHandler.genericErrorResponse("Failed to retrieve and write broker roll status");
            ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
        }
    }

    private static ResponseContainer.ErrorResponse genericErrorResponse(String message) {
        return new ResponseContainer.ErrorResponse(0, 500, message);
    }

    private void handleShutdown(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block21: {
            try (ServletInputStream inputStream = request.getInputStream();){
                ShutdownRequest shutdownRequest = (ShutdownRequest)OBJECT_MAPPER.readValue((InputStream)inputStream, ShutdownRequest.class);
                long currentBrokerId = this.brokerHandle.brokerId();
                if (shutdownRequest.brokerId != currentBrokerId) {
                    log.warn(String.format("shutdown request broker_id %d does not match current %d", shutdownRequest.brokerId, currentBrokerId));
                    ResponseContainer.ErrorResponse errResponse = RollHandler.genericErrorResponse("broker_id does not match recipient broker");
                    ResponseContainer<?> responseContainer = ResponseContainer.errorResponse(Collections.singletonList(errResponse));
                    responseContainer.write(OBJECT_MAPPER, response);
                    break block21;
                }
                try {
                    this.brokerHandle.beginShutdown(shutdownRequest.brokerEpoch);
                }
                catch (StaleBrokerEpochException ignored) {
                    log.warn(String.format("shutdown request broker_epoch %d does not match current brokerEpoch", shutdownRequest.brokerEpoch));
                    ResponseContainer.ErrorResponse errResponse = RollHandler.genericErrorResponse("broker_epoch does not match recipient broker");
                    ResponseContainer<?> responseContainer = ResponseContainer.errorResponse(Collections.singletonList(errResponse));
                    responseContainer.write(OBJECT_MAPPER, response);
                    if (inputStream != null) {
                        if (var4_4 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                    return;
                }
                log.info(String.format("beginShutdown successful for broker %d epoch %d", shutdownRequest.brokerEpoch, shutdownRequest.brokerEpoch));
                response.setCharacterEncoding("UTF-8");
                response.setStatus(200);
                response.getWriter().close();
            }
        }
    }

    static final class ShutdownRequest {
        @JsonProperty(value="broker_id")
        final long brokerId;
        @JsonProperty(value="broker_epoch")
        final long brokerEpoch;

        @JsonCreator
        public ShutdownRequest(@JsonProperty(value="broker_id", required=true) long brokerId, @JsonProperty(value="broker_epoch", required=true) long brokerEpoch) {
            this.brokerId = brokerId;
            this.brokerEpoch = brokerEpoch;
        }

        public String toString() {
            return "ShutdownRequest{brokerId=" + this.brokerId + ", brokerEpoch=" + this.brokerEpoch + '}';
        }
    }

    static final class RollStatusResponse {
        @JsonProperty(value="broker_id")
        final long brokerId;
        @JsonProperty(value="broker_epoch")
        final long brokerEpoch;
        @JsonProperty(value="controller_id")
        final Integer controllerId;
        @JsonProperty(value="rollable")
        final boolean rollable;
        @JsonProperty(value="reason")
        final String reason;

        @JsonCreator
        public RollStatusResponse(@JsonProperty(value="broker_id", required=true) long brokerId, @JsonProperty(value="broker_epoch", required=true) long brokerEpoch, @JsonProperty(value="controller_id", required=false) Integer controllerId, @JsonProperty(value="rollable", required=true) boolean rollable, @JsonProperty(value="reason", required=true) String reason) {
            this.brokerId = brokerId;
            this.brokerEpoch = brokerEpoch;
            this.controllerId = controllerId;
            this.rollable = rollable;
            this.reason = reason;
        }

        public String toString() {
            return "RollStatusResponse{brokerId=" + this.brokerId + ", brokerEpoch=" + this.brokerEpoch + ", controllerId=" + this.controllerId + ", rollable=" + this.rollable + ", reason=" + this.reason + '}';
        }
    }

    static final class StatusResponse {
        @JsonProperty(value="broker_id")
        final long brokerId;
        @JsonProperty(value="broker_epoch")
        final long brokerEpoch;
        @JsonProperty(value="under_replicated_partitions")
        final long underReplicatedPartitions;
        @JsonProperty(value="controller_id")
        final Integer controllerId;

        @JsonCreator
        public StatusResponse(@JsonProperty(value="broker_id", required=true) long brokerId, @JsonProperty(value="under_replicated_partitions", required=true) long underReplicatedPartitions, @JsonProperty(value="controller_id", required=false) Integer controllerId, @JsonProperty(value="broker_epoch", required=true) long brokerEpoch) {
            this.brokerId = brokerId;
            this.brokerEpoch = brokerEpoch;
            this.underReplicatedPartitions = underReplicatedPartitions;
            this.controllerId = controllerId;
        }

        public String toString() {
            return "StatusResponse{brokerId=" + this.brokerId + ", brokerEpoch=" + this.brokerEpoch + ", underReplicatedPartitions=" + this.underReplicatedPartitions + ", controllerId=" + this.controllerId + '}';
        }
    }
}

