/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.builder;

import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.builder.AbstractBuilder;
import com.github.rvesse.airline.builder.GroupBuilder;
import com.github.rvesse.airline.builder.ParserBuilder;
import com.github.rvesse.airline.help.sections.HelpSection;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.MetadataLoader;
import com.github.rvesse.airline.restrictions.GlobalRestriction;
import com.github.rvesse.airline.restrictions.None;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.ListUtils;

public class CliBuilder<C>
extends AbstractBuilder<Cli<C>> {
    protected final String name;
    protected String description;
    protected String optionSeparators;
    protected Class<? extends C> defaultCommand;
    protected final List<Class<? extends C>> defaultCommandGroupCommands = new ArrayList<Class<? extends C>>();
    protected final Map<String, GroupBuilder<C>> groups = new HashMap<String, GroupBuilder<C>>();
    protected final List<GlobalRestriction> restrictions = new ArrayList<GlobalRestriction>();
    protected final ParserBuilder<C> parserBuilder = new ParserBuilder();
    protected final Map<String, HelpSection> baseHelpSections = new HashMap<String, HelpSection>();

    public CliBuilder(String name) {
        this.checkNotBlank(name, "Program name");
        this.name = name;
    }

    public CliBuilder<C> withDescription(String description) {
        this.checkNotEmpty(description, "Description");
        this.description = description;
        return this;
    }

    public CliBuilder<C> withDefaultCommand(Class<? extends C> defaultCommand) {
        this.defaultCommand = defaultCommand;
        return this;
    }

    public CliBuilder<C> withCommand(Class<? extends C> command) {
        this.defaultCommandGroupCommands.add(command);
        return this;
    }

    public CliBuilder<C> withCommands(Class<? extends C> command, Class<? extends C> ... moreCommands) {
        this.defaultCommandGroupCommands.add(command);
        this.defaultCommandGroupCommands.addAll(ListUtils.unmodifiableList((List)IteratorUtils.toList((Iterator)IteratorUtils.arrayIterator((Object[])moreCommands))));
        return this;
    }

    public CliBuilder<C> withCommands(Iterable<Class<? extends C>> commands) {
        this.defaultCommandGroupCommands.addAll(ListUtils.unmodifiableList((List)IteratorUtils.toList(commands.iterator())));
        return this;
    }

    public GroupBuilder<C> withGroup(String name) {
        this.checkNotBlank(name, "Group name");
        if (this.groups.containsKey(name)) {
            return this.groups.get(name);
        }
        GroupBuilder group = new GroupBuilder(this, name);
        this.groups.put(name, group);
        return group;
    }

    public GroupBuilder<C> getGroup(String name) {
        this.checkNotBlank(name, "Group name");
        if (!this.groups.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Group %s has not been declared", name));
        }
        return this.groups.get(name);
    }

    public CliBuilder<C> withRestriction(GlobalRestriction restriction) {
        if (restriction != null) {
            this.restrictions.add(restriction);
        }
        return this;
    }

    public CliBuilder<C> withRestrictions(GlobalRestriction ... restrictions) {
        for (GlobalRestriction restriction : restrictions) {
            if (restriction == null) continue;
            this.restrictions.add(restriction);
        }
        return this;
    }

    public CliBuilder<C> withNoRestrictions() {
        this.restrictions.clear();
        this.restrictions.add(new None());
        return this;
    }

    public CliBuilder<C> withDefaultRestrictions() {
        this.restrictions.addAll(Arrays.asList(GlobalRestriction.DEFAULTS));
        return this;
    }

    public CliBuilder<C> withOnlyDefaultRestrictions() {
        this.restrictions.clear();
        return this.withDefaultRestrictions();
    }

    public ParserBuilder<C> withParser() {
        return this.parserBuilder;
    }

    public CliBuilder<C> withHelpSection(HelpSection section) {
        if (section == null) {
            return this;
        }
        this.baseHelpSections.put(section.getTitle().toLowerCase(Locale.ENGLISH), section);
        return this;
    }

    @Override
    public Cli<C> build() {
        ArrayList<CommandGroupMetadata> commandGroups;
        CommandMetadata defaultCommandMetadata = null;
        ArrayList<CommandMetadata> allCommands = new ArrayList<CommandMetadata>();
        if (this.defaultCommand != null) {
            defaultCommandMetadata = MetadataLoader.loadCommand(this.defaultCommand, this.baseHelpSections);
        }
        ArrayList<CommandMetadata> defaultCommandGroup = this.defaultCommandGroupCommands != null ? MetadataLoader.loadCommands(this.defaultCommandGroupCommands, this.baseHelpSections) : new ArrayList<CommandMetadata>();
        allCommands.addAll(defaultCommandGroup);
        if (defaultCommandMetadata != null) {
            allCommands.add(defaultCommandMetadata);
        }
        if (this.groups != null) {
            commandGroups = new ArrayList<CommandGroupMetadata>();
            for (GroupBuilder groupBuilder : this.groups.values()) {
                commandGroups.add(groupBuilder.build());
            }
        } else {
            commandGroups = new ArrayList();
        }
        for (CommandGroupMetadata commandGroupMetadata : commandGroups) {
            allCommands.addAll(commandGroupMetadata.getCommands());
            if (commandGroupMetadata.getDefaultCommand() != null) {
                allCommands.add(commandGroupMetadata.getDefaultCommand());
            }
            LinkedList<CommandGroupMetadata> subGroups = new LinkedList<CommandGroupMetadata>();
            subGroups.addAll(commandGroupMetadata.getSubGroups());
            while (!subGroups.isEmpty()) {
                CommandGroupMetadata subGroup = (CommandGroupMetadata)subGroups.poll();
                allCommands.addAll(subGroup.getCommands());
                if (subGroup.getDefaultCommand() != null) {
                    allCommands.add(subGroup.getDefaultCommand());
                }
                subGroups.addAll(subGroup.getSubGroups());
            }
        }
        MetadataLoader.loadCommandsIntoGroupsByAnnotation(allCommands, commandGroups, defaultCommandGroup, this.baseHelpSections);
        if (this.restrictions.size() == 0) {
            this.withDefaultRestrictions();
        }
        if (allCommands.size() == 0) {
            throw new IllegalArgumentException("Must specify at least one command to create a CLI");
        }
        GlobalMetadata metadata = MetadataLoader.loadGlobal(this.name, this.description, defaultCommandMetadata, ListUtils.unmodifiableList(defaultCommandGroup), ListUtils.unmodifiableList(commandGroups), ListUtils.unmodifiableList(this.restrictions), Collections.unmodifiableCollection(this.baseHelpSections.values()), this.parserBuilder.build());
        return new Cli(metadata);
    }
}

