/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.dynamic;

import com.google.protobuf.DescriptorProtos;
import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.TypeElement;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.diff.Context;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.DynamicSchema;
import io.confluent.protobuf.MetaProto;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;

public class FieldDefinition {
    private DescriptorProtos.FieldDescriptorProto mFieldType;
    private static Map<String, DescriptorProtos.FieldDescriptorProto.Type> sTypeMap = new HashMap<String, DescriptorProtos.FieldDescriptorProto.Type>();
    private static Map<String, DescriptorProtos.FieldDescriptorProto.Label> sLabelMap;

    public static Builder newBuilder(Context ctx, String fieldName, int tag, String type) {
        return new Builder(fieldName).setNumber(tag).setType(ctx, type);
    }

    public String toString() {
        return this.mFieldType.toString();
    }

    DescriptorProtos.FieldDescriptorProto getFieldType() {
        return this.mFieldType;
    }

    private FieldDefinition(DescriptorProtos.FieldDescriptorProto fieldType) {
        this.mFieldType = fieldType;
    }

    static {
        sTypeMap.put("double", DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE);
        sTypeMap.put("float", DescriptorProtos.FieldDescriptorProto.Type.TYPE_FLOAT);
        sTypeMap.put("int32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32);
        sTypeMap.put("int64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64);
        sTypeMap.put("uint32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT32);
        sTypeMap.put("uint64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT64);
        sTypeMap.put("sint32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT32);
        sTypeMap.put("sint64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT64);
        sTypeMap.put("fixed32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED32);
        sTypeMap.put("fixed64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED64);
        sTypeMap.put("sfixed32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED32);
        sTypeMap.put("sfixed64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED64);
        sTypeMap.put("bool", DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL);
        sTypeMap.put("string", DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING);
        sTypeMap.put("bytes", DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES);
        sLabelMap = new HashMap<String, DescriptorProtos.FieldDescriptorProto.Label>();
        sLabelMap.put("optional", DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL);
        sLabelMap.put("required", DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED);
        sLabelMap.put("repeated", DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED);
    }

    public static class Builder {
        private DescriptorProtos.FieldDescriptorProto.Builder mFieldTypeBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder();

        public String getName() {
            return this.mFieldTypeBuilder.getName();
        }

        public Builder setLabel(String label) {
            DescriptorProtos.FieldDescriptorProto.Label protoLabel = (DescriptorProtos.FieldDescriptorProto.Label)sLabelMap.get(label);
            this.mFieldTypeBuilder.setLabel(protoLabel);
            return this;
        }

        public Builder setProto3Optional(boolean isProto3Optional) {
            this.mFieldTypeBuilder.setProto3Optional(isProto3Optional);
            return this;
        }

        public Builder setType(Context ctx, String type) {
            DescriptorProtos.FieldDescriptorProto.Type primType = (DescriptorProtos.FieldDescriptorProto.Type)sTypeMap.get(type);
            if (primType != null) {
                this.mFieldTypeBuilder.setType(primType);
            } else {
                Pair<String, Context.TypeElementInfo> entry = ctx.resolveFull(ctx::getTypeForFullName, type, true);
                if (entry != null) {
                    TypeElement elem = ((Context.TypeElementInfo)entry.getSecond()).type();
                    if (elem instanceof MessageElement) {
                        this.mFieldTypeBuilder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE);
                    } else if (elem instanceof EnumElement) {
                        this.mFieldTypeBuilder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_ENUM);
                    }
                }
                this.mFieldTypeBuilder.setTypeName(type);
            }
            return this;
        }

        public Builder setName(String name) {
            this.mFieldTypeBuilder.setName(name);
            return this;
        }

        public Builder setNumber(int num) {
            this.mFieldTypeBuilder.setNumber(num);
            return this;
        }

        public Builder setDefaultValue(String defaultValue) {
            this.mFieldTypeBuilder.setDefaultValue(defaultValue);
            return this;
        }

        public Builder setOneofIndex(int index) {
            this.mFieldTypeBuilder.setOneofIndex(index);
            return this;
        }

        public Builder setJsonName(String jsonName) {
            this.mFieldTypeBuilder.setJsonName(jsonName);
            return this;
        }

        public Builder setCtype(DescriptorProtos.FieldOptions.CType ctype) {
            DescriptorProtos.FieldOptions.Builder optionsBuilder = DescriptorProtos.FieldOptions.newBuilder();
            optionsBuilder.setCtype(ctype);
            this.mFieldTypeBuilder.mergeOptions(optionsBuilder.build());
            return this;
        }

        public Builder setPacked(boolean isPacked) {
            DescriptorProtos.FieldOptions.Builder optionsBuilder = DescriptorProtos.FieldOptions.newBuilder();
            optionsBuilder.setPacked(isPacked);
            this.mFieldTypeBuilder.mergeOptions(optionsBuilder.build());
            return this;
        }

        public Builder setJstype(DescriptorProtos.FieldOptions.JSType jstype) {
            DescriptorProtos.FieldOptions.Builder optionsBuilder = DescriptorProtos.FieldOptions.newBuilder();
            optionsBuilder.setJstype(jstype);
            this.mFieldTypeBuilder.mergeOptions(optionsBuilder.build());
            return this;
        }

        public Builder setDeprecated(boolean isDeprecated) {
            DescriptorProtos.FieldOptions.Builder optionsBuilder = DescriptorProtos.FieldOptions.newBuilder();
            optionsBuilder.setDeprecated(isDeprecated);
            this.mFieldTypeBuilder.mergeOptions(optionsBuilder.build());
            return this;
        }

        public Builder setDebugRedact(boolean isDebugRedact) {
            DescriptorProtos.FieldOptions.Builder optionsBuilder = DescriptorProtos.FieldOptions.newBuilder();
            optionsBuilder.setDebugRedact(isDebugRedact);
            this.mFieldTypeBuilder.mergeOptions(optionsBuilder.build());
            return this;
        }

        public Builder setRetention(DescriptorProtos.FieldOptions.OptionRetention retention) {
            DescriptorProtos.FieldOptions.Builder optionsBuilder = DescriptorProtos.FieldOptions.newBuilder();
            optionsBuilder.setRetention(retention);
            this.mFieldTypeBuilder.mergeOptions(optionsBuilder.build());
            return this;
        }

        public Builder addTargets(List<DescriptorProtos.FieldOptions.OptionTargetType> targets) {
            DescriptorProtos.FieldOptions.Builder optionsBuilder = DescriptorProtos.FieldOptions.newBuilder();
            optionsBuilder.addAllTargets(targets);
            this.mFieldTypeBuilder.mergeOptions(optionsBuilder.build());
            return this;
        }

        public Builder addEditionDefaults(List<DescriptorProtos.FieldOptions.EditionDefault> editionDefaults) {
            DescriptorProtos.FieldOptions.Builder optionsBuilder = DescriptorProtos.FieldOptions.newBuilder();
            optionsBuilder.addAllEditionDefaults(editionDefaults);
            this.mFieldTypeBuilder.mergeOptions(optionsBuilder.build());
            return this;
        }

        public Builder setFeatures(DescriptorProtos.FeatureSet features) {
            DescriptorProtos.FieldOptions.Builder optionsBuilder = DescriptorProtos.FieldOptions.newBuilder();
            optionsBuilder.setFeatures(features);
            this.mFieldTypeBuilder.mergeOptions(optionsBuilder.build());
            return this;
        }

        public Builder setExtendee(String extendee) {
            this.mFieldTypeBuilder.setExtendee(extendee);
            return this;
        }

        public Builder setMeta(ProtobufSchema.ProtobufMeta meta) {
            MetaProto.Meta m = DynamicSchema.toMeta(meta);
            if (m != null) {
                DescriptorProtos.FieldOptions.Builder optionsBuilder = DescriptorProtos.FieldOptions.newBuilder();
                optionsBuilder.setExtension(MetaProto.fieldMeta, (Object)m);
                this.mFieldTypeBuilder.mergeOptions(optionsBuilder.build());
            }
            return this;
        }

        public FieldDefinition build() {
            return new FieldDefinition(this.mFieldTypeBuilder.build());
        }

        private Builder(String fieldName) {
            this.mFieldTypeBuilder.setName(fieldName);
        }
    }
}

