/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.config;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;

public class BrokerBackpressureConfig {
    public static final long DEFAULT_ACTIVE_WINDOW_MS = TimeUnit.MINUTES.toMillis(1L);
    public static final long DEFAULT_BACKPRESSURE_CHECK_FREQUENCY_MS = TimeUnit.SECONDS.toMillis(30L);
    public static final double DEFAULT_MAX_RESOURCE_UTILIZATION = 0.8;
    public static final double DEFAULT_MIN_NON_EXEMPT_REQUEST_UTILIZATION = 0.3;
    public static final double MIN_BROKER_REQUEST_QUOTA = 10.0;
    public static final double DEFAULT_REQUEST_QUOTA_INCREASE_PERCENT_FACTOR = 0.02;
    public static final double DEFAULT_REQUEST_QUOTA_DECREASE_PERCENT_FACTOR = 0.1;
    public static final double REQUEST_QUOTA_MIN_ADJUSTMENT = 25.0;
    public static final String METRIC_GROUP = "backpressure-metrics";
    public static final boolean DEFAULT_BACKPRESSURE_ENABLED_IN_CONFIG = false;
    public static final double DEFAULT_MAX_QUEUE_SIZE = Double.MAX_VALUE;
    public static final double DEFAULT_MIN_BROKER_REQUEST_QUOTA = ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT.longValue();
    public static final String DEFAULT_QUEUE_SIZE_PERCENTILE = "p95";
    public final boolean backpressureEnabledInConfig;
    public final long backpressureCheckFrequencyMs;
    public final List<String> tenantEndpointListenerNames;
    public final double maxQueueSize;
    public final double minBrokerRequestQuota;
    public final String queueSizePercentile;

    public BrokerBackpressureConfig() {
        this(false);
    }

    public BrokerBackpressureConfig(boolean backpressureEnabledInConfig) {
        this(backpressureEnabledInConfig, DEFAULT_BACKPRESSURE_CHECK_FREQUENCY_MS);
    }

    public BrokerBackpressureConfig(boolean backpressureEnabledInConfig, long backpressureCheckFrequencyMs) {
        this(backpressureEnabledInConfig, backpressureCheckFrequencyMs, new ArrayList<String>());
    }

    public BrokerBackpressureConfig(boolean backpressureEnabledInConfig, long backpressureCheckFrequencyMs, List<String> tenantEndpointListenerNames) {
        this(backpressureEnabledInConfig, backpressureCheckFrequencyMs, tenantEndpointListenerNames, Double.MAX_VALUE, DEFAULT_MIN_BROKER_REQUEST_QUOTA, DEFAULT_QUEUE_SIZE_PERCENTILE);
    }

    public BrokerBackpressureConfig(boolean backpressureEnabledInConfig, List<String> tenantEndpointListenerNames, double maxQueueSize, double minBrokerRequestQuota, String queueSizePercentile) {
        this(backpressureEnabledInConfig, DEFAULT_BACKPRESSURE_CHECK_FREQUENCY_MS, tenantEndpointListenerNames, maxQueueSize, minBrokerRequestQuota, queueSizePercentile);
    }

    public BrokerBackpressureConfig(boolean backpressureEnabledInConfig, long backpressureCheckFrequencyMs, List<String> tenantEndpointListenerNames, double maxQueueSize, double minBrokerRequestQuota, String queueSizePercentile) {
        this.backpressureEnabledInConfig = backpressureEnabledInConfig;
        this.backpressureCheckFrequencyMs = backpressureCheckFrequencyMs;
        this.tenantEndpointListenerNames = tenantEndpointListenerNames;
        this.maxQueueSize = maxQueueSize;
        this.minBrokerRequestQuota = minBrokerRequestQuota;
        this.queueSizePercentile = queueSizePercentile;
    }

    public static MetricName nonExemptRequestCapacityMetricName(Metrics metrics) {
        return metrics.metricName("non-exempt-request-time-capacity", METRIC_GROUP, "Tracking maximum utilization percentage of IO and network threads available to non-exempt requests");
    }

    public double queueSizeCap() {
        if (this.maxQueueSize < Double.MAX_VALUE) {
            return this.maxQueueSize * 0.8;
        }
        return Double.MAX_VALUE;
    }

    public String toString() {
        return "BrokerBackpressureConfig{backpressureEnabledInConfig=" + this.backpressureEnabledInConfig + ", backpressureCheckFrequencyMs=" + this.backpressureCheckFrequencyMs + ", tenantEndpointListenerNames=" + this.tenantEndpointListenerNames + ", maxQueueSize=" + this.maxQueueSize + ", minBrokerRequestQuota=" + this.minBrokerRequestQuota + ", queueSizePercentile='" + this.queueSizePercentile + '\'' + '}';
    }
}

