/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.exceptions;

import io.confluent.rest.RestConfig;
import io.confluent.rest.entities.ErrorMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public abstract class DebuggableExceptionMapper<E extends Throwable>
implements ExceptionMapper<E> {
    RestConfig restConfig;
    private static final Logger log = LoggerFactory.getLogger(DebuggableExceptionMapper.class);
    @Context
    HttpHeaders headers;

    public DebuggableExceptionMapper(RestConfig restConfig) {
        this.restConfig = restConfig;
    }

    public Response.ResponseBuilder createResponse(Throwable exc, int errorCode, Response.StatusType status, String msg) {
        if (status.getFamily() == Response.Status.Family.SERVER_ERROR) {
            log.error("Request Failed with exception ", exc);
        } else {
            log.debug("Request Failed with exception ", exc);
        }
        String readableMessage = msg;
        if (this.restConfig != null && this.restConfig.getBoolean("debug").booleanValue()) {
            readableMessage = readableMessage + " " + exc.getClass().getName() + ": " + exc.getMessage();
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                PrintStream stream = new PrintStream((OutputStream)os, false, StandardCharsets.UTF_8.name());
                exc.printStackTrace(stream);
                stream.close();
                os.close();
                readableMessage = readableMessage + System.lineSeparator() + os.toString(StandardCharsets.UTF_8.name());
            }
            catch (IOException os) {
                // empty catch block
            }
        }
        ErrorMessage message = new ErrorMessage(errorCode, readableMessage);
        return Response.status((Response.StatusType)status).entity((Object)message);
    }

    public static class HttpStatus
    implements Response.StatusType {
        private final int code;
        private final String reason;
        private final Response.Status.Family family;

        public HttpStatus(int statusCode, String reasonPhrase) {
            if (statusCode < 0 || statusCode > 599) {
                throw new IllegalArgumentException("Http status code is not within valid range:statusCode: " + Integer.toString(statusCode));
            }
            this.code = statusCode;
            this.reason = reasonPhrase;
            this.family = Response.Status.Family.familyOf((int)statusCode);
        }

        public HttpStatus(Response.StatusType status) {
            this.code = status.getStatusCode();
            this.reason = status.getReasonPhrase();
            this.family = status.getFamily();
        }

        public Response.Status.Family getFamily() {
            return this.family;
        }

        public int getStatusCode() {
            return this.code;
        }

        public String getReasonPhrase() {
            return this.toString();
        }

        public String toString() {
            return this.reason;
        }
    }
}

