/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.common.types;

import com.google.protobuf.Any;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.projectnessie.cel.common.operators.Operator;
import org.projectnessie.cel.common.types.BoolT;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.IntT;
import org.projectnessie.cel.common.types.IterableT;
import org.projectnessie.cel.common.types.IteratorT;
import org.projectnessie.cel.common.types.StringT;
import org.projectnessie.cel.common.types.TypeT;
import org.projectnessie.cel.common.types.Types;
import org.projectnessie.cel.common.types.ref.BaseVal;
import org.projectnessie.cel.common.types.ref.Type;
import org.projectnessie.cel.common.types.ref.TypeAdapter;
import org.projectnessie.cel.common.types.ref.TypeEnum;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.common.types.traits.Container;
import org.projectnessie.cel.common.types.traits.Indexer;
import org.projectnessie.cel.common.types.traits.Mapper;
import org.projectnessie.cel.common.types.traits.Sizer;
import org.projectnessie.cel.common.types.traits.Trait;

public abstract class MapT
extends BaseVal
implements Mapper,
Container,
Indexer,
IterableT,
Sizer {
    public static final Type MapType = TypeT.newTypeValue(TypeEnum.Map, Trait.ContainerType, Trait.IndexerType, Trait.IterableType, Trait.SizerType);

    public static Val newWrappedMap(TypeAdapter adapter, Map<Val, Val> value) {
        return new ValMapT(adapter, value);
    }

    public static Val newMaybeWrappedMap(TypeAdapter adapter, Map<?, ?> value) {
        HashMap<Val, Val> newMap = new HashMap<Val, Val>(value.size() * 4 / 3 + 1);
        value.forEach((k, v) -> newMap.put(adapter.nativeToValue(k), adapter.nativeToValue(v)));
        return MapT.newWrappedMap(adapter, newMap);
    }

    @Override
    public Type type() {
        return MapType;
    }

    public static Val newJSONStruct(TypeAdapter adapter, Struct value) {
        Map fields = value.getFieldsMap();
        return MapT.newMaybeWrappedMap(adapter, fields);
    }

    static final class ValMapT
    extends MapT {
        private final TypeAdapter adapter;
        private final Map<Val, Val> map;

        ValMapT(TypeAdapter adapter, Map<Val, Val> map) {
            this.adapter = adapter;
            this.map = map;
        }

        @Override
        public <T> T convertToNative(Class<T> typeDesc) {
            if (Map.class.isAssignableFrom(typeDesc) || typeDesc == Object.class) {
                return (T)this.toJavaMap();
            }
            if (typeDesc == Struct.class) {
                return (T)this.toPbStruct();
            }
            if (typeDesc == Value.class) {
                return (T)this.toPbValue();
            }
            if (typeDesc == Any.class) {
                Struct v = this.toPbStruct();
                return (T)Any.newBuilder().setTypeUrl("type.googleapis.com/google.protobuf.Struct").setValue(v.toByteString()).build();
            }
            throw new RuntimeException(String.format("native type conversion error from '%s' to '%s'", MapType, typeDesc.getName()));
        }

        private Value toPbValue() {
            return Value.newBuilder().setStructValue(this.toPbStruct()).build();
        }

        private Struct toPbStruct() {
            Struct.Builder struct = Struct.newBuilder();
            this.map.forEach((k, v) -> struct.putFields(k.convertToType(StringT.StringType).value().toString(), v.convertToNative(Value.class)));
            return struct.build();
        }

        private Map toJavaMap() {
            HashMap r = new HashMap();
            this.map.forEach((k, v) -> r.put(k.value(), v.value()));
            return r;
        }

        @Override
        public Val convertToType(Type typeValue) {
            if (typeValue == MapType) {
                return this;
            }
            if (typeValue == TypeT.TypeType) {
                return MapType;
            }
            return Err.newTypeConversionError(MapType, typeValue);
        }

        @Override
        public IteratorT iterator() {
            return IteratorT.javaIterator(this.adapter, this.map.keySet().iterator());
        }

        @Override
        public Val equal(Val other) {
            if (!(other instanceof MapT)) {
                return BoolT.False;
            }
            MapT o = (MapT)other;
            if (!this.size().equal(o.size()).booleanValue()) {
                return BoolT.False;
            }
            IteratorT myIter = this.iterator();
            while (myIter.hasNext() == BoolT.True) {
                Val key = myIter.next();
                Val val = this.get(key);
                Val oVal = o.find(key);
                if (oVal == null) {
                    return BoolT.False;
                }
                if (Err.isError(val)) {
                    return val;
                }
                if (Err.isError(oVal)) {
                    return val;
                }
                if (val.type() != oVal.type()) {
                    return Err.noSuchOverload(val, Operator.Equals.id, oVal);
                }
                Val eq = val.equal(oVal);
                if (eq instanceof Err) {
                    return eq;
                }
                if (eq == BoolT.True) continue;
                return BoolT.False;
            }
            return BoolT.True;
        }

        @Override
        public Object value() {
            Map nativeMap = this.toJavaMap();
            return nativeMap;
        }

        @Override
        public Val contains(Val value) {
            return Types.boolOf(this.map.containsKey(value));
        }

        @Override
        public Val get(Val index) {
            return this.map.get(index);
        }

        @Override
        public Val size() {
            return IntT.intOf(this.map.size());
        }

        @Override
        public Val find(Val key) {
            return this.map.get(key);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValMapT valMapT = (ValMapT)o;
            return Objects.equals(this.map, valMapT.map);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.map);
        }

        @Override
        public String toString() {
            return "JavaMapT{adapter=" + this.adapter + ", map=" + this.map + '}';
        }
    }
}

