/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.server.common.FeatureVersion;
import org.apache.kafka.server.common.MetadataVersion;

public enum KRaftVersion implements FeatureVersion
{
    KRAFT_VERSION_0(0, MetadataVersion.MINIMUM_KRAFT_VERSION),
    KRAFT_VERSION_1(1, MetadataVersion.IBP_3_9_IV0A);

    public static final String FEATURE_NAME = "kraft.version";
    private final short featureLevel;
    private final MetadataVersion bootstrapMetadataVersion;

    private KRaftVersion(int featureLevel, MetadataVersion bootstrapMetadataVersion) {
        this.featureLevel = (short)featureLevel;
        this.bootstrapMetadataVersion = bootstrapMetadataVersion;
    }

    @Override
    public short featureLevel() {
        return this.featureLevel;
    }

    public static KRaftVersion fromFeatureLevel(short version) {
        switch (version) {
            case 0: {
                return KRAFT_VERSION_0;
            }
            case 1: {
                return KRAFT_VERSION_1;
            }
        }
        throw new RuntimeException("Unknown KRaft feature level: " + version);
    }

    public boolean isReconfigSupported() {
        return this != KRAFT_VERSION_0;
    }

    @Override
    public String featureName() {
        return FEATURE_NAME;
    }

    @Override
    public MetadataVersion bootstrapMetadataVersion() {
        return this.bootstrapMetadataVersion;
    }

    @Override
    public Map<String, Short> dependencies() {
        if (this.featureLevel == 0) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap("confluent.metadata.version", MetadataVersion.IBP_3_9_IV0A.confluentFeatureLevel());
    }

    public short quorumStateVersion() {
        switch (this) {
            case KRAFT_VERSION_0: {
                return 0;
            }
            case KRAFT_VERSION_1: {
                return 1;
            }
        }
        throw new IllegalStateException("Unsupported KRaft feature level: " + this);
    }

    public short kraftVersionRecordVersion() {
        switch (this) {
            case KRAFT_VERSION_1: {
                return 0;
            }
        }
        throw new IllegalStateException("Unsupported KRaft feature level: " + this);
    }

    public short votersRecordVersion() {
        switch (this) {
            case KRAFT_VERSION_1: {
                return 0;
            }
        }
        throw new IllegalStateException("Unsupported KRaft feature level: " + this);
    }
}

