/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.errors.IllegalWorkerStateException;
import org.apache.kafka.connect.runtime.WorkerSinkTask;
import org.apache.kafka.connect.sink.ErrantRecordReporter;
import org.apache.kafka.connect.sink.SinkTaskContext;
import org.apache.kafka.connect.storage.ClusterConfigState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerSinkTaskContext
implements SinkTaskContext {
    private static final Logger log = LoggerFactory.getLogger(WorkerSinkTaskContext.class);
    private final Map<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
    private final Consumer<byte[], byte[]> consumer;
    private final WorkerSinkTask sinkTask;
    private final ClusterConfigState configState;
    private final Set<TopicPartition> pausedPartitions;
    private long timeoutMs = -1L;
    private boolean commitRequested;

    public WorkerSinkTaskContext(Consumer<byte[], byte[]> consumer, WorkerSinkTask sinkTask, ClusterConfigState configState) {
        this.consumer = consumer;
        this.sinkTask = sinkTask;
        this.configState = configState;
        this.pausedPartitions = new HashSet<TopicPartition>();
    }

    public Map<String, String> configs() {
        return this.configState.taskConfig(this.sinkTask.id());
    }

    public void offset(Map<TopicPartition, Long> offsets) {
        log.debug("{} Setting offsets for topic partitions {}", (Object)this, offsets);
        this.offsets.putAll(offsets);
    }

    public void offset(TopicPartition tp, long offset) {
        log.debug("{} Setting offset for topic partition {} to {}", new Object[]{this, tp, offset});
        this.offsets.put(tp, offset);
    }

    public void clearOffsets() {
        this.offsets.clear();
    }

    public Map<TopicPartition, Long> offsets() {
        return this.offsets;
    }

    public void timeout(long timeoutMs) {
        log.debug("{} Setting timeout to {} ms", (Object)this, (Object)timeoutMs);
        this.timeoutMs = timeoutMs;
    }

    public long timeout() {
        return this.timeoutMs;
    }

    public Set<TopicPartition> assignment() {
        if (this.consumer == null) {
            throw new IllegalWorkerStateException("SinkTaskContext may not be used to look up partition assignment until the task is initialized");
        }
        return this.consumer.assignment();
    }

    public void pause(TopicPartition ... partitions) {
        if (this.consumer == null) {
            throw new IllegalWorkerStateException("SinkTaskContext may not be used to pause consumption until the task is initialized");
        }
        try {
            Collections.addAll(this.pausedPartitions, partitions);
            if (this.sinkTask.shouldPause()) {
                log.debug("{} Connector is paused, so not pausing consumer's partitions {}", (Object)this, (Object)partitions);
            } else {
                this.consumer.pause(Arrays.asList(partitions));
                log.debug("{} Pausing partitions {}. Connector is not paused.", (Object)this, (Object)partitions);
            }
        }
        catch (IllegalStateException e) {
            throw new IllegalWorkerStateException("SinkTasks may not pause partitions that are not currently assigned to them.", (Throwable)e);
        }
    }

    public void resume(TopicPartition ... partitions) {
        if (this.consumer == null) {
            throw new IllegalWorkerStateException("SinkTaskContext may not be used to resume consumption until the task is initialized");
        }
        try {
            this.pausedPartitions.removeAll(Arrays.asList(partitions));
            if (this.sinkTask.shouldPause()) {
                log.debug("{} Connector is paused, so not resuming consumer's partitions {}", (Object)this, (Object)partitions);
            } else {
                this.consumer.resume(Arrays.asList(partitions));
                log.debug("{} Resuming partitions: {}", (Object)this, (Object)partitions);
            }
        }
        catch (IllegalStateException e) {
            throw new IllegalWorkerStateException("SinkTasks may not resume partitions that are not currently assigned to them.", (Throwable)e);
        }
    }

    public Set<TopicPartition> pausedPartitions() {
        return this.pausedPartitions;
    }

    public void requestCommit() {
        log.debug("{} Requesting commit", (Object)this);
        this.commitRequested = true;
    }

    public boolean isCommitRequested() {
        return this.commitRequested;
    }

    public void clearCommitRequest() {
        this.commitRequested = false;
    }

    public ErrantRecordReporter errantRecordReporter() {
        return this.sinkTask.workerErrantRecordReporter();
    }

    public String toString() {
        return "WorkerSinkTaskContext{id=" + this.sinkTask.id + '}';
    }
}

