/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.distributed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.connector.policy.ConnectorClientConfigOverridePolicy;
import org.apache.kafka.connect.errors.AlreadyExistsException;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.NotFoundException;
import org.apache.kafka.connect.health.ConnectorType;
import org.apache.kafka.connect.runtime.AbstractHerder;
import org.apache.kafka.connect.runtime.AbstractStatus;
import org.apache.kafka.connect.runtime.ConnectMetrics;
import org.apache.kafka.connect.runtime.ConnectMetricsRegistry;
import org.apache.kafka.connect.runtime.ConnectorConfig;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.HerderConnectorContext;
import org.apache.kafka.connect.runtime.HerderRequest;
import org.apache.kafka.connect.runtime.RestartPlan;
import org.apache.kafka.connect.runtime.RestartRequest;
import org.apache.kafka.connect.runtime.SessionKey;
import org.apache.kafka.connect.runtime.SinkConnectorConfig;
import org.apache.kafka.connect.runtime.SourceConnectorConfig;
import org.apache.kafka.connect.runtime.TargetState;
import org.apache.kafka.connect.runtime.TooManyTasksException;
import org.apache.kafka.connect.runtime.Worker;
import org.apache.kafka.connect.runtime.distributed.ConnectProtocolCompatibility;
import org.apache.kafka.connect.runtime.distributed.DistributedConfig;
import org.apache.kafka.connect.runtime.distributed.ExtendedAssignment;
import org.apache.kafka.connect.runtime.distributed.NotAssignedException;
import org.apache.kafka.connect.runtime.distributed.NotLeaderException;
import org.apache.kafka.connect.runtime.distributed.RebalanceNeededException;
import org.apache.kafka.connect.runtime.distributed.WorkerGroupMember;
import org.apache.kafka.connect.runtime.distributed.WorkerRebalanceListener;
import org.apache.kafka.connect.runtime.rest.InternalRequestSignature;
import org.apache.kafka.connect.runtime.rest.RestClient;
import org.apache.kafka.connect.runtime.rest.entities.ConfigInfos;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorOffsets;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorStateInfo;
import org.apache.kafka.connect.runtime.rest.entities.Message;
import org.apache.kafka.connect.runtime.rest.entities.TaskInfo;
import org.apache.kafka.connect.runtime.rest.errors.BadRequestException;
import org.apache.kafka.connect.runtime.rest.errors.ConnectRestException;
import org.apache.kafka.connect.source.ConnectorTransactionBoundaries;
import org.apache.kafka.connect.source.ExactlyOnceSupport;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.source.SourceTask;
import org.apache.kafka.connect.storage.ClusterConfigState;
import org.apache.kafka.connect.storage.ConfigBackingStore;
import org.apache.kafka.connect.storage.PrivilegedWriteException;
import org.apache.kafka.connect.storage.StatusBackingStore;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.ConnectUtils;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.apache.kafka.connect.util.FutureCallback;
import org.apache.kafka.connect.util.SinkUtils;
import org.apache.kafka.connect.util.Stage;
import org.apache.kafka.connect.util.TemporaryStage;
import org.slf4j.Logger;

public class DistributedHerder
extends AbstractHerder
implements Runnable {
    private final Logger log;
    private static final long FORWARD_REQUEST_SHUTDOWN_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(10L);
    private static final long START_AND_STOP_SHUTDOWN_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(1L);
    private static final long RECONFIGURE_CONNECTOR_TASKS_BACKOFF_INITIAL_MS = 250L;
    static final long RECONFIGURE_CONNECTOR_TASKS_BACKOFF_MAX_MS = 60000L;
    private static final long CONFIG_TOPIC_WRITE_PRIVILEGES_BACKOFF_MS = 250L;
    private static final int START_STOP_THREAD_POOL_SIZE = 8;
    private static final short BACKOFF_RETRIES = 5;
    private final AtomicLong requestSeqNum = new AtomicLong();
    private final Time time;
    private final HerderMetrics herderMetrics;
    private final List<AutoCloseable> uponShutdown;
    private final String workerGroupId;
    private final int workerSyncTimeoutMs;
    private final int workerUnsyncBackoffMs;
    private final int keyRotationIntervalMs;
    private final String requestSignatureAlgorithm;
    private final List<String> keySignatureVerificationAlgorithms;
    private final KeyGenerator keyGenerator;
    private final RestClient restClient;
    ExecutorService forwardRequestExecutor;
    final ExecutorService herderExecutor;
    ExecutorService startAndStopExecutor;
    private final WorkerGroupMember member;
    private final AtomicBoolean stopping;
    private final boolean isTopicTrackingEnabled;
    private boolean rebalanceResolved;
    private ExtendedAssignment runningAssignment = ExtendedAssignment.empty();
    private final Set<ConnectorTaskId> tasksToRestart = new HashSet<ConnectorTaskId>();
    ExtendedAssignment assignment;
    private boolean canReadConfigs;
    protected ClusterConfigState configState;
    boolean preemptiveScheduledRebalanceEndEnabled;
    final NavigableSet<DistributedHerderRequest> requests = new ConcurrentSkipListSet<DistributedHerderRequest>();
    private Set<String> connectorConfigUpdates = new HashSet<String>();
    private Set<ConnectorTaskId> taskConfigUpdates = new HashSet<ConnectorTaskId>();
    private Set<String> connectorTargetStateChanges = new HashSet<String>();
    private final Map<String, ZombieFencing> activeZombieFencings = new HashMap<String, ZombieFencing>();
    private final List<String> restNamespace;
    private boolean needsReconfigRebalance;
    private volatile boolean fencedFromConfigTopic;
    private volatile int generation;
    private volatile long scheduledRebalance;
    private volatile SecretKey sessionKey;
    private volatile long keyExpiration;
    private short currentProtocolVersion;
    private short backoffRetries;
    private volatile DistributedHerderRequest currentRequest;
    private volatile Stage tickThreadStage;
    final Map<String, RestartRequest> pendingRestartRequests = new HashMap<String, RestartRequest>();
    Thread herderThread;
    private final DistributedConfig config;
    private Future<?> herderTask;

    public DistributedHerder(DistributedConfig config, Time time, Worker worker, String kafkaClusterId, StatusBackingStore statusBackingStore, ConfigBackingStore configBackingStore, String restUrl, RestClient restClient, ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy, List<String> restNamespace, AutoCloseable ... uponShutdown) {
        this(config, worker, worker.workerId(), kafkaClusterId, statusBackingStore, configBackingStore, null, restUrl, restClient, worker.metrics(), time, connectorClientConfigOverridePolicy, restNamespace, null, uponShutdown);
        configBackingStore.setUpdateListener(new ConfigUpdateListener());
    }

    DistributedHerder(DistributedConfig config, Worker worker, String workerId, String kafkaClusterId, StatusBackingStore statusBackingStore, ConfigBackingStore configBackingStore, WorkerGroupMember member, String restUrl, RestClient restClient, ConnectMetrics metrics, Time time, ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy, List<String> restNamespace, ExecutorService forwardRequestExecutor, AutoCloseable[] uponShutdown) {
        super(worker, workerId, kafkaClusterId, statusBackingStore, configBackingStore, connectorClientConfigOverridePolicy, time);
        this.time = time;
        this.herderMetrics = new HerderMetrics(metrics);
        this.workerGroupId = config.getString("group.id");
        this.workerSyncTimeoutMs = config.getInt("worker.sync.timeout.ms");
        this.workerUnsyncBackoffMs = config.getInt("worker.unsync.backoff.ms");
        this.requestSignatureAlgorithm = config.getString("inter.worker.signature.algorithm");
        this.keyRotationIntervalMs = config.getInt("inter.worker.key.ttl.ms");
        this.keySignatureVerificationAlgorithms = config.getList("inter.worker.verification.algorithms");
        this.keyGenerator = config.getInternalRequestKeyGenerator();
        this.restClient = restClient;
        this.isTopicTrackingEnabled = config.getBoolean("topic.tracking.enable");
        this.restNamespace = Objects.requireNonNull(restNamespace);
        this.uponShutdown = Arrays.asList(uponShutdown);
        String clientIdConfig = config.getString("client.id");
        String clientId = clientIdConfig.isEmpty() ? "connect-" + workerId : clientIdConfig;
        String escapedClientIdForThreadNameFormat = clientId.replace("%", "%%");
        LogContext logContext = new LogContext("[Worker clientId=" + clientId + ", groupId=" + this.workerGroupId + "] ");
        this.log = logContext.logger(DistributedHerder.class);
        this.member = member != null ? member : new WorkerGroupMember(config, restUrl, this.configBackingStore, new RebalanceListener(time), time, clientId, logContext, metrics);
        this.herderExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(1), ThreadUtils.createThreadFactory((String)(this.getClass().getSimpleName() + "-" + escapedClientIdForThreadNameFormat + "-%d"), (boolean)false));
        this.forwardRequestExecutor = forwardRequestExecutor != null ? forwardRequestExecutor : Executors.newFixedThreadPool(1, ThreadUtils.createThreadFactory((String)("ForwardRequestExecutor-" + escapedClientIdForThreadNameFormat + "-%d"), (boolean)false));
        this.startAndStopExecutor = Executors.newFixedThreadPool(8, ThreadUtils.createThreadFactory((String)("StartAndStopExecutor-" + escapedClientIdForThreadNameFormat + "-%d"), (boolean)false));
        this.config = config;
        this.stopping = new AtomicBoolean(false);
        this.configState = ClusterConfigState.EMPTY;
        this.rebalanceResolved = true;
        this.needsReconfigRebalance = false;
        this.fencedFromConfigTopic = false;
        this.canReadConfigs = true;
        this.scheduledRebalance = Long.MAX_VALUE;
        this.keyExpiration = Long.MAX_VALUE;
        this.sessionKey = null;
        this.backoffRetries = (short)5;
        this.currentRequest = null;
        this.tickThreadStage = new Stage("awaiting startup", time.milliseconds());
        this.currentProtocolVersion = ConnectProtocolCompatibility.compatibility(config.getString("connect.protocol")).protocolVersion();
        if (!DistributedHerder.internalRequestValidationEnabled(this.currentProtocolVersion)) {
            this.log.warn("Internal request verification will be disabled for this cluster as this worker's {} configuration has been set to '{}'. If this is not intentional, either remove the '{}' configuration from the worker config file or change its value to '{}'. If this configuration is left as-is, the cluster will be insecure; for more information, see KIP-507: https://cwiki.apache.org/confluence/display/KAFKA/KIP-507%3A+Securing+Internal+Connect+REST+Endpoints", new Object[]{"connect.protocol", config.getString("connect.protocol"), "connect.protocol", ConnectProtocolCompatibility.SESSIONED.name()});
        }
        this.preemptiveScheduledRebalanceEndEnabled = config.getBoolean("confluent.preemptive.scheduled.rebalance.end.enable");
    }

    @Override
    public void start() {
        this.herderTask = this.herderExecutor.submit(this);
    }

    @Override
    public void run() {
        try {
            this.log.info("Herder starting");
            this.herderThread = Thread.currentThread();
            try (TickThreadStage stage = new TickThreadStage("initializing and reading to the end of internal topics");){
                this.startServices();
            }
            while (!this.stopping.get()) {
                this.tick();
                if (this.isReady()) continue;
                this.ready();
                this.log.info("Herder started");
            }
            this.recordTickThreadStage("shutting down");
            this.halt();
            this.log.info("Herder stopped");
        }
        catch (Throwable t) {
            this.log.error("Uncaught exception in herder work thread, exiting: ", t);
            Utils.closeQuietly(this::stopServices, (String)"herder services");
            Exit.exit((int)1);
        }
    }

    public Future<?> herderTask() {
        return this.herderTask;
    }

    public void tick() {
        DistributedHerderRequest next;
        long now;
        try {
            if (!this.canReadConfigs) {
                if (this.readConfigToEnd(this.workerSyncTimeoutMs)) {
                    this.canReadConfigs = true;
                } else {
                    return;
                }
            }
            this.log.debug("Ensuring group membership is still active");
            String stageDescription = "ensuring membership in the cluster";
            this.member.ensureActive(() -> new TickThreadStage(stageDescription));
            this.completeTickThreadStage();
            if (!this.handleRebalanceCompleted()) {
                return;
            }
        }
        catch (WakeupException e) {
            this.log.trace("Woken up while ensure group membership is still active");
            return;
        }
        if (this.fencedFromConfigTopic) {
            if (this.isLeader()) {
                try {
                    this.log.debug("Reclaiming write privileges for config topic after being fenced out");
                    try (TickThreadStage stage = new TickThreadStage("reclaiming write privileges for the config topic");){
                        this.configBackingStore.claimWritePrivileges();
                    }
                    this.fencedFromConfigTopic = false;
                    this.log.debug("Successfully reclaimed write privileges for config topic after being fenced out");
                }
                catch (Exception e) {
                    this.log.warn("Unable to claim write privileges for config topic. Will backoff and possibly retry if still the leader", (Throwable)e);
                    this.backoff(250L);
                    return;
                }
            }
            this.log.trace("Relinquished write privileges for config topic after being fenced out, since worker is no longer the leader of the cluster");
            this.fencedFromConfigTopic = false;
        }
        if (this.checkForKeyRotation(now = this.time.milliseconds())) {
            this.log.debug("Distributing new session key");
            this.keyExpiration = Long.MAX_VALUE;
            try {
                SessionKey newSessionKey = new SessionKey(this.keyGenerator.generateKey(), now);
                this.writeToConfigTopicAsLeader("writing a new session key to the config topic", () -> this.configBackingStore.putSessionKey(newSessionKey));
            }
            catch (Exception e) {
                this.log.info("Failed to write new session key to config topic; forcing a read to the end of the config topic before possibly retrying", (Throwable)e);
                this.canReadConfigs = false;
                return;
            }
        }
        Long scheduledTick = null;
        while ((next = this.peekWithoutException()) != null) {
            if (now < next.at) {
                scheduledTick = next.at;
                break;
            }
            this.currentRequest = this.requests.pollFirst();
            this.runRequest(next.action(), next.callback());
        }
        this.processRestartRequests();
        if (this.scheduledRebalance < Long.MAX_VALUE) {
            scheduledTick = scheduledTick != null ? Math.min(scheduledTick, this.scheduledRebalance) : this.scheduledRebalance;
            this.rebalanceResolved = false;
            this.log.debug("Scheduled rebalance at: {} (now: {} scheduledTick: {}) ", new Object[]{this.scheduledRebalance, now, scheduledTick});
        }
        if (this.isLeader() && this.internalRequestValidationEnabled() && this.keyExpiration < Long.MAX_VALUE) {
            scheduledTick = scheduledTick != null ? Math.min(scheduledTick, this.keyExpiration) : this.keyExpiration;
            this.log.debug("Scheduled next key rotation at: {} (now: {} scheduledTick: {}) ", new Object[]{this.keyExpiration, now, scheduledTick});
        }
        AtomicReference<Set<String>> connectorConfigUpdatesCopy = new AtomicReference<Set<String>>();
        AtomicReference<Set<String>> connectorTargetStateChangesCopy = new AtomicReference<Set<String>>();
        AtomicReference<Set<ConnectorTaskId>> taskConfigUpdatesCopy = new AtomicReference<Set<ConnectorTaskId>>();
        if (this.member.currentProtocolVersion() == 0) {
            boolean shouldReturn = this.updateConfigsWithEager(connectorConfigUpdatesCopy, connectorTargetStateChangesCopy);
            if (shouldReturn) {
                return;
            }
            if (connectorConfigUpdatesCopy.get() != null) {
                this.processConnectorConfigUpdates(connectorConfigUpdatesCopy.get());
            }
            if (connectorTargetStateChangesCopy.get() != null) {
                this.processTargetStateChanges(connectorTargetStateChangesCopy.get());
            }
        } else {
            boolean shouldReturn = this.updateConfigsWithIncrementalCooperative(connectorConfigUpdatesCopy, connectorTargetStateChangesCopy, taskConfigUpdatesCopy);
            if (connectorConfigUpdatesCopy.get() != null) {
                this.processConnectorConfigUpdates(connectorConfigUpdatesCopy.get());
            }
            if (connectorTargetStateChangesCopy.get() != null) {
                this.processTargetStateChanges(connectorTargetStateChangesCopy.get());
            }
            if (taskConfigUpdatesCopy.get() != null) {
                this.processTaskConfigUpdatesWithIncrementalCooperative(taskConfigUpdatesCopy.get());
            }
            if (shouldReturn) {
                return;
            }
        }
        try {
            long nextRequestTimeoutMs = scheduledTick != null ? Math.max(scheduledTick - this.time.milliseconds(), 0L) : Long.MAX_VALUE;
            this.log.trace("Polling for group activity; will wait for {}ms or until poll is interrupted by either config backing store updates or a new external request", (Object)nextRequestTimeoutMs);
            String pollDurationDescription = scheduledTick != null ? "for up to " + nextRequestTimeoutMs + "ms or " : "";
            String stageDescription = "polling the group coordinator " + pollDurationDescription + "until interrupted";
            this.member.poll(nextRequestTimeoutMs, () -> new TickThreadStage(stageDescription));
            this.completeTickThreadStage();
            this.handleRebalanceCompleted();
        }
        catch (WakeupException e) {
            this.log.trace("Woken up while polling for group activity");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForKeyRotation(long now) {
        long expiration;
        SecretKey key;
        DistributedHerder distributedHerder = this;
        synchronized (distributedHerder) {
            if (this.sessionKey == null && this.configState.sessionKey() != null) {
                this.sessionKey = this.configState.sessionKey().key();
                this.keyExpiration = this.configState.sessionKey().creationTimestamp() + (long)this.keyRotationIntervalMs;
            }
            key = this.sessionKey;
            expiration = this.keyExpiration;
        }
        if (this.internalRequestValidationEnabled() && this.isLeader()) {
            if (key == null) {
                this.log.debug("Internal request signing is enabled but no session key has been distributed yet. Distributing new key now.");
                return true;
            }
            if (expiration <= now) {
                this.log.debug("Existing key has expired. Distributing new key now.");
                return true;
            }
            if (!key.getAlgorithm().equals(this.keyGenerator.getAlgorithm()) || key.getEncoded().length != this.keyGenerator.generateKey().getEncoded().length) {
                this.log.debug("Previously-distributed key uses different algorithm/key size than required by current worker configuration. Distributing new key now.");
                return true;
            }
        }
        return false;
    }

    private synchronized boolean updateConfigsWithEager(AtomicReference<Set<String>> connectorConfigUpdatesCopy, AtomicReference<Set<String>> connectorTargetStateChangesCopy) {
        if (this.needsReconfigRebalance || !this.connectorConfigUpdates.isEmpty() || !this.connectorTargetStateChanges.isEmpty()) {
            this.log.trace("Handling config updates with eager rebalancing");
            this.configState = this.configBackingStore.snapshot();
            if (this.needsReconfigRebalance) {
                this.log.debug("Requesting rebalance due to reconfiguration of tasks (needsReconfigRebalance: {})", (Object)this.needsReconfigRebalance);
                this.member.requestRejoin();
                this.needsReconfigRebalance = false;
                this.connectorConfigUpdates.clear();
                this.connectorTargetStateChanges.clear();
                return true;
            }
            if (!this.connectorConfigUpdates.isEmpty()) {
                connectorConfigUpdatesCopy.set(this.connectorConfigUpdates);
                this.connectorConfigUpdates = new HashSet<String>();
            }
            if (!this.connectorTargetStateChanges.isEmpty()) {
                connectorTargetStateChangesCopy.set(this.connectorTargetStateChanges);
                this.connectorTargetStateChanges = new HashSet<String>();
            }
        } else {
            this.log.trace("Skipping config updates with eager rebalancing since no config rebalance is required and there are no connector config, task config, or target state changes pending");
        }
        return false;
    }

    private synchronized boolean updateConfigsWithIncrementalCooperative(AtomicReference<Set<String>> connectorConfigUpdatesCopy, AtomicReference<Set<String>> connectorTargetStateChangesCopy, AtomicReference<Set<ConnectorTaskId>> taskConfigUpdatesCopy) {
        boolean retValue = false;
        if (this.needsReconfigRebalance || !this.connectorConfigUpdates.isEmpty() || !this.connectorTargetStateChanges.isEmpty() || !this.taskConfigUpdates.isEmpty()) {
            this.log.trace("Handling config updates with incremental cooperative rebalancing");
            this.configState = this.configBackingStore.snapshot();
            if (this.needsReconfigRebalance) {
                this.log.debug("Requesting rebalance due to reconfiguration of tasks (needsReconfigRebalance: {})", (Object)this.needsReconfigRebalance);
                this.member.requestRejoin();
                this.needsReconfigRebalance = false;
                retValue = true;
            }
            if (!this.connectorConfigUpdates.isEmpty()) {
                connectorConfigUpdatesCopy.set(this.connectorConfigUpdates);
                this.connectorConfigUpdates = new HashSet<String>();
            }
            if (!this.connectorTargetStateChanges.isEmpty()) {
                connectorTargetStateChangesCopy.set(this.connectorTargetStateChanges);
                this.connectorTargetStateChanges = new HashSet<String>();
            }
            if (!this.taskConfigUpdates.isEmpty()) {
                taskConfigUpdatesCopy.set(this.taskConfigUpdates);
                this.taskConfigUpdates = new HashSet<ConnectorTaskId>();
            }
        } else {
            this.log.trace("Skipping config updates with incremental cooperative rebalancing since no config rebalance is required and there are no connector config, task config, or target state changes pending");
        }
        return retValue;
    }

    private void processConnectorConfigUpdates(Set<String> connectorConfigUpdates) {
        HashSet<String> localConnectors = this.assignment == null ? Collections.emptySet() : new HashSet<String>(this.assignment.connectors());
        ArrayList<Callable<Void>> connectorsToStart = new ArrayList<Callable<Void>>();
        this.log.trace("Processing connector config updates; currently-owned connectors are {}, and to-be-updated connectors are {}", localConnectors, connectorConfigUpdates);
        for (String connectorName : connectorConfigUpdates) {
            if (!localConnectors.contains(connectorName)) {
                this.log.trace("Skipping config update for connector {} as it is not owned by this worker", (Object)connectorName);
                continue;
            }
            boolean remains = this.configState.contains(connectorName);
            this.log.info("Handling connector-only config update by {} connector {}", (Object)(remains ? "restarting" : "stopping"), (Object)connectorName);
            try (TickThreadStage stage = new TickThreadStage("stopping connector " + connectorName);){
                this.worker.stopAndAwaitConnector(connectorName);
            }
            if (!remains) continue;
            connectorsToStart.add(this.getConnectorStartingCallable(connectorName));
        }
        String stageDescription = "restarting " + connectorsToStart.size() + " reconfigured connectors";
        this.startAndStop(connectorsToStart, stageDescription);
    }

    private void processTargetStateChanges(Set<String> connectorTargetStateChanges) {
        this.log.trace("Processing target state updates; currently-known connectors are {}, and to-be-updated connectors are {}", this.configState.connectors(), connectorTargetStateChanges);
        for (String connector : connectorTargetStateChanges) {
            TargetState targetState = this.configState.targetState(connector);
            if (!this.configState.connectors().contains(connector)) {
                this.log.debug("Received target state change for unknown connector: {}", (Object)connector);
                continue;
            }
            this.worker.setTargetState(connector, targetState, (error, newState) -> {
                if (error != null) {
                    this.log.error("Failed to transition connector to target state", error);
                    return;
                }
                if (newState == TargetState.STARTED) {
                    this.requestTaskReconfiguration(connector);
                }
            });
        }
    }

    private void processTaskConfigUpdatesWithIncrementalCooperative(Set<ConnectorTaskId> taskConfigUpdates) {
        HashSet<ConnectorTaskId> localTasks = this.assignment == null ? Collections.emptySet() : new HashSet<ConnectorTaskId>(this.assignment.tasks());
        this.log.trace("Processing task config updates with incremental cooperative rebalance protocol; currently-owned tasks are {}, and to-be-updated tasks are {}", localTasks, taskConfigUpdates);
        Set<String> connectorsWhoseTasksToStop = taskConfigUpdates.stream().map(ConnectorTaskId::connector).collect(Collectors.toSet());
        this.stopReconfiguredTasks(connectorsWhoseTasksToStop);
    }

    private void stopReconfiguredTasks(Set<String> connectors) {
        HashSet<ConnectorTaskId> localTasks = this.assignment == null ? Collections.emptySet() : new HashSet<ConnectorTaskId>(this.assignment.tasks());
        List<ConnectorTaskId> tasksToStop = localTasks.stream().filter(taskId -> connectors.contains(taskId.connector())).collect(Collectors.toList());
        if (tasksToStop.isEmpty()) {
            return;
        }
        this.log.info("Handling task config update by stopping tasks {}, which will be restarted after rebalance if still assigned to this worker", tasksToStop);
        try (TickThreadStage stage = new TickThreadStage("stopping " + tasksToStop.size() + " reconfigured tasks");){
            this.worker.stopAndAwaitTasks(tasksToStop);
        }
        this.tasksToRestart.addAll(tasksToStop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halt() {
        DistributedHerder distributedHerder = this;
        synchronized (distributedHerder) {
            this.log.info("Stopping connectors and tasks that are still assigned to this worker.");
            this.worker.stopAndAwaitConnectors();
            this.worker.stopAndAwaitTasks();
            DistributedHerderRequest request = this.requests.pollFirst();
            while (request != null) {
                request.callback().onCompletion(new ConnectException("Worker is shutting down"), null);
                request = this.requests.pollFirst();
            }
            this.stopServices();
        }
    }

    @Override
    protected void stopServices() {
        try {
            super.stopServices();
        }
        finally {
            this.closeResources();
        }
    }

    private void closeResources() {
        Utils.closeQuietly(this.member::stop, (String)"worker group member");
        Utils.closeQuietly(this.herderMetrics::close, (String)"herder metrics");
        this.uponShutdown.forEach(closeable -> Utils.closeQuietly((AutoCloseable)closeable, (String)(closeable != null ? closeable.toString() : "<unknown>")));
    }

    private long herderExecutorTimeoutMs() {
        return (long)this.workerSyncTimeoutMs + this.config.getLong("task.shutdown.graceful.timeout.ms") + Worker.CONNECTOR_GRACEFUL_SHUTDOWN_TIMEOUT_MS + 10000L;
    }

    @Override
    public void stop() {
        this.log.info("Herder stopping");
        this.stopping.set(true);
        this.member.wakeup();
        ThreadUtils.shutdownExecutorServiceQuietly((ExecutorService)this.herderExecutor, (long)this.herderExecutorTimeoutMs(), (TimeUnit)TimeUnit.MILLISECONDS);
        ThreadUtils.shutdownExecutorServiceQuietly((ExecutorService)this.forwardRequestExecutor, (long)FORWARD_REQUEST_SHUTDOWN_TIMEOUT_MS, (TimeUnit)TimeUnit.MILLISECONDS);
        ThreadUtils.shutdownExecutorServiceQuietly((ExecutorService)this.startAndStopExecutor, (long)START_AND_STOP_SHUTDOWN_TIMEOUT_MS, (TimeUnit)TimeUnit.MILLISECONDS);
        this.log.info("Herder stopped");
    }

    @Override
    public void healthCheck(Callback<Void> callback) {
        this.addRequest(() -> {
            callback.onCompletion(null, null);
            return null;
        }, DistributedHerder.forwardErrorAndTickThreadStages(callback));
    }

    @Override
    public void connectors(Callback<Collection<String>> callback) {
        this.log.trace("Submitting connector listing request");
        this.addRequest(() -> {
            if (!this.checkRebalanceNeeded(callback)) {
                callback.onCompletion(null, this.configState.connectors());
            }
            return null;
        }, DistributedHerder.forwardErrorAndTickThreadStages(callback));
    }

    @Override
    public void connectorInfo(String connName, Callback<ConnectorInfo> callback) {
        this.log.trace("Submitting connector info request {}", (Object)connName);
        this.addRequest(() -> {
            if (this.checkRebalanceNeeded(callback)) {
                return null;
            }
            if (!this.configState.contains(connName)) {
                callback.onCompletion((Throwable)new NotFoundException("Connector " + connName + " not found"), null);
            } else {
                callback.onCompletion(null, this.connectorInfo(connName));
            }
            return null;
        }, DistributedHerder.forwardErrorAndTickThreadStages(callback));
    }

    @Override
    public void tasksConfig(String connName, Callback<Map<ConnectorTaskId, Map<String, String>>> callback) {
        this.log.trace("Submitting tasks config request {}", (Object)connName);
        this.addRequest(() -> {
            if (this.checkRebalanceNeeded(callback)) {
                return null;
            }
            if (!this.configState.contains(connName)) {
                callback.onCompletion((Throwable)new NotFoundException("Connector " + connName + " not found"), null);
            } else {
                callback.onCompletion(null, this.buildTasksConfig(connName));
            }
            return null;
        }, DistributedHerder.forwardErrorAndTickThreadStages(callback));
    }

    @Override
    protected Map<String, String> rawConfig(String connName) {
        return this.configState.rawConnectorConfig(connName);
    }

    @Override
    public void connectorConfig(String connName, Callback<Map<String, String>> callback) {
        this.log.trace("Submitting connector config read request {}", (Object)connName);
        super.connectorConfig(connName, callback);
    }

    @Override
    public void deleteConnectorConfig(String connName, Callback<Herder.Created<ConnectorInfo>> callback) {
        this.addRequest(() -> {
            this.log.trace("Handling connector config request {}", (Object)connName);
            if (!this.isLeader()) {
                callback.onCompletion((Throwable)((Object)new NotLeaderException("Only the leader can delete connector configs.", this.leaderUrl())), null);
                return null;
            }
            if (!this.configState.contains(connName)) {
                callback.onCompletion((Throwable)new NotFoundException("Connector " + connName + " not found"), null);
            } else {
                this.log.trace("Removing connector config {} {}", (Object)connName, this.configState.connectors());
                this.writeToConfigTopicAsLeader("removing the config for connector " + connName + " from the config topic", () -> this.configBackingStore.removeConnectorConfig(connName));
                callback.onCompletion(null, new Herder.Created<Object>(false, null));
            }
            return null;
        }, DistributedHerder.forwardErrorAndTickThreadStages(callback));
    }

    @Override
    protected Map<String, ConfigValue> validateSinkConnectorConfig(ConfigDef configDef, Map<String, String> config) {
        Map<String, ConfigValue> validatedConfig = super.validateSinkConnectorConfig(configDef, config);
        String overriddenConsumerGroupIdConfig = "consumer.override.group.id";
        if (config.containsKey("consumer.override.group.id")) {
            String consumerGroupId = config.get("consumer.override.group.id");
            ConfigValue validatedGroupId = validatedConfig.computeIfAbsent("consumer.override.group.id", p -> new ConfigValue("consumer.override.group.id", (Object)consumerGroupId, Collections.emptyList(), new ArrayList()));
            if (this.workerGroupId.equals(consumerGroupId)) {
                validatedGroupId.addErrorMessage("Consumer group " + consumerGroupId + " conflicts with Connect worker group " + this.workerGroupId);
            }
        } else {
            ConfigValue validatedName = validatedConfig.get("name");
            String name = (String)validatedName.value();
            if (this.workerGroupId.equals(SinkUtils.consumerGroupId(name))) {
                validatedName.addErrorMessage("Consumer group for sink connector named " + name + " conflicts with Connect worker group " + this.workerGroupId);
            }
        }
        return validatedConfig;
    }

    @Override
    protected Map<String, ConfigValue> validateSourceConnectorConfig(SourceConnector connector, ConfigDef configDef, Map<String, String> config) {
        Map<String, ConfigValue> result = super.validateSourceConnectorConfig(connector, configDef, config);
        this.validateSourceConnectorExactlyOnceSupport(config, result, connector);
        this.validateSourceConnectorTransactionBoundary(config, result, connector);
        return result;
    }

    private void validateSinkConnectorGroupId(Map<String, ConfigValue> validatedConfig) {
        ConfigValue validatedName = validatedConfig.get("name");
        String name = (String)validatedName.value();
        if (this.workerGroupId.equals(SinkUtils.consumerGroupId(name))) {
            validatedName.addErrorMessage("Consumer group for sink connector named " + name + " conflicts with Connect worker group " + this.workerGroupId);
        }
    }

    private void validateSourceConnectorExactlyOnceSupport(Map<String, String> rawConfig, Map<String, ConfigValue> validatedConfig, SourceConnector connector) {
        SourceConnectorConfig.ExactlyOnceSupportLevel exactlyOnceSupportLevel;
        ConfigValue validatedExactlyOnceSupport = validatedConfig.get("exactly.once.support");
        if (validatedExactlyOnceSupport.errorMessages().isEmpty() && SourceConnectorConfig.ExactlyOnceSupportLevel.REQUIRED.equals((Object)(exactlyOnceSupportLevel = SourceConnectorConfig.ExactlyOnceSupportLevel.fromProperty(Objects.toString(validatedExactlyOnceSupport.value()))))) {
            if (!this.config.exactlyOnceSourceEnabled()) {
                validatedExactlyOnceSupport.addErrorMessage("This worker does not have exactly-once source support enabled.");
            }
            try {
                ExactlyOnceSupport exactlyOnceSupport = connector.exactlyOnceSupport(rawConfig);
                if (!ExactlyOnceSupport.SUPPORTED.equals((Object)exactlyOnceSupport)) {
                    String validationErrorMessage;
                    if (exactlyOnceSupport == null) {
                        validationErrorMessage = "The connector does not implement the API required for preflight validation of exactly-once source support. Please consult the documentation for the connector to determine whether it supports exactly-once semantics, and then consider reconfiguring the connector to use the value \"" + (Object)((Object)SourceConnectorConfig.ExactlyOnceSupportLevel.REQUESTED) + "\" for this property (which will disable this preflight check and allow the connector to be created).";
                    } else if (ExactlyOnceSupport.UNSUPPORTED.equals((Object)exactlyOnceSupport)) {
                        validationErrorMessage = "The connector does not support exactly-once semantics with the provided configuration.";
                    } else {
                        throw new ConnectException("Unexpected value returned from SourceConnector::exactlyOnceSupport: " + exactlyOnceSupport);
                    }
                    validatedExactlyOnceSupport.addErrorMessage(validationErrorMessage);
                }
            }
            catch (Exception e) {
                this.log.error("Failed while validating connector support for exactly-once semantics", (Throwable)e);
                String validationErrorMessage = "An unexpected error occurred during validation";
                String failureMessage = e.getMessage();
                validationErrorMessage = failureMessage != null && !failureMessage.trim().isEmpty() ? validationErrorMessage + ": " + failureMessage.trim() : validationErrorMessage + "; please see the worker logs for more details.";
                validatedExactlyOnceSupport.addErrorMessage(validationErrorMessage);
            }
        }
    }

    private void validateSourceConnectorTransactionBoundary(Map<String, String> rawConfig, Map<String, ConfigValue> validatedConfig, SourceConnector connector) {
        SourceTask.TransactionBoundary transactionBoundary;
        ConfigValue validatedTransactionBoundary = validatedConfig.get("transaction.boundary");
        if (validatedTransactionBoundary.errorMessages().isEmpty() && SourceTask.TransactionBoundary.CONNECTOR.equals((Object)(transactionBoundary = SourceTask.TransactionBoundary.fromProperty((String)Objects.toString(validatedTransactionBoundary.value()))))) {
            try {
                ConnectorTransactionBoundaries connectorTransactionSupport = connector.canDefineTransactionBoundaries(rawConfig);
                if (connectorTransactionSupport == null) {
                    validatedTransactionBoundary.addErrorMessage("This connector has returned a null value from its canDefineTransactionBoundaries method, which is not permitted. The connector will be treated as if it cannot define its own transaction boundaries, and cannot be configured with 'transaction.boundary' set to '" + SourceTask.TransactionBoundary.CONNECTOR + "'.");
                } else if (!ConnectorTransactionBoundaries.SUPPORTED.equals((Object)connectorTransactionSupport)) {
                    validatedTransactionBoundary.addErrorMessage("The connector does not support connector-defined transaction boundaries with the given configuration. Please reconfigure it to use a different transaction boundary definition.");
                }
            }
            catch (Exception e) {
                this.log.error("Failed while validating connector support for defining its own transaction boundaries", (Throwable)e);
                String validationErrorMessage = "An unexpected error occurred during validation";
                String failureMessage = e.getMessage();
                validationErrorMessage = failureMessage != null && !failureMessage.trim().isEmpty() ? validationErrorMessage + ": " + failureMessage.trim() : validationErrorMessage + "; please see the worker logs for more details.";
                validatedTransactionBoundary.addErrorMessage(validationErrorMessage);
            }
        }
    }

    @Override
    protected boolean connectorUsesAdmin(ConnectorType connectorType, Map<String, String> connProps) {
        return super.connectorUsesAdmin(connectorType, connProps) || this.connectorUsesSeparateOffsetsTopicClients(connectorType, connProps);
    }

    @Override
    protected boolean connectorUsesConsumer(ConnectorType connectorType, Map<String, String> connProps) {
        return super.connectorUsesConsumer(connectorType, connProps) || this.connectorUsesSeparateOffsetsTopicClients(connectorType, connProps);
    }

    private boolean connectorUsesSeparateOffsetsTopicClients(ConnectorType connectorType, Map<String, String> connProps) {
        if (connectorType != ConnectorType.SOURCE) {
            return false;
        }
        return this.config.exactlyOnceSourceEnabled() || !connProps.getOrDefault("offsets.storage.topic", "").trim().isEmpty();
    }

    @Override
    public void putConnectorConfig(String connName, Map<String, String> config, boolean allowReplace, Callback<Herder.Created<ConnectorInfo>> callback) {
        this.putConnectorConfig(connName, config, null, allowReplace, callback);
    }

    @Override
    public void putConnectorConfig(String connName, Map<String, String> config, TargetState targetState, boolean allowReplace, Callback<Herder.Created<ConnectorInfo>> callback) {
        this.log.trace("Submitting connector config write request {}", (Object)connName);
        this.addRequest(() -> {
            this.doPutConnectorConfig(connName, config, targetState, allowReplace, callback);
            return null;
        }, DistributedHerder.forwardErrorAndTickThreadStages(callback));
    }

    @Override
    public void putConnectorConfig(String connName, Map<String, String> config, boolean allowReplace, Callback<Herder.Created<ConnectorInfo>> callback, boolean validated) {
        if (!validated) {
            this.putConnectorConfig(connName, config, allowReplace, callback);
            return;
        }
        this.log.trace("Skipping connector config validation assuming pre-validation is done explicit or is not required {}", (Object)connName);
        this.addRequest(() -> this.handleConnectorConfigRequest(connName, config, null, allowReplace, callback), DistributedHerder.forwardErrorAndTickThreadStages(callback));
    }

    @Override
    public void patchConnectorConfig(String connName, Map<String, String> configPatch, Callback<Herder.Created<ConnectorInfo>> callback) {
        this.log.trace("Submitting connector config patch request {}", (Object)connName);
        this.addRequest(() -> {
            if (!this.isLeader()) {
                callback.onCompletion((Throwable)((Object)new NotLeaderException("Only the leader can set connector configs.", this.leaderUrl())), null);
                return null;
            }
            ConnectorInfo connectorInfo = this.connectorInfo(connName);
            if (connectorInfo == null) {
                callback.onCompletion((Throwable)new NotFoundException("Connector " + connName + " not found", null), null);
            } else {
                Map<String, String> patchedConfig = ConnectUtils.patchConfig(connectorInfo.config(), configPatch);
                this.doPutConnectorConfig(connName, patchedConfig, null, true, callback);
            }
            return null;
        }, DistributedHerder.forwardErrorAndTickThreadStages(callback));
    }

    private void doPutConnectorConfig(String connName, Map<String, String> config, TargetState targetState, boolean allowReplace, Callback<Herder.Created<ConnectorInfo>> callback) {
        this.validateConnectorConfig(config, callback.chainStaging((error, configInfos) -> {
            if (error != null) {
                callback.onCompletion(error, null);
                return;
            }
            this.addRequest(() -> {
                if (this.maybeAddConfigErrors((ConfigInfos)configInfos, callback)) {
                    return null;
                }
                this.log.trace("Handling connector config request {}", (Object)connName);
                return this.handleConnectorConfigRequest(connName, config, targetState, allowReplace, callback);
            }, DistributedHerder.forwardErrorAndTickThreadStages(callback));
        }));
    }

    private Void handleConnectorConfigRequest(String connName, Map<String, String> config, TargetState targetState, boolean allowReplace, Callback<Herder.Created<ConnectorInfo>> callback) {
        if (!this.isLeader()) {
            callback.onCompletion((Throwable)((Object)new NotLeaderException("Only the leader can set connector configs.", this.leaderUrl())), null);
            return null;
        }
        boolean exists = this.configState.contains(connName);
        if (!allowReplace && exists) {
            callback.onCompletion((Throwable)new AlreadyExistsException("Connector " + connName + " already exists"), null);
            return null;
        }
        this.log.trace("Submitting connector config {} {} {}", new Object[]{connName, allowReplace, this.configState.connectors()});
        this.writeToConfigTopicAsLeader("writing a config for connector " + connName + " to the config topic", () -> this.configBackingStore.putConnectorConfig(connName, config, targetState));
        ConnectorInfo info = new ConnectorInfo(connName, config, this.configState.tasks(connName), this.connectorType(config));
        callback.onCompletion(null, new Herder.Created<ConnectorInfo>(!exists, info));
        return null;
    }

    @Override
    public void stopConnector(String connName, Callback<Void> callback) {
        this.log.trace("Submitting request to transition connector {} to STOPPED state", (Object)connName);
        this.addRequest(() -> {
            if (!this.configState.contains(connName)) {
                throw new NotFoundException("Unknown connector " + connName);
            }
            if (!this.isLeader()) {
                callback.onCompletion((Throwable)((Object)new NotLeaderException("Only the leader can transition connectors to the STOPPED state.", this.leaderUrl())), null);
                return null;
            }
            this.writeTaskConfigs(connName, Collections.emptyList());
            String stageDescription = "writing the STOPPED target stage for connector " + connName + " to the config topic";
            try (TickThreadStage stage = new TickThreadStage(stageDescription);){
                this.configBackingStore.putTargetState(connName, TargetState.STOPPED);
            }
            if (!this.refreshConfigSnapshot(this.workerSyncTimeoutMs)) {
                this.log.warn("Failed to read to end of config topic after writing the STOPPED target state for connector {}", (Object)connName);
            }
            callback.onCompletion(null, null);
            return null;
        }, DistributedHerder.forwardErrorAndTickThreadStages(callback));
    }

    @Override
    public void requestTaskReconfiguration(String connName) {
        this.log.trace("Submitting connector task reconfiguration request {}", (Object)connName);
        this.addRequest(() -> {
            this.reconfigureConnectorTasksWithRetry(this.time.milliseconds(), connName);
            return null;
        }, (error, result) -> {
            if (error != null) {
                this.log.error("Unexpected error during task reconfiguration: ", error);
                this.log.error("Task reconfiguration for {} failed unexpectedly, this connector will not be properly reconfigured unless manually triggered.", (Object)connName);
            }
        });
    }

    @Override
    public void taskConfigs(String connName, Callback<List<TaskInfo>> callback) {
        this.log.trace("Submitting get task configuration request {}", (Object)connName);
        this.addRequest(() -> {
            if (this.checkRebalanceNeeded(callback)) {
                return null;
            }
            if (!this.configState.contains(connName)) {
                callback.onCompletion((Throwable)new NotFoundException("Connector " + connName + " not found"), null);
            } else {
                ArrayList<TaskInfo> result = new ArrayList<TaskInfo>();
                for (int i = 0; i < this.configState.taskCount(connName); ++i) {
                    ConnectorTaskId id = new ConnectorTaskId(connName, i);
                    result.add(new TaskInfo(id, this.filterSensitiveConfig(this.configState.rawTaskConfig(id))));
                }
                callback.onCompletion(null, result);
            }
            return null;
        }, DistributedHerder.forwardErrorAndTickThreadStages(callback));
    }

    @Override
    public void putTaskConfigs(String connName, List<Map<String, String>> configs, Callback<Void> callback, InternalRequestSignature requestSignature) {
        this.log.trace("Submitting put task configuration request {}", (Object)connName);
        if (this.requestNotSignedProperly(requestSignature, callback)) {
            return;
        }
        this.addRequest(() -> {
            if (!this.isLeader()) {
                callback.onCompletion((Throwable)((Object)new NotLeaderException("Only the leader may write task configurations.", this.leaderUrl())), null);
            } else if (!this.configState.contains(connName)) {
                callback.onCompletion((Throwable)new NotFoundException("Connector " + connName + " not found"), null);
            } else {
                this.writeTaskConfigs(connName, configs);
                callback.onCompletion(null, null);
            }
            return null;
        }, DistributedHerder.forwardErrorAndTickThreadStages(callback));
    }

    @Override
    public void fenceZombieSourceTasks(String connName, Callback<Void> callback, InternalRequestSignature requestSignature) {
        this.log.trace("Submitting zombie fencing request {}", (Object)connName);
        if (this.requestNotSignedProperly(requestSignature, callback)) {
            return;
        }
        this.fenceZombieSourceTasks(connName, callback);
    }

    void fenceZombieSourceTasks(ConnectorTaskId id, Callback<Void> callback) {
        this.log.trace("Performing preflight zombie check for task {}", (Object)id);
        this.fenceZombieSourceTasks(id.connector(), (Throwable error, Void ignored) -> {
            if (error == null) {
                callback.onCompletion(null, null);
            } else if (error instanceof NotLeaderException) {
                if (this.restClient != null) {
                    String workerUrl = ((NotLeaderException)((Object)((Object)error))).forwardUrl();
                    String fenceUrl = this.namespacedUrl(workerUrl).path("connectors").path(id.connector()).path("fence").build(new Object[0]).toString();
                    this.log.trace("Forwarding zombie fencing request for connector {} to leader at {}", (Object)id.connector(), (Object)fenceUrl);
                    this.forwardRequestExecutor.execute(() -> {
                        try {
                            String stageDescription = "Forwarding zombie fencing request to the leader at " + workerUrl;
                            try (TemporaryStage stage = new TemporaryStage(stageDescription, callback, this.time);){
                                this.restClient.httpRequest(fenceUrl, "PUT", null, null, this.sessionKey, this.requestSignatureAlgorithm);
                            }
                            callback.onCompletion(null, null);
                        }
                        catch (Throwable t) {
                            callback.onCompletion(t, null);
                        }
                    });
                } else {
                    callback.onCompletion(new ConnectException("This worker is not able to communicate with the leader of the cluster, which is required for exactly-once source tasks. If running MirrorMaker 2 in dedicated mode, consider enabling inter-worker communication via the 'dedicated.mode.enable.internal.rest' property."), null);
                }
            } else {
                error = ConnectUtils.maybeWrap(error, "Failed to perform zombie fencing");
                callback.onCompletion(error, null);
            }
        });
    }

    void fenceZombieSourceTasks(String connName, Callback<Void> callback) {
        this.addRequest(() -> {
            this.doFenceZombieSourceTasks(connName, callback);
            return null;
        }, DistributedHerder.forwardErrorAndTickThreadStages(callback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFenceZombieSourceTasks(String connName, Callback<Void> callback) {
        this.log.trace("Performing zombie fencing request for connector {}", (Object)connName);
        if (!this.isLeader()) {
            callback.onCompletion((Throwable)((Object)new NotLeaderException("Only the leader may perform zombie fencing.", this.leaderUrl())), null);
        } else if (!this.configState.contains(connName)) {
            callback.onCompletion((Throwable)new NotFoundException("Connector " + connName + " not found"), null);
        } else if (!this.isSourceConnector(connName)) {
            callback.onCompletion((Throwable)((Object)new BadRequestException("Connector " + connName + " is not a source connector")), null);
        } else {
            if (!this.refreshConfigSnapshot(this.workerSyncTimeoutMs)) {
                throw new ConnectException("Failed to read to end of config topic before performing zombie fencing");
            }
            int taskCount = this.configState.taskCount(connName);
            Integer taskCountRecord = this.configState.taskCountRecord(connName);
            ZombieFencing zombieFencing = null;
            boolean newFencing = false;
            DistributedHerder distributedHerder = this;
            synchronized (distributedHerder) {
                if (this.configState.pendingFencing(connName) && taskCountRecord != null && (taskCountRecord != 1 || taskCount != 1)) {
                    int taskGen = this.configState.taskConfigGeneration(connName);
                    zombieFencing = this.activeZombieFencings.get(connName);
                    if (zombieFencing == null) {
                        zombieFencing = new ZombieFencing(connName, taskCountRecord, taskCount, taskGen);
                        this.activeZombieFencings.put(connName, zombieFencing);
                        newFencing = true;
                    }
                }
            }
            if (zombieFencing != null) {
                if (newFencing) {
                    zombieFencing.start();
                }
                zombieFencing.addCallback(callback);
                return;
            }
            if (!this.configState.pendingFencing(connName)) {
                this.log.debug("Skipping zombie fencing round for connector {} as all old task generations have already been fenced out", (Object)connName);
            } else {
                if (taskCountRecord == null) {
                    this.log.debug("Skipping zombie fencing round but writing task count record for connector {} as it is being brought up for the first time with exactly-once source support", (Object)connName);
                } else {
                    this.log.debug("Skipping zombie fencing round but writing task count record for connector {} as both the most recent and the current generation of task configs only contain one task", (Object)connName);
                }
                this.writeToConfigTopicAsLeader("writing a task count record for connector " + connName + " to the config topic", () -> this.configBackingStore.putTaskCountRecord(connName, taskCount));
            }
            callback.onCompletion(null, null);
        }
    }

    @Override
    public void triggerRebalance(boolean preemptScheduledRebalance, Callback<Void> callback) {
        this.addRequest(() -> {
            this.log.trace("Triggering rebalance for connect cluster");
            if (!this.preemptiveScheduledRebalanceEndEnabled) {
                callback.onCompletion(new ConnectException("Pre emptive scheduled rebalance end not enabled on Connect Cluster"), null);
                return null;
            }
            if (!this.isLeader()) {
                callback.onCompletion((Throwable)((Object)new NotLeaderException("Only the leader can trigger a rebalance in a connect cluster.", this.leaderUrl())), null);
                return null;
            }
            if (preemptScheduledRebalance && this.member.currentProtocolVersion() == 0) {
                callback.onCompletion(new ConnectException("Pre emptive rebalance can not be triggered with eager assignor"), null);
                return null;
            }
            this.member.requestRejoin(preemptScheduledRebalance);
            callback.onCompletion(null, null);
            return null;
        }, DistributedHerder.forwardErrorAndTickThreadStages(callback));
    }

    @Override
    public void restartConnector(String connName, Callback<Void> callback) {
        this.restartConnector(0L, connName, callback);
    }

    @Override
    public HerderRequest restartConnector(long delayMs, String connName, Callback<Void> callback) {
        return this.addRequest(delayMs, () -> {
            if (this.checkRebalanceNeeded(callback)) {
                return null;
            }
            if (!this.configState.connectors().contains(connName)) {
                callback.onCompletion((Throwable)new NotFoundException("Unknown connector: " + connName), null);
                return null;
            }
            if (this.assignment.connectors().contains(connName)) {
                try {
                    try (TickThreadStage stage = new TickThreadStage("stopping restarted connector " + connName);){
                        this.worker.stopAndAwaitConnector(connName);
                    }
                    this.startConnector(connName, callback);
                }
                catch (Throwable t) {
                    callback.onCompletion(t, null);
                }
            } else if (this.isLeader()) {
                callback.onCompletion((Throwable)((Object)new NotAssignedException("Cannot restart connector since it is not assigned to this member", this.member.ownerUrl(connName))), null);
            } else {
                callback.onCompletion((Throwable)((Object)new NotLeaderException("Only the leader can process restart requests.", this.leaderUrl())), null);
            }
            return null;
        }, DistributedHerder.forwardErrorAndTickThreadStages(callback));
    }

    @Override
    public void restartTask(ConnectorTaskId id, Callback<Void> callback) {
        this.addRequest(() -> {
            if (this.checkRebalanceNeeded(callback)) {
                return null;
            }
            if (!this.configState.connectors().contains(id.connector())) {
                callback.onCompletion((Throwable)new NotFoundException("Unknown connector: " + id.connector()), null);
                return null;
            }
            if (this.configState.taskConfig(id) == null) {
                callback.onCompletion((Throwable)new NotFoundException("Unknown task: " + id), null);
                return null;
            }
            if (this.assignment.tasks().contains(id)) {
                try (TickThreadStage stage = new TickThreadStage("restarting task " + id);){
                    this.worker.stopAndAwaitTask(id);
                    if (!this.assignment.tasks().contains(id)) {
                        callback.onCompletion((Throwable)((Object)new NotAssignedException("Cannot restart task since it is not assigned to this member", this.member.ownerUrl(id))), null);
                        Void void_ = null;
                        return void_;
                    }
                    if (this.startTask(id)) {
                        callback.onCompletion(null, null);
                        return null;
                    }
                    callback.onCompletion(new ConnectException("Failed to start task: " + id), null);
                    return null;
                }
                catch (Throwable t) {
                    callback.onCompletion(t, null);
                    return null;
                }
            }
            if (this.isLeader()) {
                callback.onCompletion((Throwable)((Object)new NotAssignedException("Cannot restart task since it is not assigned to this member", this.member.ownerUrl(id))), null);
                return null;
            }
            callback.onCompletion((Throwable)((Object)new NotLeaderException("Cannot restart task since it is not assigned to this member", this.leaderUrl())), null);
            return null;
        }, DistributedHerder.forwardErrorAndTickThreadStages(callback));
    }

    @Override
    public int generation() {
        return this.generation;
    }

    @Override
    public void restartConnectorAndTasks(RestartRequest request, Callback<ConnectorStateInfo> callback) {
        String connectorName = request.connectorName();
        this.addRequest(() -> {
            if (this.checkRebalanceNeeded(callback)) {
                return null;
            }
            if (!this.configState.connectors().contains(request.connectorName())) {
                callback.onCompletion((Throwable)new NotFoundException("Unknown connector: " + connectorName), null);
                return null;
            }
            if (this.isLeader()) {
                String stageDescription = "writing restart request for connector " + request.connectorName() + " to the config topic";
                try (TickThreadStage stage = new TickThreadStage(stageDescription);){
                    this.configBackingStore.putRestartRequest(request);
                }
                Optional<RestartPlan> plan = this.buildRestartPlan(request);
                if (!plan.isPresent()) {
                    callback.onCompletion((Throwable)new NotFoundException("Status for connector " + connectorName + " not found", null), null);
                } else {
                    callback.onCompletion(null, plan.get().restartConnectorStateInfo());
                }
            } else {
                callback.onCompletion((Throwable)((Object)new NotLeaderException("Only the leader can process restart requests.", this.leaderUrl())), null);
            }
            return null;
        }, DistributedHerder.forwardErrorAndTickThreadStages(callback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processRestartRequests() {
        ArrayList<RestartRequest> restartRequests;
        DistributedHerder distributedHerder = this;
        synchronized (distributedHerder) {
            if (this.pendingRestartRequests.isEmpty()) {
                return;
            }
            restartRequests = new ArrayList<RestartRequest>(this.pendingRestartRequests.values());
            this.pendingRestartRequests.clear();
        }
        restartRequests.forEach(restartRequest -> {
            String stageDescription = "handling restart request for connector " + restartRequest.connectorName();
            try (TickThreadStage stage = new TickThreadStage(stageDescription);){
                this.doRestartConnectorAndTasks((RestartRequest)restartRequest);
            }
            catch (Exception e) {
                this.log.warn("Unexpected error while trying to process " + restartRequest + ", the restart request will be skipped.", (Throwable)e);
            }
        });
    }

    protected synchronized void doRestartConnectorAndTasks(RestartRequest request) {
        Throwable throwable;
        TickThreadStage stage;
        String stageDescription;
        boolean restartTasks;
        String connectorName = request.connectorName();
        Optional<RestartPlan> maybePlan = this.buildRestartPlan(request);
        if (!maybePlan.isPresent()) {
            this.log.debug("Skipping restart of connector '{}' since no status is available: {}", (Object)connectorName, (Object)request);
            return;
        }
        RestartPlan plan = maybePlan.get();
        this.log.info("Executing {}", (Object)plan);
        ExtendedAssignment currentAssignments = this.assignment;
        Collection assignedIdsToRestart = plan.taskIdsToRestart().stream().filter(taskId -> currentAssignments.tasks().contains(taskId)).collect(Collectors.toList());
        boolean restartConnector = plan.shouldRestartConnector() && currentAssignments.connectors().contains(connectorName);
        boolean bl = restartTasks = !assignedIdsToRestart.isEmpty();
        if (restartConnector) {
            stageDescription = "stopping to-be-restarted connector " + connectorName;
            stage = new TickThreadStage(stageDescription);
            throwable = null;
            try {
                this.worker.stopAndAwaitConnector(connectorName);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stage != null) {
                    if (throwable != null) {
                        try {
                            stage.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stage.close();
                    }
                }
            }
            this.onRestart(connectorName);
        }
        if (restartTasks) {
            stageDescription = "stopping " + assignedIdsToRestart.size() + " to-be-restarted tasks for connector " + connectorName;
            stage = new TickThreadStage(stageDescription);
            throwable = null;
            try {
                this.worker.stopAndAwaitTasks(assignedIdsToRestart);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stage != null) {
                    if (throwable != null) {
                        try {
                            stage.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stage.close();
                    }
                }
            }
            assignedIdsToRestart.forEach(this::onRestart);
        }
        if (restartConnector) {
            try {
                this.startConnector(connectorName, (error, targetState) -> {
                    if (error == null) {
                        this.log.info("Connector '{}' restart successful", (Object)connectorName);
                    } else {
                        this.log.error("Connector '{}' restart failed", (Object)connectorName, (Object)error);
                    }
                });
            }
            catch (Throwable t) {
                this.log.error("Connector '{}' restart failed", (Object)connectorName, (Object)t);
            }
        }
        if (restartTasks) {
            this.log.debug("Restarting {} of {} tasks for {}", new Object[]{assignedIdsToRestart.size(), plan.totalTaskCount(), request});
            assignedIdsToRestart.forEach(taskId -> {
                try {
                    if (this.startTask((ConnectorTaskId)taskId)) {
                        this.log.info("Task '{}' restart successful", taskId);
                    } else {
                        this.log.error("Task '{}' restart failed", taskId);
                    }
                }
                catch (Throwable t) {
                    this.log.error("Task '{}' restart failed", taskId, (Object)t);
                }
            });
            this.log.debug("Restarted {} of {} tasks for {} as requested", new Object[]{assignedIdsToRestart.size(), plan.totalTaskCount(), request});
        }
        this.log.info("Completed {}", (Object)plan);
    }

    @Override
    public void connectorOffsets(String connName, Callback<ConnectorOffsets> cb) {
        this.log.trace("Submitting offset fetch request for connector: {}", (Object)connName);
        this.addRequest(() -> {
            super.connectorOffsets(connName, cb);
            return null;
        }, DistributedHerder.forwardErrorAndTickThreadStages(cb));
    }

    @Override
    protected void modifyConnectorOffsets(String connName, Map<Map<String, ?>, Map<String, ?>> offsets, Callback<Message> callback) {
        this.log.trace("Submitting {} offsets request for connector '{}'", (Object)(offsets == null ? "reset" : "alter"), (Object)connName);
        this.addRequest(() -> {
            if (!this.modifyConnectorOffsetsChecks(connName, callback)) {
                return null;
            }
            if (this.isSourceConnector(connName) && this.config.exactlyOnceSourceEnabled()) {
                this.log.debug("Performing a round of zombie fencing before modifying offsets for source connector {} with exactly-once support enabled.", (Object)connName);
                this.doFenceZombieSourceTasks(connName, (error, ignored) -> {
                    if (error != null) {
                        this.log.error("Failed to perform zombie fencing for source connector prior to modifying offsets", error);
                        callback.onCompletion(new ConnectException("Failed to perform zombie fencing for source connector prior to modifying offsets", error), null);
                    } else {
                        this.log.debug("Successfully completed zombie fencing for source connector {}; proceeding to modify offsets.", (Object)connName);
                        this.addRequest(() -> {
                            try (TickThreadStage stage = new TickThreadStage("modifying offsets for connector " + connName);){
                                if (this.modifyConnectorOffsetsChecks(connName, callback)) {
                                    this.worker.modifyConnectorOffsets(connName, this.configState.connectorConfig(connName), offsets, callback);
                                }
                            }
                            return null;
                        }, DistributedHerder.forwardErrorAndTickThreadStages(callback));
                    }
                });
            } else {
                try (TickThreadStage stage = new TickThreadStage("modifying offsets for connector " + connName);){
                    this.worker.modifyConnectorOffsets(connName, this.configState.connectorConfig(connName), offsets, callback);
                }
            }
            return null;
        }, DistributedHerder.forwardErrorAndTickThreadStages(callback));
    }

    private boolean modifyConnectorOffsetsChecks(String connName, Callback<Message> callback) {
        if (this.checkRebalanceNeeded(callback)) {
            return false;
        }
        if (!this.isLeader()) {
            callback.onCompletion((Throwable)((Object)new NotLeaderException("Only the leader can process external offsets modification requests", this.leaderUrl())), null);
            return false;
        }
        if (!this.refreshConfigSnapshot(this.workerSyncTimeoutMs)) {
            throw new ConnectException("Failed to read to end of config topic before modifying connector offsets");
        }
        if (!this.configState.contains(connName)) {
            callback.onCompletion((Throwable)new NotFoundException("Connector " + connName + " not found", null), null);
            return false;
        }
        if (this.configState.targetState(connName) != TargetState.STOPPED || this.configState.taskCount(connName) != 0) {
            callback.onCompletion((Throwable)((Object)new BadRequestException("Connectors must be in the STOPPED state before their offsets can be modified. This can be done for the specified connector by issuing a 'PUT' request to the '/connectors/" + connName + "/stop' endpoint")), null);
            return false;
        }
        return true;
    }

    @Override
    public void setClusterLoggerLevel(String namespace, String level) {
        this.configBackingStore.putLoggerLevel(namespace, level);
    }

    protected boolean isLeader() {
        return this.assignment != null && this.member.memberId().equals(this.assignment.leader());
    }

    private String leaderUrl() {
        if (this.assignment == null) {
            return null;
        }
        return this.assignment.leaderUrl();
    }

    private void writeToConfigTopicAsLeader(String description, Runnable write) {
        try (TickThreadStage stage = new TickThreadStage(description);){
            write.run();
        }
        catch (PrivilegedWriteException e) {
            this.log.warn("Failed to write to config topic as leader; will rejoin group if necessary and, if still leader, attempt to reclaim write privileges for the config topic", (Throwable)((Object)e));
            this.fencedFromConfigTopic = true;
            throw new ConnectException("Failed to write to config topic; this may be due to a transient error and the request can be safely retried", (Throwable)((Object)e));
        }
    }

    private boolean handleRebalanceCompleted() {
        if (this.rebalanceResolved) {
            this.log.trace("Returning early because rebalance is marked as resolved (rebalanceResolved: true)");
            return true;
        }
        this.log.debug("Handling completed but unresolved rebalance");
        boolean needsReadToEnd = false;
        boolean needsRejoin = false;
        if (this.assignment.failed()) {
            needsRejoin = true;
            if (this.isLeader()) {
                this.log.warn("Join group completed, but assignment failed and we are the leader. Reading to end of config and retrying.");
                needsReadToEnd = true;
            } else if (this.configState.offset() < this.assignment.offset()) {
                this.log.warn("Join group completed, but assignment failed and we are lagging. Reading to end of config and retrying.");
                needsReadToEnd = true;
            } else {
                this.log.warn("Join group completed, but assignment failed. We were up to date, so just retrying.");
            }
        } else if (this.configState.offset() < this.assignment.offset()) {
            this.log.warn("Catching up to assignment's config offset.");
            needsReadToEnd = true;
        }
        long now = this.time.milliseconds();
        if (this.scheduledRebalance <= now) {
            this.log.debug("Requesting rebalance because scheduled rebalance timeout has been reached now: {} scheduledRebalance: {}", (Object)now, (Object)this.scheduledRebalance);
            needsRejoin = true;
            this.scheduledRebalance = Long.MAX_VALUE;
        }
        if (needsReadToEnd) {
            if (this.readConfigToEnd(this.workerSyncTimeoutMs)) {
                this.canReadConfigs = true;
            } else {
                this.canReadConfigs = false;
                needsRejoin = true;
            }
        }
        if (needsRejoin) {
            this.member.requestRejoin();
            return false;
        }
        if (this.configState.offset() != this.assignment.offset()) {
            this.log.info("Current config state offset {} does not match group assignment {}. Forcing rebalance.", (Object)this.configState.offset(), (Object)this.assignment.offset());
            this.member.requestRejoin();
            return false;
        }
        this.startWork();
        this.herderMetrics.rebalanceSucceeded(this.time.milliseconds());
        this.rebalanceResolved = true;
        if (!this.assignment.revokedConnectors().isEmpty() || !this.assignment.revokedTasks().isEmpty()) {
            this.assignment.revokedConnectors().clear();
            this.assignment.revokedTasks().clear();
            this.member.requestRejoin();
            return false;
        }
        this.rebalanceSuccess();
        return true;
    }

    protected void rebalanceSuccess() {
    }

    private boolean readConfigToEnd(long timeoutMs) {
        if (this.configState.offset() < this.assignment.offset()) {
            this.log.info("Current config state offset {} is behind group assignment {}, reading to end of config log", (Object)this.configState.offset(), (Object)this.assignment.offset());
        } else {
            this.log.info("Reading to end of config log; current config state offset: {}", (Object)this.configState.offset());
        }
        if (this.refreshConfigSnapshot(timeoutMs)) {
            this.backoffRetries = (short)5;
            return true;
        }
        this.member.maybeLeaveGroup("taking too long to read the log");
        this.backoff(this.workerUnsyncBackoffMs);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean refreshConfigSnapshot(long timeoutMs) {
        try (TickThreadStage stage = new TickThreadStage("reading to the end of the config topic");){
            this.configBackingStore.refresh(timeoutMs, TimeUnit.MILLISECONDS);
            this.configState = this.configBackingStore.snapshot();
            this.log.info("Finished reading to end of log and updated config snapshot, new config log offset: {}", (Object)this.configState.offset());
            boolean bl = true;
            return bl;
        }
        catch (TimeoutException e) {
            this.log.warn("Didn't reach end of config log quickly enough", (Throwable)e);
            this.canReadConfigs = false;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backoff(long ms) {
        ExtendedAssignment runningAssignmentSnapshot;
        if (ConnectProtocolCompatibility.fromProtocolVersion(this.currentProtocolVersion) == ConnectProtocolCompatibility.EAGER) {
            String stageDescription = "sleeping for a backoff duration of " + ms + "ms";
            try (TickThreadStage stage = new TickThreadStage(stageDescription);){
                this.time.sleep(ms);
            }
            return;
        }
        if (this.backoffRetries > 0) {
            int rebalanceDelayFraction = this.config.getInt("scheduled.rebalance.max.delay.ms") / 10 / this.backoffRetries;
            String stageDescription = "sleeping for a backoff duration of " + rebalanceDelayFraction + "ms";
            try (TickThreadStage stage = new TickThreadStage(stageDescription);){
                this.time.sleep((long)rebalanceDelayFraction);
            }
            this.backoffRetries = (short)(this.backoffRetries - 1);
            return;
        }
        DistributedHerder distributedHerder = this;
        synchronized (distributedHerder) {
            runningAssignmentSnapshot = ExtendedAssignment.duplicate(this.runningAssignment);
        }
        this.log.info("Revoking current running assignment {} because after {} retries the worker has not caught up with the latest Connect cluster updates", (Object)runningAssignmentSnapshot, (Object)5);
        this.member.revokeAssignment(runningAssignmentSnapshot);
        this.backoffRetries = (short)5;
    }

    void startAndStop(Collection<Callable<Void>> callables, String stageDescription) {
        if (callables.isEmpty()) {
            return;
        }
        try (TickThreadStage stage2 = new TickThreadStage(stageDescription);){
            this.startAndStopExecutor.invokeAll(callables);
        }
        catch (InterruptedException stage2) {
        }
        catch (RejectedExecutionException e) {
            if (this.stopping.get()) {
                this.log.debug("Ignoring RejectedExecutionException thrown while starting/stopping connectors/tasks en masse as the herder is already in the process of shutting down. This is not indicative of a problem and is normal behavior");
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWork() {
        ArrayList<Callable<Void>> callables = new ArrayList<Callable<Void>>();
        DistributedHerder distributedHerder = this;
        synchronized (distributedHerder) {
            this.log.info("Starting connectors and tasks using config offset {}", (Object)this.assignment.offset());
            this.log.debug("Received assignment: {}", (Object)this.assignment);
            this.log.debug("Currently running assignment: {}", (Object)this.runningAssignment);
            for (String connectorName : DistributedHerder.assignmentDifference(this.assignment.connectors(), this.runningAssignment.connectors())) {
                callables.add(this.getConnectorStartingCallable(connectorName));
            }
            this.log.debug("Tasks to restart from currently running assignment: {}", this.tasksToRestart);
            this.runningAssignment.tasks().removeAll(this.tasksToRestart);
            this.tasksToRestart.clear();
            for (ConnectorTaskId taskId : DistributedHerder.assignmentDifference(this.assignment.tasks(), this.runningAssignment.tasks())) {
                callables.add(this.getTaskStartingCallable(taskId));
            }
        }
        String stageDescription = "starting " + callables.size() + " connector(s) and task(s) after a rebalance";
        this.startAndStop(callables, stageDescription);
        DistributedHerder distributedHerder2 = this;
        synchronized (distributedHerder2) {
            this.runningAssignment = this.member.currentProtocolVersion() == 0 ? ExtendedAssignment.empty() : this.assignment;
        }
        this.log.info("Finished starting connectors and tasks");
    }

    private static <T> Collection<T> assignmentDifference(Collection<T> update, Collection<T> running) {
        if (running.isEmpty()) {
            return update;
        }
        HashSet<T> diff = new HashSet<T>(update);
        diff.removeAll(running);
        return diff;
    }

    private boolean startTask(ConnectorTaskId taskId) {
        this.log.info("Starting task {}", (Object)taskId);
        Map<String, String> connProps = this.configState.connectorConfig(taskId.connector());
        switch (this.connectorType(connProps)) {
            case SINK: {
                return this.worker.startSinkTask(taskId, this.configState, connProps, this.configState.taskConfig(taskId), this, this.configState.targetState(taskId.connector()));
            }
            case SOURCE: {
                if (this.config.exactlyOnceSourceEnabled()) {
                    int taskGeneration = this.configState.taskConfigGeneration(taskId.connector());
                    return this.worker.startExactlyOnceSourceTask(taskId, this.configState, connProps, this.configState.taskConfig(taskId), this, this.configState.targetState(taskId.connector()), () -> {
                        FutureCallback<Void> preflightFencing = new FutureCallback<Void>();
                        this.fenceZombieSourceTasks(taskId, preflightFencing);
                        try {
                            preflightFencing.get();
                        }
                        catch (InterruptedException e) {
                            throw new ConnectException("Interrupted while attempting to perform round of zombie fencing", (Throwable)e);
                        }
                        catch (ExecutionException e) {
                            Throwable cause = e.getCause();
                            throw ConnectUtils.maybeWrap(cause, "Failed to perform round of zombie fencing");
                        }
                    }, () -> this.verifyTaskGenerationAndOwnership(taskId, taskGeneration));
                }
                return this.worker.startSourceTask(taskId, this.configState, connProps, this.configState.taskConfig(taskId), this, this.configState.targetState(taskId.connector()));
            }
        }
        throw new ConnectException("Failed to start task " + taskId + " since it is not a recognizable type (source or sink)");
    }

    private Callable<Void> getTaskStartingCallable(ConnectorTaskId taskId) {
        return () -> {
            try {
                this.startTask(taskId);
            }
            catch (Throwable t) {
                this.log.error("Couldn't instantiate task {} because it has an invalid task configuration. This task will not execute until reconfigured.", (Object)taskId, (Object)t);
                this.onFailure(taskId, t);
            }
            return null;
        };
    }

    private Callable<Void> getTaskStoppingCallable(ConnectorTaskId taskId) {
        return () -> {
            this.worker.stopAndAwaitTask(taskId);
            return null;
        };
    }

    private void startConnector(String connectorName, Callback<Void> callback) {
        this.log.info("Starting connector {}", (Object)connectorName);
        Map<String, String> configProps = this.configState.connectorConfig(connectorName);
        HerderConnectorContext ctx = new HerderConnectorContext(this, connectorName);
        TargetState initialState = this.configState.targetState(connectorName);
        Callback<TargetState> onInitialStateChange = (error, newState) -> {
            if (error != null) {
                callback.onCompletion(new ConnectException("Failed to start connector: " + connectorName, error), null);
                return;
            }
            if (newState == TargetState.STARTED) {
                this.addRequest(() -> {
                    this.reconfigureConnectorTasksWithRetry(this.time.milliseconds(), connectorName);
                    callback.onCompletion(null, null);
                    return null;
                }, DistributedHerder.forwardErrorAndTickThreadStages(callback));
            } else {
                callback.onCompletion(null, null);
            }
        };
        callback.recordStage(new Stage("starting the connector", this.time.milliseconds()));
        this.worker.startConnector(connectorName, configProps, ctx, this, initialState, onInitialStateChange);
    }

    private Callable<Void> getConnectorStartingCallable(String connectorName) {
        return () -> {
            try {
                this.startConnector(connectorName, (error, result) -> {
                    if (error != null) {
                        this.log.error("Failed to start connector '" + connectorName + "'", error);
                    }
                });
            }
            catch (Throwable t) {
                this.log.error("Unexpected error while trying to start connector " + connectorName, t);
                this.onFailure(connectorName, t);
            }
            return null;
        };
    }

    private Callable<Void> getConnectorStoppingCallable(String connectorName) {
        return () -> {
            try {
                this.worker.stopAndAwaitConnector(connectorName);
            }
            catch (Throwable t) {
                this.log.error("Failed to shut down connector " + connectorName, t);
            }
            return null;
        };
    }

    private void reconfigureConnectorTasksWithRetry(long initialRequestTime, String connName) {
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(250L, 2, 60000L, 0.0);
        this.reconfigureConnectorTasksWithExponentialBackoffRetries(initialRequestTime, connName, exponentialBackoff, 0);
    }

    private void reconfigureConnectorTasksWithExponentialBackoffRetries(long initialRequestTime, String connName, ExponentialBackoff exponentialBackoff, int attempts) {
        this.reconfigureConnector(connName, (error, result) -> {
            if (error != null) {
                if (this.isPossibleExpiredKeyException(initialRequestTime, error)) {
                    this.log.debug("Failed to reconfigure connector's tasks ({}), possibly due to expired session key. Retrying after backoff", (Object)connName);
                } else {
                    if (error instanceof TooManyTasksException) {
                        this.log.debug("Connector {} generated too many tasks; will not retry configuring connector", (Object)connName);
                        return;
                    }
                    this.log.error("Failed to reconfigure connector's tasks ({}), retrying after backoff.", (Object)connName, (Object)error);
                }
                this.addRequest(exponentialBackoff.backoff((long)attempts), () -> {
                    this.reconfigureConnectorTasksWithExponentialBackoffRetries(initialRequestTime, connName, exponentialBackoff, attempts + 1);
                    return null;
                }, (err, res) -> {
                    if (err != null) {
                        this.log.error("Unexpected error during connector task reconfiguration: ", err);
                        this.log.error("Task reconfiguration for {} failed unexpectedly, this connector will not be properly reconfigured unless manually triggered.", (Object)connName);
                    }
                });
            }
        });
    }

    boolean isPossibleExpiredKeyException(long initialRequestTime, Throwable error) {
        if (error instanceof ConnectRestException) {
            ConnectRestException connectError = (ConnectRestException)((Object)error);
            return connectError.statusCode() == Response.Status.FORBIDDEN.getStatusCode() && initialRequestTime + TimeUnit.MINUTES.toMillis(1L) >= this.time.milliseconds();
        }
        return false;
    }

    private void reconfigureConnector(String connName, Callback<Void> cb) {
        try {
            List<Map<String, String>> taskProps;
            if (!this.worker.isRunning(connName)) {
                this.log.info("Skipping reconfiguration of connector {} since it is not running", (Object)connName);
                return;
            }
            if (this.configState.targetState(connName) != TargetState.STARTED) {
                this.log.info("Skipping reconfiguration of connector {} since its target state is {}", (Object)connName, (Object)this.configState.targetState(connName));
                return;
            }
            Map<String, String> configs = this.configState.connectorConfig(connName);
            ConnectorConfig connConfig = this.worker.isSinkConnector(connName) ? new SinkConnectorConfig(this.plugins(), configs) : new SourceConnectorConfig(this.plugins(), configs, this.worker.isTopicCreationEnabled());
            try (TickThreadStage stage = new TickThreadStage("generating task configs for connector " + connName);){
                taskProps = this.worker.connectorTaskConfigs(connName, connConfig);
            }
            this.publishConnectorTaskConfigs(connName, taskProps, cb);
        }
        catch (Throwable t) {
            cb.onCompletion(t, null);
        }
    }

    private void publishConnectorTaskConfigs(String connName, List<Map<String, String>> taskProps, Callback<Void> cb) {
        List<Map<String, String>> rawTaskProps = DistributedHerder.reverseTransform(connName, this.configState, taskProps);
        if (!DistributedHerder.taskConfigsChanged(this.configState, connName, rawTaskProps)) {
            return;
        }
        if (this.isLeader()) {
            this.writeTaskConfigs(connName, rawTaskProps);
            cb.onCompletion(null, null);
        } else {
            if (this.restClient == null) {
                throw new NotLeaderException("This worker is not able to communicate with the leader of the cluster, which is required for dynamically-reconfiguring connectors. If running MirrorMaker 2 in dedicated mode, consider enabling inter-worker communication via the 'dedicated.mode.enable.internal.rest' property.", this.leaderUrl());
            }
            this.forwardRequestExecutor.submit(() -> {
                try {
                    String leaderUrl = this.leaderUrl();
                    if (Utils.isBlank((String)leaderUrl)) {
                        cb.onCompletion(new ConnectException("Request to leader to reconfigure connector tasks failed because the URL of the leader's REST interface is empty!"), null);
                        return;
                    }
                    String reconfigUrl = this.namespacedUrl(leaderUrl).path("connectors").path(connName).path("tasks").build(new Object[0]).toString();
                    this.log.trace("Forwarding task configurations for connector {} to leader", (Object)connName);
                    String stageDescription = "Forwarding task configurations to the leader at " + leaderUrl;
                    try (TemporaryStage stage = new TemporaryStage(stageDescription, cb, this.time);){
                        this.restClient.httpRequest(reconfigUrl, "POST", null, rawTaskProps, this.sessionKey, this.requestSignatureAlgorithm);
                    }
                    cb.onCompletion(null, null);
                }
                catch (ConnectException e) {
                    this.log.error("Request to leader to reconfigure connector tasks failed", (Throwable)e);
                    cb.onCompletion(e, null);
                }
            });
        }
    }

    private void writeTaskConfigs(String connName, List<Map<String, String>> taskConfigs) {
        if (!taskConfigs.isEmpty() && this.configState.targetState(connName) == TargetState.STOPPED) {
            throw new BadRequestException("Cannot submit non-empty set of task configs for stopped connector " + connName);
        }
        this.writeToConfigTopicAsLeader("writing " + taskConfigs.size() + " task configs for connector " + connName + " to the config topic", () -> this.configBackingStore.putTaskConfigs(connName, taskConfigs));
    }

    private void verifyTaskGenerationAndOwnership(ConnectorTaskId id, int initialTaskGen) {
        this.log.debug("Reading to end of config topic to ensure it is still safe to bring up source task {} with exactly-once support", (Object)id);
        if (!this.refreshConfigSnapshot(Long.MAX_VALUE)) {
            throw new ConnectException("Failed to read to end of config topic");
        }
        FutureCallback verifyCallback = new FutureCallback();
        this.addRequest(() -> this.verifyTaskGenerationAndOwnership(id, initialTaskGen, verifyCallback), DistributedHerder.forwardErrorAndTickThreadStages(verifyCallback));
        try {
            verifyCallback.get();
        }
        catch (InterruptedException e) {
            throw new ConnectException("Interrupted while performing preflight check for task " + id, (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw ConnectUtils.maybeWrap(cause, "Failed to perform preflight check for task " + id);
        }
    }

    Void verifyTaskGenerationAndOwnership(ConnectorTaskId id, int initialTaskGen, Callback<Void> callback) {
        Integer currentTaskGen = this.configState.taskConfigGeneration(id.connector());
        if (!Objects.equals(initialTaskGen, currentTaskGen)) {
            throw new ConnectException("Cannot start source task " + id + " with exactly-once support as the connector has already generated a new set of task configs");
        }
        if (!this.assignment.tasks().contains(id)) {
            throw new ConnectException("Cannot start source task " + id + " as it has already been revoked from this worker");
        }
        callback.onCompletion(null, null);
        return null;
    }

    private boolean checkRebalanceNeeded(Callback<?> callback) {
        if (this.needsReconfigRebalance) {
            callback.onCompletion((Throwable)((Object)new RebalanceNeededException("Request cannot be completed because a rebalance is expected")), null);
            return true;
        }
        return false;
    }

    DistributedHerderRequest runOnTickThread(Callable<Void> action, Callback<Void> callback) {
        if (Thread.currentThread().equals(this.herderThread)) {
            this.runRequest(action, callback);
            return null;
        }
        return this.addRequest(action, callback);
    }

    DistributedHerderRequest addRequest(Callable<Void> action, Callback<Void> callback) {
        return this.addRequest(0L, action, callback);
    }

    DistributedHerderRequest addRequest(long delayMs, Callable<Void> action, Callback<Void> callback) {
        DistributedHerderRequest req = new DistributedHerderRequest(this.time.milliseconds() + delayMs, this.requestSeqNum.incrementAndGet(), action, callback);
        this.requests.add(req);
        if (this.peekWithoutException() == req) {
            this.member.wakeup();
        }
        callback.recordStage(this.tickThreadStage);
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runRequest(Callable<Void> action, Callback<Void> callback) {
        try {
            action.call();
            callback.onCompletion(null, null);
        }
        catch (Throwable t) {
            callback.onCompletion(t, null);
        }
        finally {
            this.currentRequest = null;
        }
    }

    private boolean internalRequestValidationEnabled() {
        return DistributedHerder.internalRequestValidationEnabled(this.member.currentProtocolVersion());
    }

    private static boolean internalRequestValidationEnabled(short protocolVersion) {
        return protocolVersion >= 2;
    }

    private DistributedHerderRequest peekWithoutException() {
        try {
            return this.requests.isEmpty() ? null : (DistributedHerderRequest)this.requests.first();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    private static Callback<Void> forwardErrorAndTickThreadStages(Callback<?> callback) {
        Callback<Void> cb = callback.chainStaging((error, result) -> {
            if (error != null) {
                callback.onCompletion(error, null);
            }
        });
        return cb;
    }

    private void updateDeletedConnectorStatus() {
        ClusterConfigState snapshot = this.configBackingStore.snapshot();
        Set<String> connectors = snapshot.connectors();
        for (String connector : this.statusBackingStore.connectors()) {
            if (connectors.contains(connector)) continue;
            this.log.debug("Cleaning status information for connector {}", (Object)connector);
            this.onDeletion(connector);
        }
    }

    private void updateDeletedTaskStatus() {
        ClusterConfigState snapshot = this.configBackingStore.snapshot();
        for (String connector : this.statusBackingStore.connectors()) {
            HashSet<ConnectorTaskId> remainingTasks = new HashSet<ConnectorTaskId>(snapshot.tasks(connector));
            this.statusBackingStore.getAll(connector).stream().map(AbstractStatus::id).filter(task -> !remainingTasks.contains(task)).forEach(this::onDeletion);
        }
    }

    protected HerderMetrics herderMetrics() {
        return this.herderMetrics;
    }

    private boolean isSourceConnector(String connName) {
        return org.apache.kafka.connect.runtime.rest.entities.ConnectorType.SOURCE.equals((Object)this.connectorType(this.configState.connectorConfig(connName)));
    }

    private boolean requestNotSignedProperly(InternalRequestSignature requestSignature, Callback<?> callback) {
        if (this.internalRequestValidationEnabled()) {
            ConnectRestException requestValidationError = null;
            if (requestSignature == null) {
                requestValidationError = new BadRequestException("Internal request missing required signature");
            } else if (!this.keySignatureVerificationAlgorithms.contains(requestSignature.keyAlgorithm())) {
                requestValidationError = new BadRequestException(String.format("This worker does not support the '%s' key signing algorithm used by other workers. This worker is currently configured to use: %s. Check that all workers' configuration files permit the same set of signature algorithms, and correct any misconfigured worker and restart it.", requestSignature.keyAlgorithm(), this.keySignatureVerificationAlgorithms));
            } else if (this.sessionKey == null) {
                requestValidationError = new ConnectRestException(Response.Status.SERVICE_UNAVAILABLE, "This worker is still starting up and has not been able to read a session key from the config topic yet");
            } else if (!requestSignature.isValid(this.sessionKey)) {
                requestValidationError = new ConnectRestException(Response.Status.FORBIDDEN, "Internal request contained invalid signature.");
            }
            if (requestValidationError != null) {
                callback.onCompletion((Throwable)((Object)requestValidationError), null);
                return true;
            }
        }
        return false;
    }

    private UriBuilder namespacedUrl(String workerUrl) {
        UriBuilder result = UriBuilder.fromUri((String)workerUrl);
        for (String namespacePath : this.restNamespace) {
            result = result.path(namespacePath);
        }
        return result;
    }

    private synchronized void recordTickThreadStage(String description) {
        assert (description != null);
        this.log.trace("Recording new tick thread stage: {}", (Object)description);
        this.tickThreadStage = new Stage(description, this.time.milliseconds());
        this.requests.forEach(request -> request.callback().recordStage(this.tickThreadStage));
        Optional.ofNullable(this.currentRequest).map(DistributedHerderRequest::callback).ifPresent(callback -> callback.recordStage(this.tickThreadStage));
    }

    private synchronized void completeTickThreadStage() {
        if (this.tickThreadStage == null) {
            return;
        }
        this.log.trace("Completing current tick thread stage; was {}", (Object)this.tickThreadStage);
        this.tickThreadStage.complete(this.time.milliseconds());
        this.tickThreadStage = null;
    }

    class HerderMetrics {
        private final ConnectMetrics.MetricGroup metricGroup;
        private final Sensor rebalanceCompletedCounts;
        private final Sensor rebalanceTime;
        private volatile long lastRebalanceCompletedAtMillis = Long.MIN_VALUE;
        private volatile boolean rebalancing = false;
        private volatile long rebalanceStartedAtMillis = 0L;

        public HerderMetrics(ConnectMetrics connectMetrics) {
            ConnectMetricsRegistry registry = connectMetrics.registry();
            this.metricGroup = connectMetrics.group(registry.workerRebalanceGroupName(), new String[0]);
            this.metricGroup.addValueMetric(registry.connectProtocol, now -> ConnectProtocolCompatibility.fromProtocolVersion(DistributedHerder.this.member.currentProtocolVersion()).name());
            this.metricGroup.addValueMetric(registry.leaderName, now -> DistributedHerder.this.leaderUrl());
            this.metricGroup.addValueMetric(registry.epoch, now -> DistributedHerder.this.generation);
            this.metricGroup.addValueMetric(registry.rebalanceMode, now -> this.rebalancing ? 1.0 : 0.0);
            this.rebalanceCompletedCounts = this.metricGroup.sensor("completed-rebalance-count");
            this.rebalanceCompletedCounts.add(this.metricGroup.metricName(registry.rebalanceCompletedTotal), (MeasurableStat)new CumulativeSum());
            this.rebalanceTime = this.metricGroup.sensor("rebalance-time");
            this.rebalanceTime.add(this.metricGroup.metricName(registry.rebalanceTimeMax), (MeasurableStat)new Max());
            this.rebalanceTime.add(this.metricGroup.metricName(registry.rebalanceTimeAvg), (MeasurableStat)new Avg());
            this.metricGroup.addValueMetric(registry.rebalanceTimeSinceLast, now -> this.lastRebalanceCompletedAtMillis == Long.MIN_VALUE ? Double.POSITIVE_INFINITY : (double)(now - this.lastRebalanceCompletedAtMillis));
        }

        void close() {
            this.metricGroup.close();
        }

        void rebalanceStarted(long now) {
            this.rebalanceStartedAtMillis = now;
            this.rebalancing = true;
        }

        void rebalanceSucceeded(long now) {
            long duration = Math.max(0L, now - this.rebalanceStartedAtMillis);
            this.rebalancing = false;
            this.rebalanceCompletedCounts.record(1.0);
            this.rebalanceTime.record((double)duration);
            this.lastRebalanceCompletedAtMillis = now;
        }

        protected ConnectMetrics.MetricGroup metricGroup() {
            return this.metricGroup;
        }
    }

    class ZombieFencing {
        private final String connName;
        private final int tasksToFence;
        private final int tasksToRecord;
        private final int taskGen;
        private final FutureCallback<Void> fencingFollowup;
        private KafkaFuture<Void> fencingFuture;

        public ZombieFencing(String connName, int tasksToFence, int tasksToRecord, int taskGen) {
            this.connName = connName;
            this.tasksToFence = tasksToFence;
            this.tasksToRecord = tasksToRecord;
            this.taskGen = taskGen;
            this.fencingFollowup = new FutureCallback();
        }

        public void start() {
            if (this.fencingFuture != null) {
                throw new IllegalStateException("Cannot invoke start() multiple times");
            }
            String stageDescription = "initiating a round of zombie fencing for connector " + this.connName;
            try (TickThreadStage stage = new TickThreadStage(stageDescription);){
                this.fencingFuture = DistributedHerder.this.worker.fenceZombies(this.connName, this.tasksToFence, DistributedHerder.this.configState.connectorConfig(this.connName)).thenApply(ignored -> {
                    DistributedHerder.this.runOnTickThread(this::onZombieFencingSuccess, this.fencingFollowup);
                    this.awaitFollowup();
                    return null;
                });
            }
            this.addCallback((ignored, error) -> {
                DistributedHerder distributedHerder = DistributedHerder.this;
                synchronized (distributedHerder) {
                    DistributedHerder.this.activeZombieFencings.remove(this.connName);
                }
            });
        }

        private Void onZombieFencingSuccess() {
            if (!DistributedHerder.this.refreshConfigSnapshot(DistributedHerder.this.workerSyncTimeoutMs)) {
                throw new ConnectException("Failed to read to end of config topic");
            }
            if (this.taskGen < DistributedHerder.this.configState.taskConfigGeneration(this.connName)) {
                throw new ConnectRestException(Response.Status.CONFLICT.getStatusCode(), "Fencing failed because new task configurations were generated for the connector");
            }
            if (this.fencingFollowup.isDone()) {
                return null;
            }
            DistributedHerder.this.writeToConfigTopicAsLeader("writing a task count record for connector " + this.connName + " to the config topic", () -> DistributedHerder.this.configBackingStore.putTaskCountRecord(this.connName, this.tasksToRecord));
            return null;
        }

        private void awaitFollowup() {
            try {
                this.fencingFollowup.get();
            }
            catch (InterruptedException e) {
                throw new ConnectException("Interrupted while performing zombie fencing", (Throwable)e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                throw ConnectUtils.maybeWrap(cause, "Failed to perform round of zombie fencing");
            }
        }

        public void completeExceptionally(Throwable t) {
            Objects.requireNonNull(t);
            this.fencingFollowup.onCompletion(t, null);
        }

        public void addCallback(Callback<Void> callback) {
            if (this.fencingFuture == null) {
                throw new IllegalStateException("The start() method must be invoked before adding callbacks for this zombie fencing");
            }
            this.fencingFuture.whenComplete((ignored, error) -> {
                if (error != null) {
                    callback.onCompletion(ConnectUtils.maybeWrap(error, "Failed to perform zombie fencing"), null);
                } else {
                    callback.onCompletion(null, null);
                }
            });
        }
    }

    private class TickThreadStage
    implements Utils.UncheckedCloseable {
        public TickThreadStage(String description) {
            if (description != null) {
                DistributedHerder.this.recordTickThreadStage(description);
            }
        }

        public void close() {
            DistributedHerder.this.completeTickThreadStage();
        }
    }

    public class RebalanceListener
    implements WorkerRebalanceListener {
        private final Time time;

        RebalanceListener(Time time) {
            this.time = time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAssigned(ExtendedAssignment assignment, int generation) {
            short priorProtocolVersion = DistributedHerder.this.currentProtocolVersion;
            DistributedHerder.this.currentProtocolVersion = DistributedHerder.this.member.currentProtocolVersion();
            DistributedHerder.this.log.info("Joined group at generation {} with protocol version {} and got assignment: {} with rebalance delay: {}", new Object[]{generation, DistributedHerder.this.currentProtocolVersion, assignment, assignment.delay()});
            DistributedHerder distributedHerder = DistributedHerder.this;
            synchronized (distributedHerder) {
                DistributedHerder.this.assignment = assignment;
                DistributedHerder.this.generation = generation;
                int delay = assignment.delay();
                DistributedHerder.this.scheduledRebalance = delay > 0 ? this.time.milliseconds() + (long)delay : Long.MAX_VALUE;
                boolean requestValidationWasEnabled = DistributedHerder.internalRequestValidationEnabled(priorProtocolVersion);
                boolean requestValidationNowEnabled = DistributedHerder.internalRequestValidationEnabled(DistributedHerder.this.currentProtocolVersion);
                if (requestValidationNowEnabled != requestValidationWasEnabled) {
                    if (requestValidationNowEnabled) {
                        DistributedHerder.this.log.info("Internal request validation has been re-enabled");
                    } else {
                        DistributedHerder.this.log.warn("The protocol used by this Connect cluster has been downgraded from '{}' to '{}' and internal request validation is now disabled. This is most likely caused by a new worker joining the cluster with an older protocol specified for the {} configuration; if this is not intentional, either remove the {} configuration from that worker's config file, or change its value to '{}'. If this configuration is left as-is, the cluster will be insecure; for more information, see KIP-507: https://cwiki.apache.org/confluence/display/KAFKA/KIP-507%3A+Securing+Internal+Connect+REST+Endpoints", new Object[]{ConnectProtocolCompatibility.fromProtocolVersion(priorProtocolVersion), ConnectProtocolCompatibility.fromProtocolVersion(DistributedHerder.this.currentProtocolVersion), "connect.protocol", "connect.protocol", ConnectProtocolCompatibility.SESSIONED.name()});
                    }
                }
                DistributedHerder.this.rebalanceResolved = false;
                DistributedHerder.this.herderMetrics.rebalanceStarted(this.time.milliseconds());
            }
            if (DistributedHerder.this.isLeader()) {
                DistributedHerder.this.updateDeletedConnectorStatus();
                DistributedHerder.this.updateDeletedTaskStatus();
                try {
                    DistributedHerder.this.configBackingStore.claimWritePrivileges();
                }
                catch (Exception e) {
                    DistributedHerder.this.fencedFromConfigTopic = true;
                    DistributedHerder.this.log.error("Unable to claim write privileges for config topic after being elected leader during rebalance", (Throwable)e);
                }
            }
            DistributedHerder.this.member.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRevoked(String leader, Collection<String> connectors, Collection<ConnectorTaskId> tasks) {
            if (DistributedHerder.this.rebalanceResolved || DistributedHerder.this.currentProtocolVersion >= 1) {
                ArrayList<Callable<Void>> callables = new ArrayList<Callable<Void>>();
                for (String string : connectors) {
                    callables.add(DistributedHerder.this.getConnectorStoppingCallable(string));
                }
                for (ConnectorTaskId connectorTaskId : tasks) {
                    callables.add(DistributedHerder.this.getTaskStoppingCallable(connectorTaskId));
                }
                String stageDescription = "stopping " + connectors.size() + " and " + tasks.size() + " tasks";
                DistributedHerder.this.startAndStop(callables, stageDescription);
                DistributedHerder.this.log.info("Finished stopping tasks in preparation for rebalance");
                DistributedHerder distributedHerder = DistributedHerder.this;
                synchronized (distributedHerder) {
                    DistributedHerder.this.log.debug("Removing connectors from running assignment {}", connectors);
                    DistributedHerder.this.runningAssignment.connectors().removeAll(connectors);
                    DistributedHerder.this.log.debug("Removing tasks from running assignment {}", tasks);
                    DistributedHerder.this.runningAssignment.tasks().removeAll(tasks);
                }
                if (DistributedHerder.this.isTopicTrackingEnabled) {
                    this.resetActiveTopics(connectors, tasks);
                }
                try (TickThreadStage tickThreadStage = new TickThreadStage("flushing updates to the status topic");){
                    DistributedHerder.this.statusBackingStore.flush();
                }
                DistributedHerder.this.log.info("Finished flushing status backing store in preparation for rebalance");
            } else {
                DistributedHerder.this.log.info("Wasn't able to resume work after last rebalance, can skip stopping connectors and tasks");
            }
        }

        @Override
        public void onPollTimeoutExpiry() {
            DistributedHerder.this.log.warn("worker poll timeout has expired. The last known action being performed by the worker is : {} and may contribute to the timeout. Please review the last action (if known) for any corrective actions. One of the ways of addressing this can be increasing the rebalance.timeout.ms configuration value. Please note that rebalance.timeout.ms also controls the maximum allowed time for each worker to join the group once a rebalance has begun so the set value should not be very high", (Object)(DistributedHerder.this.tickThreadStage == null ? "not known" : DistributedHerder.this.tickThreadStage.description()));
        }

        private void resetActiveTopics(Collection<String> connectors, Collection<ConnectorTaskId> tasks) {
            String stageDescription = "resetting the list of active topics for " + connectors.size() + " and " + tasks.size() + " tasks";
            try (TickThreadStage stage = new TickThreadStage(stageDescription);){
                connectors.stream().filter(connectorName -> !DistributedHerder.this.configState.contains((String)connectorName)).forEach(DistributedHerder.this::resetConnectorActiveTopics);
                tasks.stream().map(ConnectorTaskId::connector).distinct().filter(connectorName -> !DistributedHerder.this.configState.contains((String)connectorName)).forEach(DistributedHerder.this::resetConnectorActiveTopics);
            }
        }
    }

    class DistributedHerderRequest
    implements HerderRequest,
    Comparable<DistributedHerderRequest> {
        private final long at;
        private final long seq;
        private final Callable<Void> action;
        private final Callback<Void> callback;

        public DistributedHerderRequest(long at, long seq, Callable<Void> action, Callback<Void> callback) {
            this.at = at;
            this.seq = seq;
            this.action = action;
            this.callback = callback;
        }

        public Callable<Void> action() {
            return this.action;
        }

        public Callback<Void> callback() {
            return this.callback;
        }

        @Override
        public void cancel() {
            DistributedHerder.this.requests.remove(this);
        }

        @Override
        public int compareTo(DistributedHerderRequest o) {
            int cmp = Long.compare(this.at, o.at);
            return cmp == 0 ? Long.compare(this.seq, o.seq) : cmp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DistributedHerderRequest)) {
                return false;
            }
            DistributedHerderRequest other = (DistributedHerderRequest)o;
            return this.compareTo(other) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.at, this.seq);
        }
    }

    public class ConfigUpdateListener
    implements ConfigBackingStore.UpdateListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectorConfigRemove(String connector) {
            DistributedHerder.this.log.info("Connector {} config removed", (Object)connector);
            DistributedHerder distributedHerder = DistributedHerder.this;
            synchronized (distributedHerder) {
                if (DistributedHerder.this.configState.contains(connector)) {
                    DistributedHerder.this.needsReconfigRebalance = true;
                } else {
                    DistributedHerder.this.connectorConfigUpdates.add(connector);
                }
            }
            DistributedHerder.this.member.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectorConfigUpdate(String connector) {
            DistributedHerder.this.log.info("Connector {} config updated", (Object)connector);
            DistributedHerder distributedHerder = DistributedHerder.this;
            synchronized (distributedHerder) {
                if (!DistributedHerder.this.configState.contains(connector)) {
                    DistributedHerder.this.needsReconfigRebalance = true;
                } else {
                    DistributedHerder.this.connectorConfigUpdates.add(connector);
                }
            }
            DistributedHerder.this.member.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTaskConfigUpdate(Collection<ConnectorTaskId> tasks) {
            DistributedHerder.this.log.info("Tasks {} configs updated", tasks);
            DistributedHerder distributedHerder = DistributedHerder.this;
            synchronized (distributedHerder) {
                DistributedHerder.this.needsReconfigRebalance = true;
                DistributedHerder.this.taskConfigUpdates.addAll(tasks);
            }
            tasks.stream().map(ConnectorTaskId::connector).distinct().forEach(connName -> {
                ConfigUpdateListener configUpdateListener = this;
                synchronized (configUpdateListener) {
                    ZombieFencing activeFencing = (ZombieFencing)DistributedHerder.this.activeZombieFencings.get(connName);
                    if (activeFencing != null) {
                        activeFencing.completeExceptionally((Throwable)((Object)new ConnectRestException(Response.Status.CONFLICT.getStatusCode(), "Failed to complete zombie fencing because a new set of task configs was generated")));
                    }
                }
            });
            DistributedHerder.this.member.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectorTargetStateChange(String connector) {
            DistributedHerder.this.log.info("Connector {} target state change", (Object)connector);
            DistributedHerder distributedHerder = DistributedHerder.this;
            synchronized (distributedHerder) {
                DistributedHerder.this.connectorTargetStateChanges.add(connector);
            }
            DistributedHerder.this.member.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSessionKeyUpdate(SessionKey sessionKey) {
            DistributedHerder.this.log.info("Session key updated");
            DistributedHerder distributedHerder = DistributedHerder.this;
            synchronized (distributedHerder) {
                DistributedHerder.this.sessionKey = sessionKey.key();
                if (DistributedHerder.this.keyRotationIntervalMs > 0) {
                    DistributedHerder.this.keyExpiration = sessionKey.creationTimestamp() + (long)DistributedHerder.this.keyRotationIntervalMs;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRestartRequest(RestartRequest request) {
            DistributedHerder.this.log.info("Received and enqueuing {}", (Object)request);
            DistributedHerder distributedHerder = DistributedHerder.this;
            synchronized (distributedHerder) {
                String connectorName = request.connectorName();
                DistributedHerder.this.pendingRestartRequests.compute(connectorName, (k, existingRequest) -> {
                    if (existingRequest == null || request.compareTo((RestartRequest)existingRequest) > 0) {
                        DistributedHerder.this.log.debug("Overwriting existing {} and enqueuing the higher impact {}", existingRequest, (Object)request);
                        return request;
                    }
                    DistributedHerder.this.log.debug("Preserving existing higher impact {} and ignoring incoming {}", existingRequest, (Object)request);
                    return existingRequest;
                });
            }
            DistributedHerder.this.member.wakeup();
        }

        @Override
        public void onLoggingLevelUpdate(String namespace, String level) {
            DistributedHerder.this.setWorkerLoggerLevel(namespace, level);
        }
    }
}

