/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.isolation.LazyPluginInfo;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.runtime.isolation.PluginType;
import org.apache.kafka.connect.runtime.rest.RestRequestTimeout;
import org.apache.kafka.connect.runtime.rest.entities.ConfigInfos;
import org.apache.kafka.connect.runtime.rest.entities.ConfigKeyInfo;
import org.apache.kafka.connect.runtime.rest.entities.PluginInfo;
import org.apache.kafka.connect.runtime.rest.errors.ConnectRestException;
import org.apache.kafka.connect.util.FutureCallback;
import org.apache.kafka.connect.util.Stage;
import org.apache.kafka.connect.util.StagedTimeoutException;

@Path(value="/connector-plugins")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ConnectorPluginsResource {
    private static final String ALIAS_SUFFIX = "Connector";
    private final Herder herder;
    private final Set<PluginInfo> connectorPlugins;
    private final RestRequestTimeout requestTimeout;

    @Inject
    public ConnectorPluginsResource(Herder herder, RestRequestTimeout requestTimeout) {
        this.herder = herder;
        this.requestTimeout = requestTimeout;
        this.connectorPlugins = new LinkedHashSet<PluginInfo>();
        this.addConnectorPlugins(herder.plugins().sinkConnectors());
        this.addConnectorPlugins(herder.plugins().sourceConnectors());
        this.addConnectorPlugins(herder.plugins().transformations());
        this.addConnectorPlugins(herder.plugins().predicates());
        this.addConnectorPlugins(herder.plugins().converters());
        this.addConnectorPlugins(herder.plugins().headerConverters());
        if (herder.plugins().lazyLoadEnabled()) {
            this.addLazyConnectorPlugins();
        }
    }

    private <T> void addConnectorPlugins(Collection<PluginDesc<T>> plugins) {
        plugins.stream().map(PluginInfo::new).forEach(this.connectorPlugins::add);
    }

    private void addLazyConnectorPlugins() {
        Map<PluginType, Map<String, LazyPluginInfo>> lazyPlugins = this.herder.plugins().lazyLoadPluginDesc();
        lazyPlugins.forEach((pluginType, pluginInfo) -> pluginInfo.forEach((pluginName, lazyPluginInfo) -> {
            PluginInfo plugin = new PluginInfo((String)pluginName, (PluginType)((Object)pluginType), lazyPluginInfo.version());
            this.connectorPlugins.add(plugin);
        }));
    }

    @PUT
    @Path(value="/{pluginName}/config/validate")
    @Operation(summary="Validate the provided configuration against the configuration definition for the specified pluginName")
    public ConfigInfos validateConfigs(@PathParam(value="pluginName") String pluginName, @DefaultValue(value="false") @QueryParam(value="skipConnectorValidations") Boolean skipConnectorValidations, Map<String, String> connectorConfig) throws Throwable {
        String includedConnType = connectorConfig.get("connector.class");
        if (includedConnType != null && !this.normalizedPluginName(includedConnType).endsWith(this.normalizedPluginName(pluginName))) {
            throw new BadRequestException("Included connector type " + includedConnType + " does not match request type " + pluginName);
        }
        FutureCallback<ConfigInfos> validationCallback = new FutureCallback<ConfigInfos>();
        this.herder.validateConnectorConfig(connectorConfig, validationCallback, false, skipConnectorValidations);
        try {
            return (ConfigInfos)validationCallback.get(this.requestTimeout.timeoutMs(), TimeUnit.MILLISECONDS);
        }
        catch (StagedTimeoutException e) {
            Stage stage = e.stage();
            String message = stage.completed() != null ? "Request timed out. The last operation the worker completed was " + stage.description() + ", which began at " + Instant.ofEpochMilli(stage.started()) + " and completed at " + Instant.ofEpochMilli(stage.completed()) : "Request timed out. The worker is currently " + stage.description() + ", which began at " + Instant.ofEpochMilli(stage.started());
            throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), message);
        }
        catch (TimeoutException e) {
            throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Request timed out");
        }
        catch (InterruptedException e) {
            throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Request interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Operation(summary="List all connector plugins installed")
    public List<PluginInfo> listConnectorPlugins(@DefaultValue(value="true") @QueryParam(value="connectorsOnly") @Parameter(description="Whether to list only connectors instead of all plugins") boolean connectorsOnly) {
        ConnectorPluginsResource connectorPluginsResource = this;
        synchronized (connectorPluginsResource) {
            if (connectorsOnly) {
                return Collections.unmodifiableList(this.connectorPlugins.stream().filter(p -> PluginType.SINK.toString().equals(p.type()) || PluginType.SOURCE.toString().equals(p.type())).collect(Collectors.toList()));
            }
            return Collections.unmodifiableList(new ArrayList<PluginInfo>(this.connectorPlugins));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{pluginName}/config")
    @Operation(summary="Get the configuration definition for the specified pluginName")
    public List<ConfigKeyInfo> getConnectorConfigDef(@PathParam(value="pluginName") String pluginName) {
        ConnectorPluginsResource connectorPluginsResource = this;
        synchronized (connectorPluginsResource) {
            return this.herder.connectorPluginConfig(pluginName);
        }
    }

    private String normalizedPluginName(String pluginName) {
        return pluginName.endsWith(ALIAS_SUFFIX) && pluginName.length() > ALIAS_SUFFIX.length() ? pluginName.substring(0, pluginName.length() - ALIAS_SUFFIX.length()) : pluginName;
    }
}

