/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.tracing;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Confluent;
import org.apache.kafka.connect.runtime.tracing.TraceRecord;
import org.apache.kafka.connect.runtime.tracing.TraceRecordBuilder;
import org.apache.kafka.connect.runtime.tracing.TracerConfig;
import org.apache.kafka.connect.runtime.tracing.TracingContext;

@Confluent
public interface Tracer
extends AutoCloseable {
    public void start();

    public Future<RecordMetadata> writeTraceRecord(TraceRecord var1, Callback var2);

    default public List<Future<RecordMetadata>> writeTraceRecords(List<TraceRecord> traceRecords, Callback callback) {
        ArrayList<Future<RecordMetadata>> recordMetadata = new ArrayList<Future<RecordMetadata>>();
        for (TraceRecord record : traceRecords) {
            recordMetadata.add(this.writeTraceRecord(record, callback));
        }
        return recordMetadata;
    }

    public TraceRecordBuilder traceRecordBuilder();

    public List<TraceRecord> buildRecords();

    default public List<Future<RecordMetadata>> buildAndWriteRecords(Callback callback) {
        return this.writeTraceRecords(this.buildRecords(), callback);
    }

    default public List<Future<RecordMetadata>> buildAndWriteRecords() {
        return this.buildAndWriteRecords(null);
    }

    public TracerConfig tracerConfig();

    public TracingContext tracingContext();

    @Override
    public void close();
}

