/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf.builtin.serializers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.hubspot.jackson.datatype.protobuf.ExtensionRegistryWrapper;
import com.hubspot.jackson.datatype.protobuf.ProtobufJacksonConfig;
import com.hubspot.jackson.datatype.protobuf.ProtobufSerializer;
import com.hubspot.jackson.datatype.protobuf.internal.MessageSchemaGenerator;
import com.hubspot.jackson.datatype.protobuf.internal.PropertyNamingCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class MessageSerializer
extends ProtobufSerializer<MessageOrBuilder> {
    private final boolean unwrappingSerializer;
    private final Map<Descriptors.Descriptor, PropertyNamingCache> propertyNamingCache;

    @Deprecated
    public MessageSerializer(ExtensionRegistryWrapper extensionRegistry) {
        this(ProtobufJacksonConfig.builder().extensionRegistry(extensionRegistry).build());
    }

    public MessageSerializer(ProtobufJacksonConfig config) {
        this(config, false);
    }

    private MessageSerializer(ProtobufJacksonConfig config, boolean unwrappingSerializer) {
        super(MessageOrBuilder.class, config);
        this.unwrappingSerializer = unwrappingSerializer;
        this.propertyNamingCache = new ConcurrentHashMap<Descriptors.Descriptor, PropertyNamingCache>();
    }

    public void serialize(MessageOrBuilder message, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        if (!this.isUnwrappingSerializer()) {
            generator.writeStartObject();
        }
        boolean proto3 = message.getDescriptorForType().getFile().getSyntax() == Descriptors.FileDescriptor.Syntax.PROTO3;
        JsonInclude.Include include = serializerProvider.getConfig().getDefaultPropertyInclusion().getValueInclusion();
        boolean writeDefaultValues = proto3 && include != JsonInclude.Include.NON_DEFAULT;
        boolean writeEmptyCollections = include != JsonInclude.Include.NON_DEFAULT && include != JsonInclude.Include.NON_EMPTY;
        Function<Descriptors.FieldDescriptor, String> propertyNaming = this.getPropertyNaming(message, serializerProvider);
        Descriptors.Descriptor descriptor = message.getDescriptorForType();
        ArrayList<Descriptors.FieldDescriptor> fields = descriptor.getFields();
        if (descriptor.isExtendable()) {
            fields = new ArrayList<Descriptors.FieldDescriptor>(fields);
            for (ExtensionRegistry.ExtensionInfo extensionInfo : this.getConfig().extensionRegistry().getExtensionsByDescriptor(descriptor)) {
                fields.add(extensionInfo.descriptor);
            }
        }
        for (Descriptors.FieldDescriptor field : fields) {
            String fieldName = propertyNaming.apply(field);
            if (field.isRepeated()) {
                List valueList = (List)message.getField(field);
                if (valueList.isEmpty() && !writeEmptyCollections) continue;
                if (field.isMapField()) {
                    generator.writeFieldName(fieldName);
                    this.writeMap(field, valueList, generator, serializerProvider);
                    continue;
                }
                if (valueList.size() == 1 && MessageSerializer.writeSingleElementArraysUnwrapped(serializerProvider)) {
                    generator.writeFieldName(fieldName);
                    this.writeValue(field, valueList.get(0), generator, serializerProvider);
                    continue;
                }
                generator.writeArrayFieldStart(fieldName);
                for (Object subValue : valueList) {
                    this.writeValue(field, subValue, generator, serializerProvider);
                }
                generator.writeEndArray();
                continue;
            }
            if (message.hasField(field) || writeDefaultValues && !MessageSerializer.supportsFieldPresence(field) && field.getContainingOneof() == null) {
                generator.writeFieldName(fieldName);
                this.writeValue(field, message.getField(field), generator, serializerProvider);
                continue;
            }
            if (include != JsonInclude.Include.ALWAYS || field.getContainingOneof() != null) continue;
            generator.writeFieldName(fieldName);
            generator.writeNull();
        }
        if (!this.isUnwrappingSerializer()) {
            generator.writeEndObject();
        }
    }

    public boolean isUnwrappingSerializer() {
        return this.unwrappingSerializer;
    }

    public MessageSerializer unwrappingSerializer(NameTransformer nameTransformer) {
        return new MessageSerializer(this.getConfig(), true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        Message defaultInstance = MessageSerializer.defaultInstance(typeHint);
        Function<Descriptors.FieldDescriptor, String> propertyNaming = this.getPropertyNaming((MessageOrBuilder)defaultInstance, visitor.getProvider());
        new MessageSchemaGenerator(defaultInstance, this.getConfig(), propertyNaming).acceptJsonFormatVisitor(visitor, typeHint);
    }

    private static Message defaultInstance(JavaType typeHint) {
        Class<?> messageType;
        Class<?> messageOrBuilderType = typeHint.getRawClass();
        if (Message.class.isAssignableFrom(messageOrBuilderType)) {
            messageType = messageOrBuilderType;
        } else if (Message.Builder.class.isAssignableFrom(messageOrBuilderType)) {
            messageType = messageOrBuilderType.getDeclaringClass();
        } else {
            throw new RuntimeException("Class does not appear to extend Message or Message.Builder: " + messageOrBuilderType);
        }
        try {
            return (Message)messageType.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get default instance for type " + messageType, e);
        }
    }

    private Function<Descriptors.FieldDescriptor, String> getPropertyNaming(MessageOrBuilder messageOrBuilder, SerializerProvider serializerProvider) {
        Descriptors.Descriptor descriptor = messageOrBuilder.getDescriptorForType();
        PropertyNamingCache cache = this.propertyNamingCache.get(descriptor);
        if (cache == null) {
            cache = this.propertyNamingCache.computeIfAbsent(descriptor, ignored -> PropertyNamingCache.forDescriptor(descriptor, messageOrBuilder.getDefaultInstanceForType().getClass(), this.getConfig()));
        }
        return cache.forSerialization((MapperConfig<?>)serializerProvider.getConfig());
    }

    private static boolean supportsFieldPresence(Descriptors.FieldDescriptor field) {
        return field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE;
    }

    private static boolean writeSingleElementArraysUnwrapped(SerializerProvider config) {
        return config.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
    }
}

