/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.bootstrap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;

public class BootstrapMetadata {
    private final List<ApiMessageAndVersion> records;
    private final MetadataVersion metadataVersion;
    private final String source;

    public static BootstrapMetadata fromVersions(MetadataVersion metadataVersion, Map<String, Short> featureVersions, String source) {
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        records.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("confluent.metadata.version").setFeatureLevel(metadataVersion.confluentFeatureLevel()), 0));
        ArrayList featureNames = new ArrayList(featureVersions.size());
        featureVersions.keySet().forEach(n -> {
            if (!(n.equals("confluent.metadata.version") || n.equals("metadata.version") || n.equals("kraft.version"))) {
                featureNames.add(n);
            }
        });
        featureNames.sort(String::compareTo);
        for (String featureName : featureNames) {
            short level = featureVersions.get(featureName);
            if (level <= 0) continue;
            records.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName(featureName).setFeatureLevel(level), 0));
        }
        return new BootstrapMetadata(records, metadataVersion, source);
    }

    public static BootstrapMetadata fromVersion(MetadataVersion metadataVersion, String source) {
        return BootstrapMetadata.fromVersion(metadataVersion, source, true);
    }

    public static BootstrapMetadata fromVersion(MetadataVersion metadataVersion, String source, boolean requireMinimumVersion) {
        List<ApiMessageAndVersion> records = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("confluent.metadata.version").setFeatureLevel(metadataVersion.confluentFeatureLevel()), 0));
        return new BootstrapMetadata(records, metadataVersion, source, requireMinimumVersion);
    }

    public static BootstrapMetadata fromRecords(List<ApiMessageAndVersion> records, String source) {
        return BootstrapMetadata.fromRecords(records, source, true);
    }

    public static BootstrapMetadata fromRecords(List<ApiMessageAndVersion> records, String source, boolean requireMinimumVersion) {
        MetadataVersion metadataVersion = null;
        for (ApiMessageAndVersion record : records) {
            Optional<MetadataVersion> version = BootstrapMetadata.recordToMetadataVersion(record.message());
            if (!version.isPresent()) continue;
            metadataVersion = version.get();
        }
        if (metadataVersion == null) {
            throw new RuntimeException("No FeatureLevelRecord for metadata.version or confluent.metadata.version was found in the bootstrap metadata from " + source);
        }
        return new BootstrapMetadata(records, metadataVersion, source, requireMinimumVersion);
    }

    public static Optional<MetadataVersion> recordToMetadataVersion(ApiMessage record) {
        if (record instanceof FeatureLevelRecord) {
            FeatureLevelRecord featureLevel = (FeatureLevelRecord)record;
            if (featureLevel.name().equals("metadata.version")) {
                return Optional.of(MetadataVersion.fromApacheFeatureLevel((short)featureLevel.featureLevel()));
            }
            if (featureLevel.name().equals("confluent.metadata.version")) {
                return Optional.of(MetadataVersion.fromConfluentFeatureLevel((short)featureLevel.featureLevel()));
            }
        }
        return Optional.empty();
    }

    BootstrapMetadata(List<ApiMessageAndVersion> records, MetadataVersion metadataVersion, String source) {
        this(records, metadataVersion, source, true);
    }

    BootstrapMetadata(List<ApiMessageAndVersion> records, MetadataVersion metadataVersion, String source, boolean requireMinimumVersion) {
        this.records = Objects.requireNonNull(records);
        if (requireMinimumVersion && metadataVersion.isLessThan(MetadataVersion.MINIMUM_BOOTSTRAP_VERSION)) {
            throw new RuntimeException("Bootstrap metadata.version before " + MetadataVersion.MINIMUM_BOOTSTRAP_VERSION + " are not supported. Can't load metadata from " + source);
        }
        this.metadataVersion = metadataVersion;
        Objects.requireNonNull(source);
        this.source = source;
    }

    public List<ApiMessageAndVersion> records() {
        return this.records;
    }

    public MetadataVersion metadataVersion() {
        return this.metadataVersion;
    }

    public String source() {
        return this.source;
    }

    public BootstrapMetadata copyWithOnlyVersion() {
        ApiMessageAndVersion versionRecord = null;
        for (ApiMessageAndVersion record : this.records) {
            if (!BootstrapMetadata.recordToMetadataVersion(record.message()).isPresent()) continue;
            versionRecord = record;
        }
        if (versionRecord == null) {
            throw new RuntimeException("No FeatureLevelRecord for metadata.version or confluent.metadata.version was found in " + this.source);
        }
        return new BootstrapMetadata(Collections.singletonList(versionRecord), this.metadataVersion, this.source);
    }

    public int hashCode() {
        return Objects.hash(this.records, this.metadataVersion, this.source);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        BootstrapMetadata other = (BootstrapMetadata)o;
        return Objects.equals(this.records, other.records) && this.metadataVersion.equals((Object)other.metadataVersion) && this.source.equals(other.source);
    }

    public String toString() {
        return "BootstrapMetadata(records=" + this.records.toString() + ", metadataVersion=" + this.metadataVersion + ", source=" + this.source + ")";
    }
}

