/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.secretregistry.rbac.config.provider;

import io.confluent.connect.secretregistry.ConnectSecretRegistryExtension;
import io.confluent.kafka.secretregistry.client.rest.entities.Secret;
import io.confluent.kafka.secretregistry.rest.SecretRegistryConfig;
import io.confluent.kafka.secretregistry.storage.KafkaSecretRegistry;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigData;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalSecretConfigProvider
implements ConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(InternalSecretConfigProvider.class);
    private static String PARAM_PREFIX = "param.";
    private static KafkaSecretRegistry secretRegistry;

    private static synchronized void initSecretRegistry(Map<String, ?> configs) {
        try {
            if (secretRegistry == null) {
                Properties props = new Properties();
                for (Map.Entry<String, ?> entry : configs.entrySet()) {
                    String key = entry.getKey();
                    if (key.startsWith(PARAM_PREFIX)) {
                        key = key.substring(PARAM_PREFIX.length());
                    }
                    props.put(key, entry.getValue());
                }
                SecretRegistryConfig config = new SecretRegistryConfig(props);
                secretRegistry = new KafkaSecretRegistry(config);
                secretRegistry.initStore();
                ConnectSecretRegistryExtension.configureSecretRegistry(secretRegistry);
                log.info("Done initializing InternalSecretConfigProvider");
            }
        }
        catch (Exception e) {
            secretRegistry = null;
            log.warn("Error initializing InternalSecretConfigProvider", (Throwable)e);
        }
    }

    public void configure(Map<String, ?> configs) {
        InternalSecretConfigProvider.initSecretRegistry(configs);
    }

    public ConfigData get(String path) {
        try {
            Map<String, String> data = secretRegistry.getAllLatest(path).stream().collect(Collectors.toMap(Secret::getKey, Secret::getSecret));
            return new ConfigData(data);
        }
        catch (Exception e) {
            log.error("Could not obtain config data", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ConfigData get(String path, Set<String> keys) {
        try {
            Map<String, String> data = secretRegistry.getAllLatest(path).stream().filter(s -> keys.contains(s.getKey())).collect(Collectors.toMap(Secret::getKey, Secret::getSecret));
            return new ConfigData(data);
        }
        catch (Exception e) {
            log.error("Could not obtain config data", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void close() {
    }
}

