/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.availability;

import io.confluent.kafka.availability.CheckedFunction;
import io.confluent.kafka.availability.CheckedFunctionVoid;
import io.confluent.kafka.availability.ThreadLocalCounters;
import io.confluent.kafka.availability.UncheckedFunction;
import io.confluent.kafka.availability.UncheckedFunctionVoid;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadCountersManager {
    public static volatile boolean threadCountersManagerEnabled = false;
    private static Map<Thread, List<ThreadLocalCounters>> threadToThreadLocalCountersMap = new WeakHashMap<Thread, List<ThreadLocalCounters>>();
    private static final Object LOCK = new Object();
    private static LocalCounters storageCounters = new LocalCounters();
    private static LocalCounters engineCounters = new LocalCounters();
    private static AtomicInteger brokerCount = new AtomicInteger(0);

    private static void decrementInProgressAndIncrementSuccess(ThreadLocalCounters counters) {
        ++counters.numSuccessOps;
        --counters.numInProgressOps;
    }

    private static void incrementInProgress(ThreadLocalCounters counters) {
        ++counters.numInProgressOps;
    }

    public static <T> T wrapIO(UncheckedFunction<T> f) {
        if (!threadCountersManagerEnabled) {
            return f.apply();
        }
        ThreadLocalCounters counters = (ThreadLocalCounters)storageCounters.get();
        ThreadCountersManager.incrementInProgress(counters);
        try {
            T t = f.apply();
            return t;
        }
        finally {
            ThreadCountersManager.decrementInProgressAndIncrementSuccess(counters);
        }
    }

    public static void wrapIOVoid(UncheckedFunctionVoid f) {
        if (!threadCountersManagerEnabled) {
            f.apply();
            return;
        }
        ThreadLocalCounters counters = (ThreadLocalCounters)storageCounters.get();
        ThreadCountersManager.incrementInProgress(counters);
        try {
            f.apply();
        }
        finally {
            ThreadCountersManager.decrementInProgressAndIncrementSuccess(counters);
        }
    }

    public static <T> T wrapIOChecked(CheckedFunction<T> f) throws IOException {
        if (!threadCountersManagerEnabled) {
            return f.apply();
        }
        ThreadLocalCounters counters = (ThreadLocalCounters)storageCounters.get();
        ThreadCountersManager.incrementInProgress(counters);
        try {
            T t = f.apply();
            return t;
        }
        finally {
            ThreadCountersManager.decrementInProgressAndIncrementSuccess(counters);
        }
    }

    public static void wrapIOChecked(CheckedFunctionVoid f) throws IOException {
        if (!threadCountersManagerEnabled) {
            f.apply();
            return;
        }
        ThreadLocalCounters counters = (ThreadLocalCounters)storageCounters.get();
        ThreadCountersManager.incrementInProgress(counters);
        try {
            f.apply();
        }
        finally {
            ThreadCountersManager.decrementInProgressAndIncrementSuccess(counters);
        }
    }

    public static <T> T wrapEngine(UncheckedFunction<T> f) {
        if (!threadCountersManagerEnabled) {
            return f.apply();
        }
        ThreadLocalCounters counters = (ThreadLocalCounters)engineCounters.get();
        ThreadCountersManager.incrementInProgress(counters);
        try {
            T t = f.apply();
            return t;
        }
        finally {
            ThreadCountersManager.decrementInProgressAndIncrementSuccess(counters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Thread, List<ThreadLocalCounters>> getThreadLocalCounterSnapshotForAllKnownThreads() {
        WeakHashMap<Thread, List<ThreadLocalCounters>> snapshot = new WeakHashMap<Thread, List<ThreadLocalCounters>>();
        if (!threadCountersManagerEnabled) {
            return snapshot;
        }
        Object object = LOCK;
        synchronized (object) {
            threadToThreadLocalCountersMap.forEach((key, list) -> list.forEach(value -> {
                if (value.threadGroupType != ThreadLocalCounters.ThreadGroupType.OTHER) {
                    List threadLocalCountersListForThread = snapshot.computeIfAbsent((Thread)key, thread -> new ArrayList());
                    threadLocalCountersListForThread.add(new ThreadLocalCounters((ThreadLocalCounters)value));
                }
            }));
        }
        return snapshot;
    }

    public static void registerBroker() {
        brokerCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterBroker() {
        if (brokerCount.decrementAndGet() == 0) {
            Object object = LOCK;
            synchronized (object) {
                threadToThreadLocalCountersMap.clear();
            }
        }
    }

    public static class LocalCounters
    extends ThreadLocal<ThreadLocalCounters> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ThreadLocalCounters initialValue() {
            ThreadLocalCounters value = new ThreadLocalCounters();
            Object object = LOCK;
            synchronized (object) {
                List countersList = threadToThreadLocalCountersMap.computeIfAbsent(Thread.currentThread(), key -> new ArrayList());
                countersList.add(value);
            }
            super.set(value);
            return value;
        }

        @Override
        public void set(ThreadLocalCounters value) {
            throw new UnsupportedOperationException("Set should not be called on this object.");
        }

        public static void setThreadType(ThreadLocalCounters.ThreadGroupType type) {
            if (!threadCountersManagerEnabled) {
                return;
            }
            ((ThreadLocalCounters)storageCounters.get()).setThreadGroupType(type);
            ((ThreadLocalCounters)storageCounters.get()).setComponentType(ThreadLocalCounters.MetricComponentType.STORAGE);
            ((ThreadLocalCounters)engineCounters.get()).setThreadGroupType(type);
            ((ThreadLocalCounters)engineCounters.get()).setComponentType(ThreadLocalCounters.MetricComponentType.ENGINE);
        }
    }
}

