/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BrokerLeadershipPriorityResult {
    private final int brokerId;
    private final LeadershipPriorityEnum leadershipPriorityEnum;

    BrokerLeadershipPriorityResult(int brokerId, byte leadershipPriorityValue) {
        this.brokerId = brokerId;
        this.leadershipPriorityEnum = LeadershipPriorityEnum.ENUM_MAP.getOrDefault(leadershipPriorityValue, LeadershipPriorityEnum.UNKNOWN);
    }

    public int brokerId() {
        return this.brokerId;
    }

    public LeadershipPriorityEnum leadershipPriority() {
        return this.leadershipPriorityEnum;
    }

    public String toString() {
        return "BrokerLeadershipPriorityResult(brokerId=" + this.brokerId + ", leadershipPriority=" + (Object)((Object)this.leadershipPriorityEnum) + ")";
    }

    public static enum LeadershipPriorityEnum {
        UNKNOWN(-1),
        DEMOTED(0),
        NORMAL(1);

        private static final Map<Byte, LeadershipPriorityEnum> ENUM_MAP;
        private final byte id;

        private LeadershipPriorityEnum(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        static {
            ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(LeadershipPriorityEnum.values()).collect(Collectors.toMap(LeadershipPriorityEnum::id, Function.identity())));
        }
    }
}

