/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeConfigsRequestData
implements ApiMessage {
    List<DescribeConfigsResource> resources;
    boolean includeSynonyms;
    boolean includeDocumentation;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("resources", new ArrayOf(DescribeConfigsResource.SCHEMA_0), "The resources whose configurations we want to describe."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 4;

    public DescribeConfigsRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public DescribeConfigsRequestData() {
        this.resources = new ArrayList<DescribeConfigsResource>(0);
        this.includeSynonyms = false;
        this.includeDocumentation = false;
    }

    @Override
    public short apiKey() {
        return 32;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 4;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        DescribeConfigsResource _resourcesTransformed;
        DescribeConfigsResource _resourcesRawElement;
        int i;
        ArrayList<DescribeConfigsResource> newCollection;
        int arrayLength;
        if (_version >= 4) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field resources was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                _resourcesRawElement = new DescribeConfigsResource(_readable, _version, _context);
                _resourcesTransformed = (DescribeConfigsResource)_context.read(EntityType.CONFIG_RESOURCE, _resourcesRawElement);
                newCollection.add(_resourcesTransformed);
            }
            this.resources = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field resources was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<DescribeConfigsResource>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                _resourcesRawElement = new DescribeConfigsResource(_readable, _version, _context);
                _resourcesTransformed = (DescribeConfigsResource)_context.read(EntityType.CONFIG_RESOURCE, _resourcesRawElement);
                newCollection.add(_resourcesTransformed);
            }
            this.resources = newCollection;
        }
        this.includeSynonyms = _version >= 1 ? _readable.readByte() != 0 : false;
        this.includeDocumentation = _version >= 3 ? _readable.readByte() != 0 : false;
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        ArrayList _resourcesTransformed;
        int _numTaggedFields = 0;
        if (_version >= 4) {
            _writable.writeUnsignedVarint(this.resources.size() + 1);
            _resourcesTransformed = (ArrayList)_cache.getTransformedValue(this.resources);
            for (DescribeConfigsResource resourcesElement : _resourcesTransformed) {
                resourcesElement.write(_writable, _cache, _version, _context);
            }
        } else {
            _writable.writeInt(this.resources.size());
            _resourcesTransformed = (ArrayList)_cache.getTransformedValue(this.resources);
            for (DescribeConfigsResource resourcesElement : _resourcesTransformed) {
                resourcesElement.write(_writable, _cache, _version, _context);
            }
        }
        if (_version >= 1) {
            _writable.writeByte(this.includeSynonyms ? (byte)1 : 0);
        } else if (this.includeSynonyms) {
            throw new UnsupportedVersionException("Attempted to write a non-default includeSynonyms at version " + _version);
        }
        if (_version >= 3) {
            _writable.writeByte(this.includeDocumentation ? (byte)1 : 0);
        } else if (this.includeDocumentation) {
            throw new UnsupportedVersionException("Attempted to write a non-default includeDocumentation at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 4) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.resources.size() + 1));
        } else {
            _size.addBytes(4);
        }
        ArrayList<DescribeConfigsResource> _resourcesTransformed = new ArrayList<DescribeConfigsResource>(this.resources.size());
        for (DescribeConfigsResource resourcesElement : this.resources) {
            DescribeConfigsResource _transformedMessage = (DescribeConfigsResource)_context.write(EntityType.CONFIG_RESOURCE, resourcesElement);
            _resourcesTransformed.add(_transformedMessage);
            _transformedMessage.addSize(_size, _cache, _version, _context);
        }
        _cache.cacheTransformedValue(this.resources, _resourcesTransformed);
        if (_version >= 1) {
            _size.addBytes(1);
        }
        if (_version >= 3) {
            _size.addBytes(1);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeConfigsRequestData)) {
            return false;
        }
        DescribeConfigsRequestData other = (DescribeConfigsRequestData)obj;
        if (this.resources == null ? other.resources != null : !this.resources.equals(other.resources)) {
            return false;
        }
        if (this.includeSynonyms != other.includeSynonyms) {
            return false;
        }
        if (this.includeDocumentation != other.includeDocumentation) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.resources == null ? 0 : this.resources.hashCode());
        hashCode = 31 * hashCode + (this.includeSynonyms ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.includeDocumentation ? 1231 : 1237);
        return hashCode;
    }

    @Override
    public DescribeConfigsRequestData duplicate() {
        DescribeConfigsRequestData _duplicate = new DescribeConfigsRequestData();
        ArrayList<DescribeConfigsResource> newResources = new ArrayList<DescribeConfigsResource>(this.resources.size());
        for (DescribeConfigsResource _element : this.resources) {
            newResources.add(_element.duplicate());
        }
        _duplicate.resources = newResources;
        _duplicate.includeSynonyms = this.includeSynonyms;
        _duplicate.includeDocumentation = this.includeDocumentation;
        return _duplicate;
    }

    public String toString() {
        return "DescribeConfigsRequestData(resources=" + MessageUtil.deepToString(this.resources.iterator()) + ", includeSynonyms=" + (this.includeSynonyms ? "true" : "false") + ", includeDocumentation=" + (this.includeDocumentation ? "true" : "false") + ")";
    }

    public List<DescribeConfigsResource> resources() {
        return this.resources;
    }

    public boolean includeSynonyms() {
        return this.includeSynonyms;
    }

    public boolean includeDocumentation() {
        return this.includeDocumentation;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeConfigsRequestData setResources(List<DescribeConfigsResource> v) {
        this.resources = v;
        return this;
    }

    public DescribeConfigsRequestData setIncludeSynonyms(boolean v) {
        this.includeSynonyms = v;
        return this;
    }

    public DescribeConfigsRequestData setIncludeDocumentation(boolean v) {
        this.includeDocumentation = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = new Schema(new Field("resources", new ArrayOf(DescribeConfigsResource.SCHEMA_0), "The resources whose configurations we want to describe."), new Field("include_synonyms", Type.BOOLEAN, "True if we should include all synonyms."));
        SCHEMA_3 = new Schema(new Field("resources", new ArrayOf(DescribeConfigsResource.SCHEMA_0), "The resources whose configurations we want to describe."), new Field("include_synonyms", Type.BOOLEAN, "True if we should include all synonyms."), new Field("include_documentation", Type.BOOLEAN, "True if we should include configuration documentation."));
        SCHEMA_4 = new Schema(new Field("resources", new CompactArrayOf(DescribeConfigsResource.SCHEMA_4), "The resources whose configurations we want to describe."), new Field("include_synonyms", Type.BOOLEAN, "True if we should include all synonyms."), new Field("include_documentation", Type.BOOLEAN, "True if we should include configuration documentation."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
    }

    public static class DescribeConfigsResource
    implements Message {
        byte resourceType;
        String resourceName;
        List<String> configurationKeys;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 4;

        public DescribeConfigsResource(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public DescribeConfigsResource() {
            this.resourceType = 0;
            this.resourceName = "";
            this.configurationKeys = new ArrayList<String>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 4;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int length;
            int i;
            ArrayList<String> newCollection;
            int arrayLength;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeConfigsResource");
            }
            this.resourceType = _readable.readByte();
            int length2 = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length2 < 0) {
                throw new RuntimeException("non-nullable field resourceName was serialized as null");
            }
            if (length2 > Short.MAX_VALUE) {
                throw new RuntimeException("string field resourceName had invalid length " + length2);
            }
            this.resourceName = _readable.readString(length2);
            if (_version >= 4) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    this.configurationKeys = null;
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        length = _readable.readUnsignedVarint() - 1;
                        if (length < 0) {
                            throw new RuntimeException("non-nullable field configurationKeys element was serialized as null");
                        }
                        if (length > Short.MAX_VALUE) {
                            throw new RuntimeException("string field configurationKeys element had invalid length " + length);
                        }
                        newCollection.add(_readable.readString(length));
                    }
                    this.configurationKeys = newCollection;
                }
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    this.configurationKeys = null;
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    newCollection = new ArrayList<String>(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        length = _readable.readShort();
                        if (length < 0) {
                            throw new RuntimeException("non-nullable field configurationKeys element was serialized as null");
                        }
                        if (length > Short.MAX_VALUE) {
                            throw new RuntimeException("string field configurationKeys element had invalid length " + length);
                        }
                        newCollection.add(_readable.readString(length));
                    }
                    this.configurationKeys = newCollection;
                }
            }
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeByte(this.resourceType);
            Object _stringBytes = _cache.getSerializedValue(this.resourceName);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 4) {
                if (this.configurationKeys == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeUnsignedVarint(this.configurationKeys.size() + 1);
                    _stringBytes = this.configurationKeys.iterator();
                    while (_stringBytes.hasNext()) {
                        String configurationKeysElement = (String)_stringBytes.next();
                        byte[] _stringBytes2 = _cache.getSerializedValue(configurationKeysElement);
                        _writable.writeUnsignedVarint(_stringBytes2.length + 1);
                        _writable.writeByteArray(_stringBytes2);
                    }
                }
            } else if (this.configurationKeys == null) {
                _writable.writeInt(-1);
            } else {
                _writable.writeInt(this.configurationKeys.size());
                _stringBytes = this.configurationKeys.iterator();
                while (_stringBytes.hasNext()) {
                    String configurationKeysElement = (String)_stringBytes.next();
                    byte[] _stringBytes3 = _cache.getSerializedValue(configurationKeysElement);
                    _writable.writeShort((short)_stringBytes3.length);
                    _writable.writeByteArray(_stringBytes3);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribeConfigsResource");
            }
            _size.addBytes(1);
            byte[] _stringBytes = this.resourceName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'resourceName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.resourceName, _stringBytes);
            if (_version >= 4) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (this.configurationKeys == null) {
                if (_version >= 4) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(4);
                }
            } else {
                if (_version >= 4) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.configurationKeys.size() + 1));
                } else {
                    _size.addBytes(4);
                }
                for (String configurationKeysElement : this.configurationKeys) {
                    byte[] _stringBytes2 = configurationKeysElement.getBytes(StandardCharsets.UTF_8);
                    if (_stringBytes2.length > Short.MAX_VALUE) {
                        throw new RuntimeException("'configurationKeysElement' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue(configurationKeysElement, _stringBytes2);
                    if (_version >= 4) {
                        _size.addBytes(_stringBytes2.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes2.length + 1));
                        continue;
                    }
                    _size.addBytes(_stringBytes2.length + 2);
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeConfigsResource)) {
                return false;
            }
            DescribeConfigsResource other = (DescribeConfigsResource)obj;
            if (this.resourceType != other.resourceType) {
                return false;
            }
            if (this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName)) {
                return false;
            }
            if (this.configurationKeys == null ? other.configurationKeys != null : !this.configurationKeys.equals(other.configurationKeys)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.resourceType;
            hashCode = 31 * hashCode + (this.resourceName == null ? 0 : this.resourceName.hashCode());
            hashCode = 31 * hashCode + (this.configurationKeys == null ? 0 : this.configurationKeys.hashCode());
            return hashCode;
        }

        @Override
        public DescribeConfigsResource duplicate() {
            DescribeConfigsResource _duplicate = new DescribeConfigsResource();
            _duplicate.resourceType = this.resourceType;
            _duplicate.resourceName = this.resourceName;
            if (this.configurationKeys == null) {
                _duplicate.configurationKeys = null;
            } else {
                ArrayList<String> newConfigurationKeys = new ArrayList<String>(this.configurationKeys.size());
                for (String _element : this.configurationKeys) {
                    newConfigurationKeys.add(_element);
                }
                _duplicate.configurationKeys = newConfigurationKeys;
            }
            return _duplicate;
        }

        public String toString() {
            return "DescribeConfigsResource(resourceType=" + this.resourceType + ", resourceName=" + (this.resourceName == null ? "null" : "'" + this.resourceName.toString() + "'") + ", configurationKeys=" + (this.configurationKeys == null ? "null" : MessageUtil.deepToString(this.configurationKeys.iterator())) + ")";
        }

        public byte resourceType() {
            return this.resourceType;
        }

        public String resourceName() {
            return this.resourceName;
        }

        public List<String> configurationKeys() {
            return this.configurationKeys;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribeConfigsResource setResourceType(byte v) {
            this.resourceType = v;
            return this;
        }

        public DescribeConfigsResource setResourceName(String v) {
            this.resourceName = v;
            return this;
        }

        public DescribeConfigsResource setConfigurationKeys(List<String> v) {
            this.configurationKeys = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("resource_type", Type.INT8, "The resource type."), new Field("resource_name", Type.STRING, "The resource name."), new Field("configuration_keys", ArrayOf.nullable(Type.STRING), "The configuration keys to list, or null to list all configuration keys."))));
            SCHEMA_4 = new Schema(new Field("resource_type", Type.INT8, "The resource type."), new Field("resource_name", Type.COMPACT_STRING, "The resource name."), new Field("configuration_keys", CompactArrayOf.nullable(Type.COMPACT_STRING), "The configuration keys to list, or null to list all configuration keys."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
        }
    }
}

