/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.Closeable;
import java.net.InetAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.net.ssl.SSLEngine;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.network.AsyncAuthExecutor;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import org.apache.kafka.common.network.ProxyProtocolEngine;
import org.apache.kafka.common.network.ProxyProtocolEngineFactory;
import org.apache.kafka.common.network.SslTransportLayer;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SslAuthenticationContext;
import org.apache.kafka.common.security.auth.SslEngineFactory;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.common.security.ssl.SslPrincipalMapper;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.interceptor.BrokerInterceptor;

public class SslChannelBuilder
implements ChannelBuilder,
ListenerReconfigurable {
    private static final String SECURITY_MECHANISM = "SSL";
    private final ListenerName listenerName;
    private final boolean isInterBrokerListener;
    private final ConnectionMode connectionMode;
    private SslFactory sslFactory;
    private Map<String, ?> configs;
    private SslPrincipalMapper sslPrincipalMapper;
    private final ProxyProtocolEngineFactory proxyProtocolEngineFactory;
    private boolean shouldParseSni;
    private boolean shouldParseLkcId;

    public SslChannelBuilder(ConnectionMode connectionMode, ListenerName listenerName, boolean isInterBrokerListener, LogContext logContext, ProxyProtocolEngineFactory proxyProtocolEngineFactory) {
        this.connectionMode = connectionMode;
        this.listenerName = listenerName;
        this.isInterBrokerListener = isInterBrokerListener;
        this.proxyProtocolEngineFactory = proxyProtocolEngineFactory;
    }

    @Override
    public void configure(Map<String, ?> configs) throws KafkaException {
        try {
            this.configs = configs;
            this.sslPrincipalMapper = SslChannelBuilder.createSslPrincipalMapperFromConfigs(configs);
            this.sslFactory = new SslFactory(this.connectionMode, null, this.isInterBrokerListener);
            this.sslFactory.configure(this.configs);
            Map<String, ?> nextConfigs = configs;
            this.shouldParseSni = nextConfigs.getOrDefault("confluent.multitenant.parse.sni.host.name.enable", false);
            this.shouldParseLkcId = nextConfigs.getOrDefault("confluent.multitenant.parse.lkc.id.enable", false);
        }
        catch (KafkaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KafkaException(e);
        }
    }

    public static SslPrincipalMapper createSslPrincipalMapperFromConfigs(Map<String, ?> configs) {
        String sslPrincipalMappingRules = (String)configs.get("ssl.principal.mapping.rules");
        if (sslPrincipalMappingRules != null) {
            return SslPrincipalMapper.fromRules(sslPrincipalMappingRules);
        }
        return null;
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return SslConfigs.RECONFIGURABLE_CONFIGS;
    }

    @Override
    public void validateReconfiguration(Map<String, ?> configs) {
        this.sslFactory.validateReconfiguration(configs);
    }

    @Override
    public void reconfigure(Map<String, ?> configs) {
        this.sslFactory.reconfigure(configs);
    }

    @Override
    public ListenerName listenerName() {
        return this.listenerName;
    }

    @Override
    public KafkaChannel buildChannel(String id, SelectionKey key, int maxReceiveSize, AsyncAuthExecutor asyncAuthExecutor, MemoryPool memoryPool, ChannelMetadataRegistry metadataRegistry, Time time) throws KafkaException {
        SslTransportLayer transportLayer = null;
        try {
            SslTransportLayer finalTransportLayer = transportLayer = this.buildTransportLayer(this.sslFactory, id, key, metadataRegistry, this.proxyProtocolEngineFactory.createProxyProtocolEngine());
            BrokerInterceptor interceptor = ConfluentConfigs.buildBrokerInterceptor(this.connectionMode, this.configs);
            Supplier<Authenticator> authenticatorCreator = () -> new SslAuthenticator(this.configs, finalTransportLayer, this.listenerName, this.sslPrincipalMapper);
            return new KafkaChannel(id, transportLayer, authenticatorCreator, maxReceiveSize, asyncAuthExecutor, memoryPool != null ? memoryPool : MemoryPool.NONE, metadataRegistry, interceptor, time, this.shouldParseSni, this.shouldParseLkcId);
        }
        catch (Exception e) {
            Utils.closeQuietly(transportLayer, "transport layer for channel Id: " + id);
            throw new KafkaException(e);
        }
    }

    @Override
    public Set<String> securityMechanisms() {
        return Collections.singleton(SECURITY_MECHANISM);
    }

    @Override
    public void close() {
        if (this.sslFactory != null) {
            this.sslFactory.close();
        }
    }

    SslEngineFactory sslEngineFactory() {
        return this.sslFactory.sslEngineFactory();
    }

    protected SslTransportLayer buildTransportLayer(SslFactory sslFactory, String id, SelectionKey key, ChannelMetadataRegistry metadataRegistry, ProxyProtocolEngine proxyProtocolEngine) {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        SSLEngine engine = sslFactory.createSslEngine(socketChannel.socket());
        return SslTransportLayer.create(id, key, engine, metadataRegistry, sslFactory.createCloseableSslEngine(engine), this.connectionMode, false, false, proxyProtocolEngine);
    }

    private static class SslAuthenticator
    implements Authenticator {
        private final SslTransportLayer transportLayer;
        private final KafkaPrincipalBuilder principalBuilder;
        private final ListenerName listenerName;
        private KafkaPrincipal principal;

        private SslAuthenticator(Map<String, ?> configs, SslTransportLayer transportLayer, ListenerName listenerName, SslPrincipalMapper sslPrincipalMapper) {
            this.transportLayer = transportLayer;
            this.principalBuilder = ChannelBuilders.createPrincipalBuilder(configs, null, sslPrincipalMapper);
            this.listenerName = listenerName;
        }

        @Override
        public void authenticate() {
        }

        @Override
        public KafkaPrincipal principal() {
            if (this.principal == null) {
                this.principal = this.principalBuilder.build(this.authenticationContext());
            }
            return this.principal;
        }

        @Override
        public Optional<KafkaPrincipalSerde> principalSerde() {
            return this.principalBuilder instanceof KafkaPrincipalSerde ? Optional.of((KafkaPrincipalSerde)((Object)this.principalBuilder)) : Optional.empty();
        }

        @Override
        public void close() {
            if (this.principalBuilder instanceof Closeable) {
                Utils.closeQuietly((Closeable)((Object)this.principalBuilder), "principal builder");
            }
        }

        @Override
        public boolean complete() {
            return true;
        }

        @Override
        public AuthenticationContext authenticationContext() {
            InetAddress clientAddress = this.transportLayer.socketChannel().socket().getInetAddress();
            if (this.listenerName == null) {
                throw new IllegalStateException("Unexpected call to principal()/authenticationContext() when listenerName is null");
            }
            return new SslAuthenticationContext(this.transportLayer.sslSession(), clientAddress, this.listenerName.value());
        }

        @Override
        public String securityMechanism() {
            return SslChannelBuilder.SECURITY_MECHANISM;
        }
    }
}

