/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.common.message.AlterBrokerReplicaExclusionsRequestData;
import org.apache.kafka.common.message.AlterBrokerReplicaExclusionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterBrokerReplicaExclusionsResponse;
import org.apache.kafka.common.requests.ApiError;

public class AlterBrokerReplicaExclusionsRequest
extends AbstractRequest {
    private AlterBrokerReplicaExclusionsRequestData data;

    public AlterBrokerReplicaExclusionsRequest(AlterBrokerReplicaExclusionsRequestData data, short version) {
        super(ApiKeys.ALTER_BROKER_REPLICA_EXCLUSIONS, version);
        this.data = data;
    }

    @Override
    public AlterBrokerReplicaExclusionsRequestData data() {
        return this.data;
    }

    @Override
    public AlterBrokerReplicaExclusionsResponse getErrorResponse(int throttleTimeMs, Throwable throwable) {
        ApiError apiError = ApiError.fromThrowable(throwable);
        ArrayList<AlterBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse> exclusions = this.data.brokersToExclude() == null ? new ArrayList<AlterBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse>() : this.data.brokersToExclude().stream().map(e -> new AlterBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setBrokerId(e.brokerId()).setExclusionOperationCode(e.exclusionOperationCode()).setExclusionErrorMessage(apiError.message()).setExclusionErrorCode(apiError.error().code())).collect(Collectors.toList());
        AlterBrokerReplicaExclusionsResponseData data = new AlterBrokerReplicaExclusionsResponseData().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setThrottleTimeMs(throttleTimeMs).setBrokerExclusions(exclusions).setWasApplied(false);
        return new AlterBrokerReplicaExclusionsResponse(data);
    }

    public static AlterBrokerReplicaExclusionsRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new AlterBrokerReplicaExclusionsRequest(new AlterBrokerReplicaExclusionsRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterBrokerReplicaExclusionsRequest> {
        private final Map<Integer, AlterBrokerReplicaExclusionsRequestData.BrokerExclusion> exclusionById = new HashMap<Integer, AlterBrokerReplicaExclusionsRequestData.BrokerExclusion>();

        public Builder() {
            super(ApiKeys.ALTER_BROKER_REPLICA_EXCLUSIONS);
        }

        public Builder addExclusion(int brokerId, ExclusionOp operation) {
            if (this.exclusionById.containsKey(brokerId)) {
                throw new IllegalArgumentException(String.format("Cannot add a duplicate exclusion for broker %d", brokerId));
            }
            this.exclusionById.put(brokerId, new AlterBrokerReplicaExclusionsRequestData.BrokerExclusion().setBrokerId(brokerId).setExclusionOperationCode(operation.opType().id()).setReason(operation.reason()));
            return this;
        }

        @Override
        public AlterBrokerReplicaExclusionsRequest build(short version) {
            if (this.exclusionById.isEmpty()) {
                throw new IllegalArgumentException("Cannot create a request without any exclusions.");
            }
            return new AlterBrokerReplicaExclusionsRequest(new AlterBrokerReplicaExclusionsRequestData().setBrokersToExclude(new ArrayList<AlterBrokerReplicaExclusionsRequestData.BrokerExclusion>(this.exclusionById.values())), version);
        }
    }
}

