/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics.utils;

import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.stats.Meter;

public final class MetricUtils {
    public static Meter createMeter(Metrics metrics, String groupName, Map<String, String> metricTags, String baseName, String descriptiveName) {
        MetricName rateMetricName = MetricUtils.rateMetricName(metrics, groupName, metricTags, baseName, descriptiveName);
        MetricName totalMetricName = MetricUtils.totalMetricName(metrics, groupName, metricTags, baseName, descriptiveName);
        return new Meter(rateMetricName, totalMetricName);
    }

    public static MetricName rateMetricName(Metrics metrics, String groupName, Map<String, String> metricTags, String baseName, String descriptiveName) {
        return metrics.metricName(baseName + "-rate", groupName, String.format("The number of %s per second", descriptiveName), metricTags);
    }

    public static MetricName totalMetricName(Metrics metrics, String groupName, Map<String, String> metricTags, String baseName, String descriptiveName) {
        return metrics.metricName(baseName + "-total", groupName, String.format("The total number of %s", descriptiveName), metricTags);
    }
}

