/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.remote.config.poller.kubernetes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import io.confluent.remote.config.poller.PollingRemoteConfigurationSource;
import io.confluent.remote.config.poller.kubernetes.ConfigSet;
import io.confluent.remote.config.poller.kubernetes.KubernetesConfigMapRemoteConfigurationConfig;
import io.confluent.remote.config.poller.kubernetes.V1ConfigMap;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.kafka.common.security.oauthbearer.internals.secured.Retryable;
import org.apache.kafka.common.security.oauthbearer.internals.secured.UnretryableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesConfigMapRemoteConfigurationSource<T>
extends PollingRemoteConfigurationSource<T>
implements Retryable<T> {
    private static final Logger log = LoggerFactory.getLogger(KubernetesConfigMapRemoteConfigurationSource.class);
    private static final String KUBERNETES_SERVICE_HOST_ENV_VAR = "KUBERNETES_SERVICE_HOST";
    private static final String KUBERNETES_SERVICE_PORT_ENV_VAR = "KUBERNETES_SERVICE_PORT";
    private static final String SERVICE_ACCOUNT_TOKEN_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    private static final String CERTIFICATE_AUTHORITY = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    private static final ThreadLocal<ObjectMapper> OBJECT_MAPPER = ThreadLocal.withInitial(() -> new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES, true).configure(DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES, true));
    private final String schemaVersion;
    private String latestResourceVersion;
    private final List<URL> endpoints;
    private final SSLSocketFactory sslSocketFactory;
    private String serviceAccountToken;

    public KubernetesConfigMapRemoteConfigurationSource(KubernetesConfigMapRemoteConfigurationConfig config, Optional<String> physicalClusterId, Consumer<T> callback, Class<T> typeParameterClass) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        super(config.getRefreshIntervalMs(), callback, typeParameterClass);
        ArrayList<URL> endpoints = new ArrayList<URL>();
        if (physicalClusterId.isPresent()) {
            endpoints.add(new URL(KubernetesConfigMapRemoteConfigurationSource.createEndpointFromEnv(config, physicalClusterId.get())));
        }
        endpoints.add(new URL(KubernetesConfigMapRemoteConfigurationSource.createDefaultEndpointFromEnv(config)));
        this.endpoints = endpoints;
        this.sslSocketFactory = KubernetesConfigMapRemoteConfigurationSource.buildSSLSocketFactory();
        this.serviceAccountToken = KubernetesConfigMapRemoteConfigurationSource.getKubeServiceAccountToken();
        this.schemaVersion = config.getSchemaVersion();
    }

    @VisibleForTesting
    KubernetesConfigMapRemoteConfigurationSource(KubernetesConfigMapRemoteConfigurationConfig config, List<URL> endpoints, Consumer<T> callback, Class<T> typeParameterClass) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        super(config.getRefreshIntervalMs(), callback, typeParameterClass);
        this.endpoints = endpoints;
        this.sslSocketFactory = KubernetesConfigMapRemoteConfigurationSource.buildSSLSocketFactory();
        this.serviceAccountToken = KubernetesConfigMapRemoteConfigurationSource.getKubeServiceAccountToken();
        this.schemaVersion = config.getSchemaVersion();
    }

    @VisibleForTesting
    static SSLSocketFactory buildSSLSocketFactory() throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        try (BufferedInputStream caInput = new BufferedInputStream(Files.newInputStream(Paths.get(CERTIFICATE_AUTHORITY, new String[0]), new OpenOption[0]));){
            CertificateFactory ca = CertificateFactory.getInstance("X.509");
            int certificateNumber = 0;
            while (((InputStream)caInput).available() > 0) {
                keyStore.setCertificateEntry("ca" + certificateNumber, ca.generateCertificate(caInput));
                ++certificateNumber;
            }
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, tmf.getTrustManagers(), null);
        return context.getSocketFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Optional<T> requestConfig() {
        Iterator<URL> iterator = this.endpoints.iterator();
        block25: while (iterator.hasNext()) {
            URL endpoint = iterator.next();
            try {
                Throwable throwable;
                InputStream is;
                HttpURLConnection connection = (HttpURLConnection)endpoint.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Authorization", "Bearer " + this.serviceAccountToken);
                ((HttpsURLConnection)connection).setSSLSocketFactory(this.sslSocketFactory);
                int responseCode = connection.getResponseCode();
                switch (responseCode) {
                    case 404: {
                        log.warn("Unable to find the configmap resource at the endpoint {}. Will retry in the next attempt", (Object)endpoint);
                        continue block25;
                    }
                    case 200: {
                        is = connection.getInputStream();
                        throwable = null;
                        try {
                            Optional<T> optional = this.validateConfigResponse((V1ConfigMap)KubernetesConfigMapRemoteConfigurationSource.getObjectMapper().readValue(is, V1ConfigMap.class));
                            return optional;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (is != null) {
                                if (throwable != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                        }
                    }
                    case 401: {
                        this.serviceAccountToken = KubernetesConfigMapRemoteConfigurationSource.getKubeServiceAccountToken();
                        log.warn("Auth denied for ConfigMap. Refreshing service account token.");
                        return Optional.empty();
                    }
                }
                is = connection.getErrorStream();
                throwable = null;
                try {
                    log.error("Error querying for ConfigMap. Status code: {} with body: {}", (Object)responseCode, (Object)new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n")));
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException e) {
                log.error("Error configuring connection to Kube API Server: " + e);
            }
        }
        return Optional.empty();
    }

    public T call() throws ExecutionException, UnretryableException {
        Object currentConfig = this.getConfig();
        if (Objects.nonNull(currentConfig)) {
            return currentConfig;
        }
        throw new ExecutionException(new IllegalStateException("No config found"));
    }

    private Optional<T> validateConfigResponse(V1ConfigMap configMap) {
        if (configMap != null && configMap.getMetadata() != null && configMap.getMetadata().getResourceVersion() != null) {
            if (this.latestResourceVersion == null || !Objects.equals(configMap.getMetadata().getResourceVersion(), this.latestResourceVersion)) {
                try {
                    Optional config = ConfigSet.parseConfigYaml(Objects.requireNonNull(configMap.getData()).get("configs")).getCompatibleConfigVersion(this.schemaVersion, this.typeParameterClass);
                    this.latestResourceVersion = configMap.getMetadata().getResourceVersion();
                    log.info("Propagating configmap: " + configMap.getMetadata().getName());
                    return config;
                }
                catch (JsonProcessingException e) {
                    log.error("Can't parse configmap yaml", (Throwable)e);
                    return Optional.empty();
                }
            }
            log.debug("No change in the configmap resource version. Skipping the config update");
        } else {
            log.warn("ConfigMap is null or doesn't have a resource version");
        }
        return Optional.empty();
    }

    public static String createEndpointFromEnv(KubernetesConfigMapRemoteConfigurationConfig config, String configMapName) {
        String path = "/api/v1/namespaces/" + config.getNamespace() + "/configmaps/" + configMapName;
        String kubeServiceHost = System.getenv(KUBERNETES_SERVICE_HOST_ENV_VAR);
        String endpoint = Objects.isNull(kubeServiceHost) || kubeServiceHost.isEmpty() ? "https://kubernetes.default.svc" + path : "https://" + kubeServiceHost + ":" + System.getenv(KUBERNETES_SERVICE_PORT_ENV_VAR) + path;
        log.info("Remote Configmap endpoint: {} configured with the name: {}", (Object)endpoint, (Object)configMapName);
        return endpoint;
    }

    public static String createDefaultEndpointFromEnv(KubernetesConfigMapRemoteConfigurationConfig config) {
        return KubernetesConfigMapRemoteConfigurationSource.createEndpointFromEnv(config, config.getConfigMapNameConfig());
    }

    @VisibleForTesting
    static String getKubeServiceAccountToken() throws IOException {
        return new String(Files.readAllBytes(Paths.get(SERVICE_ACCOUNT_TOKEN_PATH, new String[0])));
    }

    @VisibleForTesting
    void setLatestResourceVersion(String resourceVersion) {
        this.latestResourceVersion = resourceVersion;
    }

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER.get();
    }
}

