/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.coordinator.group.CoordinatorRecord;
import org.apache.kafka.coordinator.group.OffsetAndMetadata;
import org.apache.kafka.coordinator.group.classic.ClassicGroup;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupPartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupPartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.modern.TopicMetadata;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupMember;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;

public class CoordinatorRecordHelpers {
    private CoordinatorRecordHelpers() {
    }

    public static CoordinatorRecord newConsumerGroupMemberSubscriptionRecord(String groupId, ConsumerGroupMember member) {
        ArrayList<String> topicNames = new ArrayList<String>(member.subscribedTopicNames());
        Collections.sort(topicNames);
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMemberMetadataKey().setGroupId(groupId).setMemberId(member.memberId()), 5), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMemberMetadataValue().setRackId(member.rackId()).setInstanceId(member.instanceId()).setClientId(member.clientId()).setClientHost(member.clientHost()).setSubscribedTopicNames(topicNames).setSubscribedTopicRegex(member.subscribedTopicRegex()).setServerAssignor(member.serverAssignorName().orElse(null)).setRebalanceTimeoutMs(member.rebalanceTimeoutMs()).setClassicMemberMetadata(member.classicMemberMetadata().orElse(null)), 0));
    }

    public static CoordinatorRecord newConsumerGroupMemberSubscriptionTombstoneRecord(String groupId, String memberId) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMemberMetadataKey().setGroupId(groupId).setMemberId(memberId), 5), null);
    }

    public static CoordinatorRecord newConsumerGroupSubscriptionMetadataRecord(String groupId, Map<String, TopicMetadata> newSubscriptionMetadata) {
        ConsumerGroupPartitionMetadataValue value = new ConsumerGroupPartitionMetadataValue();
        newSubscriptionMetadata.forEach((topicName, topicMetadata) -> {
            ArrayList<ConsumerGroupPartitionMetadataValue.PartitionMetadata> partitionMetadata = new ArrayList<ConsumerGroupPartitionMetadataValue.PartitionMetadata>();
            if (!topicMetadata.partitionRacks().isEmpty()) {
                topicMetadata.partitionRacks().forEach((partition, racks) -> partitionMetadata.add(new ConsumerGroupPartitionMetadataValue.PartitionMetadata().setPartition((int)partition).setRacks(new ArrayList<String>((Collection<String>)racks))));
            }
            value.topics().add(new ConsumerGroupPartitionMetadataValue.TopicMetadata().setTopicId(topicMetadata.id()).setTopicName(topicMetadata.name()).setNumPartitions(topicMetadata.numPartitions()).setPartitionMetadata(partitionMetadata));
        });
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupPartitionMetadataKey().setGroupId(groupId), 4), new ApiMessageAndVersion((ApiMessage)value, 0));
    }

    public static CoordinatorRecord newConsumerGroupSubscriptionMetadataTombstoneRecord(String groupId) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupPartitionMetadataKey().setGroupId(groupId), 4), null);
    }

    public static CoordinatorRecord newConsumerGroupEpochRecord(String groupId, int newGroupEpoch) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId(groupId), 3), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(newGroupEpoch), 0));
    }

    public static CoordinatorRecord newConsumerGroupEpochTombstoneRecord(String groupId) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId(groupId), 3), null);
    }

    public static CoordinatorRecord newConsumerGroupTargetAssignmentRecord(String groupId, String memberId, Map<Uuid, Set<Integer>> partitions) {
        ArrayList<ConsumerGroupTargetAssignmentMemberValue.TopicPartition> topicPartitions = new ArrayList<ConsumerGroupTargetAssignmentMemberValue.TopicPartition>(partitions.size());
        for (Map.Entry<Uuid, Set<Integer>> entry : partitions.entrySet()) {
            topicPartitions.add(new ConsumerGroupTargetAssignmentMemberValue.TopicPartition().setTopicId(entry.getKey()).setPartitions(new ArrayList<Integer>((Collection)entry.getValue())));
        }
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMemberKey().setGroupId(groupId).setMemberId(memberId), 7), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMemberValue().setTopicPartitions(topicPartitions), 0));
    }

    public static CoordinatorRecord newConsumerGroupTargetAssignmentTombstoneRecord(String groupId, String memberId) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMemberKey().setGroupId(groupId).setMemberId(memberId), 7), null);
    }

    public static CoordinatorRecord newConsumerGroupTargetAssignmentEpochRecord(String groupId, int assignmentEpoch) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMetadataKey().setGroupId(groupId), 6), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMetadataValue().setAssignmentEpoch(assignmentEpoch), 0));
    }

    public static CoordinatorRecord newConsumerGroupTargetAssignmentEpochTombstoneRecord(String groupId) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMetadataKey().setGroupId(groupId), 6), null);
    }

    public static CoordinatorRecord newConsumerGroupCurrentAssignmentRecord(String groupId, ConsumerGroupMember member) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupCurrentMemberAssignmentKey().setGroupId(groupId).setMemberId(member.memberId()), 8), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupCurrentMemberAssignmentValue().setMemberEpoch(member.memberEpoch()).setPreviousMemberEpoch(member.previousMemberEpoch()).setState(member.state().value()).setAssignedPartitions(CoordinatorRecordHelpers.toTopicPartitions(member.assignedPartitions())).setPartitionsPendingRevocation(CoordinatorRecordHelpers.toTopicPartitions(member.partitionsPendingRevocation())), 0));
    }

    public static CoordinatorRecord newConsumerGroupCurrentAssignmentRecord(String groupId, ShareGroupMember member) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupCurrentMemberAssignmentKey().setGroupId(groupId).setMemberId(member.memberId()), 8), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupCurrentMemberAssignmentValue().setMemberEpoch(member.memberEpoch()).setPreviousMemberEpoch(member.previousMemberEpoch()).setState(member.state().value()).setAssignedPartitions(CoordinatorRecordHelpers.toTopicPartitions(member.assignedPartitions())), 0));
    }

    public static CoordinatorRecord newConsumerGroupCurrentAssignmentTombstoneRecord(String groupId, String memberId) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupCurrentMemberAssignmentKey().setGroupId(groupId).setMemberId(memberId), 8), null);
    }

    public static CoordinatorRecord newGroupMetadataRecord(ClassicGroup group, Map<String, byte[]> assignment, MetadataVersion metadataVersion) {
        ArrayList<GroupMetadataValue.MemberMetadata> members = new ArrayList<GroupMetadataValue.MemberMetadata>(group.allMembers().size());
        group.allMembers().forEach(member -> {
            byte[] subscription = group.protocolName().map(member::metadata).orElse(null);
            if (subscription == null) {
                throw new IllegalStateException("Attempted to write non-empty group metadata with no defined protocol.");
            }
            byte[] memberAssignment = (byte[])assignment.get(member.memberId());
            if (memberAssignment == null) {
                throw new IllegalStateException("Attempted to write member " + member.memberId() + " of group " + group.groupId() + " with no assignment.");
            }
            members.add(new GroupMetadataValue.MemberMetadata().setMemberId(member.memberId()).setClientId(member.clientId()).setClientHost(member.clientHost()).setRebalanceTimeout(member.rebalanceTimeoutMs()).setSessionTimeout(member.sessionTimeoutMs()).setGroupInstanceId(member.groupInstanceId().orElse(null)).setSubscription(subscription).setAssignment(memberAssignment));
        });
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new GroupMetadataKey().setGroup(group.groupId()), 2), new ApiMessageAndVersion((ApiMessage)new GroupMetadataValue().setProtocol(group.protocolName().orElse(null)).setProtocolType(group.protocolType().orElse("")).setGeneration(group.generationId()).setLeader(group.leaderOrNull()).setCurrentStateTimestamp(group.currentStateTimestampOrDefault()).setMembers(members), metadataVersion.groupMetadataValueVersion()));
    }

    public static CoordinatorRecord newGroupMetadataTombstoneRecord(String groupId) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new GroupMetadataKey().setGroup(groupId), 2), null);
    }

    public static CoordinatorRecord newEmptyGroupMetadataRecord(ClassicGroup group, MetadataVersion metadataVersion) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new GroupMetadataKey().setGroup(group.groupId()), 2), new ApiMessageAndVersion((ApiMessage)new GroupMetadataValue().setProtocol(null).setProtocolType("").setGeneration(0).setLeader(null).setCurrentStateTimestamp(group.currentStateTimestampOrDefault()).setMembers(Collections.emptyList()), metadataVersion.groupMetadataValueVersion()));
    }

    public static CoordinatorRecord newOffsetCommitRecord(String groupId, String topic, int partitionId, OffsetAndMetadata offsetAndMetadata, MetadataVersion metadataVersion) {
        short version = metadataVersion.offsetCommitValueVersion(offsetAndMetadata.expireTimestampMs.isPresent());
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new OffsetCommitKey().setGroup(groupId).setTopic(topic).setPartition(partitionId), 1), new ApiMessageAndVersion((ApiMessage)new OffsetCommitValue().setOffset(offsetAndMetadata.committedOffset).setLeaderEpoch(offsetAndMetadata.leaderEpoch.orElse(-1)).setMetadata(offsetAndMetadata.metadata).setCommitTimestamp(offsetAndMetadata.commitTimestampMs).setExpireTimestamp(offsetAndMetadata.expireTimestampMs.orElse(-1L)), version));
    }

    public static CoordinatorRecord newOffsetCommitTombstoneRecord(String groupId, String topic, int partitionId) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new OffsetCommitKey().setGroup(groupId).setTopic(topic).setPartition(partitionId), 1), null);
    }

    public static CoordinatorRecord newShareGroupMemberSubscriptionRecord(String groupId, ShareGroupMember member) {
        ArrayList<String> topicNames = new ArrayList<String>(member.subscribedTopicNames());
        Collections.sort(topicNames);
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ShareGroupMemberMetadataKey().setGroupId(groupId).setMemberId(member.memberId()), 10), new ApiMessageAndVersion((ApiMessage)new ShareGroupMemberMetadataValue().setRackId(member.rackId()).setClientId(member.clientId()).setClientHost(member.clientHost()).setSubscribedTopicNames(topicNames), 0));
    }

    public static CoordinatorRecord newShareGroupMemberSubscriptionTombstoneRecord(String groupId, String memberId) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ShareGroupMemberMetadataKey().setGroupId(groupId).setMemberId(memberId), 10), null);
    }

    public static CoordinatorRecord newShareGroupSubscriptionMetadataRecord(String groupId, Map<String, TopicMetadata> newSubscriptionMetadata) {
        ShareGroupPartitionMetadataValue value = new ShareGroupPartitionMetadataValue();
        newSubscriptionMetadata.forEach((topicName, topicMetadata) -> {
            ArrayList<ShareGroupPartitionMetadataValue.PartitionMetadata> partitionMetadata = new ArrayList<ShareGroupPartitionMetadataValue.PartitionMetadata>();
            if (!topicMetadata.partitionRacks().isEmpty()) {
                topicMetadata.partitionRacks().forEach((partition, racks) -> partitionMetadata.add(new ShareGroupPartitionMetadataValue.PartitionMetadata().setPartition((int)partition).setRacks(new ArrayList<String>((Collection<String>)racks))));
            }
            value.topics().add(new ShareGroupPartitionMetadataValue.TopicMetadata().setTopicId(topicMetadata.id()).setTopicName(topicMetadata.name()).setNumPartitions(topicMetadata.numPartitions()).setPartitionMetadata(partitionMetadata));
        });
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ShareGroupPartitionMetadataKey().setGroupId(groupId), 9), new ApiMessageAndVersion((ApiMessage)value, 0));
    }

    public static CoordinatorRecord newShareGroupSubscriptionMetadataTombstoneRecord(String groupId) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ShareGroupPartitionMetadataKey().setGroupId(groupId), 9), null);
    }

    public static CoordinatorRecord newShareGroupEpochRecord(String groupId, int newGroupEpoch) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ShareGroupMetadataKey().setGroupId(groupId), 11), new ApiMessageAndVersion((ApiMessage)new ShareGroupMetadataValue().setEpoch(newGroupEpoch), 0));
    }

    public static CoordinatorRecord newShareGroupEpochTombstoneRecord(String groupId) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ShareGroupMetadataKey().setGroupId(groupId), 11), null);
    }

    public static CoordinatorRecord newShareGroupTargetAssignmentRecord(String groupId, String memberId, Map<Uuid, Set<Integer>> partitions) {
        ArrayList<ShareGroupTargetAssignmentMemberValue.TopicPartition> topicPartitions = new ArrayList<ShareGroupTargetAssignmentMemberValue.TopicPartition>(partitions.size());
        for (Map.Entry<Uuid, Set<Integer>> entry : partitions.entrySet()) {
            topicPartitions.add(new ShareGroupTargetAssignmentMemberValue.TopicPartition().setTopicId(entry.getKey()).setPartitions(new ArrayList<Integer>((Collection)entry.getValue())));
        }
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ShareGroupTargetAssignmentMemberKey().setGroupId(groupId).setMemberId(memberId), 13), new ApiMessageAndVersion((ApiMessage)new ShareGroupTargetAssignmentMemberValue().setTopicPartitions(topicPartitions), 0));
    }

    public static CoordinatorRecord newShareGroupTargetAssignmentTombstoneRecord(String groupId, String memberId) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ShareGroupTargetAssignmentMemberKey().setGroupId(groupId).setMemberId(memberId), 13), null);
    }

    public static CoordinatorRecord newShareGroupTargetAssignmentEpochRecord(String groupId, int assignmentEpoch) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ShareGroupTargetAssignmentMetadataKey().setGroupId(groupId), 12), new ApiMessageAndVersion((ApiMessage)new ShareGroupTargetAssignmentMetadataValue().setAssignmentEpoch(assignmentEpoch), 0));
    }

    public static CoordinatorRecord newShareGroupTargetAssignmentEpochTombstoneRecord(String groupId) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ShareGroupTargetAssignmentMetadataKey().setGroupId(groupId), 12), null);
    }

    public static CoordinatorRecord newShareGroupCurrentAssignmentRecord(String groupId, ShareGroupMember member) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ShareGroupCurrentMemberAssignmentKey().setGroupId(groupId).setMemberId(member.memberId()), 14), new ApiMessageAndVersion((ApiMessage)new ShareGroupCurrentMemberAssignmentValue().setMemberEpoch(member.memberEpoch()).setPreviousMemberEpoch(member.previousMemberEpoch()).setState(member.state().value()).setAssignedPartitions(CoordinatorRecordHelpers.toShareGroupTopicPartitions(member.assignedPartitions())), 0));
    }

    public static CoordinatorRecord newShareGroupCurrentAssignmentTombstoneRecord(String groupId, String memberId) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ShareGroupCurrentMemberAssignmentKey().setGroupId(groupId).setMemberId(memberId), 14), null);
    }

    private static List<ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions> toTopicPartitions(Map<Uuid, Set<Integer>> topicPartitions) {
        ArrayList<ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions> topics = new ArrayList<ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions>(topicPartitions.size());
        topicPartitions.forEach((topicId, partitions) -> topics.add(new ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions().setTopicId((Uuid)topicId).setPartitions(new ArrayList<Integer>((Collection<Integer>)partitions))));
        return topics;
    }

    private static List<ShareGroupCurrentMemberAssignmentValue.TopicPartitions> toShareGroupTopicPartitions(Map<Uuid, Set<Integer>> topicPartitions) {
        ArrayList<ShareGroupCurrentMemberAssignmentValue.TopicPartitions> topics = new ArrayList<ShareGroupCurrentMemberAssignmentValue.TopicPartitions>(topicPartitions.size());
        topicPartitions.forEach((topicId, partitions) -> topics.add(new ShareGroupCurrentMemberAssignmentValue.TopicPartitions().setTopicId((Uuid)topicId).setPartitions(new ArrayList<Integer>((Collection<Integer>)partitions))));
        return topics;
    }
}

