/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.generated;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.coordinator.group.generated.ShareGroupPartitionMetadataValue;

public class ShareGroupPartitionMetadataValueJsonConverter {
    public static ShareGroupPartitionMetadataValue read(JsonNode _node, short _version) {
        ShareGroupPartitionMetadataValue _object = new ShareGroupPartitionMetadataValue();
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("ShareGroupPartitionMetadataValue: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("ShareGroupPartitionMetadataValue expected a JSON array, but got " + _node.getNodeType());
        }
        ArrayList<ShareGroupPartitionMetadataValue.TopicMetadata> _collection = new ArrayList<ShareGroupPartitionMetadataValue.TopicMetadata>(_topicsNode.size());
        _object.topics = _collection;
        for (JsonNode _element : _topicsNode) {
            _collection.add(TopicMetadataJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(ShareGroupPartitionMetadataValue _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (ShareGroupPartitionMetadataValue.TopicMetadata _element : _object.topics) {
            _topicsArray.add(TopicMetadataJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("topics", (JsonNode)_topicsArray);
        return _node;
    }

    public static JsonNode write(ShareGroupPartitionMetadataValue _object, short _version) {
        return ShareGroupPartitionMetadataValueJsonConverter.write(_object, _version, true);
    }

    public static class TopicMetadataJsonConverter {
        public static ShareGroupPartitionMetadataValue.TopicMetadata read(JsonNode _node, short _version) {
            ShareGroupPartitionMetadataValue.TopicMetadata _object = new ShareGroupPartitionMetadataValue.TopicMetadata();
            JsonNode _topicIdNode = _node.get("topicId");
            if (_topicIdNode == null) {
                throw new RuntimeException("TopicMetadata: unable to locate field 'topicId', which is mandatory in version " + _version);
            }
            if (!_topicIdNode.isTextual()) {
                throw new RuntimeException("TopicMetadata expected a JSON string type, but got " + _node.getNodeType());
            }
            _object.topicId = Uuid.fromString((String)_topicIdNode.asText());
            JsonNode _topicNameNode = _node.get("topicName");
            if (_topicNameNode == null) {
                throw new RuntimeException("TopicMetadata: unable to locate field 'topicName', which is mandatory in version " + _version);
            }
            if (!_topicNameNode.isTextual()) {
                throw new RuntimeException("TopicMetadata expected a string type, but got " + _node.getNodeType());
            }
            _object.topicName = _topicNameNode.asText();
            JsonNode _numPartitionsNode = _node.get("numPartitions");
            if (_numPartitionsNode == null) {
                throw new RuntimeException("TopicMetadata: unable to locate field 'numPartitions', which is mandatory in version " + _version);
            }
            _object.numPartitions = MessageUtil.jsonNodeToInt((JsonNode)_numPartitionsNode, (String)"TopicMetadata");
            JsonNode _partitionMetadataNode = _node.get("partitionMetadata");
            if (_partitionMetadataNode == null) {
                throw new RuntimeException("TopicMetadata: unable to locate field 'partitionMetadata', which is mandatory in version " + _version);
            }
            if (!_partitionMetadataNode.isArray()) {
                throw new RuntimeException("TopicMetadata expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<ShareGroupPartitionMetadataValue.PartitionMetadata> _collection = new ArrayList<ShareGroupPartitionMetadataValue.PartitionMetadata>(_partitionMetadataNode.size());
            _object.partitionMetadata = _collection;
            for (JsonNode _element : _partitionMetadataNode) {
                _collection.add(PartitionMetadataJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(ShareGroupPartitionMetadataValue.TopicMetadata _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
            _node.set("topicName", (JsonNode)new TextNode(_object.topicName));
            _node.set("numPartitions", (JsonNode)new IntNode(_object.numPartitions));
            ArrayNode _partitionMetadataArray = new ArrayNode(JsonNodeFactory.instance);
            for (ShareGroupPartitionMetadataValue.PartitionMetadata _element : _object.partitionMetadata) {
                _partitionMetadataArray.add(PartitionMetadataJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("partitionMetadata", (JsonNode)_partitionMetadataArray);
            return _node;
        }

        public static JsonNode write(ShareGroupPartitionMetadataValue.TopicMetadata _object, short _version) {
            return TopicMetadataJsonConverter.write(_object, _version, true);
        }
    }

    public static class PartitionMetadataJsonConverter {
        public static ShareGroupPartitionMetadataValue.PartitionMetadata read(JsonNode _node, short _version) {
            ShareGroupPartitionMetadataValue.PartitionMetadata _object = new ShareGroupPartitionMetadataValue.PartitionMetadata();
            JsonNode _partitionNode = _node.get("partition");
            if (_partitionNode == null) {
                throw new RuntimeException("PartitionMetadata: unable to locate field 'partition', which is mandatory in version " + _version);
            }
            _object.partition = MessageUtil.jsonNodeToInt((JsonNode)_partitionNode, (String)"PartitionMetadata");
            JsonNode _racksNode = _node.get("racks");
            if (_racksNode == null) {
                throw new RuntimeException("PartitionMetadata: unable to locate field 'racks', which is mandatory in version " + _version);
            }
            if (!_racksNode.isArray()) {
                throw new RuntimeException("PartitionMetadata expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<String> _collection = new ArrayList<String>(_racksNode.size());
            _object.racks = _collection;
            for (JsonNode _element : _racksNode) {
                if (!_element.isTextual()) {
                    throw new RuntimeException("PartitionMetadata element expected a string type, but got " + _node.getNodeType());
                }
                _collection.add(_element.asText());
            }
            return _object;
        }

        public static JsonNode write(ShareGroupPartitionMetadataValue.PartitionMetadata _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partition", (JsonNode)new IntNode(_object.partition));
            ArrayNode _racksArray = new ArrayNode(JsonNodeFactory.instance);
            for (String _element : _object.racks) {
                _racksArray.add((JsonNode)new TextNode(_element));
            }
            _node.set("racks", (JsonNode)_racksArray);
            return _node;
        }

        public static JsonNode write(ShareGroupPartitionMetadataValue.PartitionMetadata _object, short _version) {
            return PartitionMetadataJsonConverter.write(_object, _version, true);
        }
    }
}

