/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature.internal;

import com.google.crypto.tink.AccessesPartialKey;
import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.config.internal.TinkFipsUtil;
import com.google.crypto.tink.internal.ConscryptUtil;
import com.google.crypto.tink.internal.Util;
import com.google.crypto.tink.signature.RsaSsaPkcs1Parameters;
import com.google.crypto.tink.signature.RsaSsaPkcs1PublicKey;
import com.google.crypto.tink.subtle.Validators;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import javax.annotation.Nullable;

@Immutable
public final class RsaSsaPkcs1VerifyConscrypt
implements PublicKeyVerify {
    public static final TinkFipsUtil.AlgorithmFipsCompatibility FIPS = TinkFipsUtil.AlgorithmFipsCompatibility.ALGORITHM_REQUIRES_BORINGCRYPTO;
    private static final byte[] EMPTY = new byte[0];
    private static final byte[] LEGACY_MESSAGE_SUFFIX = new byte[]{0};
    private static final Provider PROVIDER = RsaSsaPkcs1VerifyConscrypt.conscryptProviderOrNull();
    private final RSAPublicKey publicKey;
    private final String signatureAlgorithm;
    private final byte[] outputPrefix;
    private final byte[] messageSuffix;

    @Nullable
    private static Provider conscryptProviderOrNull() {
        if (Util.isAndroid() && Util.getAndroidApiLevel() <= 21) {
            return null;
        }
        return ConscryptUtil.providerOrNull();
    }

    public static boolean isSupported() {
        return PROVIDER != null;
    }

    private static Signature getSignature(String algorithm) throws GeneralSecurityException {
        if (PROVIDER == null) {
            throw new GeneralSecurityException("Conscrypt Provider not found");
        }
        return Signature.getInstance(algorithm, PROVIDER);
    }

    public static String toRsaSsaPkcs1Algo(RsaSsaPkcs1Parameters.HashType hashType) throws GeneralSecurityException {
        if (hashType == RsaSsaPkcs1Parameters.HashType.SHA256) {
            return "SHA256withRSA";
        }
        if (hashType == RsaSsaPkcs1Parameters.HashType.SHA384) {
            return "SHA384withRSA";
        }
        if (hashType == RsaSsaPkcs1Parameters.HashType.SHA512) {
            return "SHA512withRSA";
        }
        throw new GeneralSecurityException("unknown hash type");
    }

    @AccessesPartialKey
    public static PublicKeyVerify create(RsaSsaPkcs1PublicKey key) throws GeneralSecurityException {
        if (!RsaSsaPkcs1VerifyConscrypt.isSupported()) {
            throw new GeneralSecurityException("RSA-PKCS1.5 using Conscrypt is not supported.");
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", PROVIDER);
        RSAPublicKey publicKey = (RSAPublicKey)keyFactory.generatePublic(new RSAPublicKeySpec(key.getModulus(), key.getParameters().getPublicExponent()));
        return new RsaSsaPkcs1VerifyConscrypt(publicKey, key.getParameters().getHashType(), key.getOutputPrefix().toByteArray(), key.getParameters().getVariant().equals(RsaSsaPkcs1Parameters.Variant.LEGACY) ? LEGACY_MESSAGE_SUFFIX : EMPTY);
    }

    private RsaSsaPkcs1VerifyConscrypt(RSAPublicKey pubKey, RsaSsaPkcs1Parameters.HashType hashType, byte[] outputPrefix, byte[] messageSuffix) throws GeneralSecurityException {
        if (!FIPS.isCompatible()) {
            throw new GeneralSecurityException("Can not use RSA-PKCS1.5 in FIPS-mode, as BoringCrypto module is not available.");
        }
        Validators.validateRsaModulusSize(pubKey.getModulus().bitLength());
        Validators.validateRsaPublicExponent(pubKey.getPublicExponent());
        this.publicKey = pubKey;
        this.signatureAlgorithm = RsaSsaPkcs1VerifyConscrypt.toRsaSsaPkcs1Algo(hashType);
        this.outputPrefix = outputPrefix;
        this.messageSuffix = messageSuffix;
    }

    @Override
    public void verify(byte[] signature, byte[] data) throws GeneralSecurityException {
        if (!Util.isPrefix(this.outputPrefix, signature)) {
            throw new GeneralSecurityException("Invalid signature (output prefix mismatch)");
        }
        Signature verifier = RsaSsaPkcs1VerifyConscrypt.getSignature(this.signatureAlgorithm);
        verifier.initVerify(this.publicKey);
        verifier.update(data);
        if (this.messageSuffix.length > 0) {
            verifier.update(this.messageSuffix);
        }
        boolean verified = false;
        try {
            byte[] signatureNoPrefix = Arrays.copyOfRange(signature, this.outputPrefix.length, signature.length);
            verified = verifier.verify(signatureNoPrefix);
        }
        catch (RuntimeException ex) {
            verified = false;
        }
        if (!verified) {
            throw new GeneralSecurityException("Invalid signature");
        }
    }
}

