/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.security;

import io.confluent.connect.security.ConnectSecurityExtensionConfig;
import io.confluent.connect.security.ConnectSecurityFilter;
import io.confluent.connect.security.ConnectorSecretConfigFilter;
import io.confluent.connect.security.permissions.PermissionsResource;
import io.confluent.connect.security.util.Version;
import io.confluent.security.auth.client.RestAuthorizer;
import io.confluent.security.authorizer.Scope;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.health.ConnectClusterState;
import org.apache.kafka.connect.rest.ConnectRestExtension;
import org.apache.kafka.connect.rest.ConnectRestExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectSecurityExtension
implements ConnectRestExtension {
    public static final String CONNECT_CLUSTER_TYPE = "connect-cluster";
    public static final String UNKNOWN_KAFKA_CLUSTER_ID = "UNKNOWN";
    private static final String InternalSecretConfigProvider_FQCN = "io.confluent.connect.secretregistry.rbac.config.provider.InternalSecretConfigProvider";
    private static final Logger log = LoggerFactory.getLogger(ConnectSecurityExtension.class);
    private ConnectSecurityExtensionConfig config;
    private RestAuthorizer restAuthorizer;

    public void configure(Map<String, ?> configs) {
        this.config = new ConnectSecurityExtensionConfig(configs);
    }

    public void register(ConnectRestExtensionContext restExtensionContext) {
        Scope scope = ConnectSecurityExtension.scope(this.config.connectClusterId(), restExtensionContext.clusterState());
        log.info("Registering RBAC authorizer on cluster with scope '{}'", (Object)scope);
        this.restAuthorizer = new RestAuthorizer();
        this.restAuthorizer.configure(this.config.originals());
        ConnectSecurityFilter connectSecurityFilter = new ConnectSecurityFilter(this.config, scope, this.restAuthorizer, restExtensionContext.clusterState());
        PermissionsResource permissionsResource = new PermissionsResource(scope, this.restAuthorizer, restExtensionContext.clusterState());
        String secretProviderName = this.secretProviderName();
        if (secretProviderName != null) {
            ConnectorSecretConfigFilter connectorSecretConfigFilter = new ConnectorSecretConfigFilter(secretProviderName);
            restExtensionContext.configurable().register((Object)connectorSecretConfigFilter);
        }
        restExtensionContext.configurable().register((Object)connectSecurityFilter);
        restExtensionContext.configurable().register((Object)permissionsResource);
    }

    public void close() {
        if (this.restAuthorizer != null) {
            try {
                this.restAuthorizer.close();
            }
            catch (IOException e) {
                log.error("Error while closing REST authorizer", (Throwable)e);
            }
            finally {
                this.restAuthorizer = null;
            }
        }
    }

    public String version() {
        return Version.getVersion();
    }

    private String secretProviderName() {
        List<String> configProviders = this.config.configProviders();
        for (String configProvider : configProviders) {
            String providerClassConfig = String.format("%s.%s.class", "config.providers", configProvider);
            String providerClass = this.config.originals().get(providerClassConfig).toString();
            if (!InternalSecretConfigProvider_FQCN.equals(providerClass)) continue;
            return configProvider;
        }
        return null;
    }

    private static Scope scope(String connectClusterId, ConnectClusterState clusterState) {
        String kafkaClusterId = clusterState.clusterDetails().kafkaClusterId();
        if (kafkaClusterId == null) {
            kafkaClusterId = UNKNOWN_KAFKA_CLUSTER_ID;
        }
        return new Scope.Builder(new String[0]).withKafkaCluster(kafkaClusterId).withCluster(CONNECT_CLUSTER_TYPE, connectClusterId).build();
    }
}

