/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.security;

import io.confluent.common.security.util.AuthorizerUtils;
import io.confluent.common.security.util.StreamUtils;
import io.confluent.connect.security.ConnectSecurityExtensionConfig;
import io.confluent.connect.security.config.manipulation.ConfigManipulator;
import io.confluent.connect.security.config.manipulation.ConfigManipulators;
import io.confluent.connect.security.config.manipulation.RbacBasicCredentialsManipulator;
import io.confluent.connect.security.rbac.ConnectActions;
import io.confluent.connect.security.rbac.ConnectorOperations;
import io.confluent.connect.security.util.ConnectRestApiMethods;
import io.confluent.connect.security.util.ConnectRestUtils;
import io.confluent.security.auth.client.RestAuthorizer;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.AuthorizeResult;
import io.confluent.security.authorizer.Scope;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.connect.health.ConnectClusterState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectSecurityFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(ConnectSecurityFilter.class);
    @Context
    private ResourceInfo resourceInfo;
    private final Scope scope;
    private final ConnectActions actions;
    private final RestAuthorizer restAuthorizer;
    private final ConfigManipulators configManipulators;

    public ConnectSecurityFilter(ConnectSecurityExtensionConfig config, Scope scope, RestAuthorizer restAuthorizer, ConnectClusterState clusterState) {
        this(config, scope, ConnectActions.build(scope, clusterState), restAuthorizer, null);
    }

    ConnectSecurityFilter(ConnectSecurityExtensionConfig config, Scope scope, ConnectActions actions, RestAuthorizer restAuthorizer, ResourceInfo resourceInfo) {
        this.scope = scope;
        this.restAuthorizer = restAuthorizer;
        this.actions = actions;
        this.resourceInfo = resourceInfo;
        this.configManipulators = config.shouldInjectRbacCredentials() ? new ConfigManipulators(new RbacBasicCredentialsManipulator(config)) : new ConfigManipulators(new ConfigManipulator[0]);
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!this.authorizeRequest(requestContext)) {
            return;
        }
        this.configManipulators.transformRequest(this.resourceInfo, requestContext);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        int status = responseContext.getStatus();
        if (status >= 300 || status < 200) {
            return;
        }
        if (ConnectRestApiMethods.LIST_CONNECTORS.equals(this.resourceInfo.getResourceMethod())) {
            this.filterListedConnectors(requestContext, responseContext);
        }
        this.configManipulators.transformResponse(this.resourceInfo, responseContext);
    }

    boolean authorizeRequest(ContainerRequestContext requestContext) throws IOException {
        Method resourceMethod = this.resourceInfo.getResourceMethod();
        List<Action> actions = this.actions.actions(resourceMethod, requestContext);
        if (!actions.isEmpty()) {
            Principal requestPrincipal = requestContext.getSecurityContext().getUserPrincipal();
            if (requestPrincipal == null) {
                ConnectRestUtils.abortRequest(requestContext, Response.Status.UNAUTHORIZED, "User not authenticated");
                return false;
            }
            KafkaPrincipal userPrincipal = AuthorizerUtils.kafkaPrincipalFor((Principal)requestPrincipal);
            log.debug("Authorizing request for principal {}. Actions: {}", (Object)userPrincipal, actions);
            List authorizations = this.restAuthorizer.authorize(userPrincipal, null, actions);
            if (!authorizations.stream().allMatch(arg_0 -> AuthorizeResult.ALLOWED.equals(arg_0))) {
                ConnectRestUtils.abortRequest(requestContext, Response.Status.FORBIDDEN, "Unauthorized operation");
                return false;
            }
        }
        return true;
    }

    private void filterListedConnectors(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        Object response = ConnectRestUtils.responseEntity(responseContext);
        Principal principal = requestContext.getSecurityContext().getUserPrincipal();
        try {
            if (response instanceof Collection) {
                Collection allConnectors = (Collection)response;
                if (allConnectors.isEmpty()) {
                    return;
                }
                Collection newEntity = this.allActionsForConnectors(allConnectors, principal).filter((? super T aa) -> AuthorizeResult.ALLOWED.equals((Object)aa.authorizeResult)).map(aa -> aa.action).map(Action::resourceName).collect(Collectors.toSet());
                responseContext.setEntity((Object)newEntity);
            } else if (response instanceof Map) {
                Map connectors = (Map)response;
                if (connectors.isEmpty()) {
                    return;
                }
                List authorizations = this.allActionsForConnectors(connectors.keySet(), principal).collect(Collectors.toList());
                HashMap newEntity = new HashMap();
                for (AuthorizedAction authAction : authorizations) {
                    Object info;
                    Object status;
                    if (!AuthorizeResult.ALLOWED.equals((Object)authAction.authorizeResult)) continue;
                    String connector = authAction.action.resourceName();
                    if (!newEntity.containsKey(connector)) {
                        newEntity.put(connector, new HashMap());
                    }
                    Map connectorStatusAndInfo = connectors.getOrDefault(connector, Collections.emptyMap());
                    if (ConnectorOperations.READ_STATUS.equals((Object)authAction.action.operation()) && (status = connectorStatusAndInfo.get("status")) != null) {
                        ((Map)newEntity.get(connector)).put("status", status);
                    }
                    if (!ConnectorOperations.READ_CONFIG.equals((Object)authAction.action.operation()) || (info = connectorStatusAndInfo.get("info")) == null) continue;
                    ((Map)newEntity.get(connector)).put("info", info);
                }
                responseContext.setEntity(newEntity);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ConnectRestUtils.abortRequest(requestContext, Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    private Stream<AuthorizedAction> allActionsForConnectors(Collection<String> allConnectors, Principal principal) throws Exception {
        List actions = allConnectors.stream().flatMap(connector -> ConnectorOperations.ALL.stream().map(op -> new Action(this.scope, ConnectActions.CONNECTOR_RESOURCE, connector, op))).collect(Collectors.toList());
        List authorizations = this.restAuthorizer.authorize(AuthorizerUtils.kafkaPrincipalFor((Principal)principal), null, actions);
        if (authorizations.size() != actions.size()) {
            throw new Exception("Invalid response size from authorization service");
        }
        return StreamUtils.zip(actions, (List)authorizations).map(pair -> new AuthorizedAction((Action)pair.getLeft(), (AuthorizeResult)pair.getRight()));
    }

    static class AuthorizedAction {
        final Action action;
        final AuthorizeResult authorizeResult;

        public AuthorizedAction(Action action, AuthorizeResult authorizeResult) {
            this.action = action;
            this.authorizeResult = authorizeResult;
        }
    }
}

