/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfluentTopicConfig;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.ConsumerGroupMigrationPolicy;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.api.assignor.ConsumerGroupPartitionAssignor;
import org.apache.kafka.coordinator.group.assignor.RangeAssignor;
import org.apache.kafka.coordinator.group.assignor.UniformAssignor;
import org.apache.kafka.metadata.TopicPlacement;

public class GroupCoordinatorConfig {
    public static final String CONFLUENT_PREFIX = "confluent.";
    public static final String GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG = "group.min.session.timeout.ms";
    public static final String GROUP_MIN_SESSION_TIMEOUT_MS_DOC = "The minimum allowed session timeout for registered consumers. Shorter timeouts result in quicker failure detection at the cost of more frequent consumer heartbeating, which can overwhelm broker resources.";
    public static final int GROUP_MIN_SESSION_TIMEOUT_MS_DEFAULT = 6000;
    public static final String GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG = "group.max.session.timeout.ms";
    public static final String GROUP_MAX_SESSION_TIMEOUT_MS_DOC = "The maximum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.";
    public static final int GROUP_MAX_SESSION_TIMEOUT_MS_DEFAULT = 1800000;
    public static final String GROUP_INITIAL_REBALANCE_DELAY_MS_CONFIG = "group.initial.rebalance.delay.ms";
    public static final String GROUP_INITIAL_REBALANCE_DELAY_MS_DOC = "The amount of time the group coordinator will wait for more consumers to join a new group before performing the first rebalance. A longer delay means potentially fewer rebalances, but increases the time until processing begins.";
    public static final int GROUP_INITIAL_REBALANCE_DELAY_MS_DEFAULT = 3000;
    public static final String GROUP_MAX_SIZE_CONFIG = "group.max.size";
    public static final String GROUP_MAX_SIZE_DOC = "The maximum number of consumers that a single consumer group can accommodate.";
    public static final int GROUP_MAX_SIZE_DEFAULT = Integer.MAX_VALUE;
    public static final String GROUP_METADATA_LOAD_THREADS_CONFIG = "confluent.group.metadata.load.threads";
    public static final String GROUP_METADATA_LOAD_THREADS_DOC = "The number of threads group metadata load / unload can use to concurrently load / unload metadata.";
    public static final int GROUP_METADATA_LOAD_THREADS_DEFAULT = 32;
    public static final String GROUP_COORDINATOR_OFFSET_WRITER_THREADS_CONFIG = "confluent.group.coordinator.offsets.writer.threads";
    public static final String GROUP_COORDINATOR_OFFSET_WRITER_THREADS_DOC = "The number of offset commit batching writer threads.";
    public static final int GROUP_COORDINATOR_OFFSET_WRITER_THREADS_DEFAULT = 2;
    public static final String GROUP_COORDINATOR_OFFSETS_BATCHING_ENABLE_CONFIG = "confluent.group.coordinator.offsets.batching.enable";
    public static final String GROUP_COORDINATOR_OFFSETS_BATCHING_ENABLE_DOC = "Enables offset commit batching in the group coordinator.";
    public static final boolean GROUP_COORDINATOR_OFFSETS_BATCHING_ENABLE_DEFAULT = false;
    public static final String GROUP_SUBSCRIPTION_PATTERN_LOG_INTERVAL_MS_CONFIG = "confluent.group.subscription.pattern.log.interval.ms";
    public static final String GROUP_SUBSCRIPTION_PATTERN_LOG_INTERVAL_MS_DOC = "The minimum interval between logging groups with heterogeneous subscription patterns. -1 disables logging.";
    public static final int GROUP_SUBSCRIPTION_PATTERN_LOG_INTERVAL_MS_DEFAULT = -1;
    public static final String NEW_GROUP_COORDINATOR_ENABLE_CONFIG = "group.coordinator.new.enable";
    public static final String NEW_GROUP_COORDINATOR_ENABLE_DOC = "Enable the new group coordinator.";
    public static final boolean NEW_GROUP_COORDINATOR_ENABLE_DEFAULT = true;
    public static final String GROUP_COORDINATOR_REBALANCE_PROTOCOLS_CONFIG = "group.coordinator.rebalance.protocols";
    public static final String GROUP_COORDINATOR_REBALANCE_PROTOCOLS_DOC = "The list of enabled rebalance protocols. Supported protocols: " + Arrays.stream(Group.GroupType.values()).map(Group.GroupType::toString).collect(Collectors.joining(",")) + ". The " + (Object)((Object)Group.GroupType.CONSUMER) + " rebalance protocol is in early access and therefore must not be used in production.";
    public static final List<String> GROUP_COORDINATOR_REBALANCE_PROTOCOLS_DEFAULT = Collections.singletonList(Group.GroupType.CLASSIC.toString());
    public static final String GROUP_COORDINATOR_APPEND_LINGER_MS_CONFIG = "group.coordinator.append.linger.ms";
    public static final String GROUP_COORDINATOR_APPEND_LINGER_MS_DOC = "The duration in milliseconds that the coordinator will wait for writes to accumulate before flushing them to disk. Transactional writes are not accumulated.";
    public static final int GROUP_COORDINATOR_APPEND_LINGER_MS_DEFAULT = 10;
    public static final String GROUP_COORDINATOR_NUM_THREADS_CONFIG = "group.coordinator.threads";
    public static final String GROUP_COORDINATOR_NUM_THREADS_DOC = "The number of threads used by the group coordinator.";
    public static final int GROUP_COORDINATOR_NUM_THREADS_DEFAULT = 1;
    public static final String CONSUMER_GROUP_SESSION_TIMEOUT_MS_CONFIG = "group.consumer.session.timeout.ms";
    public static final String CONSUMER_GROUP_SESSION_TIMEOUT_MS_DOC = "The timeout to detect client failures when using the consumer group protocol.";
    public static final int CONSUMER_GROUP_SESSION_TIMEOUT_MS_DEFAULT = 45000;
    public static final String CONSUMER_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG = "group.consumer.min.session.timeout.ms";
    public static final String CONSUMER_GROUP_MIN_SESSION_TIMEOUT_MS_DOC = "The minimum allowed session timeout for registered consumers.";
    public static final int CONSUMER_GROUP_MIN_SESSION_TIMEOUT_MS_DEFAULT = 45000;
    public static final String CONSUMER_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG = "group.consumer.max.session.timeout.ms";
    public static final String CONSUMER_GROUP_MAX_SESSION_TIMEOUT_MS_DOC = "The maximum allowed session timeout for registered consumers.";
    public static final int CONSUMER_GROUP_MAX_SESSION_TIMEOUT_MS_DEFAULT = 60000;
    public static final String CONSUMER_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG = "group.consumer.heartbeat.interval.ms";
    public static final String CONSUMER_GROUP_HEARTBEAT_INTERVAL_MS_DOC = "The heartbeat interval given to the members of a consumer group.";
    public static final int CONSUMER_GROUP_HEARTBEAT_INTERVAL_MS_DEFAULT = 5000;
    public static final String CONSUMER_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG = "group.consumer.min.heartbeat.interval.ms";
    public static final String CONSUMER_GROUP_MIN_HEARTBEAT_INTERVAL_MS_DOC = "The minimum heartbeat interval for registered consumers.";
    public static final int CONSUMER_GROUP_MIN_HEARTBEAT_INTERVAL_MS_DEFAULT = 5000;
    public static final String CONSUMER_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG = "group.consumer.max.heartbeat.interval.ms";
    public static final String CONSUMER_GROUP_MAX_HEARTBEAT_INTERVAL_MS_DOC = "The maximum heartbeat interval for registered consumers.";
    public static final int CONSUMER_GROUP_MAX_HEARTBEAT_INTERVAL_MS_DEFAULT = 15000;
    public static final String CONSUMER_GROUP_MAX_SIZE_CONFIG = "group.consumer.max.size";
    public static final String CONSUMER_GROUP_MAX_SIZE_DOC = "The maximum number of consumers that a single consumer group can accommodate. This value will only impact the new consumer coordinator. To configure the classic consumer coordinator check group.max.size instead.";
    public static final int CONSUMER_GROUP_MAX_SIZE_DEFAULT = Integer.MAX_VALUE;
    public static final String CONSUMER_GROUP_ASSIGNORS_CONFIG = "group.consumer.assignors";
    public static final String CONSUMER_GROUP_ASSIGNORS_DOC = "The server side assignors as a list of full class names. The first one in the list is considered as the default assignor to be used in the case where the consumer does not specify an assignor.";
    public static final List<String> CONSUMER_GROUP_ASSIGNORS_DEFAULT = Collections.unmodifiableList(Arrays.asList(UniformAssignor.class.getName(), RangeAssignor.class.getName()));
    public static final String CONSUMER_GROUP_MIGRATION_POLICY_CONFIG = "group.consumer.migration.policy";
    public static final String CONSUMER_GROUP_MIGRATION_POLICY_DEFAULT = ConsumerGroupMigrationPolicy.DISABLED.toString();
    public static final String CONSUMER_GROUP_MIGRATION_POLICY_DOC = "The config that enables converting the non-empty classic group using the consumer embedded protocol to the non-empty consumer group using the consumer group protocol and vice versa; conversions of empty groups in both directions are always enabled regardless of this policy. " + (Object)((Object)ConsumerGroupMigrationPolicy.BIDIRECTIONAL) + ": both upgrade from classic group to consumer group and downgrade from consumer group to classic group are enabled, " + (Object)((Object)ConsumerGroupMigrationPolicy.UPGRADE) + ": only upgrade from classic group to consumer group is enabled, " + (Object)((Object)ConsumerGroupMigrationPolicy.DOWNGRADE) + ": only downgrade from consumer group to classic group is enabled, " + (Object)((Object)ConsumerGroupMigrationPolicy.DISABLED) + ": neither upgrade nor downgrade is enabled.";
    public static final String SHARE_GROUP_MAX_SIZE_CONFIG = "group.share.max.size";
    public static final short SHARE_GROUP_MAX_SIZE_DEFAULT = 200;
    public static final String SHARE_GROUP_MAX_SIZE_DOC = "The maximum number of members that a single share group can accommodate.";
    public static final String SHARE_GROUP_SESSION_TIMEOUT_MS_CONFIG = "group.share.session.timeout.ms";
    public static final int SHARE_GROUP_SESSION_TIMEOUT_MS_DEFAULT = 45000;
    public static final String SHARE_GROUP_SESSION_TIMEOUT_MS_DOC = "The timeout to detect client failures when using the share group protocol.";
    public static final String SHARE_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG = "group.share.min.session.timeout.ms";
    public static final int SHARE_GROUP_MIN_SESSION_TIMEOUT_MS_DEFAULT = 45000;
    public static final String SHARE_GROUP_MIN_SESSION_TIMEOUT_MS_DOC = "The minimum allowed session timeout for share group members.";
    public static final String SHARE_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG = "group.share.max.session.timeout.ms";
    public static final int SHARE_GROUP_MAX_SESSION_TIMEOUT_MS_DEFAULT = 60000;
    public static final String SHARE_GROUP_MAX_SESSION_TIMEOUT_MS_DOC = "The maximum allowed session timeout for share group members.";
    public static final String SHARE_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG = "group.share.heartbeat.interval.ms";
    public static final int SHARE_GROUP_HEARTBEAT_INTERVAL_MS_DEFAULT = 5000;
    public static final String SHARE_GROUP_HEARTBEAT_INTERVAL_MS_DOC = "The heartbeat interval given to the members of a share group.";
    public static final String SHARE_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG = "group.share.min.heartbeat.interval.ms";
    public static final int SHARE_GROUP_MIN_HEARTBEAT_INTERVAL_MS_DEFAULT = 5000;
    public static final String SHARE_GROUP_MIN_HEARTBEAT_INTERVAL_MS_DOC = "The minimum heartbeat interval for share group members.";
    public static final String SHARE_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG = "group.share.max.heartbeat.interval.ms";
    public static final int SHARE_GROUP_MAX_HEARTBEAT_INTERVAL_MS_DEFAULT = 15000;
    public static final String SHARE_GROUP_MAX_HEARTBEAT_INTERVAL_MS_DOC = "The maximum heartbeat interval for share group members.";
    public static final String OFFSET_METADATA_MAX_SIZE_CONFIG = "offset.metadata.max.bytes";
    public static final int OFFSET_METADATA_MAX_SIZE_DEFAULT = 4096;
    public static final String OFFSET_METADATA_MAX_SIZE_DOC = "The maximum size for a metadata entry associated with an offset commit.";
    public static final String OFFSETS_LOAD_BUFFER_SIZE_CONFIG = "offsets.load.buffer.size";
    public static final int OFFSETS_LOAD_BUFFER_SIZE_DEFAULT = 0x500000;
    public static final String OFFSETS_LOAD_BUFFER_SIZE_DOC = "Batch size for reading from the offsets segments when loading offsets into the cache (soft-limit, overridden if records are too large).";
    public static final String OFFSETS_RETENTION_MINUTES_CONFIG = "offsets.retention.minutes";
    public static final int OFFSETS_RETENTION_MINUTES_DEFAULT = 10080;
    public static final String OFFSETS_RETENTION_MINUTES_DOC = "For subscribed consumers, committed offset of a specific partition will be expired and discarded when 1) this retention period has elapsed after the consumer group loses all its consumers (i.e. becomes empty); 2) this retention period has elapsed since the last time an offset is committed for the partition and the group is no longer subscribed to the corresponding topic. For standalone consumers (using manual assignment), offsets will be expired after this retention period has elapsed since the time of last commit. Note that when a group is deleted via the delete-group request, its committed offsets will also be deleted without extra retention period; also when a topic is deleted via the delete-topic request, upon propagated metadata update any group's committed offsets for that topic will also be deleted without extra retention period.";
    public static final String OFFSETS_RETENTION_CHECK_INTERVAL_MS_CONFIG = "offsets.retention.check.interval.ms";
    public static final long OFFSETS_RETENTION_CHECK_INTERVAL_MS_DEFAULT = 600000L;
    public static final String OFFSETS_RETENTION_CHECK_INTERVAL_MS_DOC = "Frequency at which to check for stale offsets";
    public static final String OFFSETS_TOPIC_PARTITIONS_CONFIG = "offsets.topic.num.partitions";
    public static final int OFFSETS_TOPIC_PARTITIONS_DEFAULT = 50;
    public static final String OFFSETS_TOPIC_PARTITIONS_DOC = "The number of partitions for the offset commit topic (should not change after deployment).";
    public static final String OFFSETS_TOPIC_SEGMENT_BYTES_CONFIG = "offsets.topic.segment.bytes";
    public static final int OFFSETS_TOPIC_SEGMENT_BYTES_DEFAULT = 0x6400000;
    public static final String OFFSETS_TOPIC_SEGMENT_BYTES_DOC = "The offsets topic segment bytes should be kept relatively small in order to facilitate faster log compaction and cache loads.";
    public static final String OFFSETS_TOPIC_REPLICATION_FACTOR_CONFIG = "offsets.topic.replication.factor";
    public static final short OFFSETS_TOPIC_REPLICATION_FACTOR_DEFAULT = 3;
    public static final String OFFSETS_TOPIC_REPLICATION_FACTOR_DOC = "The replication factor for the offsets topic (set higher to ensure availability). Internal topic creation will fail until the cluster size meets this replication factor requirement.";
    public static final String OFFSETS_TOPIC_COMPRESSION_CODEC_CONFIG = "offsets.topic.compression.codec";
    public static final CompressionType OFFSETS_TOPIC_COMPRESSION_CODEC_DEFAULT = CompressionType.NONE;
    public static final String OFFSETS_TOPIC_COMPRESSION_CODEC_DOC = "Compression codec for the offsets topic - compression may be used to achieve \"atomic\" commits.";
    public static final String OFFSET_COMMIT_TIMEOUT_MS_CONFIG = "offsets.commit.timeout.ms";
    public static final int OFFSET_COMMIT_TIMEOUT_MS_DEFAULT = 5000;
    public static final String OFFSET_COMMIT_TIMEOUT_MS_DOC = "Offset commit will be delayed until all replicas for the offsets topic receive the commit or this timeout is reached. This is similar to the producer request timeout.";
    @Deprecated
    public static final String OFFSET_COMMIT_REQUIRED_ACKS_CONFIG = "offsets.commit.required.acks";
    public static final short OFFSET_COMMIT_REQUIRED_ACKS_DEFAULT = -1;
    public static final String OFFSET_COMMIT_REQUIRED_ACKS_DOC = "DEPRECATED: The required acks before the commit can be accepted. In general, the default (-1) should not be overridden.";
    public static final String OFFSET_TOPIC_PLACEMENT_CONSTRAINTS_CONFIG = "confluent.offsets.topic.placement.constraints";
    public static final String OFFSET_TOPIC_PLACEMENT_CONSTRAINTS_DOC = ConfluentTopicConfig.TOPIC_PLACEMENT_CONSTRAINTS_DOC;
    public static final String OFFSET_TOPIC_PLACEMENT_CONSTRAINTS_DEFAULT = "";
    public static final String OFFSETS_LOG_CLEANER_DELETE_RETENTION_MS_CONFIG = "confluent.offsets.log.cleaner.delete.retention.ms";
    public static final String OFFSETS_LOG_CLEANER_DELETE_RETENTION_MS_DOC = "The delete retention timeout for the log cleaner compacting the __consumer_offsets topic.";
    public static final long OFFSETS_LOG_CLEANER_DELETE_RETENTION_MS_DEFAULT = 86400000L;
    public static final String OFFSETS_LOG_CLEANER_MIN_CLEANABLE_DIRTY_RATIO_CONFIG = "confluent.offsets.log.cleaner.min.cleanable.dirty.ratio";
    public static final String OFFSETS_LOG_CLEANER_MIN_CLEANABLE_DIRTY_RATIO_DOC = "The minimum cleanable dirty ratio config for the __consumer_offsets topic.";
    public static final double OFFSETS_LOG_CLEANER_MIN_CLEANABLE_DIRTY_RATIO_DEFAULT = 0.5;
    public static final String OFFSETS_LOG_CLEANER_MAX_COMPACTION_LAG_MS_CONFIG = "confluent.offsets.log.cleaner.max.compaction.lag.ms";
    public static final String OFFSETS_LOG_CLEANER_MAX_COMPACTION_LAG_MS_DOC = "The maximum time a message will remain ineligible for compaction in the log. Only applicable for __consumer_offsets logs that are being compacted.";
    public static final long OFFSETS_LOG_CLEANER_MAX_COMPACTION_LAG_MS_DEFAULT = Long.MAX_VALUE;
    public static final ConfigDef GROUP_COORDINATOR_CONFIG_DEF = new ConfigDef().define("group.min.session.timeout.ms", ConfigDef.Type.INT, (Object)6000, ConfigDef.Importance.MEDIUM, "The minimum allowed session timeout for registered consumers. Shorter timeouts result in quicker failure detection at the cost of more frequent consumer heartbeating, which can overwhelm broker resources.").define("group.max.session.timeout.ms", ConfigDef.Type.INT, (Object)1800000, ConfigDef.Importance.MEDIUM, "The maximum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.").define("group.initial.rebalance.delay.ms", ConfigDef.Type.INT, (Object)3000, ConfigDef.Importance.MEDIUM, "The amount of time the group coordinator will wait for more consumers to join a new group before performing the first rebalance. A longer delay means potentially fewer rebalances, but increases the time until processing begins.").define("group.max.size", ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum number of consumers that a single consumer group can accommodate.").define("confluent.group.metadata.load.threads", ConfigDef.Type.INT, (Object)32, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The number of threads group metadata load / unload can use to concurrently load / unload metadata.").defineInternal("confluent.group.coordinator.offsets.writer.threads", ConfigDef.Type.INT, (Object)2, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The number of offset commit batching writer threads.").defineInternal("confluent.group.coordinator.offsets.batching.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, "Enables offset commit batching in the group coordinator.").defineInternal("confluent.group.subscription.pattern.log.interval.ms", ConfigDef.Type.INT, (Object)-1, ConfigDef.Importance.MEDIUM, "The minimum interval between logging groups with heterogeneous subscription patterns. -1 disables logging.");
    public static final ConfigDef NEW_GROUP_CONFIG_DEF = new ConfigDef().define("group.coordinator.rebalance.protocols", ConfigDef.Type.LIST, GROUP_COORDINATOR_REBALANCE_PROTOCOLS_DEFAULT, (ConfigDef.Validator)ConfigDef.ValidList.in((String[])Utils.enumOptions(Group.GroupType.class)), ConfigDef.Importance.MEDIUM, GROUP_COORDINATOR_REBALANCE_PROTOCOLS_DOC).define("group.coordinator.threads", ConfigDef.Type.INT, (Object)1, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The number of threads used by the group coordinator.").define("group.coordinator.append.linger.ms", ConfigDef.Type.INT, (Object)10, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The duration in milliseconds that the coordinator will wait for writes to accumulate before flushing them to disk. Transactional writes are not accumulated.").defineInternal("group.coordinator.new.enable", ConfigDef.Type.BOOLEAN, (Object)true, null, ConfigDef.Importance.MEDIUM, "Enable the new group coordinator.");
    public static final ConfigDef OFFSET_MANAGEMENT_CONFIG_DEF = new ConfigDef().define("offset.metadata.max.bytes", ConfigDef.Type.INT, (Object)4096, ConfigDef.Importance.HIGH, "The maximum size for a metadata entry associated with an offset commit.").define("offsets.load.buffer.size", ConfigDef.Type.INT, (Object)0x500000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "Batch size for reading from the offsets segments when loading offsets into the cache (soft-limit, overridden if records are too large).").define("offsets.topic.replication.factor", ConfigDef.Type.SHORT, (Object)3, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The replication factor for the offsets topic (set higher to ensure availability). Internal topic creation will fail until the cluster size meets this replication factor requirement.").define("offsets.topic.num.partitions", ConfigDef.Type.INT, (Object)50, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The number of partitions for the offset commit topic (should not change after deployment).").define("offsets.topic.segment.bytes", ConfigDef.Type.INT, (Object)0x6400000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The offsets topic segment bytes should be kept relatively small in order to facilitate faster log compaction and cache loads.").define("offsets.topic.compression.codec", ConfigDef.Type.INT, (Object)GroupCoordinatorConfig.OFFSETS_TOPIC_COMPRESSION_CODEC_DEFAULT.id, ConfigDef.Importance.HIGH, "Compression codec for the offsets topic - compression may be used to achieve \"atomic\" commits.").define("offsets.retention.minutes", ConfigDef.Type.INT, (Object)10080, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "For subscribed consumers, committed offset of a specific partition will be expired and discarded when 1) this retention period has elapsed after the consumer group loses all its consumers (i.e. becomes empty); 2) this retention period has elapsed since the last time an offset is committed for the partition and the group is no longer subscribed to the corresponding topic. For standalone consumers (using manual assignment), offsets will be expired after this retention period has elapsed since the time of last commit. Note that when a group is deleted via the delete-group request, its committed offsets will also be deleted without extra retention period; also when a topic is deleted via the delete-topic request, upon propagated metadata update any group's committed offsets for that topic will also be deleted without extra retention period.").define("offsets.retention.check.interval.ms", ConfigDef.Type.LONG, (Object)600000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "Frequency at which to check for stale offsets").define("offsets.commit.timeout.ms", ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "Offset commit will be delayed until all replicas for the offsets topic receive the commit or this timeout is reached. This is similar to the producer request timeout.").define("offsets.commit.required.acks", ConfigDef.Type.SHORT, (Object)-1, ConfigDef.Importance.HIGH, "DEPRECATED: The required acks before the commit can be accepted. In general, the default (-1) should not be overridden.").define("confluent.offsets.topic.placement.constraints", ConfigDef.Type.STRING, (Object)"", TopicPlacement.VALIDATOR, ConfigDef.Importance.HIGH, OFFSET_TOPIC_PLACEMENT_CONSTRAINTS_DOC).define("confluent.offsets.log.cleaner.delete.retention.ms", ConfigDef.Type.LONG, (Object)86400000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The delete retention timeout for the log cleaner compacting the __consumer_offsets topic.").define("confluent.offsets.log.cleaner.min.cleanable.dirty.ratio", ConfigDef.Type.DOUBLE, (Object)0.5, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.HIGH, "The minimum cleanable dirty ratio config for the __consumer_offsets topic.").define("confluent.offsets.log.cleaner.max.compaction.lag.ms", ConfigDef.Type.LONG, (Object)Long.MAX_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The maximum time a message will remain ineligible for compaction in the log. Only applicable for __consumer_offsets logs that are being compacted.");
    public static final ConfigDef CONSUMER_GROUP_CONFIG_DEF = new ConfigDef().define("group.consumer.session.timeout.ms", ConfigDef.Type.INT, (Object)45000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The timeout to detect client failures when using the consumer group protocol.").define("group.consumer.min.session.timeout.ms", ConfigDef.Type.INT, (Object)45000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The minimum allowed session timeout for registered consumers.").define("group.consumer.max.session.timeout.ms", ConfigDef.Type.INT, (Object)60000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum allowed session timeout for registered consumers.").define("group.consumer.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The heartbeat interval given to the members of a consumer group.").define("group.consumer.min.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The minimum heartbeat interval for registered consumers.").define("group.consumer.max.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)15000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum heartbeat interval for registered consumers.").define("group.consumer.max.size", ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum number of consumers that a single consumer group can accommodate. This value will only impact the new consumer coordinator. To configure the classic consumer coordinator check group.max.size instead.").define("group.consumer.assignors", ConfigDef.Type.LIST, CONSUMER_GROUP_ASSIGNORS_DEFAULT, null, ConfigDef.Importance.MEDIUM, "The server side assignors as a list of full class names. The first one in the list is considered as the default assignor to be used in the case where the consumer does not specify an assignor.").defineInternal("group.consumer.migration.policy", ConfigDef.Type.STRING, (Object)CONSUMER_GROUP_MIGRATION_POLICY_DEFAULT, (ConfigDef.Validator)ConfigDef.CaseInsensitiveValidString.in((String[])Utils.enumOptions(ConsumerGroupMigrationPolicy.class)), ConfigDef.Importance.MEDIUM, CONSUMER_GROUP_MIGRATION_POLICY_DOC);
    public static final ConfigDef SHARE_GROUP_CONFIG_DEF = new ConfigDef().define("group.share.session.timeout.ms", ConfigDef.Type.INT, (Object)45000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The timeout to detect client failures when using the share group protocol.").define("group.share.min.session.timeout.ms", ConfigDef.Type.INT, (Object)45000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The minimum allowed session timeout for share group members.").define("group.share.max.session.timeout.ms", ConfigDef.Type.INT, (Object)60000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum allowed session timeout for share group members.").define("group.share.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The heartbeat interval given to the members of a share group.").define("group.share.min.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The minimum heartbeat interval for share group members.").define("group.share.max.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)15000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum heartbeat interval for share group members.").define("group.share.max.size", ConfigDef.Type.SHORT, (Object)200, (ConfigDef.Validator)ConfigDef.Range.between((Number)10, (Number)1000), ConfigDef.Importance.MEDIUM, "The maximum number of members that a single share group can accommodate.");
    public static final int CLASSIC_GROUP_NEW_MEMBER_JOIN_TIMEOUT_MS = 300000;
    private final int numThreads;
    private final int appendLingerMs;
    private final int consumerGroupSessionTimeoutMs;
    private final int consumerGroupHeartbeatIntervalMs;
    private final int consumerGroupMaxSize;
    private final List<ConsumerGroupPartitionAssignor> consumerGroupAssignors;
    private final int offsetsTopicSegmentBytes;
    private final int offsetMetadataMaxSize;
    private final long offsetsLogCleanerDeleteRetentionMs;
    private final double offsetsLogCleanerMinCleanableDirtyRatio;
    private final long offsetsLogCleanerMaxCompactionLagMs;
    private final int classicGroupMaxSize;
    private final int classicGroupInitialRebalanceDelayMs;
    private final int classicGroupMinSessionTimeoutMs;
    private final int classicGroupMaxSessionTimeoutMs;
    private final int groupSubscriptionPatternLogIntervalMs;
    private final long offsetsRetentionCheckIntervalMs;
    private final long offsetsRetentionMs;
    private final int offsetCommitTimeoutMs;
    private final ConsumerGroupMigrationPolicy consumerGroupMigrationPolicy;
    private final CompressionType offsetTopicCompressionType;
    private final int offsetsLoadBufferSize;
    private final int offsetsTopicPartitions;
    private final short offsetsTopicReplicationFactor;
    private final short offsetCommitRequiredAcks;
    private final int consumerGroupMinSessionTimeoutMs;
    private final int consumerGroupMaxSessionTimeoutMs;
    private final int consumerGroupMinHeartbeatIntervalMs;
    private final int consumerGroupMaxHeartbeatIntervalMs;
    private final Optional<TopicPlacement> offsetsTopicPlacementConstraints;
    private final int groupCoordinatorOffsetWriterThreads;
    private final boolean groupCoordinatorOffsetsBatchingEnable;
    private final int groupMetadataLoadThreads;
    private final short shareGroupMaxSize;
    private final int shareGroupSessionTimeoutMs;
    private final int shareGroupMinSessionTimeoutMs;
    private final int shareGroupMaxSessionTimeoutMs;
    private final int shareGroupHeartbeatIntervalMs;
    private final int shareGroupMinHeartbeatIntervalMs;
    private final int shareGroupMaxHeartbeatIntervalMs;

    public GroupCoordinatorConfig(AbstractConfig config) {
        this.numThreads = config.getInt(GROUP_COORDINATOR_NUM_THREADS_CONFIG);
        this.appendLingerMs = config.getInt(GROUP_COORDINATOR_APPEND_LINGER_MS_CONFIG);
        this.consumerGroupSessionTimeoutMs = config.getInt(CONSUMER_GROUP_SESSION_TIMEOUT_MS_CONFIG);
        this.consumerGroupHeartbeatIntervalMs = config.getInt(CONSUMER_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG);
        this.consumerGroupMaxSize = config.getInt(CONSUMER_GROUP_MAX_SIZE_CONFIG);
        this.consumerGroupAssignors = Collections.unmodifiableList(config.getConfiguredInstances(CONSUMER_GROUP_ASSIGNORS_CONFIG, ConsumerGroupPartitionAssignor.class));
        this.offsetsTopicSegmentBytes = config.getInt(OFFSETS_TOPIC_SEGMENT_BYTES_CONFIG);
        this.offsetMetadataMaxSize = config.getInt(OFFSET_METADATA_MAX_SIZE_CONFIG);
        this.offsetsLogCleanerDeleteRetentionMs = config.getLong(OFFSETS_LOG_CLEANER_DELETE_RETENTION_MS_CONFIG);
        this.offsetsLogCleanerMinCleanableDirtyRatio = config.getDouble(OFFSETS_LOG_CLEANER_MIN_CLEANABLE_DIRTY_RATIO_CONFIG);
        this.offsetsLogCleanerMaxCompactionLagMs = config.getLong(OFFSETS_LOG_CLEANER_MAX_COMPACTION_LAG_MS_CONFIG);
        this.classicGroupMaxSize = config.getInt(GROUP_MAX_SIZE_CONFIG);
        this.classicGroupInitialRebalanceDelayMs = config.getInt(GROUP_INITIAL_REBALANCE_DELAY_MS_CONFIG);
        this.classicGroupMinSessionTimeoutMs = config.getInt(GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG);
        this.classicGroupMaxSessionTimeoutMs = config.getInt(GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG);
        this.groupSubscriptionPatternLogIntervalMs = config.getInt(GROUP_SUBSCRIPTION_PATTERN_LOG_INTERVAL_MS_CONFIG);
        this.offsetsRetentionCheckIntervalMs = config.getLong(OFFSETS_RETENTION_CHECK_INTERVAL_MS_CONFIG);
        this.offsetsRetentionMs = (long)config.getInt(OFFSETS_RETENTION_MINUTES_CONFIG).intValue() * 60L * 1000L;
        this.offsetCommitTimeoutMs = config.getInt(OFFSET_COMMIT_TIMEOUT_MS_CONFIG);
        this.consumerGroupMigrationPolicy = ConsumerGroupMigrationPolicy.parse(config.getString(CONSUMER_GROUP_MIGRATION_POLICY_CONFIG));
        this.offsetTopicCompressionType = Optional.ofNullable(config.getInt(OFFSETS_TOPIC_COMPRESSION_CODEC_CONFIG)).map(CompressionType::forId).orElse(null);
        this.offsetsLoadBufferSize = config.getInt(OFFSETS_LOAD_BUFFER_SIZE_CONFIG);
        this.offsetsTopicPartitions = config.getInt(OFFSETS_TOPIC_PARTITIONS_CONFIG);
        this.offsetsTopicReplicationFactor = config.getShort(OFFSETS_TOPIC_REPLICATION_FACTOR_CONFIG);
        this.offsetCommitRequiredAcks = config.getShort(OFFSET_COMMIT_REQUIRED_ACKS_CONFIG);
        this.consumerGroupMinSessionTimeoutMs = config.getInt(CONSUMER_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG);
        this.consumerGroupMaxSessionTimeoutMs = config.getInt(CONSUMER_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG);
        this.consumerGroupMinHeartbeatIntervalMs = config.getInt(CONSUMER_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG);
        this.consumerGroupMaxHeartbeatIntervalMs = config.getInt(CONSUMER_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG);
        this.offsetsTopicPlacementConstraints = TopicPlacement.parse((String)config.getString(OFFSET_TOPIC_PLACEMENT_CONSTRAINTS_CONFIG));
        this.groupCoordinatorOffsetWriterThreads = config.getInt(GROUP_COORDINATOR_OFFSET_WRITER_THREADS_CONFIG);
        this.groupCoordinatorOffsetsBatchingEnable = config.getBoolean(GROUP_COORDINATOR_OFFSETS_BATCHING_ENABLE_CONFIG);
        this.groupMetadataLoadThreads = config.getInt(GROUP_METADATA_LOAD_THREADS_CONFIG);
        this.shareGroupSessionTimeoutMs = config.getInt(SHARE_GROUP_SESSION_TIMEOUT_MS_CONFIG);
        this.shareGroupMinSessionTimeoutMs = config.getInt(SHARE_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG);
        this.shareGroupMaxSessionTimeoutMs = config.getInt(SHARE_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG);
        this.shareGroupHeartbeatIntervalMs = config.getInt(SHARE_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG);
        this.shareGroupMinHeartbeatIntervalMs = config.getInt(SHARE_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG);
        this.shareGroupMaxHeartbeatIntervalMs = config.getInt(SHARE_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG);
        this.shareGroupMaxSize = config.getShort(SHARE_GROUP_MAX_SIZE_CONFIG);
        Utils.require((this.offsetCommitRequiredAcks >= -1 && this.offsetCommitRequiredAcks <= this.offsetsTopicReplicationFactor ? 1 : 0) != 0, (String)String.format("%s must be greater or equal to -1 and less or equal to %s", OFFSET_COMMIT_REQUIRED_ACKS_CONFIG, OFFSETS_TOPIC_REPLICATION_FACTOR_CONFIG));
        Utils.require((this.consumerGroupMaxHeartbeatIntervalMs >= this.consumerGroupMinHeartbeatIntervalMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equals to %s", CONSUMER_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG, CONSUMER_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG));
        Utils.require((this.consumerGroupHeartbeatIntervalMs >= this.consumerGroupMinHeartbeatIntervalMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equals to %s", CONSUMER_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG, CONSUMER_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG));
        Utils.require((this.consumerGroupHeartbeatIntervalMs <= this.consumerGroupMaxHeartbeatIntervalMs ? 1 : 0) != 0, (String)String.format("%s must be less than or equals to %s", CONSUMER_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG, CONSUMER_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG));
        Utils.require((this.consumerGroupMaxSessionTimeoutMs >= this.consumerGroupMinSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equals to %s", CONSUMER_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG, CONSUMER_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG));
        Utils.require((this.consumerGroupSessionTimeoutMs >= this.consumerGroupMinSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equals to %s", CONSUMER_GROUP_SESSION_TIMEOUT_MS_CONFIG, CONSUMER_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG));
        Utils.require((this.consumerGroupSessionTimeoutMs <= this.consumerGroupMaxSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be less than or equals to %s", CONSUMER_GROUP_SESSION_TIMEOUT_MS_CONFIG, CONSUMER_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG));
        Utils.require((this.shareGroupMaxHeartbeatIntervalMs >= this.shareGroupMinHeartbeatIntervalMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equals to %s", SHARE_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG, SHARE_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG));
        Utils.require((this.shareGroupHeartbeatIntervalMs >= this.shareGroupMinHeartbeatIntervalMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equals to %s", SHARE_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG, SHARE_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG));
        Utils.require((this.shareGroupHeartbeatIntervalMs <= this.shareGroupMaxHeartbeatIntervalMs ? 1 : 0) != 0, (String)String.format("%s must be less than or equals to %s", SHARE_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG, SHARE_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG));
        Utils.require((this.shareGroupMaxSessionTimeoutMs >= this.shareGroupMinSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equals to %s", SHARE_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG, SHARE_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG));
        Utils.require((this.shareGroupSessionTimeoutMs >= this.shareGroupMinSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equals to %s", SHARE_GROUP_SESSION_TIMEOUT_MS_CONFIG, SHARE_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG));
        Utils.require((this.shareGroupSessionTimeoutMs <= this.shareGroupMaxSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be less than or equals to %s", SHARE_GROUP_SESSION_TIMEOUT_MS_CONFIG, SHARE_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG));
    }

    public int numThreads() {
        return this.numThreads;
    }

    public int appendLingerMs() {
        return this.appendLingerMs;
    }

    public int consumerGroupSessionTimeoutMs() {
        return this.consumerGroupSessionTimeoutMs;
    }

    public int consumerGroupHeartbeatIntervalMs() {
        return this.consumerGroupHeartbeatIntervalMs;
    }

    public int consumerGroupMaxSize() {
        return this.consumerGroupMaxSize;
    }

    public List<ConsumerGroupPartitionAssignor> consumerGroupAssignors() {
        return this.consumerGroupAssignors;
    }

    public int offsetsTopicSegmentBytes() {
        return this.offsetsTopicSegmentBytes;
    }

    public int offsetMetadataMaxSize() {
        return this.offsetMetadataMaxSize;
    }

    public long offsetsLogCleanerDeleteRetentionMs() {
        return this.offsetsLogCleanerDeleteRetentionMs;
    }

    public double offsetsLogCleanerMinCleanableDirtyRatio() {
        return this.offsetsLogCleanerMinCleanableDirtyRatio;
    }

    public long offsetsLogCleanerMaxCompactionLagMs() {
        return this.offsetsLogCleanerMaxCompactionLagMs;
    }

    public int classicGroupMaxSize() {
        return this.classicGroupMaxSize;
    }

    public int classicGroupInitialRebalanceDelayMs() {
        return this.classicGroupInitialRebalanceDelayMs;
    }

    public int classicGroupNewMemberJoinTimeoutMs() {
        return 300000;
    }

    public int classicGroupMinSessionTimeoutMs() {
        return this.classicGroupMinSessionTimeoutMs;
    }

    public int classicGroupMaxSessionTimeoutMs() {
        return this.classicGroupMaxSessionTimeoutMs;
    }

    public int classicGroupSubscriptionPatternLogIntervalMs() {
        return this.groupSubscriptionPatternLogIntervalMs;
    }

    public long offsetsRetentionCheckIntervalMs() {
        return this.offsetsRetentionCheckIntervalMs;
    }

    public long offsetsRetentionMs() {
        return this.offsetsRetentionMs;
    }

    public int offsetCommitTimeoutMs() {
        return this.offsetCommitTimeoutMs;
    }

    public ConsumerGroupMigrationPolicy consumerGroupMigrationPolicy() {
        return this.consumerGroupMigrationPolicy;
    }

    public CompressionType offsetsTopicCompressionType() {
        return this.offsetTopicCompressionType;
    }

    public int offsetsLoadBufferSize() {
        return this.offsetsLoadBufferSize;
    }

    public int offsetsTopicPartitions() {
        return this.offsetsTopicPartitions;
    }

    public short offsetsTopicReplicationFactor() {
        return this.offsetsTopicReplicationFactor;
    }

    @Deprecated
    public short offsetCommitRequiredAcks() {
        return this.offsetCommitRequiredAcks;
    }

    public int consumerGroupMinSessionTimeoutMs() {
        return this.consumerGroupMinSessionTimeoutMs;
    }

    public int consumerGroupMaxSessionTimeoutMs() {
        return this.consumerGroupMaxSessionTimeoutMs;
    }

    public int consumerGroupMinHeartbeatIntervalMs() {
        return this.consumerGroupMinHeartbeatIntervalMs;
    }

    public int consumerGroupMaxHeartbeatIntervalMs() {
        return this.consumerGroupMaxHeartbeatIntervalMs;
    }

    public Optional<TopicPlacement> offsetsTopicPlacementConstraints() {
        return this.offsetsTopicPlacementConstraints;
    }

    public int groupCoordinatorOffsetWriterThreads() {
        return this.groupCoordinatorOffsetWriterThreads;
    }

    public boolean groupCoordinatorOffsetsBatchingEnable() {
        return this.groupCoordinatorOffsetsBatchingEnable;
    }

    public int groupMetadataLoadThreads() {
        return this.groupMetadataLoadThreads;
    }

    public int shareGroupSessionTimeoutMs() {
        return this.shareGroupSessionTimeoutMs;
    }

    public int shareGroupHeartbeatIntervalMs() {
        return this.shareGroupHeartbeatIntervalMs;
    }

    public int shareGroupMaxSize() {
        return this.shareGroupMaxSize;
    }

    public int shareGroupMinSessionTimeoutMs() {
        return this.shareGroupMinSessionTimeoutMs;
    }

    public int shareGroupMaxSessionTimeoutMs() {
        return this.shareGroupMaxSessionTimeoutMs;
    }

    public int shareGroupMinHeartbeatIntervalMs() {
        return this.shareGroupMinHeartbeatIntervalMs;
    }

    public int shareGroupMaxHeartbeatIntervalMs() {
        return this.shareGroupMaxHeartbeatIntervalMs;
    }
}

