/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.metrics;

import java.util.concurrent.atomic.AtomicReference;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;

public final class HdrHistogram {
    private static final long DEFAULT_MAX_SNAPSHOT_AGE_MS = 1000L;
    private final long maxSnapshotAgeMs;
    private final Recorder recorder;
    private final AtomicReference<Timestamped<Histogram>> timestampedHistogramSnapshot;

    public HdrHistogram(long highestTrackableValue, int numberOfSignificantValueDigits) {
        this(1000L, highestTrackableValue, numberOfSignificantValueDigits);
    }

    HdrHistogram(long maxSnapshotAgeMs, long highestTrackableValue, int numberOfSignificantValueDigits) {
        this.maxSnapshotAgeMs = maxSnapshotAgeMs;
        this.recorder = new Recorder(highestTrackableValue, numberOfSignificantValueDigits);
        this.timestampedHistogramSnapshot = new AtomicReference(new Timestamped(0L, null));
    }

    private Histogram latestHistogram(long now) {
        Timestamped<Histogram> latest = this.timestampedHistogramSnapshot.get();
        while (now - ((Timestamped)latest).timestamp > this.maxSnapshotAgeMs) {
            Histogram currentSnapshot = this.recorder.getIntervalHistogram();
            boolean updatedLatest = this.timestampedHistogramSnapshot.compareAndSet(latest, new Timestamped(now, currentSnapshot));
            latest = this.timestampedHistogramSnapshot.get();
            if (!updatedLatest) continue;
            break;
        }
        return (Histogram)((Timestamped)latest).value;
    }

    public void record(long value) {
        this.recorder.recordValue(value);
    }

    public long count(long now) {
        return this.latestHistogram(now).getTotalCount();
    }

    public long max(long now) {
        return this.latestHistogram(now).getMaxValue();
    }

    public double measurePercentile(long now, double percentile) {
        return this.latestHistogram(now).getValueAtPercentile(percentile);
    }

    private static final class Timestamped<T> {
        private final long timestamp;
        private final T value;

        private Timestamped(long timestamp, T value) {
            this.timestamp = timestamp;
            this.value = value;
        }
    }
}

