/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupPartitionMetadataValue;

public class TopicMetadata {
    private final Uuid id;
    private final String name;
    private final int numPartitions;
    private final Map<Integer, Set<String>> partitionRacks;

    public TopicMetadata(Uuid id, String name, int numPartitions, Map<Integer, Set<String>> partitionRacks) {
        this.id = Objects.requireNonNull(id);
        if (Uuid.ZERO_UUID.equals((Object)id)) {
            throw new IllegalArgumentException("Topic id cannot be ZERO_UUID.");
        }
        this.name = Objects.requireNonNull(name);
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Topic name cannot be empty.");
        }
        this.numPartitions = numPartitions;
        if (numPartitions < 0) {
            throw new IllegalArgumentException("Number of partitions cannot be negative.");
        }
        this.partitionRacks = Objects.requireNonNull(partitionRacks);
    }

    public Uuid id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public Map<Integer, Set<String>> partitionRacks() {
        return this.partitionRacks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicMetadata that = (TopicMetadata)o;
        if (!this.id.equals((Object)that.id)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.numPartitions != that.numPartitions) {
            return false;
        }
        return this.partitionRacks.equals(that.partitionRacks);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.numPartitions;
        result = 31 * result + this.partitionRacks.hashCode();
        return result;
    }

    public String toString() {
        return "TopicMetadata(id=" + this.id + ", name=" + this.name + ", numPartitions=" + this.numPartitions + ", partitionRacks=" + this.partitionRacks + ')';
    }

    public static TopicMetadata fromRecord(ConsumerGroupPartitionMetadataValue.TopicMetadata record) {
        HashMap<Integer, Set<String>> partitionRacks = new HashMap<Integer, Set<String>>();
        for (ConsumerGroupPartitionMetadataValue.PartitionMetadata partitionMetadata : record.partitionMetadata()) {
            partitionRacks.put(partitionMetadata.partition(), Collections.unmodifiableSet(new HashSet<String>(partitionMetadata.racks())));
        }
        return new TopicMetadata(record.topicId(), record.topicName(), record.numPartitions(), partitionRacks);
    }

    public static TopicMetadata fromRecord(ShareGroupPartitionMetadataValue.TopicMetadata record) {
        HashMap<Integer, Set<String>> partitionRacks = new HashMap<Integer, Set<String>>();
        for (ShareGroupPartitionMetadataValue.PartitionMetadata partitionMetadata : record.partitionMetadata()) {
            partitionRacks.put(partitionMetadata.partition(), Collections.unmodifiableSet(new HashSet<String>(partitionMetadata.racks())));
        }
        return new TopicMetadata(record.topicId(), record.topicName(), record.numPartitions(), partitionRacks);
    }
}

