/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern.consumer;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.IllegalGenerationException;
import org.apache.kafka.common.errors.StaleMemberEpochException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.ConsumerProtocolSubscription;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.CoordinatorRecord;
import org.apache.kafka.coordinator.group.CoordinatorRecordHelpers;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.OffsetExpirationCondition;
import org.apache.kafka.coordinator.group.OffsetExpirationConditionImpl;
import org.apache.kafka.coordinator.group.Utils;
import org.apache.kafka.coordinator.group.classic.ClassicGroup;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetricsShard;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.MemberState;
import org.apache.kafka.coordinator.group.modern.ModernGroup;
import org.apache.kafka.coordinator.group.modern.ModernGroupMember;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroupMember;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.apache.kafka.timeline.TimelineInteger;
import org.apache.kafka.timeline.TimelineObject;

public class ConsumerGroup
extends ModernGroup<ConsumerGroupMember> {
    private final Time time;
    private final TimelineObject<ConsumerGroupState> state;
    private final TimelineHashMap<String, String> staticMembers;
    private final TimelineHashMap<String, Integer> serverAssignors;
    private final GroupCoordinatorMetricsShard metrics;
    private final TimelineInteger numClassicProtocolMembers;
    private final TimelineHashMap<String, Integer> classicProtocolMembersSupportedProtocols;
    private final TimelineObject<Optional<Long>> rebalanceStartTimestampMs;

    public ConsumerGroup(Time time, SnapshotRegistry snapshotRegistry, String groupId, GroupCoordinatorMetricsShard metrics) {
        super(snapshotRegistry, groupId);
        this.time = time;
        this.state = new TimelineObject(snapshotRegistry, (Object)ConsumerGroupState.EMPTY);
        this.staticMembers = new TimelineHashMap(snapshotRegistry, 0);
        this.serverAssignors = new TimelineHashMap(snapshotRegistry, 0);
        this.metrics = Objects.requireNonNull(metrics);
        this.numClassicProtocolMembers = new TimelineInteger(snapshotRegistry);
        this.classicProtocolMembersSupportedProtocols = new TimelineHashMap(snapshotRegistry, 0);
        this.rebalanceStartTimestampMs = new TimelineObject(snapshotRegistry, Optional.empty());
    }

    @Override
    public Group.GroupType type() {
        return Group.GroupType.CONSUMER;
    }

    @Override
    public String protocolType() {
        return "consumer";
    }

    @Override
    public String stateAsString() {
        return ((ConsumerGroupState)((Object)this.state.get())).toString();
    }

    @Override
    public String stateAsString(long committedOffset) {
        return ((ConsumerGroupState)((Object)this.state.get(committedOffset))).toString();
    }

    public ConsumerGroupState state() {
        return (ConsumerGroupState)((Object)this.state.get());
    }

    public ConsumerGroupState state(long committedOffset) {
        return (ConsumerGroupState)((Object)this.state.get(committedOffset));
    }

    public void setNumClassicProtocolMembers(int numClassicProtocolMembers) {
        this.numClassicProtocolMembers.set(numClassicProtocolMembers);
    }

    public String staticMemberId(String groupInstanceId) {
        if (groupInstanceId == null) {
            return null;
        }
        return (String)this.staticMembers.get((Object)groupInstanceId);
    }

    @Override
    public ConsumerGroupMember getOrMaybeCreateMember(String memberId, boolean createIfNotExists) throws UnknownMemberIdException {
        ConsumerGroupMember member = (ConsumerGroupMember)this.members.get((Object)memberId);
        if (member != null) {
            return member;
        }
        if (!createIfNotExists) {
            throw new UnknownMemberIdException(String.format("Member %s is not a member of group %s.", memberId, this.groupId));
        }
        return new ConsumerGroupMember.Builder(memberId).build();
    }

    public ConsumerGroupMember staticMember(String instanceId) {
        String existingMemberId = this.staticMemberId(instanceId);
        return existingMemberId == null ? null : this.getOrMaybeCreateMember(existingMemberId, false);
    }

    public boolean hasStaticMember(String instanceId) {
        if (instanceId == null) {
            return false;
        }
        return this.staticMembers.containsKey((Object)instanceId);
    }

    public Assignment targetAssignment(String memberId, String instanceId) {
        if (instanceId == null) {
            return this.targetAssignment(memberId);
        }
        String previousMemberId = this.staticMemberId(instanceId);
        if (previousMemberId != null) {
            return this.targetAssignment(previousMemberId);
        }
        return Assignment.EMPTY;
    }

    @Override
    public void updateMember(ConsumerGroupMember newMember) {
        if (newMember == null) {
            throw new IllegalArgumentException("newMember cannot be null.");
        }
        ConsumerGroupMember oldMember = (ConsumerGroupMember)this.members.put((Object)newMember.memberId(), (Object)newMember);
        this.maybeUpdateSubscribedTopicNamesAndGroupSubscriptionType(oldMember, newMember);
        this.maybeUpdateServerAssignors(oldMember, newMember);
        this.maybeUpdatePartitionEpoch(oldMember, newMember);
        this.updateStaticMember(newMember);
        this.maybeUpdateGroupState();
        this.maybeUpdateNumClassicProtocolMembers(oldMember, newMember);
        this.maybeUpdateClassicProtocolMembersSupportedProtocols(oldMember, newMember);
    }

    private void updateStaticMember(ConsumerGroupMember newMember) {
        if (newMember.instanceId() != null) {
            this.staticMembers.put((Object)newMember.instanceId(), (Object)newMember.memberId());
        }
    }

    @Override
    public void removeMember(String memberId) {
        ConsumerGroupMember oldMember = (ConsumerGroupMember)this.members.remove((Object)memberId);
        this.maybeUpdateSubscribedTopicNamesAndGroupSubscriptionType(oldMember, null);
        this.maybeUpdateServerAssignors(oldMember, null);
        this.maybeRemovePartitionEpoch(oldMember);
        this.removeStaticMember(oldMember);
        this.maybeUpdateGroupState();
        this.maybeUpdateNumClassicProtocolMembers(oldMember, null);
        this.maybeUpdateClassicProtocolMembersSupportedProtocols(oldMember, null);
    }

    private void removeStaticMember(ConsumerGroupMember oldMember) {
        if (oldMember.instanceId() != null) {
            this.staticMembers.remove((Object)oldMember.instanceId());
        }
    }

    public int numClassicProtocolMembers() {
        return this.numClassicProtocolMembers.get();
    }

    public Map<String, Integer> classicMembersSupportedProtocols() {
        return Collections.unmodifiableMap(this.classicProtocolMembersSupportedProtocols);
    }

    public Map<String, String> staticMembers() {
        return Collections.unmodifiableMap(this.staticMembers);
    }

    public Optional<String> computePreferredServerAssignor(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>((Map<String, Integer>)this.serverAssignors);
        ConsumerGroup.maybeUpdateServerAssignors(counts, oldMember, newMember);
        return counts.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey);
    }

    public Optional<String> preferredServerAssignor() {
        return this.preferredServerAssignor(Long.MAX_VALUE);
    }

    public Optional<String> preferredServerAssignor(long committedOffset) {
        return this.serverAssignors.entrySet(committedOffset).stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey);
    }

    @Override
    public void validateOffsetCommit(String memberId, String groupInstanceId, int memberEpoch, boolean isTransactional, short apiVersion) throws UnknownMemberIdException, StaleMemberEpochException, IllegalGenerationException {
        if (memberEpoch < 0 && this.members().isEmpty()) {
            return;
        }
        ConsumerGroupMember member = this.getOrMaybeCreateMember(memberId, false);
        if (!isTransactional && !member.useClassicProtocol() && apiVersion < 9) {
            throw new UnsupportedVersionException("OffsetCommit version 9 or above must be used by members using the modern group protocol");
        }
        this.validateMemberEpoch(memberEpoch, member.memberEpoch(), member.useClassicProtocol());
    }

    @Override
    public void validateOffsetFetch(String memberId, int memberEpoch, long lastCommittedOffset) throws UnknownMemberIdException, StaleMemberEpochException, IllegalGenerationException {
        if (memberId == null && memberEpoch < 0) {
            return;
        }
        ConsumerGroupMember member = (ConsumerGroupMember)this.members.get((Object)memberId, lastCommittedOffset);
        if (member == null) {
            throw new UnknownMemberIdException(String.format("Member %s is not a member of group %s.", memberId, this.groupId));
        }
        this.validateMemberEpoch(memberEpoch, member.memberEpoch(), member.useClassicProtocol());
    }

    @Override
    public void validateOffsetDelete() {
    }

    @Override
    public void validateDeleteGroup() throws ApiException {
        if (this.state() != ConsumerGroupState.EMPTY) {
            throw Errors.NON_EMPTY_GROUP.exception();
        }
    }

    @Override
    public void createGroupTombstoneRecords(List<CoordinatorRecord> records) {
        this.members().forEach((memberId, member) -> records.add(CoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord(this.groupId(), memberId)));
        this.members().forEach((memberId, member) -> records.add(CoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord(this.groupId(), memberId)));
        records.add(CoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochTombstoneRecord(this.groupId()));
        this.members().forEach((memberId, member) -> records.add(CoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord(this.groupId(), memberId)));
        records.add(CoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataTombstoneRecord(this.groupId()));
        records.add(CoordinatorRecordHelpers.newConsumerGroupEpochTombstoneRecord(this.groupId()));
    }

    @Override
    public boolean isEmpty() {
        return this.state() == ConsumerGroupState.EMPTY;
    }

    @Override
    public Optional<OffsetExpirationCondition> offsetExpirationCondition() {
        return Optional.of(new OffsetExpirationConditionImpl(offsetAndMetadata -> offsetAndMetadata.commitTimestampMs));
    }

    @Override
    public boolean isInStates(Set<String> statesFilter, long committedOffset) {
        return statesFilter.contains(((ConsumerGroupState)((Object)this.state.get(committedOffset))).toLowerCaseString());
    }

    private void validateMemberEpoch(int receivedMemberEpoch, int expectedMemberEpoch, boolean useClassicProtocol) throws StaleMemberEpochException, IllegalGenerationException {
        if (receivedMemberEpoch != expectedMemberEpoch) {
            if (useClassicProtocol) {
                throw new IllegalGenerationException(String.format("The received generation id %d does not match the expected member epoch %d.", receivedMemberEpoch, expectedMemberEpoch));
            }
            throw new StaleMemberEpochException(String.format("The received member epoch %d does not match the expected member epoch %d.", receivedMemberEpoch, expectedMemberEpoch));
        }
    }

    @Override
    protected void maybeUpdateGroupState() {
        ConsumerGroupState previousState = (ConsumerGroupState)((Object)this.state.get());
        ConsumerGroupState newState = ConsumerGroupState.STABLE;
        if (this.members.isEmpty()) {
            newState = ConsumerGroupState.EMPTY;
        } else if (this.groupEpoch.get() > this.targetAssignmentEpoch.get()) {
            newState = ConsumerGroupState.ASSIGNING;
        } else {
            for (ModernGroupMember member : this.members.values()) {
                if (member.isReconciledTo(this.targetAssignmentEpoch.get())) continue;
                newState = ConsumerGroupState.RECONCILING;
                break;
            }
        }
        this.state.set((Object)newState);
        this.rebalanceStartTimestampMs.set(this.getRebalanceStartTimestampMs(previousState, newState));
        this.metrics.recordRebalanceStartTimestampMs(this.type(), this.groupId, ((Optional)this.rebalanceStartTimestampMs.get()).orElse(null));
        this.metrics.onConsumerGroupStateTransition(previousState, newState);
    }

    private void maybeUpdateServerAssignors(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        ConsumerGroup.maybeUpdateServerAssignors(this.serverAssignors, oldMember, newMember);
    }

    private static void maybeUpdateServerAssignors(Map<String, Integer> serverAssignorCount, ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        if (oldMember != null) {
            oldMember.serverAssignorName().ifPresent(name -> serverAssignorCount.compute((String)name, Utils::decValue));
        }
        if (newMember != null) {
            newMember.serverAssignorName().ifPresent(name -> serverAssignorCount.compute((String)name, Utils::incValue));
        }
    }

    private void maybeUpdateNumClassicProtocolMembers(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        int delta = 0;
        if (oldMember != null && oldMember.useClassicProtocol()) {
            --delta;
        }
        if (newMember != null && newMember.useClassicProtocol()) {
            ++delta;
        }
        this.setNumClassicProtocolMembers(this.numClassicProtocolMembers() + delta);
    }

    private void maybeUpdateClassicProtocolMembersSupportedProtocols(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        if (oldMember != null) {
            oldMember.supportedClassicProtocols().ifPresent(protocols -> protocols.forEach(protocol -> {
                Integer cfr_ignored_0 = (Integer)this.classicProtocolMembersSupportedProtocols.compute((Object)protocol.name(), Utils::decValue);
            }));
        }
        if (newMember != null) {
            newMember.supportedClassicProtocols().ifPresent(protocols -> protocols.forEach(protocol -> {
                Integer cfr_ignored_0 = (Integer)this.classicProtocolMembersSupportedProtocols.compute((Object)protocol.name(), Utils::incValue);
            }));
        }
    }

    private void maybeUpdatePartitionEpoch(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        this.maybeRemovePartitionEpoch(oldMember);
        this.addPartitionEpochs(newMember.assignedPartitions(), newMember.memberEpoch());
        this.addPartitionEpochs(newMember.partitionsPendingRevocation(), newMember.memberEpoch());
    }

    private void maybeRemovePartitionEpoch(ConsumerGroupMember oldMember) {
        if (oldMember != null) {
            this.removePartitionEpochs(oldMember.assignedPartitions(), oldMember.memberEpoch());
            this.removePartitionEpochs(oldMember.partitionsPendingRevocation(), oldMember.memberEpoch());
        }
    }

    private Optional<Long> getRebalanceStartTimestampMs(ConsumerGroupState prevState, ConsumerGroupState nextState) {
        switch (nextState) {
            case ASSIGNING: 
            case RECONCILING: {
                if (prevState == ConsumerGroupState.ASSIGNING || prevState == ConsumerGroupState.RECONCILING) {
                    return (Optional)this.rebalanceStartTimestampMs.get();
                }
                return Optional.of(this.time.milliseconds());
            }
        }
        return Optional.empty();
    }

    public ConsumerGroupDescribeResponseData.DescribedGroup asDescribedGroup(long committedOffset, String defaultAssignor, TopicsImage topicsImage) {
        ConsumerGroupDescribeResponseData.DescribedGroup describedGroup = new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId(this.groupId).setAssignorName(this.preferredServerAssignor(committedOffset).orElse(defaultAssignor)).setGroupEpoch(this.groupEpoch.get(committedOffset)).setGroupState(((ConsumerGroupState)((Object)this.state.get(committedOffset))).toString()).setAssignmentEpoch(this.targetAssignmentEpoch.get(committedOffset));
        this.members.entrySet(committedOffset).forEach(entry -> describedGroup.members().add(((ConsumerGroupMember)entry.getValue()).asConsumerGroupDescribeMember((Assignment)this.targetAssignment.get((Object)((ConsumerGroupMember)entry.getValue()).memberId(), committedOffset), topicsImage)));
        return describedGroup;
    }

    public static ConsumerGroup fromClassicGroup(SnapshotRegistry snapshotRegistry, GroupCoordinatorMetricsShard metrics, ClassicGroup classicGroup, TopicsImage topicsImage, Time time) {
        String groupId = classicGroup.groupId();
        ConsumerGroup consumerGroup = new ConsumerGroup(time, snapshotRegistry, groupId, metrics);
        consumerGroup.setGroupEpoch(classicGroup.generationId());
        consumerGroup.setTargetAssignmentEpoch(classicGroup.generationId());
        classicGroup.allMembers().forEach(classicGroupMember -> {
            Map<Uuid, Set<Integer>> assignedPartitions = Utils.toTopicPartitionMap(ConsumerProtocol.deserializeConsumerProtocolAssignment((ByteBuffer)ByteBuffer.wrap(classicGroupMember.assignment())), topicsImage);
            ConsumerProtocolSubscription subscription = ConsumerProtocol.deserializeConsumerProtocolSubscription((ByteBuffer)ByteBuffer.wrap(classicGroupMember.metadata(classicGroup.protocolName().get())));
            ConsumerGroupMember newMember = new ConsumerGroupMember.Builder(classicGroupMember.memberId()).setMemberEpoch(classicGroup.generationId()).setState(MemberState.STABLE).setPreviousMemberEpoch(classicGroup.generationId()).setInstanceId(classicGroupMember.groupInstanceId().orElse(null)).setRackId(Utils.toOptional(subscription.rackId()).orElse(null)).setRebalanceTimeoutMs(classicGroupMember.rebalanceTimeoutMs()).setClientId(classicGroupMember.clientId()).setClientHost(classicGroupMember.clientHost()).setSubscribedTopicNames(subscription.topics()).setAssignedPartitions(assignedPartitions).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(classicGroupMember.sessionTimeoutMs()).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection(classicGroupMember.supportedProtocols()))).build();
            consumerGroup.updateTargetAssignment(newMember.memberId(), new Assignment(assignedPartitions));
            consumerGroup.updateMember(newMember);
        });
        return consumerGroup;
    }

    public void createConsumerGroupRecords(List<CoordinatorRecord> records) {
        this.members().forEach((__, consumerGroupMember) -> records.add(CoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord(this.groupId(), consumerGroupMember)));
        records.add(CoordinatorRecordHelpers.newConsumerGroupEpochRecord(this.groupId(), this.groupEpoch()));
        this.members().forEach((consumerGroupMemberId, consumerGroupMember) -> records.add(CoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord(this.groupId(), consumerGroupMemberId, this.targetAssignment((String)consumerGroupMemberId).partitions())));
        records.add(CoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord(this.groupId(), this.groupEpoch()));
        this.members().forEach((__, consumerGroupMember) -> records.add(CoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord(this.groupId(), consumerGroupMember)));
    }

    public boolean supportsClassicProtocols(String memberProtocolType, Set<String> memberProtocols) {
        if ("consumer".equals(memberProtocolType)) {
            if (this.isEmpty()) {
                return !memberProtocols.isEmpty();
            }
            return memberProtocols.stream().anyMatch(name -> ((Integer)this.classicProtocolMembersSupportedProtocols.getOrDefault(name, (Object)0)).intValue() == this.numClassicProtocolMembers());
        }
        return false;
    }

    public boolean allMembersUseClassicProtocolExcept(String memberId) {
        return this.numClassicProtocolMembers() == this.members().size() - 1 && !this.getOrMaybeCreateMember(memberId, false).useClassicProtocol();
    }

    public boolean waitingOnUnreleasedPartition(ConsumerGroupMember member) {
        if (member.state() == MemberState.UNRELEASED_PARTITIONS) {
            for (Map.Entry<Uuid, Set<Integer>> entry : this.targetAssignment().get(member.memberId()).partitions().entrySet()) {
                Uuid topicId = entry.getKey();
                Set assignedPartitions = member.assignedPartitions().getOrDefault(topicId, Collections.emptySet());
                for (int partition : entry.getValue()) {
                    if (assignedPartitions.contains(partition) || this.currentPartitionEpoch(topicId, partition) == -1) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static enum ConsumerGroupState {
        EMPTY("Empty"),
        ASSIGNING("Assigning"),
        RECONCILING("Reconciling"),
        STABLE("Stable"),
        DEAD("Dead");

        private final String name;
        private final String lowerCaseName;

        private ConsumerGroupState(String name) {
            this.name = name;
            this.lowerCaseName = name.toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.name;
        }

        public String toLowerCaseString() {
            return this.lowerCaseName;
        }
    }
}

