/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.protobuf.Any;
import io.grpc.Channel;
import io.grpc.Context;
import io.grpc.InternalLogId;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.MessagePrinter;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsClientImpl;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsResourceType;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.AggregatedDiscoveryServiceGrpc;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class ControlPlaneClient {
    public static final String CLOSED_BY_SERVER = "Closed by server";
    private final SynchronizationContext syncContext;
    private final InternalLogId logId;
    private final XdsLogger logger;
    private final Bootstrapper.ServerInfo serverInfo;
    private final ManagedChannel channel;
    private final XdsClient.XdsResponseHandler xdsResponseHandler;
    private final XdsClient.ResourceStore resourceStore;
    private final Context context;
    private final ScheduledExecutorService timeService;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Stopwatch stopwatch;
    private final EnvoyProtoData.Node bootstrapNode;
    private final XdsClient.TimerLaunch timerLaunch;
    private final Map<XdsResourceType<?>, String> versions = new HashMap();
    private boolean shutdown;
    @Nullable
    private AbstractAdsStream adsStream;
    @Nullable
    private BackoffPolicy retryBackoffPolicy;
    @Nullable
    private SynchronizationContext.ScheduledHandle rpcRetryTimer;

    ControlPlaneClient(XdsClientImpl.XdsChannelFactory xdsChannelFactory, Bootstrapper.ServerInfo serverInfo, EnvoyProtoData.Node bootstrapNode, XdsClient.XdsResponseHandler xdsResponseHandler, XdsClient.ResourceStore resourceStore, Context context, ScheduledExecutorService timeService, SynchronizationContext syncContext, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier, XdsClient.TimerLaunch timerLaunch) {
        this.serverInfo = (Bootstrapper.ServerInfo)Preconditions.checkNotNull((Object)serverInfo, (Object)"serverInfo");
        this.channel = ((XdsClientImpl.XdsChannelFactory)Preconditions.checkNotNull((Object)xdsChannelFactory, (Object)"xdsChannelFactory")).create(serverInfo);
        this.xdsResponseHandler = (XdsClient.XdsResponseHandler)Preconditions.checkNotNull((Object)xdsResponseHandler, (Object)"xdsResponseHandler");
        this.resourceStore = (XdsClient.ResourceStore)Preconditions.checkNotNull((Object)resourceStore, (Object)"resourcesSubscriber");
        this.bootstrapNode = (EnvoyProtoData.Node)Preconditions.checkNotNull((Object)bootstrapNode, (Object)"bootstrapNode");
        this.context = (Context)Preconditions.checkNotNull((Object)context, (Object)"context");
        this.timeService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)timeService, (Object)"timeService");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)syncContext, (Object)"syncContext");
        this.backoffPolicyProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)backoffPolicyProvider, (Object)"backoffPolicyProvider");
        this.timerLaunch = (XdsClient.TimerLaunch)Preconditions.checkNotNull((Object)timerLaunch, (Object)"timerLaunch");
        this.stopwatch = (Stopwatch)((Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatchSupplier")).get();
        this.logId = InternalLogId.allocate((String)"xds-client", (String)serverInfo.target());
        this.logger = XdsLogger.withLogId(this.logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    Channel channel() {
        return this.channel;
    }

    void shutdown() {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ControlPlaneClient.this.shutdown = true;
                ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutting down");
                if (ControlPlaneClient.this.adsStream != null) {
                    ControlPlaneClient.this.adsStream.close((Exception)((Object)Status.CANCELLED.withDescription("shutdown").asException()));
                }
                if (ControlPlaneClient.this.rpcRetryTimer != null && ControlPlaneClient.this.rpcRetryTimer.isPending()) {
                    ControlPlaneClient.this.rpcRetryTimer.cancel();
                }
                ControlPlaneClient.this.channel.shutdown();
            }
        });
    }

    public String toString() {
        return this.logId.toString();
    }

    void adjustResourceSubscription(XdsResourceType<?> resourceType) {
        Collection<String> resources;
        if (this.isInBackoff()) {
            return;
        }
        if (this.adsStream == null) {
            this.startRpcStream();
        }
        if ((resources = this.resourceStore.getSubscribedResources(this.serverInfo, resourceType)) != null) {
            this.adsStream.sendDiscoveryRequest(resourceType, resources);
        }
    }

    void ackResponse(XdsResourceType<?> type, String versionInfo, String nonce) {
        this.versions.put(type, versionInfo);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending ACK for {0} update, nonce: {1}, current version: {2}", type.typeName(), nonce, versionInfo);
        Collection<String> resources = this.resourceStore.getSubscribedResources(this.serverInfo, type);
        if (resources == null) {
            resources = Collections.emptyList();
        }
        this.adsStream.sendDiscoveryRequest(type, versionInfo, resources, nonce, null);
    }

    void nackResponse(XdsResourceType<?> type, String nonce, String errorDetail) {
        String versionInfo = this.versions.getOrDefault(type, "");
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending NACK for {0} update, nonce: {1}, current version: {2}", type.typeName(), nonce, versionInfo);
        Collection<String> resources = this.resourceStore.getSubscribedResources(this.serverInfo, type);
        if (resources == null) {
            resources = Collections.emptyList();
        }
        this.adsStream.sendDiscoveryRequest(type, versionInfo, resources, nonce, errorDetail);
    }

    boolean isInBackoff() {
        return this.rpcRetryTimer != null && this.rpcRetryTimer.isPending();
    }

    boolean isReady() {
        return this.adsStream != null && this.adsStream.isReady();
    }

    void readyHandler() {
        if (!this.isReady()) {
            return;
        }
        if (this.isInBackoff()) {
            this.rpcRetryTimer.cancel();
            this.rpcRetryTimer = null;
        }
        this.timerLaunch.startSubscriberTimersIfNeeded(this.serverInfo);
    }

    private void startRpcStream() {
        Preconditions.checkState((this.adsStream == null ? 1 : 0) != 0, (Object)"Previous adsStream has not been cleared yet");
        this.adsStream = new AdsStreamV3();
        Context prevContext = this.context.attach();
        try {
            this.adsStream.start();
        }
        finally {
            this.context.detach(prevContext);
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "ADS stream started");
        this.stopwatch.reset().start();
    }

    @Nullable
    @VisibleForTesting
    XdsResourceType<?> fromTypeUrl(String typeUrl) {
        return this.resourceStore.getSubscribedResourceTypesWithTypeUrl().get(typeUrl);
    }

    private final class AdsStreamV3
    extends AbstractAdsStream {
        private StreamObserver<DiscoveryRequest> requestWriter;

        private AdsStreamV3() {
        }

        @Override
        public boolean isReady() {
            return this.requestWriter != null && ((ClientCallStreamObserver)this.requestWriter).isReady();
        }

        @Override
        void start() {
            AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceStub stub = AggregatedDiscoveryServiceGrpc.newStub((Channel)ControlPlaneClient.this.channel);
            final class AdsClientResponseObserver
            implements ClientResponseObserver<DiscoveryRequest, DiscoveryResponse> {
                AdsClientResponseObserver() {
                }

                public void beforeStart(ClientCallStreamObserver<DiscoveryRequest> requestStream) {
                    requestStream.setOnReadyHandler(ControlPlaneClient.this::readyHandler);
                }

                public void onNext(final DiscoveryResponse response) {
                    ControlPlaneClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            XdsResourceType<?> type = ControlPlaneClient.this.fromTypeUrl(response.getTypeUrl());
                            if (ControlPlaneClient.this.logger.isLoggable(XdsLogger.XdsLogLevel.DEBUG)) {
                                ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received {0} response:\n{1}", type, MessagePrinter.print(response));
                            }
                            if (type == null) {
                                ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Ignore an unknown type of DiscoveryResponse: {0}", response.getTypeUrl());
                                return;
                            }
                            AdsStreamV3.this.handleRpcResponse(type, response.getVersionInfo(), response.getResourcesList(), response.getNonce());
                        }
                    });
                }

                public void onError(final Throwable t) {
                    ControlPlaneClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            AdsStreamV3.this.handleRpcError(t);
                        }
                    });
                }

                public void onCompleted() {
                    ControlPlaneClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            AdsStreamV3.this.handleRpcCompleted();
                        }
                    });
                }
            }
            this.requestWriter = stub.streamAggregatedResources((StreamObserver<DiscoveryResponse>)new AdsClientResponseObserver());
        }

        @Override
        void sendDiscoveryRequest(XdsResourceType<?> type, String versionInfo, Collection<String> resources, String nonce, @Nullable String errorDetail) {
            Preconditions.checkState((this.requestWriter != null ? 1 : 0) != 0, (Object)"ADS stream has not been started");
            DiscoveryRequest.Builder builder = DiscoveryRequest.newBuilder().setVersionInfo(versionInfo).setNode(ControlPlaneClient.this.bootstrapNode.toEnvoyProtoNode()).addAllResourceNames(resources).setTypeUrl(type.typeUrl()).setResponseNonce(nonce);
            if (errorDetail != null) {
                com.google.rpc.Status error = com.google.rpc.Status.newBuilder().setCode(3).setMessage(errorDetail).build();
                builder.setErrorDetail(error);
            }
            DiscoveryRequest request = builder.build();
            this.requestWriter.onNext((Object)request);
            if (ControlPlaneClient.this.logger.isLoggable(XdsLogger.XdsLogLevel.DEBUG)) {
                ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sent DiscoveryRequest\n{0}", MessagePrinter.print(request));
            }
        }

        @Override
        void sendError(Exception error) {
            this.requestWriter.onError((Throwable)error);
        }
    }

    private abstract class AbstractAdsStream {
        private boolean responseReceived;
        private boolean closed;
        private final Map<XdsResourceType<?>, String> respNonces = new HashMap();

        private AbstractAdsStream() {
        }

        abstract void start();

        abstract void sendError(Exception var1);

        abstract boolean isReady();

        abstract void sendDiscoveryRequest(XdsResourceType<?> var1, String var2, Collection<String> var3, String var4, @Nullable String var5);

        final void sendDiscoveryRequest(XdsResourceType<?> type, Collection<String> resources) {
            ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending {0} request for resources: {1}", type, resources);
            this.sendDiscoveryRequest(type, ControlPlaneClient.this.versions.getOrDefault(type, ""), resources, this.respNonces.getOrDefault(type, ""), null);
        }

        final void handleRpcResponse(XdsResourceType<?> type, String versionInfo, List<Any> resources, String nonce) {
            Preconditions.checkNotNull(type, (Object)"type");
            if (this.closed) {
                return;
            }
            this.responseReceived = true;
            this.respNonces.put(type, nonce);
            ControlPlaneClient.this.xdsResponseHandler.handleResourceResponse(type, ControlPlaneClient.this.serverInfo, versionInfo, resources, nonce);
        }

        final void handleRpcError(Throwable t) {
            this.handleRpcStreamClosed(Status.fromThrowable((Throwable)t));
        }

        final void handleRpcCompleted() {
            this.handleRpcStreamClosed(Status.UNAVAILABLE.withDescription(ControlPlaneClient.CLOSED_BY_SERVER));
        }

        private void handleRpcStreamClosed(Status error) {
            if (this.closed) {
                return;
            }
            if (this.responseReceived || ControlPlaneClient.this.retryBackoffPolicy == null) {
                ControlPlaneClient.this.retryBackoffPolicy = ControlPlaneClient.this.backoffPolicyProvider.get();
            }
            long elapsed = ControlPlaneClient.this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            long delayNanos = Math.max(0L, ControlPlaneClient.this.retryBackoffPolicy.nextBackoffNanos() - elapsed);
            ControlPlaneClient.this.rpcRetryTimer = ControlPlaneClient.this.syncContext.schedule((Runnable)new RpcRetryTask(), delayNanos, TimeUnit.NANOSECONDS, ControlPlaneClient.this.timeService);
            Preconditions.checkArgument((!error.isOk() ? 1 : 0) != 0, (Object)"unexpected OK status");
            String errorMsg = error.getDescription() != null && error.getDescription().equals(ControlPlaneClient.CLOSED_BY_SERVER) ? "ADS stream closed with status {0}: {1}. Cause: {2}" : "ADS stream failed with status {0}: {1}. Cause: {2}";
            ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.ERROR, errorMsg, error.getCode(), error.getDescription(), error.getCause());
            this.closed = true;
            ControlPlaneClient.this.xdsResponseHandler.handleStreamClosed(error);
            this.cleanUp();
            ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Retry ADS stream in {0} ns", delayNanos);
        }

        private void close(Exception error) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            this.sendError(error);
        }

        private void cleanUp() {
            if (ControlPlaneClient.this.adsStream == this) {
                ControlPlaneClient.this.adsStream = null;
            }
        }
    }

    @VisibleForTesting
    final class RpcRetryTask
    implements Runnable {
        RpcRetryTask() {
        }

        @Override
        public void run() {
            if (ControlPlaneClient.this.shutdown) {
                return;
            }
            ControlPlaneClient.this.startRpcStream();
            HashSet subscribedResourceTypes = new HashSet(ControlPlaneClient.this.resourceStore.getSubscribedResourceTypesWithTypeUrl().values());
            for (XdsResourceType xdsResourceType : subscribedResourceTypes) {
                Collection<String> resources = ControlPlaneClient.this.resourceStore.getSubscribedResources(ControlPlaneClient.this.serverInfo, xdsResourceType);
                if (resources == null) continue;
                ControlPlaneClient.this.adsStream.sendDiscoveryRequest(xdsResourceType, resources);
            }
            ControlPlaneClient.this.xdsResponseHandler.handleStreamRestarted(ControlPlaneClient.this.serverInfo);
        }
    }
}

