/*
 * Decompiled with CFR 0.152.
 */
package kafka.assignor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.placement.CellDescriber;
import org.apache.kafka.metadata.placement.ClusterDescriber;
import org.apache.kafka.metadata.placement.TenantDescriber;
import org.apache.kafka.metadata.placement.UsableBroker;

public class ZkClusterDescriber
implements ClusterDescriber {
    private final Cluster cluster;
    private final CellDescriber cellDescriber;
    private final TenantDescriber tenantDescriber;

    public static List<List<Integer>> partitionInfosToReplicas(List<PartitionInfo> partitions) {
        if (partitions == null) {
            return Collections.emptyList();
        }
        ArrayList<List<Integer>> results = new ArrayList<List<Integer>>(partitions.size());
        for (PartitionInfo partition : partitions) {
            ArrayList<Integer> replicas = new ArrayList<Integer>(partition.replicas().length);
            for (Node node : partition.replicas()) {
                replicas.add(node.id());
            }
            results.add(replicas);
        }
        return results;
    }

    public ZkClusterDescriber(Cluster cluster, CellDescriber cellDescriber, TenantDescriber tenantDescriber) {
        this.cluster = cluster;
        this.cellDescriber = cellDescriber;
        this.tenantDescriber = tenantDescriber;
    }

    public Iterator<UsableBroker> usableBrokers() {
        return new UsableBrokerIterator(this.cluster, this.cellDescriber);
    }

    public Iterator<String> topicNames() {
        return this.cluster.topics().iterator();
    }

    public List<List<Integer>> replicasForTopicName(String topicName) {
        List partitions = this.cluster.partitionsForTopic(topicName);
        return ZkClusterDescriber.partitionInfosToReplicas(partitions);
    }

    public Uuid defaultDir(int brokerId) {
        return DirectoryId.MIGRATING;
    }

    public List<Integer> getTenantCellIds(String tenant) {
        return this.tenantDescriber.getTenantCellIds(tenant);
    }

    static class UsableBrokerIterator
    implements Iterator<UsableBroker> {
        private final Iterator<Node> iterator;
        private final CellDescriber cellDescriber;

        UsableBrokerIterator(Cluster cluster, CellDescriber cellDescriber) {
            this.iterator = cluster.nodes().iterator();
            this.cellDescriber = cellDescriber;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public UsableBroker next() {
            Node node = this.iterator.next();
            return new UsableBroker(node.id(), Optional.ofNullable(node.rack()), false, this.cellDescriber.getBrokerCellId(node.id()));
        }
    }
}

