/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.event;

import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kafka.catalog.MetadataEventUtils;
import kafka.catalog.ZKMetadataCollector;
import kafka.catalog.ZKMetadataCollectorContext;
import kafka.catalog.event.MetadataCollectorEvent;
import kafka.catalog.event.SnapshotEvent;
import kafka.catalog.metadata.ClusterLinkInfo;
import kafka.catalog.metadata.MirrorTopicInfo;
import kafka.catalog.metadata.TopicInfo;
import kafka.common.TenantHelpers;
import kafka.server.link.ClusterLinkConfig;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.queue.EventQueue;
import org.apache.kafka.storage.internals.log.LogConfig;

public class CacheBuildEvent
extends MetadataCollectorEvent {
    private int maxNumEntitiesProcess;

    public CacheBuildEvent(ZKMetadataCollector collector, int maxNumEntitiesProcess, Time time) {
        super(collector, time);
        this.maxNumEntitiesProcess = maxNumEntitiesProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        ZKMetadataCollectorContext context = this.context();
        Iterator<String> topicIter = context.initialTopics().iterator();
        int processed = 0;
        while (topicIter.hasNext() && processed < this.maxNumEntitiesProcess) {
            String topic = topicIter.next();
            try {
                MetadataEvent topicMetadataEvent;
                LogConfig logConfigsMap = this.getLogConfigsForTopic(context, topic);
                TopicInfo topicInfo = context.removeTopicFromInitialSnapshot(topic);
                if (topicInfo.mirrorTopicInfo().isPresent()) {
                    MirrorTopicInfo mirrorTopicInfo = topicInfo.mirrorTopicInfo().get();
                    topicMetadataEvent = MetadataEventUtils.topicMetadataEventFromLogConfig(logConfigsMap, TenantHelpers.extractLogicalName(topic), topicInfo.topicId(), topicInfo.partitions(), topicInfo.replicationFactors(), MetadataEventUtils.mirrorTopicMetadata(mirrorTopicInfo.linkId(), mirrorTopicInfo.linkName(), mirrorTopicInfo.sourceTopicId(), mirrorTopicInfo.sourceTopicName(), mirrorTopicInfo.mirrorTopicState(), mirrorTopicInfo.remoteClusterId(), null), context.config().fullConfigsEnable, null, null);
                } else {
                    topicMetadataEvent = MetadataEventUtils.topicMetadataEventFromLogConfig(logConfigsMap, TenantHelpers.extractLogicalName(topic), topicInfo.topicId(), topicInfo.partitions(), topicInfo.replicationFactors(), null, context.config().fullConfigsEnable, null, null);
                }
                Set<String> topicConfigOverrides = this.filterCatalogConfigOverride(logConfigsMap.overriddenConfigs);
                context.localStore().addTopicMetadataEvent(topicInfo.logicalClusterId(), topic, topicMetadataEvent, topicConfigOverrides, Collections.emptySet());
            }
            catch (Exception e) {
                LOG.error("Skipping topic '{}' due to", (Object)topic, (Object)e);
                context.catalogMetrics().collectorEventHandleErrorSensor.record();
            }
            finally {
                ++processed;
            }
        }
        Iterator<ClusterLinkInfo> clusterLinkIter = context.initialClusterLinks().iterator();
        while (clusterLinkIter.hasNext() && processed < this.maxNumEntitiesProcess) {
            ClusterLinkInfo clusterLink = clusterLinkIter.next();
            String linkName = clusterLink.clusterLinkName();
            Uuid linkId = clusterLink.clusterLinkId();
            try {
                ClusterLinkConfig config = this.getClusterLinkConfigForClusterLink(context, linkId);
                if (config == null) continue;
                context.removeClusterLinkFromInitialSnapshot(linkName);
                MetadataEvent clusterLinkMetadataEvent = MetadataEventUtils.clusterLinkMetadataEvent(TenantHelpers.extractLogicalName(linkName), linkId, clusterLink.linkMode(), clusterLink.connectionMode(), clusterLink.remoteClusterId(), clusterLink.localClusterId(), null, null);
                context.localStore().addClusterLinkMetadataEvent(clusterLink.logicalClusterId(), linkName, clusterLinkMetadataEvent);
            }
            catch (Exception e) {
                LOG.error("Skipping cluster link '{}' due to ", (Object)linkName, (Object)e);
                context.catalogMetrics().collectorEventHandleErrorSensor.record();
            }
            finally {
                ++processed;
            }
        }
        this.scheduleSnapshotOrNextCacheBuild(context);
    }

    private void scheduleSnapshotOrNextCacheBuild(ZKMetadataCollectorContext context) {
        if (!context.cacheInitialized()) {
            context.eventQueue().appendWithTag("CACHE_BUILD_EVENT", new CacheBuildEvent(this.collector, this.maxNumEntitiesProcess, this.time));
        } else {
            long delayNs = TimeUnit.NANOSECONDS.convert(context.config().snapshotInitDelaySec, TimeUnit.SECONDS);
            long currNs = this.time.nanoseconds();
            long passNs = currNs - context.startNs();
            long remainNs = Math.max(0L, delayNs - passNs);
            LOG.info("Finished cache build. Schedule SnapshotEvent in {} ns from now", (Object)remainNs);
            context.eventQueue().scheduleDeferred("SNAPSHOT_EVENT", (Function<OptionalLong, OptionalLong>)new EventQueue.DeadlineFunction(currNs + remainNs), new SnapshotEvent(this.collector, this.time));
        }
    }

    public String toString() {
        return "CacheBuildEvent(maxNumEntitiesProcess=" + this.maxNumEntitiesProcess + ')';
    }
}

