/*
 * Decompiled with CFR 0.152.
 */
package kafka.migration;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.controller.ControllerChannelContext;
import kafka.controller.KRaftControllerChannelManager;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.controller.StateChangeLogger;
import kafka.migration.MigrationControllerChannelContext;
import kafka.migration.MigrationControllerChannelContext$;
import kafka.migration.MigrationPropagator$;
import kafka.migration.MigrationPropagatorBatch;
import kafka.migration.MigrationTierTopicProducer;
import kafka.server.KafkaConfig;
import kafka.zk.ConfluentAssignmentMigration$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.migration.LegacyPropagator;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015w!\u0002\u0010 \u0011\u0003!c!\u0002\u0014 \u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003y\u0003\"\u0002\u0019\u0002\t\u0003\td\u0001\u0002\u0014 \u0001UC\u0001\"\u001a\u0003\u0003\u0002\u0003\u0006IA\u001a\u0005\tS\u0012\u0011\t\u0011)A\u0005U\"A\u0001\u000f\u0002B\u0001B\u0003%\u0011\u000fC\u0003/\t\u0011\u0005A\u000fC\u0004z\t\u0001\u0007I\u0011\u0002>\t\u000fy$\u0001\u0019!C\u0005\u007f\"9\u00111\u0002\u0003!B\u0013Y\b\"CA\u000b\t\t\u0007I\u0011AA\f\u0011!\tI\u0003\u0002Q\u0001\n\u0005e\u0001\"CA\u0016\t\t\u0007I\u0011AA\u0017\u0011!\tY\u0004\u0002Q\u0001\n\u0005=\u0002\"CA\u001f\t\t\u0007I\u0011AA \u0011!\t9\u0005\u0002Q\u0001\n\u0005\u0005\u0003\"CA%\t\t\u0007I\u0011BA&\u0011!\t\u0019\u0006\u0002Q\u0001\n\u00055\u0003\"CA+\t\t\u0007I\u0011AA,\u0011!\t)\u0007\u0002Q\u0001\n\u0005e\u0003bBA4\t\u0011%\u0011\u0011\u000e\u0005\b\u0003c\"A\u0011AA:\u0011\u001d\t)\b\u0002C\u0001\u0003gBq!a\u001e\u0005\t\u0003\nI\bC\u0004\u0002~\u0011!I!a \t\u000f\u0005\u001dF\u0001\"\u0011\u0002*\"9\u00111\u0018\u0003\u0005B\u0005u\u0006bBAb\t\u0011\u0005\u00131O\u0001\u0014\u001b&<'/\u0019;j_:\u0004&o\u001c9bO\u0006$xN\u001d\u0006\u0003A\u0005\n\u0011\"\\5he\u0006$\u0018n\u001c8\u000b\u0003\t\nQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002&\u00035\tqDA\nNS\u001e\u0014\u0018\r^5p]B\u0013x\u000e]1hCR|'o\u0005\u0002\u0002QA\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0013\u0002-\r\fGnY;mCR,'I]8lKJ\u001c\u0005.\u00198hKN$2A\r$T!\u0011I3'N\u001b\n\u0005QR#A\u0002+va2,'\u0007E\u00027{\u0001s!aN\u001e\u0011\u0005aRS\"A\u001d\u000b\u0005i\u001a\u0013A\u0002\u001fs_>$h(\u0003\u0002=U\u00051\u0001K]3eK\u001aL!AP \u0003\u0007M+GO\u0003\u0002=UA\u0011\u0011\tR\u0007\u0002\u0005*\u00111)I\u0001\bG2,8\u000f^3s\u0013\t)%I\u0001\u0004Ce>\\WM\u001d\u0005\u0006\u000f\u000e\u0001\r\u0001S\u0001\u0011aJ,go\u00117vgR,'/S7bO\u0016\u0004\"!S)\u000e\u0003)S!a\u0013'\u0002\u000b%l\u0017mZ3\u000b\u0005\tj%B\u0001(P\u0003\u0019\t\u0007/Y2iK*\t\u0001+A\u0002pe\u001eL!A\u0015&\u0003\u0019\rcWo\u001d;fe&k\u0017mZ3\t\u000bQ\u001b\u0001\u0019\u0001%\u0002\u0019\rdWo\u001d;fe&k\u0017mZ3\u0014\u0007\u00111f\f\u0005\u0002X96\t\u0001L\u0003\u0002Z5\u0006!A.\u00198h\u0015\u0005Y\u0016\u0001\u00026bm\u0006L!!\u0018-\u0003\r=\u0013'.Z2u!\ty6-D\u0001a\u0015\t\u0001\u0013M\u0003\u0002c\u0019\u0006AQ.\u001a;bI\u0006$\u0018-\u0003\u0002eA\n\u0001B*Z4bGf\u0004&o\u001c9bO\u0006$xN]\u0001\u0007]>$W-\u00133\u0011\u0005%:\u0017B\u00015+\u0005\rIe\u000e^\u0001\u0007G>tg-[4\u0011\u0005-tW\"\u00017\u000b\u00055\f\u0013AB:feZ,'/\u0003\u0002pY\nY1*\u00194lC\u000e{gNZ5h\u0003%\u0019G.^:uKJLE\r\u0005\u00027e&\u00111o\u0010\u0002\u0007'R\u0014\u0018N\\4\u0015\tU4x\u000f\u001f\t\u0003K\u0011AQ!\u001a\u0005A\u0002\u0019DQ!\u001b\u0005A\u0002)DQ\u0001\u001d\u0005A\u0002E\faaX5nC\u001e,W#A>\u0011\u0005%c\u0018BA?K\u00055iU\r^1eCR\f\u0017*\\1hK\u0006Qq,[7bO\u0016|F%Z9\u0015\t\u0005\u0005\u0011q\u0001\t\u0004S\u0005\r\u0011bAA\u0003U\t!QK\\5u\u0011!\tIACA\u0001\u0002\u0004Y\u0018a\u0001=%c\u00059q,[7bO\u0016\u0004\u0003fA\u0006\u0002\u0010A\u0019\u0011&!\u0005\n\u0007\u0005M!F\u0001\u0005w_2\fG/\u001b7f\u0003\u0011!\u0018.\\3\u0016\u0005\u0005e\u0001\u0003BA\u000e\u0003Ki!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u0006kRLGn\u001d\u0006\u0004\u0003Ga\u0015AB2p[6|g.\u0003\u0003\u0002(\u0005u!\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\n\u0011c\u001d;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s+\t\ty\u0003\u0005\u0003\u00022\u0005]RBAA\u001a\u0015\r\t)$I\u0001\u000bG>tGO]8mY\u0016\u0014\u0018\u0002BA\u001d\u0003g\u0011\u0011c\u0015;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s\u0003I\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0011\u0002\u001d\rD\u0017M\u001c8fY6\u000bg.Y4feV\u0011\u0011\u0011\t\t\u0005\u0003c\t\u0019%\u0003\u0003\u0002F\u0005M\"!H&SC\u001a$8i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u0002\u001f\rD\u0017M\u001c8fY6\u000bg.Y4fe\u0002\nAB]3rk\u0016\u001cHOQ1uG\",\"!!\u0014\u0011\u0007\u0015\ny%C\u0002\u0002R}\u0011\u0001$T5he\u0006$\u0018n\u001c8Qe>\u0004\u0018mZ1u_J\u0014\u0015\r^2i\u00035\u0011X-];fgR\u0014\u0015\r^2iA\u0005iR.[4sCRLwN\u001c+jKJ$v\u000e]5d!J|G-^2fe>\u0003H/\u0006\u0002\u0002ZA)\u0011&a\u0017\u0002`%\u0019\u0011Q\f\u0016\u0003\r=\u0003H/[8o!\r)\u0013\u0011M\u0005\u0004\u0003Gz\"AG'jOJ\fG/[8o)&,'\u000fV8qS\u000e\u0004&o\u001c3vG\u0016\u0014\u0018AH7jOJ\fG/[8o)&,'\u000fV8qS\u000e\u0004&o\u001c3vG\u0016\u0014x\n\u001d;!\u0003AiW\r^1eCR\f\u0007K]8wS\u0012,'\u000f\u0006\u0002\u0002lA!\u0011\u0011GA7\u0013\u0011\ty'a\r\u00031\r{g\u000e\u001e:pY2,'o\u00115b]:,GnQ8oi\u0016DH/A\u0004ti\u0006\u0014H/\u001e9\u0015\u0005\u0005\u0005\u0011\u0001C:ikR$wn\u001e8\u0002\u001fA,(\r\\5tQ6+G/\u00193bi\u0006$B!!\u0001\u0002|!)1*\u0007a\u0001w\u0006)R.\u0019;fe&\fG.\u001b>f!\u0006\u0014H/\u001b;j_:\u001cH\u0003BAA\u0003;\u0003\u0002\"a!\u0002\n\u00065\u0015QS\u0007\u0003\u0003\u000bS1!a\"[\u0003\u0011)H/\u001b7\n\t\u0005-\u0015Q\u0011\u0002\u0004\u001b\u0006\u0004\b\u0003BAH\u0003#k!!!\t\n\t\u0005M\u0015\u0011\u0005\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\u0011\t9*!'\u000e\u0003\u0005L1!a'b\u0005U\u0001\u0016M\u001d;ji&|gNU3hSN$(/\u0019;j_:Dq!a(\u001b\u0001\u0004\t\t+A\u0006u_BL7m]%nC\u001e,\u0007cA%\u0002$&\u0019\u0011Q\u0015&\u0003\u0017Q{\u0007/[2t\u00136\fw-Z\u0001#g\u0016tGM\u0015)DgR{'I]8lKJ\u001chI]8n\u001b\u0016$\u0018\rZ1uC\u0012+G\u000e^1\u0015\u0011\u0005\u0005\u00111VA[\u0003oCq!!,\u001c\u0001\u0004\ty+A\u0003eK2$\u0018\rE\u0002J\u0003cK1!a-K\u00055iU\r^1eCR\fG)\u001a7uC\")1j\u0007a\u0001w\"1\u0011\u0011X\u000eA\u0002\u0019\f\u0011C_6D_:$(o\u001c7mKJ,\u0005o\\2i\u0003\t\u001aXM\u001c3S!\u000e\u001bHk\u001c\"s_.,'o\u001d$s_6lU\r^1eCR\f\u0017*\\1hKR1\u0011\u0011AA`\u0003\u0003DQa\u0013\u000fA\u0002mDa!!/\u001d\u0001\u00041\u0017!B2mK\u0006\u0014\b")
public class MigrationPropagator
implements LegacyPropagator {
    private volatile MetadataImage _image = MetadataImage.EMPTY;
    private final Time time = Time.SYSTEM;
    private final StateChangeLogger stateChangeLogger;
    private final KRaftControllerChannelManager channelManager;
    private final MigrationPropagatorBatch requestBatch;
    private final Option<MigrationTierTopicProducer> migrationTierTopicProducerOpt;

    public static Tuple2<scala.collection.immutable.Set<Broker>, scala.collection.immutable.Set<Broker>> calculateBrokerChanges(ClusterImage prevClusterImage, ClusterImage clusterImage) {
        return MigrationPropagator$.MODULE$.calculateBrokerChanges(prevClusterImage, clusterImage);
    }

    private MetadataImage _image() {
        return this._image;
    }

    private void _image_$eq(MetadataImage x$1) {
        this._image = x$1;
    }

    public Time time() {
        return this.time;
    }

    public StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public KRaftControllerChannelManager channelManager() {
        return this.channelManager;
    }

    private MigrationPropagatorBatch requestBatch() {
        return this.requestBatch;
    }

    public Option<MigrationTierTopicProducer> migrationTierTopicProducerOpt() {
        return this.migrationTierTopicProducerOpt;
    }

    private ControllerChannelContext metadataProvider() {
        return new MigrationControllerChannelContext(this._image());
    }

    public void startup() {
        this.channelManager().startup((Set<Broker>)Predef$.MODULE$.Set().empty());
    }

    public void shutdown() {
        this.clear();
        this.migrationTierTopicProducerOpt().foreach((Function1 & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        this.channelManager().shutdown();
    }

    /*
     * WARNING - void declaration
     */
    public void publishMetadata(MetadataImage image) {
        void var5_5;
        void var4_4;
        MetadataImage oldImage = this._image();
        Tuple2<scala.collection.immutable.Set<Broker>, scala.collection.immutable.Set<Broker>> tuple2 = MigrationPropagator$.MODULE$.calculateBrokerChanges(oldImage.cluster(), image.cluster());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set addedBrokers = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set removedBrokers = (scala.collection.immutable.Set)tuple2._2();
        if ((var4_4.nonEmpty() || var5_5.nonEmpty()) && this.stateChangeLogger().logger().underlying().isInfoEnabled()) {
            this.stateChangeLogger().logger().underlying().info("Adding brokers {}, removing brokers {}.", new Object[]{var4_4, var5_5});
        }
        var5_5.foreach((Function1 & Serializable)broker -> {
            MigrationPropagator.$anonfun$publishMetadata$1(this, broker);
            return BoxedUnit.UNIT;
        });
        var4_4.foreach((Function1 & Serializable)broker -> {
            MigrationPropagator.$anonfun$publishMetadata$2(this, broker);
            return BoxedUnit.UNIT;
        });
        this._image_$eq(image);
    }

    private Map<TopicPartition, PartitionRegistration> materializePartitions(TopicsImage topicsImage) {
        HashMap<TopicPartition, PartitionRegistration> result = new HashMap<TopicPartition, PartitionRegistration>();
        topicsImage.topicsById().values().forEach(topic -> topic.partitions().forEach((key, value) -> result.put(new TopicPartition(topic.name(), Predef$.MODULE$.Integer2int(key)), (PartitionRegistration)value)));
        return result;
    }

    public void sendRPCsToBrokersFromMetadataDelta(MetadataDelta delta, MetadataImage image, int zkControllerEpoch) {
        boolean brokersChanged;
        this.publishMetadata(image);
        this.requestBatch().newBatch();
        delta.getOrCreateTopicsDelta();
        delta.getOrCreateClusterDelta();
        scala.collection.immutable.Set changedZkBrokers = ((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(delta.clusterDelta().changedBrokers().values()).asScala().map((Function1 & Serializable)x$7 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$7)))).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MigrationPropagator.$anonfun$sendRPCsToBrokersFromMetadataDelta$2(x0$1)))).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)MigrationPropagator.$anonfun$sendRPCsToBrokersFromMetadataDelta$3(x$8)))).toSet();
        scala.collection.immutable.Set oldZkBrokers = (scala.collection.immutable.Set)((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(image.cluster().brokers().values()).asScala().filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isMigratingZkBroker()))).map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.id()))).toSet().$minus$minus((IterableOnce)changedZkBrokers);
        boolean bl = brokersChanged = !delta.clusterDelta().changedBrokers().isEmpty();
        if (changedZkBrokers.nonEmpty()) {
            this.requestBatch().addUpdateMetadataRequestForBrokers((Seq<Object>)changedZkBrokers.toSeq(), (Set<TopicPartition>)CollectionConverters$.MODULE$.MapHasAsScala(this.materializePartitions(image.topics())).asScala().keySet());
        }
        if (brokersChanged) {
            this.requestBatch().addUpdateMetadataRequestForBrokers((Seq<Object>)oldZkBrokers.toSeq());
        }
        this.requestBatch().sendRequestsToBrokers(zkControllerEpoch);
        this.requestBatch().newBatch();
        this.requestBatch().setUpdateType(AbstractControlRequest.Type.INCREMENTAL);
        if (changedZkBrokers.nonEmpty()) {
            CollectionConverters$.MODULE$.MapHasAsScala(this.materializePartitions(image.topics())).asScala().foreach((Function1 & Serializable)x0$2 -> {
                MigrationPropagator.$anonfun$sendRPCsToBrokersFromMetadataDelta$6(this, image, changedZkBrokers, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        if (!delta.topicsDelta().deletedTopicIds().isEmpty() || !delta.topicsDelta().changedTopics().isEmpty()) {
            this.requestBatch().addUpdateMetadataRequestForBrokers((Seq<Object>)oldZkBrokers.toSeq());
        }
        CollectionConverters$.MODULE$.SetHasAsScala(delta.topicsDelta().deletedTopicIds()).asScala().foreach((Function1 & Serializable)deletedTopicId -> {
            MigrationPropagator.$anonfun$sendRPCsToBrokersFromMetadataDelta$7(this, delta, image, oldZkBrokers, zkControllerEpoch, deletedTopicId);
            return BoxedUnit.UNIT;
        });
        CollectionConverters$.MODULE$.MapHasAsScala(delta.topicsDelta().changedTopics()).asScala().foreach((Function1 & Serializable)x0$4 -> {
            MigrationPropagator.$anonfun$sendRPCsToBrokersFromMetadataDelta$11(this, image, delta, x0$4);
            return BoxedUnit.UNIT;
        });
        this.requestBatch().sendRequestsToBrokers(zkControllerEpoch);
    }

    public void sendRPCsToBrokersFromMetadataImage(MetadataImage image, int zkControllerEpoch) {
        this.publishMetadata(image);
        scala.collection.immutable.Seq zkBrokers = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(image.cluster().brokers().values()).asScala().filter((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isMigratingZkBroker()))).map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.id()))).toSeq();
        Map<TopicPartition, PartitionRegistration> partitions = this.materializePartitions(image.topics());
        this.requestBatch().newBatch();
        this.requestBatch().addUpdateMetadataRequestForBrokers((Seq<Object>)zkBrokers, (Set<TopicPartition>)CollectionConverters$.MODULE$.SetHasAsScala(partitions.keySet()).asScala());
        this.requestBatch().sendRequestsToBrokers(zkControllerEpoch);
        this.requestBatch().newBatch();
        this.requestBatch().setUpdateType(AbstractControlRequest.Type.FULL);
        CollectionConverters$.MODULE$.MapHasAsScala(partitions).asScala().foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                PartitionRegistration partitionRegistration = (PartitionRegistration)x0$1._2();
                Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt = MigrationControllerChannelContext$.MODULE$.partitionLeadershipInfo(image, tp);
                if (leaderIsrAndControllerEpochOpt instanceof Some) {
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)leaderIsrAndControllerEpochOpt).value();
                    ReplicaAssignment replicaAssignment = ConfluentAssignmentMigration$.MODULE$.fromKRaftToZkAssignment(partitionRegistration);
                    this.requestBatch().addLeaderAndIsrRequestForBrokers(replicaAssignment.replicas(), tp, leaderIsrAndControllerEpoch, replicaAssignment, true);
                    return BoxedUnit.UNIT;
                }
                if (None$.MODULE$.equals(leaderIsrAndControllerEpochOpt)) {
                    return None$.MODULE$;
                }
                throw new MatchError(leaderIsrAndControllerEpochOpt);
            }
            throw new MatchError(null);
        });
        this.requestBatch().sendRequestsToBrokers(zkControllerEpoch);
    }

    public void clear() {
        this.requestBatch().clear();
    }

    public static final /* synthetic */ void $anonfun$publishMetadata$1(MigrationPropagator $this, Broker broker) {
        $this.channelManager().removeBroker(broker.id());
    }

    public static final /* synthetic */ void $anonfun$publishMetadata$2(MigrationPropagator $this, Broker broker) {
        $this.channelManager().addBroker(broker);
    }

    public static final /* synthetic */ boolean $anonfun$sendRPCsToBrokersFromMetadataDelta$2(Option x0$1) {
        if (None$.MODULE$.equals(x0$1)) {
            return false;
        }
        if (x0$1 instanceof Some) {
            BrokerRegistration registration = (BrokerRegistration)((Some)x0$1).value();
            return registration.isMigratingZkBroker() && !registration.fenced();
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ int $anonfun$sendRPCsToBrokersFromMetadataDelta$3(Option x$8) {
        return ((BrokerRegistration)x$8.get()).id();
    }

    public static final /* synthetic */ void $anonfun$sendRPCsToBrokersFromMetadataDelta$6(MigrationPropagator $this, MetadataImage image$1, scala.collection.immutable.Set changedZkBrokers$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartition tp = (TopicPartition)x0$2._1();
            PartitionRegistration partitionRegistration = (PartitionRegistration)x0$2._2();
            scala.collection.immutable.Set replicas = Predef$.MODULE$.wrapIntArray(partitionRegistration.replicas).toSet();
            Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt = MigrationControllerChannelContext$.MODULE$.partitionLeadershipInfo(image$1, tp);
            scala.collection.immutable.Set newBrokersWithReplicas = (scala.collection.immutable.Set)replicas.intersect((Set)changedZkBrokers$1);
            if (newBrokersWithReplicas.nonEmpty()) {
                if (leaderIsrAndControllerEpochOpt instanceof Some) {
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)leaderIsrAndControllerEpochOpt).value();
                    ReplicaAssignment replicaAssignment = ConfluentAssignmentMigration$.MODULE$.fromKRaftToZkAssignment(partitionRegistration);
                    $this.requestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)newBrokersWithReplicas.toSeq(), tp, leaderIsrAndControllerEpoch, replicaAssignment, true);
                    return;
                }
                if (None$.MODULE$.equals(leaderIsrAndControllerEpochOpt)) {
                    return;
                }
                throw new MatchError(leaderIsrAndControllerEpochOpt);
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$sendRPCsToBrokersFromMetadataDelta$10(MetadataImage image$1, TopicImage deletedTopic$1, Uuid deletedTopicId$1, Integer partition$1, int zkControllerEpoch$1, MigrationTierTopicProducer tierTopicProducer) {
        if (!tierTopicProducer.isInitialized()) {
            tierTopicProducer.initialize(image$1);
        }
        if (!tierTopicProducer.isStarted()) {
            tierTopicProducer.start();
        }
        tierTopicProducer.queuePartitionDeleteInitiate(deletedTopic$1.name(), deletedTopicId$1, Predef$.MODULE$.Integer2int(partition$1), zkControllerEpoch$1);
    }

    public static final /* synthetic */ void $anonfun$sendRPCsToBrokersFromMetadataDelta$8(MigrationPropagator $this, TopicImage deletedTopic$1, MetadataImage image$1, scala.collection.immutable.Set oldZkBrokers$1, int zkControllerEpoch$1, Uuid deletedTopicId$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            Integer partition = (Integer)x0$3._1();
            PartitionRegistration partitionRegistration = (PartitionRegistration)x0$3._2();
            TopicPartition tp = new TopicPartition(deletedTopic$1.name(), Predef$.MODULE$.Integer2int(partition));
            int[] offlineReplicas = (int[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.intArrayOps(partitionRegistration.replicas), (Function1)(JFunction1.mcZI.sp & Serializable)x$11 -> MigrationControllerChannelContext$.MODULE$.isReplicaOnline(image$1, x$11, (scala.collection.immutable.Set<Object>)Predef$.MODULE$.wrapIntArray(partitionRegistration$1.replicas).toSet()));
            LeaderAndIsr deletedLeaderAndIsr = LeaderAndIsr$.MODULE$.duringDelete((List<Object>)Predef$.MODULE$.wrapIntArray(partitionRegistration.isr).toList());
            $this.requestBatch().addStopReplicaRequestForBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(partitionRegistration.replicas), tp, true);
            ConfluentAssignmentMigration$.MODULE$.fromKRaftToZkAssignment(partitionRegistration).effectiveObservers();
            $this.requestBatch().addUpdateMetadataRequestForBrokers((Seq<Object>)oldZkBrokers$1.toSeq(), zkControllerEpoch$1, tp, deletedLeaderAndIsr.leader(), deletedLeaderAndIsr.leaderEpoch(), deletedLeaderAndIsr.partitionEpoch(), deletedLeaderAndIsr.isr(), (Seq<Object>)Predef$.MODULE$.wrapIntArray(partitionRegistration.replicas), ConfluentAssignmentMigration$.MODULE$.fromKRaftToZkAssignment(partitionRegistration).effectiveObservers(), (Seq<Object>)Predef$.MODULE$.wrapIntArray(offlineReplicas));
            $this.migrationTierTopicProducerOpt().foreach((Function1 & Serializable)tierTopicProducer -> {
                MigrationPropagator.$anonfun$sendRPCsToBrokersFromMetadataDelta$10(image$1, deletedTopic$1, deletedTopicId$1, partition, zkControllerEpoch$1, tierTopicProducer);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$sendRPCsToBrokersFromMetadataDelta$7(MigrationPropagator $this, MetadataDelta delta$1, MetadataImage image$1, scala.collection.immutable.Set oldZkBrokers$1, int zkControllerEpoch$1, Uuid deletedTopicId) {
        TopicImage deletedTopic = delta$1.image().topics().getTopic(deletedTopicId);
        CollectionConverters$.MODULE$.MapHasAsScala(deletedTopic.partitions()).asScala().foreach((Function1 & Serializable)x0$3 -> {
            MigrationPropagator.$anonfun$sendRPCsToBrokersFromMetadataDelta$8($this, deletedTopic, image$1, oldZkBrokers$1, zkControllerEpoch$1, deletedTopicId, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$sendRPCsToBrokersFromMetadataDelta$12(MigrationPropagator $this, TopicDelta topicDelta$1, MetadataImage image$1, MetadataDelta delta$1, Tuple2 x0$5) {
        if (x0$5 != null) {
            Integer partition = (Integer)x0$5._1();
            PartitionRegistration partitionRegistration = (PartitionRegistration)x0$5._2();
            TopicPartition tp = new TopicPartition(topicDelta$1.name(), Predef$.MODULE$.Integer2int(partition));
            Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt = MigrationControllerChannelContext$.MODULE$.partitionLeadershipInfo(image$1, tp);
            if (leaderIsrAndControllerEpochOpt instanceof Some) {
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)leaderIsrAndControllerEpochOpt).value();
                ReplicaAssignment replicaAssignment = ConfluentAssignmentMigration$.MODULE$.fromKRaftToZkAssignment(partitionRegistration);
                $this.requestBatch().addLeaderAndIsrRequestForBrokers(replicaAssignment.replicas(), tp, leaderIsrAndControllerEpoch, replicaAssignment, true);
            } else if (!None$.MODULE$.equals(leaderIsrAndControllerEpochOpt)) {
                throw new MatchError(leaderIsrAndControllerEpochOpt);
            }
            scala.collection.immutable.Set oldReplicas = (scala.collection.immutable.Set)Option$.MODULE$.apply((Object)delta$1.image().topics().getPartition(topicDelta$1.id(), tp.partition())).map((Function1 & Serializable)x$12 -> Predef$.MODULE$.wrapIntArray(x$12.replicas).toSet()).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
            scala.collection.immutable.Set newReplicas = Predef$.MODULE$.wrapIntArray(partitionRegistration.replicas).toSet();
            scala.collection.immutable.Set removedReplicas = (scala.collection.immutable.Set)oldReplicas.$minus$minus((IterableOnce)newReplicas);
            if (removedReplicas.nonEmpty()) {
                $this.requestBatch().addStopReplicaRequestForBrokers((Seq<Object>)removedReplicas.toSeq(), tp, true);
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$sendRPCsToBrokersFromMetadataDelta$11(MigrationPropagator $this, MetadataImage image$1, MetadataDelta delta$1, Tuple2 x0$4) {
        if (x0$4 != null) {
            TopicDelta topicDelta = (TopicDelta)x0$4._2();
            CollectionConverters$.MODULE$.MapHasAsScala(topicDelta.partitionChanges()).asScala().foreach((Function1 & Serializable)x0$5 -> {
                MigrationPropagator.$anonfun$sendRPCsToBrokersFromMetadataDelta$12($this, topicDelta, image$1, delta$1, x0$5);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public MigrationPropagator(int nodeId, KafkaConfig config, String clusterId) {
        this.stateChangeLogger = new StateChangeLogger(nodeId, true, (Option<Object>)None$.MODULE$);
        this.channelManager = new KRaftControllerChannelManager((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> this._image().highestOffsetAndEpoch().epoch(), config, this.time(), new Metrics(), this.stateChangeLogger(), (Option<String>)None$.MODULE$);
        this.requestBatch = new MigrationPropagatorBatch(config, (Function0<ControllerChannelContext>)(Function0 & Serializable)() -> this.metadataProvider(), (Function0<MetadataVersion>)(Function0 & Serializable)() -> this._image().features().metadataVersion(), this.channelManager(), this.stateChangeLogger());
        this.migrationTierTopicProducerOpt = Predef$.MODULE$.Boolean2boolean(config.confluentConfig().tierFeature()) ? Option$.MODULE$.apply((Object)new MigrationTierTopicProducer(config, clusterId, this.time())) : Option$.MODULE$.empty();
    }
}

