/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.schedulers;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kafka.restore.RestoreMetricsManager;
import kafka.restore.messages.CopyObjectInStoreResponse;
import kafka.restore.messages.ListObjectsInStoreResponse;
import kafka.restore.messages.MessageResponse;
import kafka.restore.messages.MessageResult;
import kafka.restore.messages.MessageStatusCode;
import kafka.restore.messages.MultipleResponseHandler;
import kafka.restore.messages.RestoreObjectsInStoreRequest;
import kafka.restore.messages.RestoreObjectsInStoreResponse;
import kafka.restore.operators.SegmentStateAndPath;
import kafka.restore.schedulers.AsyncServiceSchedulerResultsReceiver;
import kafka.tier.state.SegmentState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreObjectMultipleResponseHandler
implements MultipleResponseHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestoreObjectMultipleResponseHandler.class);
    private final AsyncServiceSchedulerResultsReceiver resultsReceiver;
    private final RestoreObjectsInStoreRequest parentRequest;
    private final RestoreMetricsManager restoreMetricsManager;
    private final Set<UUID> listObjectResponseNotReceived = new HashSet<UUID>();
    private final Set<String> restoreObjectResponseNotReceived = new HashSet<String>();
    private final Set<UUID> segmentRestoreFailed = new HashSet<UUID>();

    public RestoreObjectMultipleResponseHandler(RestoreObjectsInStoreRequest parentRequest, AsyncServiceSchedulerResultsReceiver resultsReceiver, RestoreMetricsManager restoreMetricsManager) {
        this.resultsReceiver = resultsReceiver;
        this.parentRequest = parentRequest;
        this.restoreMetricsManager = restoreMetricsManager;
        this.listObjectResponseNotReceived.addAll(parentRequest.getSegmentStateAndPathMap().keySet());
    }

    @Override
    public synchronized void addReceivedResponse(MessageResponse response) {
        LOGGER.debug("received MessageResponse: " + response);
        if (response instanceof ListObjectsInStoreResponse) {
            ListObjectsInStoreResponse resp = (ListObjectsInStoreResponse)response;
            this.listObjectResponseNotReceived.remove(resp.getSegmentId());
            MessageResult result = response.getResult();
            if (result == MessageResult.SUCCESS) {
                this.restoreObjectResponseNotReceived.addAll(resp.getObjectMap().keySet());
            } else {
                this.segmentRestoreFailed.add(resp.getSegmentId());
            }
        } else if (response instanceof CopyObjectInStoreResponse) {
            MessageResult result;
            boolean isSegmentFile;
            CopyObjectInStoreResponse resp = (CopyObjectInStoreResponse)response;
            this.restoreObjectResponseNotReceived.remove(resp.getObjectPath());
            long bytes = -1L;
            boolean bl = isSegmentFile = resp.getObjectPath().endsWith(".segment") || resp.getObjectPath().endsWith(".segment-with-metadata");
            if (isSegmentFile) {
                Map<UUID, SegmentStateAndPath> map = this.parentRequest.getSegmentStateAndPathMap();
                SegmentState segmentState = map.get(resp.getSegmentId()).segmentState();
                bytes = segmentState.size();
            }
            if ((result = response.getResult()) == MessageResult.SUCCESS) {
                this.restoreMetricsManager.update("RestoreFilesSuccess", 1L);
                if (isSegmentFile) {
                    this.restoreMetricsManager.update("RestoreSegmentsSuccess", 1L);
                    this.restoreMetricsManager.update("RestoreBytesSuccess", bytes);
                    this.restoreMetricsManager.recordRestoreOverallRate();
                }
            } else {
                this.segmentRestoreFailed.add(resp.getSegmentId());
                this.restoreMetricsManager.update("RestoreFilesFailed", 1L);
                if (isSegmentFile) {
                    this.restoreMetricsManager.update("RestoreSegmentsFailed", 1L);
                    this.restoreMetricsManager.update("RestoreBytesFailed", bytes);
                }
            }
        } else {
            LOGGER.error("the response type is not supported: " + response.getClass().getName());
        }
        if (this.receivedAllResponses()) {
            LOGGER.debug("[" + this.parentRequest.getTopic() + "-" + this.parentRequest.getPartition() + "] all responses received, report response to Orchestrator with " + this.segmentRestoreFailed.size() + " segments restore failed");
            this.resultsReceiver.reportServiceSchedulerResponse(new RestoreObjectsInStoreResponse(0, this.parentRequest.getTopic(), this.parentRequest.getPartition(), this.parentRequest.getUuid(), MessageStatusCode.OK, MessageResult.SUCCESS, this.segmentRestoreFailed));
        }
    }

    @Override
    public synchronized boolean receivedAllResponses() {
        LOGGER.debug("segmentIdsInListObjectRequests size: " + this.listObjectResponseNotReceived.size() + ", requestIdsOfRestoreRequests size: " + this.restoreObjectResponseNotReceived.size());
        return this.listObjectResponseNotReceived.isEmpty() && this.restoreObjectResponseNotReceived.isEmpty();
    }
}

