/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.statemachine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kafka.restore.MessageEmitter;
import kafka.restore.RestoreMetricsManager;
import kafka.restore.configmap.NodeConfig;
import kafka.restore.db.Job;
import kafka.restore.db.PartitionRestoreContext;
import kafka.restore.messages.KafkaPreConditionCheckRequest;
import kafka.restore.messages.MessageRequest;
import kafka.restore.snapshot.FtpsStateForRestore;
import kafka.restore.statemachine.RestoreFiniteStateMachine;
import kafka.restore.statemachine.api.Event;
import kafka.restore.statemachine.api.FiniteStateMachine;
import kafka.restore.statemachine.api.Transition;
import kafka.restore.statemachine.transitions.FenceEventSentToPartitionFencedTransition;
import kafka.restore.statemachine.transitions.ForceRestoreEventSentToPartitionRestoredTransition;
import kafka.restore.statemachine.transitions.FtpsFetchedToFtpsRepairedTransition;
import kafka.restore.statemachine.transitions.FtpsFetchedToPartitionRestoredTransition;
import kafka.restore.statemachine.transitions.FtpsReconciledToFtpsUploadedTransition;
import kafka.restore.statemachine.transitions.FtpsRepairedToFtpsReconciledTransition;
import kafka.restore.statemachine.transitions.FtpsRepairedToSegmentsRepairedTransition;
import kafka.restore.statemachine.transitions.FtpsUploadedToForceRestoreEventSentTransition;
import kafka.restore.statemachine.transitions.PartitionFencedToFtpsFetchedTransition;
import kafka.restore.statemachine.transitions.PartitionFencedToFtpsRepairedTransition;
import kafka.restore.statemachine.transitions.PartitionFencedToPartitionRestoredTransition;
import kafka.restore.statemachine.transitions.PartitionRestoredToRestoreStartOffsetEventSentTransition;
import kafka.restore.statemachine.transitions.PreConditionReadyToFenceEventSentTransition;
import kafka.restore.statemachine.transitions.RestoreStartOffsetEventSentToStartOffsetRestoredTransition;
import kafka.restore.statemachine.transitions.SegmentsRepairedToFtpsReconciledTransition;
import kafka.restore.statemachine.transitions.StartToPreConditionReadyTransition;
import kafka.tier.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachineController {
    private static final Logger LOGGER = LoggerFactory.getLogger(StateMachineController.class);
    private final HashMap<TopicPartition, FiniteStateMachine> inProgressMap = new HashMap();
    private final HashMap<TopicPartition, FiniteStateMachine> waitingMap = new HashMap();
    private final HashMap<TopicPartition, FiniteStateMachine> failedMap = new HashMap();
    private final HashMap<TopicPartition, FiniteStateMachine> completedMap = new HashMap();
    private final Job restoreJob;
    private final MessageEmitter messageEmitter;
    private final RestoreMetricsManager restoreMetricsManager;
    private final Map<TopicIdPartition, FtpsStateForRestore> ftpsMap;

    public StateMachineController(Job restoreJob, MessageEmitter messageEmitter, RestoreMetricsManager restoreMetricsManager) {
        this(restoreJob, messageEmitter, restoreMetricsManager, null);
    }

    public StateMachineController(Job restoreJob, MessageEmitter messageEmitter, RestoreMetricsManager restoreMetricsManager, Map<TopicIdPartition, FtpsStateForRestore> ftpsMap) {
        this.restoreJob = restoreJob;
        this.messageEmitter = messageEmitter;
        this.restoreMetricsManager = restoreMetricsManager;
        this.ftpsMap = ftpsMap;
        this.buildStateMachinesFromDB();
    }

    private synchronized void buildStateMachinesFromDB() {
        HashSet<Transition<Event>> transitions = new HashSet<Transition<Event>>();
        transitions.add(new StartToPreConditionReadyTransition(this.messageEmitter));
        transitions.add(new PreConditionReadyToFenceEventSentTransition(this.messageEmitter));
        transitions.add(new FenceEventSentToPartitionFencedTransition(this.messageEmitter));
        transitions.add(new ForceRestoreEventSentToPartitionRestoredTransition(this.messageEmitter));
        transitions.add(new FtpsFetchedToFtpsRepairedTransition(this.messageEmitter));
        transitions.add(new FtpsFetchedToPartitionRestoredTransition(this.messageEmitter));
        transitions.add(new FtpsReconciledToFtpsUploadedTransition(this.messageEmitter));
        transitions.add(new FtpsRepairedToFtpsReconciledTransition(this.messageEmitter));
        transitions.add(new FtpsRepairedToSegmentsRepairedTransition(this.messageEmitter));
        transitions.add(new FtpsUploadedToForceRestoreEventSentTransition(this.messageEmitter));
        transitions.add(new PartitionFencedToFtpsFetchedTransition(this.messageEmitter));
        transitions.add(new PartitionFencedToFtpsRepairedTransition(this.messageEmitter));
        transitions.add(new PartitionFencedToPartitionRestoredTransition(this.messageEmitter));
        transitions.add(new PartitionRestoredToRestoreStartOffsetEventSentTransition(this.messageEmitter));
        transitions.add(new RestoreStartOffsetEventSentToStartOffsetRestoredTransition(this.messageEmitter));
        transitions.add(new SegmentsRepairedToFtpsReconciledTransition(this.messageEmitter));
        Map<TopicPartition, PartitionRestoreContext> contextMap = this.restoreJob.partitionRestoreContextMap;
        for (TopicPartition tp : contextMap.keySet()) {
            PartitionRestoreContext ctx = contextMap.get(tp);
            HashMap<TopicPartition, FiniteStateMachine> map = null;
            switch (ctx.status) {
                case COMPLETED: {
                    map = this.completedMap;
                    break;
                }
                case FAILED: {
                    map = this.failedMap;
                    break;
                }
                default: {
                    map = this.waitingMap;
                }
            }
            TopicIdPartition tpid = new TopicIdPartition(tp.topic(), ctx.topicId(), tp.partition());
            FtpsStateForRestore ftpsForRestore = this.ftpsMap != null ? this.ftpsMap.get(tpid) : null;
            LOGGER.debug(String.format("[%s]: add ftpsForRestore in StateMachine", tp));
            map.put(tp, new RestoreFiniteStateMachine(ctx, transitions, ftpsForRestore));
        }
    }

    public synchronized int waitingCount() {
        return this.waitingMap.size();
    }

    public synchronized int inProgressCount() {
        return this.inProgressMap.size();
    }

    public synchronized int failedCount() {
        return this.failedMap.size();
    }

    public synchronized int completedCount() {
        return this.completedMap.size();
    }

    public synchronized void moveToFailMap(TopicPartition tp) {
        if (this.inProgressMap.containsKey(tp)) {
            this.failedMap.put(tp, this.inProgressMap.remove(tp));
        } else if (this.waitingMap.containsKey(tp)) {
            this.failedMap.put(tp, this.waitingMap.remove(tp));
        }
        this.maybeMarkJobCompleted();
    }

    public synchronized void moveToCompleteSet(TopicPartition tp) {
        if (this.inProgressMap.containsKey(tp)) {
            this.completedMap.put(tp, this.inProgressMap.remove(tp));
        } else if (this.waitingMap.containsKey(tp)) {
            this.completedMap.put(tp, this.waitingMap.remove(tp));
        }
        if (this.ftpsMap != null) {
            PartitionRestoreContext ctx = this.restoreJob.partitionRestoreContextMap.get(tp);
            TopicIdPartition tpid = new TopicIdPartition(tp.topic(), ctx.topicId(), tp.partition());
            this.ftpsMap.remove(tpid);
        }
        this.maybeMarkJobCompleted();
    }

    public synchronized void moveToInprogressMap(TopicPartition tp) {
        if (this.waitingMap.containsKey(tp)) {
            this.inProgressMap.put(tp, this.waitingMap.remove(tp));
        } else if (this.failedMap.containsKey(tp)) {
            this.inProgressMap.put(tp, this.failedMap.remove(tp));
        }
    }

    public synchronized FiniteStateMachine pickOneNewPartitionToStartRestore() {
        FiniteStateMachine finiteStateMachine = null;
        if (this.waitingMap.size() > 0) {
            TopicPartition tp = (TopicPartition)this.waitingMap.keySet().stream().findFirst().get();
            LOGGER.info(String.format("[%s]: pick a new partition to restore", tp));
            finiteStateMachine = this.waitingMap.get(tp);
            this.moveToInprogressMap(tp);
            this.restoreJob.status = Job.JobStatus.IN_PROGRESS;
        } else {
            LOGGER.info("no partition left in waitingMap to be picked");
        }
        return finiteStateMachine;
    }

    public synchronized FiniteStateMachine getFiniteStateMachineByTopicPartition(TopicPartition tp) {
        if (this.waitingMap.containsKey(tp)) {
            return this.waitingMap.get(tp);
        }
        if (this.inProgressMap.containsKey(tp)) {
            return this.inProgressMap.get(tp);
        }
        if (this.failedMap.containsKey(tp)) {
            return this.failedMap.get(tp);
        }
        return this.completedMap.get(tp);
    }

    public static MessageRequest buildPreConditionCheckRequest(FiniteStateMachine finiteStateMachine) {
        String topic = (String)finiteStateMachine.getMetadata("topic");
        int partition = (Integer)finiteStateMachine.getMetadata("partition");
        NodeConfig partitionLeader = (NodeConfig)finiteStateMachine.getMetadata("partition_leader");
        return new KafkaPreConditionCheckRequest(0, topic, partition, partitionLeader);
    }

    public synchronized boolean isAllTasksDone() {
        return this.inProgressMap.size() == 0 && this.waitingMap.size() == 0;
    }

    public String status() {
        StringBuilder sb = new StringBuilder();
        sb.append("{wait: ").append(this.waitingMap.size()).append(", in_progress: ").append(this.inProgressMap.size()).append(", failed: ").append(this.failedMap.size()).append("}");
        return sb.toString();
    }

    public void maybeMarkJobCompleted() {
        if (this.isAllTasksDone()) {
            this.restoreJob.status = Job.JobStatus.COMPLETE;
            this.restoreMetricsManager.endRestoreRecord();
        }
    }
}

