/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.builders;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import kafka.log.LogManager;
import kafka.log.SegmentDeletionThrottlerConfig;
import kafka.log.TierLogComponents;
import kafka.server.BrokerTopicStats;
import kafka.server.ProducerIdQuotaManager;
import kafka.server.metadata.ConfigRepository;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.CheckpointFileConfig;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class LogManagerBuilder {
    private static final int PRODUCER_ID_EXPIRATION_CHECK_INTERVAL_MS = 600000;
    private List<File> logDirs = null;
    private List<File> initialOfflineDirs = Collections.emptyList();
    private ConfigRepository configRepository = null;
    private LogConfig initialDefaultConfig = null;
    private CleanerConfig cleanerConfig = null;
    private SegmentDeletionThrottlerConfig segmentDeletionThrottlerConfig = null;
    private int recoveryThreadsPerDataDir = 1;
    private long flushCheckMs = 1000L;
    private long flushRecoveryOffsetCheckpointMs = 10000L;
    private long flushStartOffsetCheckpointMs = 10000L;
    private int tierStateCheckpointMs = 15000;
    private boolean eagerRollEnable = false;
    private long retentionCheckMs = 1000L;
    private long rollCheckIntervalMs = 1000L;
    private int maxTransactionTimeoutMs = 900000;
    private ProducerStateManagerConfig producerStateManagerConfig = new ProducerStateManagerConfig(60000, false);
    private ProducerIdQuotaManager producerIdQuotaManager = null;
    private MetadataVersion interBrokerProtocolVersion = MetadataVersion.latestProduction();
    private Scheduler scheduler = null;
    private BrokerTopicStats brokerTopicStats = null;
    private LogDirFailureChannel logDirFailureChannel = null;
    private TierLogComponents tierLogComponents = TierLogComponents.EMPTY();
    private Metrics metrics = null;
    private Time time = Time.SYSTEM;
    private boolean keepPartitionMetadataFile = true;
    private boolean zkMigrationEnabled = false;
    private long initialTaskDelayMs = 30000L;

    public LogManagerBuilder setLogDirs(List<File> logDirs) {
        this.logDirs = logDirs;
        return this;
    }

    public LogManagerBuilder setInitialOfflineDirs(List<File> initialOfflineDirs) {
        this.initialOfflineDirs = initialOfflineDirs;
        return this;
    }

    public LogManagerBuilder setConfigRepository(ConfigRepository configRepository) {
        this.configRepository = configRepository;
        return this;
    }

    public LogManagerBuilder setInitialDefaultConfig(LogConfig initialDefaultConfig) {
        this.initialDefaultConfig = initialDefaultConfig;
        return this;
    }

    public LogManagerBuilder setCleanerConfig(CleanerConfig cleanerConfig) {
        this.cleanerConfig = cleanerConfig;
        return this;
    }

    public LogManagerBuilder setSegmentDeletionThrottlerConfig(SegmentDeletionThrottlerConfig segmentDeletionThrottlerConfig) {
        this.segmentDeletionThrottlerConfig = segmentDeletionThrottlerConfig;
        return this;
    }

    public LogManagerBuilder setRecoveryThreadsPerDataDir(int recoveryThreadsPerDataDir) {
        this.recoveryThreadsPerDataDir = recoveryThreadsPerDataDir;
        return this;
    }

    public LogManagerBuilder setFlushCheckMs(long flushCheckMs) {
        this.flushCheckMs = flushCheckMs;
        return this;
    }

    public LogManagerBuilder setFlushRecoveryOffsetCheckpointMs(long flushRecoveryOffsetCheckpointMs) {
        this.flushRecoveryOffsetCheckpointMs = flushRecoveryOffsetCheckpointMs;
        return this;
    }

    public LogManagerBuilder setFlushStartOffsetCheckpointMs(long flushStartOffsetCheckpointMs) {
        this.flushStartOffsetCheckpointMs = flushStartOffsetCheckpointMs;
        return this;
    }

    public LogManagerBuilder setTierStateCheckpointMs(int tierStateCheckpointMs) {
        this.tierStateCheckpointMs = tierStateCheckpointMs;
        return this;
    }

    public LogManagerBuilder setRetentionCheckMs(long retentionCheckMs) {
        this.retentionCheckMs = retentionCheckMs;
        return this;
    }

    public LogManagerBuilder setRollCheckIntervalMs(long rollCheckIntervalMs) {
        this.rollCheckIntervalMs = rollCheckIntervalMs;
        return this;
    }

    public LogManagerBuilder setMaxTransactionTimeoutMs(int maxTransactionTimeoutMs) {
        this.maxTransactionTimeoutMs = maxTransactionTimeoutMs;
        return this;
    }

    public LogManagerBuilder setProducerStateManagerConfig(int maxProducerIdExpirationMs, boolean transactionVerificationEnabled) {
        this.producerStateManagerConfig = new ProducerStateManagerConfig(maxProducerIdExpirationMs, transactionVerificationEnabled);
        return this;
    }

    public LogManagerBuilder setProducerIdQuotaManager(ProducerIdQuotaManager producerIdQuotaManager) {
        this.producerIdQuotaManager = producerIdQuotaManager;
        return this;
    }

    public LogManagerBuilder setInterBrokerProtocolVersion(MetadataVersion interBrokerProtocolVersion) {
        this.interBrokerProtocolVersion = interBrokerProtocolVersion;
        return this;
    }

    public LogManagerBuilder setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public LogManagerBuilder setBrokerTopicStats(BrokerTopicStats brokerTopicStats) {
        this.brokerTopicStats = brokerTopicStats;
        return this;
    }

    public LogManagerBuilder setLogDirFailureChannel(LogDirFailureChannel logDirFailureChannel) {
        this.logDirFailureChannel = logDirFailureChannel;
        return this;
    }

    public LogManagerBuilder setTierLogComponents(TierLogComponents tierLogComponents) {
        this.tierLogComponents = tierLogComponents;
        return this;
    }

    public LogManagerBuilder setMetrics(Metrics metrics) {
        this.metrics = metrics;
        return this;
    }

    public LogManagerBuilder setTime(Time time) {
        this.time = time;
        return this;
    }

    public LogManagerBuilder setKeepPartitionMetadataFile(boolean keepPartitionMetadataFile) {
        this.keepPartitionMetadataFile = keepPartitionMetadataFile;
        return this;
    }

    public LogManagerBuilder setZkMigrationEnabled(boolean zkMigrationEnabled) {
        this.zkMigrationEnabled = zkMigrationEnabled;
        return this;
    }

    public LogManagerBuilder setInitialTaskDelayMs(long initialTaskDelayMs) {
        this.initialTaskDelayMs = initialTaskDelayMs;
        return this;
    }

    public LogManager build() {
        if (this.logDirs == null) {
            throw new RuntimeException("you must set logDirs");
        }
        if (this.configRepository == null) {
            throw new RuntimeException("you must set configRepository");
        }
        if (this.initialDefaultConfig == null) {
            throw new RuntimeException("you must set initialDefaultConfig");
        }
        if (this.cleanerConfig == null) {
            throw new RuntimeException("you must set cleanerConfig");
        }
        if (this.scheduler == null) {
            throw new RuntimeException("you must set scheduler");
        }
        if (this.brokerTopicStats == null) {
            throw new RuntimeException("you must set brokerTopicStats");
        }
        if (this.logDirFailureChannel == null) {
            throw new RuntimeException("you must set logDirFailureChannel");
        }
        if (this.metrics == null) {
            this.metrics = new Metrics();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    LogManagerBuilder.this.metrics.close();
                }
            });
        }
        return new LogManager((Seq<File>)((Iterator)JavaConverters.asScalaIteratorConverter(this.logDirs.iterator()).asScala()).toSeq(), (Seq<File>)((Iterator)JavaConverters.asScalaIteratorConverter(this.initialOfflineDirs.iterator()).asScala()).toSeq(), this.configRepository, this.initialDefaultConfig, this.cleanerConfig, this.recoveryThreadsPerDataDir, this.flushCheckMs, this.flushRecoveryOffsetCheckpointMs, this.flushStartOffsetCheckpointMs, this.tierStateCheckpointMs, this.eagerRollEnable, this.retentionCheckMs, this.rollCheckIntervalMs, this.segmentDeletionThrottlerConfig, this.maxTransactionTimeoutMs, this.producerStateManagerConfig, 600000, (Option<ProducerIdQuotaManager>)Option.apply((Object)this.producerIdQuotaManager), this.interBrokerProtocolVersion, this.scheduler, this.brokerTopicStats, this.metrics, this.logDirFailureChannel, this.tierLogComponents, this.time, this.keepPartitionMetadataFile, Optional.empty(), CheckpointFileConfig.DEFAULT, this.zkMigrationEnabled, this.initialTaskDelayMs);
    }
}

