/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.cell;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import kafka.controller.ControllerContext;
import kafka.server.KafkaConfig;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.CellLoad;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.Tenant;
import org.apache.kafka.common.errors.CellNotFoundException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.DescribeCellsResponseData;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.placement.CellAssignor;
import org.apache.kafka.metadata.placement.CellDescriber;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Iterable;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\tma\u0001B\u000f\u001f\u0001\u0015B\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"AQ\n\u0001B\u0001B\u0003%a\n\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003W\u0011!Q\u0006A!A!\u0002\u0013Y\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u000b\u0015\u0004A\u0011\u00014\t\u000f=\u0004!\u0019!C\u0005a\"1A\u000f\u0001Q\u0001\nEDQ!\u001e\u0001\u0005\u0002YDq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002<\u0001!\t!!\u0010\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002F!9\u00111\t\u0001\u0005\u0002\u0005\u0005\u0004bBA5\u0001\u0011\u0005\u00111\u000e\u0005\b\u0003S\u0002A\u0011AA<\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u000bCq!!#\u0001\t\u0003\tY\tC\u0004\u0002.\u0002!\t!a,\t\u000f\u0005M\u0006\u0001\"\u0001\u00026\"9\u0011Q\u001a\u0001\u0005\u0002\u0005=\u0007bBAm\u0001\u0011\u0005\u00131\u001c\u0005\b\u0003C\u0004A\u0011AAr\u0011\u001d\t9\u000f\u0001C\u0005\u0003SDq!a=\u0001\t\u0013\t)\u0010C\u0004\u0002z\u0002!I!a?\t\u000f\t=\u0001\u0001\"\u0003\u0003\u0012!9!Q\u0003\u0001\u0005\n\t]!\u0001\u0006.l\u0007\u0016dGnQ8oiJ|G.T1oC\u001e,'O\u0003\u0002 A\u0005!1-\u001a7m\u0015\t\t#%\u0001\u0004tKJ4XM\u001d\u0006\u0002G\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001'YI\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0007CA\u00171\u001b\u0005q#BA\u0018#\u0003\u0015)H/\u001b7t\u0013\t\tdFA\u0004M_\u001e<\u0017N\\4\u0011\u0005MjT\"\u0001\u001b\u000b\u0005U2\u0014!\u00039mC\u000e,W.\u001a8u\u0015\t9\u0004(\u0001\u0005nKR\fG-\u0019;b\u0015\t\u0019\u0013H\u0003\u0002;w\u00051\u0011\r]1dQ\u0016T\u0011\u0001P\u0001\u0004_J<\u0017B\u0001 5\u00055\u0019U\r\u001c7EKN\u001c'/\u001b2fe\u0006A!p[\"mS\u0016tG\u000f\u0005\u0002B\t6\t!I\u0003\u0002DE\u0005\u0011!p[\u0005\u0003\u000b\n\u0013QbS1gW\u0006T6n\u00117jK:$\u0018aB2p]R,\u0007\u0010\u001e\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015\n\n!bY8oiJ|G\u000e\\3s\u0013\ta\u0015JA\tD_:$(o\u001c7mKJ\u001cuN\u001c;fqR\fA\u0001^5nKB\u0011qjU\u0007\u0002!*\u0011q&\u0015\u0006\u0003%b\naaY8n[>t\u0017B\u0001+Q\u0005\u0011!\u0016.\\3\u0002\r\r|gNZ5h!\t9\u0006,D\u0001!\u0013\tI\u0006EA\u0006LC\u001a\\\u0017mQ8oM&<\u0017A\u0002:b]\u0012|W\u000e\u0005\u0002]?6\tQL\u0003\u0002_Q\u0005!Q\u000f^5m\u0013\t\u0001WL\u0001\u0004SC:$w.\\\u0001\u0012e\u0016\u0004H.[2bi&|gNR1di>\u0014\bCA\u0014d\u0013\t!\u0007FA\u0003TQ>\u0014H/\u0001\u0004=S:LGO\u0010\u000b\bO&T7\u000e\\7o!\tA\u0007!D\u0001\u001f\u0011\u0015yt\u00011\u0001A\u0011\u00151u\u00011\u0001H\u0011\u0015iu\u00011\u0001O\u0011\u0015)v\u00011\u0001W\u0011\u0015Qv\u00011\u0001\\\u0011\u0015\tw\u00011\u0001c\u00031\u0019W\r\u001c7BgNLwM\\8s+\u0005\t\bCA\u001as\u0013\t\u0019HG\u0001\u0007DK2d\u0017i]:jO:|'/A\u0007dK2d\u0017i]:jO:|'\u000fI\u0001\u0015CN\u001c\u0018n\u001a8Ce>\\WM]:U_\u000e+G\u000e\\:\u0015\u0005]T\bCA\u0014y\u0013\tI\bF\u0001\u0003V]&$\b\"B>\u000b\u0001\u0004a\u0018AC1mY\n\u0013xn[3sgB)Q0!\u0001\u0002\u00065\taP\u0003\u0002\u0000Q\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007\u0005\raPA\u0002TKF\u00042aJA\u0004\u0013\r\tI\u0001\u000b\u0002\u0004\u0013:$\u0018aE1tg&<gN\u0011:pW\u0016\u00148\u000fV8DK2dG#C<\u0002\u0010\u0005M\u0011qCA\u0019\u0011\u0019\t\tb\u0003a\u0001y\u00069!M]8lKJ\u001c\bbBA\u000b\u0017\u0001\u0007\u0011QA\u0001\ri\u0006\u0014x-\u001a;DK2d\u0017\n\u001a\u0005\b\u00033Y\u0001\u0019AA\u000e\u00035)8/\u00192mK\n\u0013xn[3sgB1\u0011QDA\u0016\u0003\u000bqA!a\b\u0002(A\u0019\u0011\u0011\u0005\u0015\u000e\u0005\u0005\r\"bAA\u0013I\u00051AH]8pizJ1!!\u000b)\u0003\u0019\u0001&/\u001a3fM&!\u0011QFA\u0018\u0005\r\u0019V\r\u001e\u0006\u0004\u0003SA\u0003bBA\u001a\u0017\u0001\u0007\u0011QG\u0001\u0006M>\u00148-\u001a\t\u0004O\u0005]\u0012bAA\u001dQ\t9!i\\8mK\u0006t\u0017aF;oCN\u001c\u0018n\u001a8Ce>\\WM]:Ge>l7)\u001a7m)\u00159\u0018qHA!\u0011\u0019\t\t\u0002\u0004a\u0001y\"9\u0011\u0011\u0004\u0007A\u0002\u0005m\u0011AE;qI\u0006$XmQ3mY6+G/\u00193bi\u0006$2b^A$\u0003\u0017\n9&a\u0017\u0002`!9\u0011\u0011J\u0007A\u0002\u0005\u0015\u0011AB2fY2LE\rC\u0004\u0002N5\u0001\r!a\u0014\u0002\u000bM$\u0018\r^3\u0011\t\u0005E\u00131K\u0007\u0002#&\u0019\u0011QK)\u0003\u0013\r+G\u000e\\*uCR,\u0007BBA-\u001b\u0001\u0007!-A\u0004nS:\u001c\u0016N_3\t\r\u0005uS\u00021\u0001c\u0003\u001di\u0017\r_*ju\u0016Dq!!\u0007\u000e\u0001\u0004\tY\u0002F\u0004x\u0003G\n)'a\u001a\t\u000f\u0005%c\u00021\u0001\u0002\u0006!9\u0011Q\n\bA\u0002\u0005=\u0003bBA\r\u001d\u0001\u0007\u00111D\u0001\u000bGJ,\u0017\r^3DK2dGCBA7\u0003g\n)\b\u0005\u0003\u0002R\u0005=\u0014bAA9#\n!1)\u001a7m\u0011\u001d\tIe\u0004a\u0001\u0003\u000bAq!!\u0014\u0010\u0001\u0004\ty\u0005\u0006\u0007\u0002n\u0005e\u00141PA?\u0003\u007f\n\t\tC\u0004\u0002JA\u0001\r!!\u0002\t\r\u0005E\u0001\u00031\u0001}\u0011\u001d\ti\u0005\u0005a\u0001\u0003\u001fBa!!\u0017\u0011\u0001\u0004\u0011\u0007BBA/!\u0001\u0007!-\u0001\u0006eK2,G/Z\"fY2$2a^AD\u0011\u001d\tI%\u0005a\u0001\u0003\u000b\tqCZ;mYV\u0003H-\u0019;f\u0007\u0016dG\u000eT8bI\u000e\u000b7\r[3\u0015\u000b]\fi)a)\t\u000f\u0005=%\u00031\u0001\u0002\u0012\u0006I1-\u001a7m\u0019>\fGm\u001d\t\u0007\u0003'\u000bY*!(\u000e\u0005\u0005U%b\u00010\u0002\u0018*\u0011\u0011\u0011T\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002.\u0005U\u0005\u0003BA)\u0003?K1!!)R\u0005!\u0019U\r\u001c7M_\u0006$\u0007bBAS%\u0001\u0007\u0011qU\u0001\rkB$\u0017\r^3US6,Wj\u001d\t\u0004O\u0005%\u0016bAAVQ\t!Aj\u001c8h\u0003-\u0019xN\u001d;fI\u000e+G\u000e\\:\u0016\u0005\u0005E\u0006#B?\u0002\u0002\u00055\u0014!\u00043fg\u000e\u0014\u0018NY3DK2d7\u000f\u0006\u0003\u00028\u0006-\u0007#B?\u0002\u0002\u0005e\u0006\u0003BA^\u0003\u000ftA!!0\u0002D6\u0011\u0011q\u0018\u0006\u0004\u0003\u0003\f\u0016aB7fgN\fw-Z\u0005\u0005\u0003\u000b\fy,A\rEKN\u001c'/\u001b2f\u0007\u0016dGn\u001d*fgB|gn]3ECR\f\u0017\u0002BA9\u0003\u0013TA!!2\u0002@\"9\u0011\u0011\u0004\u000bA\u0002\u0005m\u0011aB4fi\u000e+G\u000e\u001c\u000b\u0005\u0003#\f9\u000eE\u0003(\u0003'\fi'C\u0002\u0002V\"\u0012aa\u00149uS>t\u0007bBA%+\u0001\u0007\u0011QA\u0001\u0010O\u0016$(I]8lKJ\u001cU\r\u001c7JIR!\u0011QAAo\u0011\u001d\tyN\u0006a\u0001\u0003\u000b\t\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u0001\u0012G>l\u0007/\u001e;f+N\f'\r\\3DK2dG\u0003BAi\u0003KDq!!\u0007\u0018\u0001\u0004\tY\"A\u000be_\u0006\u001b8/[4o\u0005J|7.\u001a:t)>\u001cU\r\u001c7\u0015\u0013]\fY/!<\u0002p\u0006E\bBBA\t1\u0001\u0007A\u0010C\u0004\u0002\u0016a\u0001\r!!\u0002\t\u000f\u0005e\u0001\u00041\u0001\u0002\u001c!9\u00111\u0007\rA\u0002\u0005U\u0012aC5oSRL\u0017\r\\\"fY2$B!!\u001c\u0002x\"9\u0011\u0011J\rA\u0002\u0005\u0015\u0011!\u0003;p\u0015\u00064\u0018mU3u)\u0011\tiPa\u0003\u0011\r\u0005M\u00151TA\u0000!\u0011\u0011\tAa\u0002\u000e\u0005\t\r!\u0002\u0002B\u0003\u0003/\u000bA\u0001\\1oO&!!\u0011\u0002B\u0002\u0005\u001dIe\u000e^3hKJDqA!\u0004\u001b\u0001\u0004\tY\"A\u0002tKR\f!\u0002^8TG\u0006d\u0017mU3u)\u0011\tYBa\u0005\t\u000f\t51\u00041\u0001\u0002~\u0006Qa.^7UK:\fg\u000e^:\u0015\t\u0005\u0015!\u0011\u0004\u0005\b\u0003\u0013b\u0002\u0019AA\u0003\u0001")
public class ZkCellControlManager
implements Logging,
CellDescriber {
    private final KafkaZkClient zkClient;
    private final ControllerContext context;
    private final KafkaConfig config;
    private final short replicationFactor;
    private final CellAssignor cellAssignor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private CellAssignor cellAssignor() {
        return this.cellAssignor;
    }

    public void assignBrokersToCells(Seq<Object> allBrokers) {
        scala.collection.immutable.Set existingBrokers = ((IterableOnceOps)this.context.cellIdToCell().values().toSeq().flatMap((Function1 & Serializable)cell -> this.toScalaSet(cell.brokers()))).toSet();
        Map cellIdToUnassignedBrokers = ((Seq)allBrokers.filter((Function1)(JFunction1.mcZI.sp & Serializable)broker -> !existingBrokers.contains((Object)BoxesRunTime.boxToInteger((int)broker)))).groupBy((Function1)(JFunction1.mcII.sp & Serializable)broker -> {
            short getImplicitBrokerCellId_cellSize = $this.config.cellDefaultSize();
            return broker / getImplicitBrokerCellId_cellSize;
        });
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(cellId, unassignedCellBrokers) -> {
            ZkCellControlManager.$anonfun$assignBrokersToCells$4(this, BoxesRunTime.unboxToInt((Object)cellId), unassignedCellBrokers);
            return BoxedUnit.UNIT;
        };
        cellIdToUnassignedBrokers.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
    }

    public void assignBrokersToCell(Seq<Object> brokers, int targetCellId, scala.collection.immutable.Set<Object> usableBrokers, boolean force) {
        if (!this.context.cellIdToCell().contains((Object)BoxesRunTime.boxToInteger((int)targetCellId))) {
            throw new CellNotFoundException(new StringBuilder(27).append("Target cell ").append(targetCellId).append(" does not exist").toString());
        }
        this.doAssignBrokersToCell(brokers, targetCellId, usableBrokers, force);
    }

    public void unassignBrokersFromCell(Seq<Object> brokers, scala.collection.immutable.Set<Object> usableBrokers) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(20).append("Unassigning brokers ").append(brokers).toString());
        this.doAssignBrokersToCell(brokers, -1, usableBrokers, false);
    }

    public void updateCellMetadata(int cellId, CellState state, short minSize, short maxSize, scala.collection.immutable.Set<Object> usableBrokers) {
        Option<Cell> option = this.getCell(cellId);
        if (option instanceof Some) {
            Cell cell = (Cell)((Some)option).value();
            Cell newCell = new Cell(cellId, cell.brokers(), state, minSize, maxSize);
            CellAssignor.checkCellMetadata((Cell)newCell, (Cell)cell, this.toJavaSet(usableBrokers), (short)this.replicationFactor, (int)this.numTenants(cellId));
            this.zkClient.setCell(newCell, this.context.epochZkVersion());
            this.context.updateCell(newCell);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            throw new CellNotFoundException(new StringBuilder(20).append("Cell ").append(cellId).append(" does not exist").toString());
        }
        throw new MatchError(option);
    }

    public void updateCellMetadata(int cellId, CellState state, scala.collection.immutable.Set<Object> usableBrokers) {
        Option<Cell> option = this.getCell(cellId);
        if (option instanceof Some) {
            Cell cell = (Cell)((Some)option).value();
            this.updateCellMetadata(cellId, state, cell.minSize(), cell.maxSize(), usableBrokers);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            throw new CellNotFoundException(new StringBuilder(20).append("Cell ").append(cellId).append(" does not exist").toString());
        }
        throw new MatchError(option);
    }

    public Cell createCell(int cellId, CellState state) {
        return this.createCell(cellId, (Seq<Object>)Nil$.MODULE$, state, this.config.cellMinSize(), this.config.cellMaxSize());
    }

    public Cell createCell(int cellId, Seq<Object> brokers, CellState state, short minSize, short maxSize) {
        if (this.context.cellIdToCell().contains((Object)BoxesRunTime.boxToInteger((int)cellId))) {
            String msg = new StringBuilder(46).append("Cell ").append(cellId).append(" won't be created since it already exists").toString();
            this.error((Function0<String>)(Function0 & Serializable)() -> msg);
            throw new InvalidRequestException(msg);
        }
        Cell newCell = new Cell(cellId, this.toJavaSet((scala.collection.immutable.Set<Object>)brokers.toSet()), state, minSize, maxSize);
        CellAssignor.checkCellMetadata((Cell)newCell, (Cell)newCell, new HashSet(), (short)this.replicationFactor, (int)0);
        this.zkClient.createCell(newCell, this.context.epochZkVersion());
        this.context.updateCell(newCell);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(13).append("Created cell ").append(newCell).toString());
        return newCell;
    }

    public void deleteCell(int cellId) {
        Option<Cell> cell = this.getCell(cellId);
        if (cell.isEmpty()) {
            String msg = new StringBuilder(44).append("Did not delete cell ").append(cellId).append(" since it does not exist").toString();
            this.warn((Function0<String>)(Function0 & Serializable)() -> msg);
            throw new CellNotFoundException(msg);
        }
        if (!((Cell)cell.get()).brokers().isEmpty()) {
            throw new InvalidRequestException(new StringBuilder(54).append("Did not delete cell ").append(cellId).append(" since brokers ").append(CollectionConverters$.MODULE$.SetHasAsScala(((Cell)cell.get()).brokers()).asScala().toSeq()).append(" are still assigned").toString());
        }
        if (this.context.tenantIdToTenant().values().exists((Function1 & Serializable)tenant -> BoxesRunTime.boxToBoolean((boolean)ZkCellControlManager.$anonfun$deleteCell$2(cellId, tenant)))) {
            scala.collection.immutable.Seq tenants = ((IterableOnceOps)((IterableOps)this.context.tenantIdToTenant().values().filter((Function1 & Serializable)tenant -> BoxesRunTime.boxToBoolean((boolean)ZkCellControlManager.$anonfun$deleteCell$3(cellId, tenant)))).map((Function1 & Serializable)x$1 -> x$1.tenantId())).toSeq();
            throw new InvalidRequestException(new StringBuilder(54).append("Did not delete cell ").append(cellId).append(" since tenants ").append(tenants).append(" are still assigned").toString());
        }
        if (!this.zkClient.deleteCell(cellId, this.context.epochZkVersion())) {
            String msg = new StringBuilder(44).append("Did not delete cell ").append(cellId).append(" since it does not exist").toString();
            this.warn((Function0<String>)(Function0 & Serializable)() -> msg);
            throw new InvalidRequestException(msg);
        }
        this.context.removeCell(cellId);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(13).append("Deleted cell ").append(cellId).toString());
    }

    public void fullUpdateCellLoadCache(java.util.Set<CellLoad> cellLoads, long updateTimeMs) {
        this.cellAssignor().fullUpdateCellLoadCache(cellLoads, updateTimeMs);
    }

    public Seq<Cell> sortedCells() {
        return (Seq)this.context.cellIdToCell().values().toSeq().sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.cellId()), (Ordering)Ordering.Int$.MODULE$);
    }

    public Seq<DescribeCellsResponseData.Cell> describeCells(scala.collection.immutable.Set<Object> usableBrokers) {
        return (Seq)this.sortedCells().map((Function1 & Serializable)c -> new DescribeCellsResponseData.Cell().setCellId(c.cellId()).setState(c.state().code()).setBrokers(c.brokersList()).setOpenForTenantAssignment(CellAssignor.isCellOpenForAssignment((Cell)c, this.toJavaSet(usableBrokers), (int)$this.replicationFactor)));
    }

    public Option<Cell> getCell(int cellId) {
        return this.context.cellIdToCell().get((Object)BoxesRunTime.boxToInteger((int)cellId));
    }

    public int getBrokerCellId(int brokerId) {
        return BoxesRunTime.unboxToInt((Object)this.context.cellIdToCell().values().find((Function1 & Serializable)cell -> BoxesRunTime.boxToBoolean((boolean)ZkCellControlManager.$anonfun$getBrokerCellId$1(brokerId, cell))).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.cellId())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1));
    }

    public Option<Cell> computeUsableCell(scala.collection.immutable.Set<Object> usableBrokers) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.cellAssignor().computeUsableCell(CollectionConverters$.MODULE$.SetHasAsJava((Set)usableBrokers.map((Function1 & Serializable)x -> ZkCellControlManager.$anonfun$computeUsableCell$1(BoxesRunTime.unboxToInt((Object)x)))).asJava(), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.context.cellIdToCell().values().toSeq()).asJava(), (int)this.replicationFactor)));
    }

    private void doAssignBrokersToCell(Seq<Object> brokers, int targetCellId, scala.collection.immutable.Set<Object> usableBrokers, boolean force) {
        CellAssignor.checkBrokerAssignment(this.toJavaSet((scala.collection.immutable.Set<Object>)brokers.toSet()), (int)this.config.cellDefaultSize(), (boolean)force);
        scala.collection.immutable.Set brokersSet = brokers.toSet();
        ((Iterable)this.context.cellIdToCell().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                scala.collection.immutable.Set newBrokers;
                scala.collection.immutable.Set set;
                int cellId = x0$1._1$mcI$sp();
                Cell cell = (Cell)x0$1._2();
                scala.collection.immutable.Set<Object> currCellBrokers = this.toScalaSet(cell.brokers());
                if (cellId == targetCellId) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Assigning brokers ").append(brokers).append(" to cell ").append(targetCellId).toString());
                    set = (scala.collection.immutable.Set)currCellBrokers.$plus$plus((IterableOnce)brokersSet);
                } else {
                    set = (scala.collection.immutable.Set)currCellBrokers.$minus$minus((IterableOnce)brokersSet);
                }
                scala.collection.immutable.Set set2 = newBrokers = set;
                if (set2 == null || !set2.equals(currCellBrokers)) {
                    Cell newCell = new Cell(cellId, this.toJavaSet((scala.collection.immutable.Set<Object>)newBrokers), cell.state(), cell.minSize(), cell.maxSize());
                    CellAssignor.checkCellMetadata((Cell)newCell, (Cell)cell, this.toJavaSet(usableBrokers), (short)$this.replicationFactor, (int)this.numTenants(cellId));
                    return new Some((Object)newCell);
                }
                return None$.MODULE$;
            }
            throw new MatchError(null);
        })).foreach((Function1 & Serializable)x$4 -> {
            x$4.foreach((Function1 & Serializable)newCell -> {
                ZkCellControlManager.$anonfun$doAssignBrokersToCell$4($this, newCell);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    private Cell initialCell(int cellId) {
        return new Cell(cellId, new HashSet(), CellState.READY, this.config.cellMinSize(), this.config.cellMaxSize());
    }

    private java.util.Set<Integer> toJavaSet(scala.collection.immutable.Set<Object> set) {
        return CollectionConverters$.MODULE$.SetHasAsJava((Set)set.map((Function1 & Serializable)x -> ZkCellControlManager.$anonfun$toJavaSet$1(BoxesRunTime.unboxToInt((Object)x)))).asJava();
    }

    private scala.collection.immutable.Set<Object> toScalaSet(java.util.Set<Integer> set) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(set).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$5)))).toSet();
    }

    private int numTenants(int cellId) {
        return this.context.tenantIdToTenant().values().count((Function1 & Serializable)tenant -> BoxesRunTime.boxToBoolean((boolean)ZkCellControlManager.$anonfun$numTenants$1(cellId, tenant)));
    }

    public static final /* synthetic */ void $anonfun$assignBrokersToCells$4(ZkCellControlManager $this, int cellId, Seq unassignedCellBrokers) {
        Cell assignedCell = (Cell)$this.getCell(cellId).getOrElse((Function0 & Serializable)() -> $this.initialCell(cellId));
        scala.collection.immutable.Set newlyAssignableBrokers = ((IterableOnceOps)unassignedCellBrokers.take(package$.MODULE$.max(0, assignedCell.maxSize() - assignedCell.brokers().size()))).toSet();
        scala.collection.immutable.Set remainingUnassignedBrokers = (scala.collection.immutable.Set)unassignedCellBrokers.toSet().$minus$minus((IterableOnce)newlyAssignableBrokers);
        if (newlyAssignableBrokers.nonEmpty()) {
            scala.collection.immutable.Set newBrokers = (scala.collection.immutable.Set)$this.toScalaSet(assignedCell.brokers()).$plus$plus((IterableOnce)newlyAssignableBrokers);
            Cell cell = new Cell(cellId, $this.toJavaSet((scala.collection.immutable.Set<Object>)newBrokers), assignedCell.state(), assignedCell.minSize(), assignedCell.maxSize());
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Setting cell ").append(cellId).append(" with ").append(newBrokers).append(" (new brokers are ").append(newlyAssignableBrokers).append(")").toString());
            $this.zkClient.createOrSetCell(cell, $this.context.epochZkVersion());
            $this.context.updateCell(cell);
        }
        if (remainingUnassignedBrokers.nonEmpty()) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Brokers ").append(remainingUnassignedBrokers).append(" are not assignable to cell ").append(cellId).append(", since cell is at max size ").append(assignedCell.maxSize()).toString());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$deleteCell$2(int cellId$2, Tenant tenant) {
        return tenant.cellIds().contains(BoxesRunTime.boxToInteger((int)cellId$2));
    }

    public static final /* synthetic */ boolean $anonfun$deleteCell$3(int cellId$2, Tenant tenant) {
        return tenant.cellIds().contains(BoxesRunTime.boxToInteger((int)cellId$2));
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerCellId$1(int brokerId$1, Cell cell) {
        return cell.brokers().contains(BoxesRunTime.boxToInteger((int)brokerId$1));
    }

    public static final /* synthetic */ Integer $anonfun$computeUsableCell$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ void $anonfun$doAssignBrokersToCell$4(ZkCellControlManager $this, Cell newCell) {
        $this.zkClient.setCell(newCell, $this.context.epochZkVersion());
        $this.context.updateCell(newCell);
    }

    public static final /* synthetic */ Integer $anonfun$toJavaSet$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ boolean $anonfun$numTenants$1(int cellId$3, Tenant tenant) {
        return tenant.cellIds().contains(BoxesRunTime.boxToInteger((int)cellId$3));
    }

    public ZkCellControlManager(KafkaZkClient zkClient, ControllerContext context, Time time, KafkaConfig config, Random random, short replicationFactor) {
        this.zkClient = zkClient;
        this.context = context;
        this.config = config;
        this.replicationFactor = replicationFactor;
        CellAssignor.confirmInitialCellStateValid((short)config.cellMinSize(), (short)config.cellMaxSize(), (short)config.cellDefaultSize());
        this.cellAssignor = new CellAssignor(random.self(), time);
    }
}

