/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.BrokerAuthenticationTaskErrorCode$;
import kafka.server.link.ClusterLinkAutoCreateMirror$;
import kafka.server.link.ClusterLinkAutoMirroringTaskType$;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.InvalidTopicTaskErrorCode$;
import kafka.server.link.MisconfigurationTaskErrorCode$;
import kafka.server.link.NotConfiguredTaskState$;
import kafka.server.link.PolicyViolationTaskErrorCode$;
import kafka.server.link.SourceCluster$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TopicExistsTaskErrorCode$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewMirrorTopic;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\r=a\u0001B\u001f?\u0001\u0015C\u0001B\u0014\u0001\u0003\u0006\u0004%\ta\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005!\"AA\u000b\u0001BC\u0002\u0013\u0005Q\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003W\u0011!Q\u0006A!A!\u0002\u0013Y\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u0011\u0015\u0004!\u0011!Q\u0001\n\tD\u0001B\u001a\u0001\u0003\u0002\u0003\u0006Ia\u001a\u0005\nU\u0002\u0011\t\u0011)A\u0005WbD\u0011\"\u001f\u0001\u0003\u0002\u0003\u0006IA\u001f@\t\r}\u0004A\u0011AA\u0001\u0011%\t)\u0002\u0001a\u0001\n\u0013\t9\u0002C\u0005\u0002 \u0001\u0001\r\u0011\"\u0003\u0002\"!A\u00111\u0007\u0001!B\u0013\tI\u0002C\u0005\u00026\u0001\u0011\r\u0011\"\u0003\u00028!A\u0011q\f\u0001!\u0002\u0013\tI\u0004C\u0005\u0002b\u0001\u0011\r\u0011\"\u0003\u00028!A\u00111\r\u0001!\u0002\u0013\tI\u0004C\u0005\u0002f\u0001\u0001\r\u0011\"\u0003\u0002h!I\u0011q\u000e\u0001A\u0002\u0013%\u0011\u0011\u000f\u0005\t\u0003k\u0002\u0001\u0015)\u0003\u0002j!I\u0011q\u000f\u0001A\u0002\u0013%\u0011\u0011\u0010\u0005\n\u0003\u0003\u0003\u0001\u0019!C\u0005\u0003\u0007C\u0001\"a\"\u0001A\u0003&\u00111\u0010\u0005\f\u0003\u0013\u0003\u0001\u0019!a\u0001\n\u0013\tI\bC\u0006\u0002\f\u0002\u0001\r\u00111A\u0005\n\u00055\u0005bCAI\u0001\u0001\u0007\t\u0011)Q\u0005\u0003wB\u0011\"a%\u0001\u0001\u0004%I!!&\t\u0013\u0005\r\u0006\u00011A\u0005\n\u0005\u0015\u0006\u0002CAU\u0001\u0001\u0006K!a&\t\u000f\u0005M\u0006\u0001\"\u0015\u00026\"9\u00111\u001a\u0001\u0005\n\u0005U\u0006bBAg\u0001\u0011%\u0011q\u001a\u0005\b\u00037\u0004A\u0011BAo\u0011\u001d\t)\u0010\u0001C\u0005\u0003oDqAa\b\u0001\t\u0013\u0011\t\u0003C\u0004\u0003*\u0001!IAa\u000b\t\u000f\tM\u0002\u0001\"\u0003\u00036!9!\u0011\b\u0001\u0005\n\tm\u0002b\u0002B!\u0001\u0011%!1\t\u0005\b\u0005\u0013\u0002A\u0011\u0002B&\u0011\u001d\u0011)\t\u0001C\u0005\u0005\u000fCqA!'\u0001\t\u0013\u0011Y\nC\u0004\u0003\u001e\u0002!IAa(\t\u0011\t\u0005\u0006\u0001\"\u0001?\u0003oA\u0001Ba)\u0001\t\u0003q\u0014q\u0007\u0005\t\u0005K\u0003A\u0011\u0001 \u0002z!9!q\u0015\u0001\u0005R\t%\u0006b\u0002BZ\u0001\u0011\u0005#QW\u0004\b\u0005os\u0004\u0012\u0001B]\r\u0019id\b#\u0001\u0003<\"1qp\rC\u0001\u0005\u0007D\u0011B!24\u0005\u0004%\tAa2\t\u0011\t]7\u0007)A\u0005\u0005\u0013D\u0011B!74\u0005\u0004%\tAa7\t\u0011\t%8\u0007)A\u0005\u0005;DqAa;4\t\u0003\u0011i\u000fC\u0004\u0004\u0004M\"\ta!\u0002\t\u0013\r-1G1A\u0005\u0002\u0005\u001d\u0004\u0002CB\u0007g\u0001\u0006I!!\u001b\u00037\rcWo\u001d;fe2Kgn[!vi>\u001c%/Z1uK6K'O]8s\u0015\ty\u0004)\u0001\u0003mS:\\'BA!C\u0003\u0019\u0019XM\u001d<fe*\t1)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0005CA$L\u001d\tA\u0015*D\u0001?\u0013\tQe(\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0005\u0003\u00196\u0013A\u0002U3sS>$\u0017n\u0019+bg.T!A\u0013 \u0002\u001b\rd\u0017.\u001a8u\u001b\u0006t\u0017mZ3s+\u0005\u0001\u0006C\u0001%R\u0013\t\u0011fH\u0001\u000fDYV\u001cH/\u001a:MS:\\G)Z:u\u00072LWM\u001c;NC:\fw-\u001a:\u0002\u001d\rd\u0017.\u001a8u\u001b\u0006t\u0017mZ3sA\u0005yQ.\u001a;bI\u0006$\u0018-T1oC\u001e,'/F\u0001W!\tAu+\u0003\u0002Y}\tQ2\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0006\u0001R.\u001a;bI\u0006$\u0018-T1oC\u001e,'\u000fI\u0001\tY&t7\u000eR1uCB\u0011AlX\u0007\u0002;*\u0011aLQ\u0001\u0003u.L!\u0001Y/\u0003\u001f\rcWo\u001d;fe2Kgn\u001b#bi\u0006\f1B]3n_R,\u0017\tZ7j]B\u0011\u0001jY\u0005\u0003Iz\u0012Qc\u00117vgR,'\u000fT5oW\n\u000bGo\u00195BI6Lg.\u0001\u0006m_\u000e\fG.\u00113nS:\fq!\\3ue&\u001c7\u000f\u0005\u0002IQ&\u0011\u0011N\u0010\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T3ue&\u001c7/\u0001\u0003uS6,\u0007C\u00017w\u001b\u0005i'B\u00018p\u0003\u0015)H/\u001b7t\u0015\t\u0001\u0018/\u0001\u0004d_6lwN\u001c\u0006\u0003\u0007JT!a\u001d;\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0018aA8sO&\u0011q/\u001c\u0002\u0005)&lW-\u0003\u0002k\u0017\u0006)\u0011/^8uCB\u00111\u0010`\u0007\u0002\u0001&\u0011Q\u0010\u0011\u0002\u0018\u00072,8\u000f^3s\u0019&t7NU3rk\u0016\u001cH/U;pi\u0006L!!_&\u0002\rqJg.\u001b;?)I\t\u0019!!\u0002\u0002\b\u0005%\u00111BA\u0007\u0003\u001f\t\t\"a\u0005\u0011\u0005!\u0003\u0001\"\u0002(\f\u0001\u0004\u0001\u0006\"\u0002+\f\u0001\u00041\u0006\"\u0002.\f\u0001\u0004Y\u0006\"B1\f\u0001\u0004\u0011\u0007\"B3\f\u0001\u0004\u0011\u0007\"\u00024\f\u0001\u00049\u0007\"\u00026\f\u0001\u0004Y\u0007\"B=\f\u0001\u0004Q\u0018AB2p]\u001aLw-\u0006\u0002\u0002\u001aA\u0019\u0001*a\u0007\n\u0007\u0005uaHA\tDYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\f!bY8oM&<w\fJ3r)\u0011\t\u0019#a\f\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ!!!\u000b\u0002\u000bM\u001c\u0017\r\\1\n\t\u00055\u0012q\u0005\u0002\u0005+:LG\u000fC\u0005\u000225\t\t\u00111\u0001\u0002\u001a\u0005\u0019\u0001\u0010J\u0019\u0002\u000f\r|gNZ5hA\u0005aQ.\u001b:s_J$v\u000e]5dgV\u0011\u0011\u0011\b\t\u0007\u0003w\t)%!\u0013\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\nq!\\;uC\ndWM\u0003\u0003\u0002D\u0005\u001d\u0012AC2pY2,7\r^5p]&!\u0011qIA\u001f\u0005\r\u0019V\r\u001e\t\u0005\u0003\u0017\nIF\u0004\u0003\u0002N\u0005U\u0003\u0003BA(\u0003Oi!!!\u0015\u000b\u0007\u0005MC)\u0001\u0004=e>|GOP\u0005\u0005\u0003/\n9#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00037\niF\u0001\u0004TiJLgn\u001a\u0006\u0005\u0003/\n9#A\u0007nSJ\u0014xN\u001d+pa&\u001c7\u000fI\u0001\u0016G>tg\r\\5di&tw\rR3tiR{\u0007/[2t\u0003Y\u0019wN\u001c4mS\u000e$\u0018N\\4EKN$Hk\u001c9jGN\u0004\u0013\u0001\u0005;bg.\u001cx*\u001e;ti\u0006tG-\u001b8h+\t\tI\u0007\u0005\u0003\u0002&\u0005-\u0014\u0002BA7\u0003O\u00111!\u00138u\u0003Q!\u0018m]6t\u001fV$8\u000f^1oI&twm\u0018\u0013fcR!\u00111EA:\u0011%\t\t\u0004FA\u0001\u0002\u0004\tI'A\tuCN\\7oT;ugR\fg\u000eZ5oO\u0002\n1\"\u001b8ji&\fG.\u001b>fIV\u0011\u00111\u0010\t\u0005\u0003K\ti(\u0003\u0003\u0002\u0000\u0005\u001d\"a\u0002\"p_2,\u0017M\\\u0001\u0010S:LG/[1mSj,Gm\u0018\u0013fcR!\u00111EAC\u0011%\t\tdFA\u0001\u0002\u0004\tY(\u0001\u0007j]&$\u0018.\u00197ju\u0016$\u0007%\u0001\rtQ>,H\u000e\u001a$jYR,'/T5se>\u0014Hk\u001c9jGN\fAd\u001d5pk2$g)\u001b7uKJl\u0015N\u001d:peR{\u0007/[2t?\u0012*\u0017\u000f\u0006\u0003\u0002$\u0005=\u0005\"CA\u00195\u0005\u0005\t\u0019AA>\u0003e\u0019\bn\\;mI\u001aKG\u000e^3s\u001b&\u0014(o\u001c:U_BL7m\u001d\u0011\u0002\u0011Q\f7o\u001b#fg\u000e,\"!a&\u0011\r\u0005\u0015\u0012\u0011TAO\u0013\u0011\tY*a\n\u0003\r=\u0003H/[8o!\rA\u0015qT\u0005\u0004\u0003Cs$a\u0004+bg.$Um]2sSB$\u0018n\u001c8\u0002\u0019Q\f7o\u001b#fg\u000e|F%Z9\u0015\t\u0005\r\u0012q\u0015\u0005\n\u0003ci\u0012\u0011!a\u0001\u0003/\u000b\u0011\u0002^1tW\u0012+7o\u0019\u0011)\u0007y\ti\u000b\u0005\u0003\u0002&\u0005=\u0016\u0002BAY\u0003O\u0011\u0001B^8mCRLG.Z\u0001\u0004eVtGCAA\\!\u0011\tI,a2\u000f\u0007\u0005m\u0016J\u0004\u0003\u0002>\u0006\u0015g\u0002BA`\u0003\u0007tA!a\u0014\u0002B&\t1)\u0003\u0002B\u0005&\u0011q\bQ\u0005\u0004\u0003\u0013l%A\u0003+bg.\u0014Vm];mi\u00069\u0012N\\5uS\u0006d\u0017N_3B]\u0012\fU\u000f^8NSJ\u0014xN]\u0001\u000bCV$x.T5se>\u0014H\u0003BA\\\u0003#Dq!a5\"\u0001\u0004\t).A\u0006uCN\\7i\u001c8uKb$\b\u0003BA]\u0003/L1!!7N\u0005-!\u0016m]6D_:$X\r\u001f;\u0002-!\fg\u000e\u001a7f\u0019&\u001cHoU8ve\u000e,Gk\u001c9jGN$b!a.\u0002`\u0006\u0005\bbBAjE\u0001\u0007\u0011Q\u001b\u0005\b\u0003G\u0014\u0003\u0019AAs\u0003\u0019\u0011Xm];miB!\u0011q]Ay\u001b\t\tIO\u0003\u0003\u0002l\u00065\u0018!B1e[&t'bAAxc\u000691\r\\5f]R\u001c\u0018\u0002BAz\u0003S\u0014\u0001\u0003T5tiR{\u0007/[2t%\u0016\u001cX\u000f\u001c;\u00029!\fg\u000e\u001a7f\u0019&\u001cHoU8ve\u000e,W*\u001b:s_J$v\u000e]5dgRA\u0011qWA}\u0003w\u0014\u0019\u0001C\u0004\u0002T\u000e\u0002\r!!6\t\u000f\u0005u8\u00051\u0001\u0002\u0000\u00061Ao\u001c9jGN\u0004b!a\u0013\u0003\u0002\u0005%\u0013\u0002BA$\u0003;BqA!\u0002$\u0001\u0004\u00119!A\tmSN$X*\u001b:s_J\u001ch)\u001e;ve\u0016\u0004bA!\u0003\u0003\f\t=Q\"A8\n\u0007\t5qNA\u0006LC\u001a\\\u0017MR;ukJ,\u0007C\u0002B\t\u00057\tI%\u0004\u0002\u0003\u0014)!!Q\u0003B\f\u0003\u0011)H/\u001b7\u000b\u0005\te\u0011\u0001\u00026bm\u0006LAA!\b\u0003\u0014\tQ1i\u001c7mK\u000e$\u0018n\u001c8\u0002)!\fg\u000e\u001a7f\r&dG/\u001a:fIR{\u0007/[2t)\u0019\t9La\t\u0003&!9\u00111\u001b\u0013A\u0002\u0005U\u0007b\u0002B\u0014I\u0001\u0007\u0011q`\u0001\u000fM&dG/\u001a:fIR{\u0007/[2t\u0003QA\u0017M\u001c3mK2K7\u000f\u001e#fgR$v\u000e]5dgRA\u0011q\u0017B\u0017\u0005_\u0011\t\u0004C\u0004\u0002T\u0016\u0002\r!!6\t\u000f\u0005\rX\u00051\u0001\u0002f\"9!qE\u0013A\u0002\u0005}\u0018\u0001\u00044jYR,'\u000fV8qS\u000e\u001cH\u0003BA\u0000\u0005oAq!!@'\u0001\u0004\ty0\u0001\u0007de\u0016\fG/\u001a+pa&\u001c7\u000f\u0006\u0004\u00028\nu\"q\b\u0005\b\u0003'<\u0003\u0019AAk\u0011\u001d\tip\na\u0001\u0003\u007f\f\u0001D]3n_Z,7k\\;sG\u0016l\u0015N\u001d:peR{\u0007/[2t)\u0019\tyP!\u0012\u0003H!9\u0011Q \u0015A\u0002\u0005}\bbBA\u001bQ\u0001\u0007\u0011q`\u0001\u0018Q\u0006tG\r\\3CCR\u001c\u0007n\u0011:fCR,Gk\u001c9jGN$\u0002\"a.\u0003N\t=#q\r\u0005\b\u0003'L\u0003\u0019AAk\u0011\u001d\u0011\t&\u000ba\u0001\u0005'\nQ\u0002^8qS\u000ed\u0015n\u001d;j]\u001e\u001c\b\u0003\u0003B\t\u0005+\nIE!\u0017\n\t\t]#1\u0003\u0002\u0004\u001b\u0006\u0004\bC\u0002B\u0005\u0005\u0017\u0011Y\u0006\u0005\u0003\u0003^\t\rTB\u0001B0\u0015\u0011\u0011\tGa\u0006\u0002\t1\fgnZ\u0005\u0005\u0005K\u0012yF\u0001\u0003W_&$\u0007b\u0002B5S\u0001\u0007!1N\u0001\u0011e\u0016l\u0017-\u001b8j]\u001e\u0014\u0015\r^2iKN\u0004bA!\u001c\u0003x\tud\u0002\u0002B8\u0005grA!a\u0014\u0003r%\u0011\u0011\u0011F\u0005\u0005\u0005k\n9#A\u0004qC\u000e\\\u0017mZ3\n\t\te$1\u0010\u0002\u0004'\u0016\f(\u0002\u0002B;\u0003O\u0001b!a\u0013\u0003\u0002\t}\u0004\u0003BAt\u0005\u0003KAAa!\u0002j\nAa*Z<U_BL7-\u0001\u0010bI\u0012l\u0015N\u001d:pe\u0016$Gk\u001c9jG\u0006sG\rT8h/\u0006\u0014h.\u001b8hgR1!\u0011\u0012BI\u0005+\u0003bA!\u001c\u0003x\t-\u0005c\u0001%\u0003\u000e&\u0019!q\u0012 \u0003'Q\u000b7o[#se>\u00148i\u001c3f\u0003:$Wj]4\t\u000f\tM%\u00061\u0001\u0002J\u0005)Ao\u001c9jG\"9!q\u0013\u0016A\u0002\te\u0013A\u00024viV\u0014X-A\bbY2d\u0015N\\6fIR{\u0007/[2t)\t\ty0A\u0016sK\u000e|'\u000f\u001a$bS2,G\r\u0015:fM&DX\rZ!vi>l\u0015N\u001d:pe\u000e\u0013X-\u0019;f\u001b\u0016$(/[2t)\t\t\u0019#A\bhKRl\u0015N\u001d:peR{\u0007/[2t\u0003a9W\r^\"p]\u001ad\u0017n\u0019;j]\u001e$Um\u001d;U_BL7m]\u0001\u000fO\u0016$\u0018J\\5uS\u0006d\u0017N_3e\u00031ygnQ8na2,G/[8o)\u0011\t\u0019Ca+\t\u000f\u0005\r\b\u00071\u0001\u0003.B\u0019qIa,\n\u0007\tEVJA\nD_6\u0004H.\u001a;fIR\u000b7o\u001b*fgVdG/A\buCN\\G)Z:de&\u0004H/[8o)\t\t9*A\u000eDYV\u001cH/\u001a:MS:\\\u0017)\u001e;p\u0007J,\u0017\r^3NSJ\u0014xN\u001d\t\u0003\u0011N\u001a2a\rB_!\u0011\t)Ca0\n\t\t\u0005\u0017q\u0005\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\te\u0016\u0001G1eI&$\u0018n\u001c8bY&sG/\u001a:oC2$v\u000e]5dgV\u0011!\u0011\u001a\t\u0007\u0005\u0017\u0014\tNa5\u000e\u0005\t5'\u0002\u0002Bh\u0003\u0003\n\u0011\"[7nkR\f'\r\\3\n\t\u0005\u001d#Q\u001a\t\u0005\u0005;\u0012).\u0003\u0003\u0002\\\t}\u0013!G1eI&$\u0018n\u001c8bY&sG/\u001a:oC2$v\u000e]5dg\u0002\na$\u00193eSRLwN\\1m\u0013:$XM\u001d8bYR{\u0007/[2QCR$XM\u001d8\u0016\u0005\tu\u0007\u0003\u0002Bp\u0005Kl!A!9\u000b\t\t\r(1C\u0001\u0006e\u0016<W\r_\u0005\u0005\u0005O\u0014\tOA\u0004QCR$XM\u001d8\u0002?\u0005$G-\u001b;j_:\fG.\u00138uKJt\u0017\r\u001c+pa&\u001c\u0007+\u0019;uKJt\u0007%\u0001\ndQ\u0016\u001c7.\u00138uKJt\u0017\r\u001c+pa&\u001cG\u0003CA>\u0005_\u0014ip!\u0001\t\u000f\tE\u0018\b1\u0001\u0003t\u0006ya.Y7fgR{G*[:uS:<7\u000f\u0005\u0005\u0002<\tU\u0018\u0011\nB|\u0013\u0011\u00119&!\u0010\u0011\t\u0005\u001d(\u0011`\u0005\u0005\u0005w\fIO\u0001\u0007U_BL7\rT5ti&tw\rC\u0004\u0003\u0000f\u0002\r!!\u001b\u0002\u0013A\u0014XMZ5y\u0019\u0016t\u0007b\u0002BJs\u0001\u0007\u0011\u0011J\u0001\u000fG\",7m\u001b+pa&\u001cG+\u001f9f)\u0019\tYha\u0002\u0004\n!9!\u0011\u001f\u001eA\u0002\tM\bb\u0002BJu\u0001\u0007\u0011\u0011J\u0001\u0019\u0007J+\u0015\tV#`)>\u0003\u0016jQ*`\u0005\u0006#6\tS0T\u0013j+\u0015!G\"S\u000b\u0006#Vi\u0018+P!&\u001b5k\u0018\"B)\u000eCulU%[\u000b\u0002\u0002")
public class ClusterLinkAutoCreateMirror
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkMetadataManager metadataManager;
    private final ClusterLinkData linkData;
    private final ClusterLinkBatchAdmin remoteAdmin;
    private final ClusterLinkBatchAdmin localAdmin;
    private final ClusterLinkMetrics metrics;
    private ClusterLinkConfig config;
    private final scala.collection.mutable.Set<String> mirrorTopics;
    private final scala.collection.mutable.Set<String> conflictingDestTopics;
    private int tasksOutstanding;
    private boolean initialized;
    private boolean shouldFilterMirrorTopics;
    private volatile Option<TaskDescription> taskDesc;

    public static int CREATE_TOPICS_BATCH_SIZE() {
        return ClusterLinkAutoCreateMirror$.MODULE$.CREATE_TOPICS_BATCH_SIZE();
    }

    public static boolean checkTopicType(scala.collection.mutable.Map<String, TopicListing> namesToListings, String topic) {
        return ClusterLinkAutoCreateMirror$.MODULE$.checkTopicType(namesToListings, topic);
    }

    public static boolean checkInternalTopic(scala.collection.mutable.Map<String, TopicListing> namesToListings, int prefixLen, String topic) {
        return ClusterLinkAutoCreateMirror$.MODULE$.checkInternalTopic(namesToListings, prefixLen, topic);
    }

    public static Pattern additionalInternalTopicPattern() {
        return ClusterLinkAutoCreateMirror$.MODULE$.additionalInternalTopicPattern();
    }

    public static scala.collection.immutable.Set<String> additionalInternalTopics() {
        return ClusterLinkAutoCreateMirror$.MODULE$.additionalInternalTopics();
    }

    public ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    public ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ClusterLinkConfig config() {
        return this.config;
    }

    private void config_$eq(ClusterLinkConfig x$1) {
        this.config = x$1;
    }

    private scala.collection.mutable.Set<String> mirrorTopics() {
        return this.mirrorTopics;
    }

    private scala.collection.mutable.Set<String> conflictingDestTopics() {
        return this.conflictingDestTopics;
    }

    private int tasksOutstanding() {
        return this.tasksOutstanding;
    }

    private void tasksOutstanding_$eq(int x$1) {
        this.tasksOutstanding = x$1;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private boolean shouldFilterMirrorTopics() {
        return this.shouldFilterMirrorTopics;
    }

    private void shouldFilterMirrorTopics_$eq(boolean x$1) {
        this.shouldFilterMirrorTopics = x$1;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        if (!this.initialized()) {
            return this.initializeAndAutoMirror();
        }
        return this.autoMirror(new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty())));
    }

    private ClusterLinkScheduler.TaskResult initializeAndAutoMirror() {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Initializing auto-mirroring ").append($this.linkData.linkId()).toString());
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty()));
        if (this.config().clusterLinkPrefix().isEmpty() || ((String)this.config().clusterLinkPrefix().get()).isEmpty()) {
            this.shouldFilterMirrorTopics_$eq(false);
            this.initialized_$eq(true);
            return this.autoMirror(taskContext);
        }
        KafkaFuture listMirrorsFuture = this.remoteAdmin.listMirrors().result();
        this.scheduleWhenComplete(listMirrorsFuture, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> {
            void var5_5;
            this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
            Tuple2<Object, Option<TaskErrorCodeAndMsg>> tuple2 = SourceCluster$.MODULE$.canContainMirrorTopics($this.metrics, (KafkaFuture<Collection<String>>)listMirrorsFuture);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            boolean shouldFilter = tuple2._1$mcZ$sp();
            Option errOpt = (Option)tuple2._2();
            if (var5_5 instanceof Some) {
                TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)((Some)var5_5).value();
                .colon.colon completedTask_errs = new .colon.colon((Object)err, (List)Nil$.MODULE$);
                return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
            }
            if (None$.MODULE$.equals(var5_5)) {
                void var4_4;
                this.shouldFilterMirrorTopics_$eq((boolean)var4_4);
                this.initialized_$eq(true);
                return this.autoMirror((ClusterLinkScheduler.TaskContext)tc);
            }
            throw new MatchError((Object)var5_5);
        }, taskContext));
        this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    private ClusterLinkScheduler.TaskResult autoMirror(ClusterLinkScheduler.TaskContext taskContext) {
        this.mirrorTopics().clear();
        this.config_$eq(this.clientManager().currentConfig());
        if (this.metadataManager().isLinkCoordinator(this.linkData.linkName()) && this.config().autoMirroringEnable()) {
            if (this.tasksOutstanding() != 0) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(91).append("Number of outstanding tasks was ").append(this.tasksOutstanding()).append(" at the beginning of run. Resetting to 0 and continuing on.").toString());
                this.tasksOutstanding_$eq(0);
            }
            if (this.config().topicFilters().isEmpty()) {
                String errMsg = new StringBuilder(72).append(ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()).append(" is true but no topic filters are specified. No topics will be mirrored.").toString();
                this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
                TaskErrorCodeAndMsg err = new TaskErrorCodeAndMsg(MisconfigurationTaskErrorCode$.MODULE$, errMsg);
                Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)err, (List)Nil$.MODULE$));
                return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
            }
            this.trace((Function0<String>)(Function0 & Serializable)() -> "Attempting to list topics from source cluster");
            ListTopicsResult listTopicsResult = this.remoteAdmin.listTopics();
            this.scheduleWhenComplete(listTopicsResult.namesToListings(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleListSourceTopics((ClusterLinkScheduler.TaskContext)tc, listTopicsResult), taskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    private ClusterLinkScheduler.TaskResult handleListSourceTopics(ClusterLinkScheduler.TaskContext taskContext, ListTopicsResult result) {
        ClusterLinkScheduler.TaskResult taskResult;
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        try {
            ObjectRef filteredTopics = ObjectRef.create((Object)((scala.collection.immutable.Set)this.filterTopics((scala.collection.immutable.Set<String>)CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)result.names().get()).asScala().toSet()).$minus$minus(this.allLinkedTopics())));
            scala.collection.mutable.Map namesToListings = CollectionConverters$.MODULE$.MapHasAsScala((Map)result.namesToListings().get()).asScala();
            int prefixLength = ((String)this.linkData.tenantPrefix().getOrElse((Function0 & Serializable)() -> "")).length() + ((String)this.config().clusterLinkPrefix().getOrElse((Function0 & Serializable)() -> "")).length();
            ((scala.collection.immutable.Set)filteredTopics.elem).foreach((Function1 & Serializable)topicName -> {
                ClusterLinkAutoCreateMirror.$anonfun$handleListSourceTopics$3(this, namesToListings, prefixLength, filteredTopics, topicName);
                return BoxedUnit.UNIT;
            });
            if (this.shouldFilterMirrorTopics()) {
                KafkaFuture listMirrorsFuture = this.remoteAdmin.listMirrors().result();
                this.scheduleWhenComplete(listMirrorsFuture, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleListSourceMirrorTopics((ClusterLinkScheduler.TaskContext)tc, (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)filteredTopics$1.elem), (KafkaFuture<Collection<String>>)listMirrorsFuture), taskContext));
                this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
                return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
            }
            taskResult = this.handleFilteredTopics(taskContext, (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)filteredTopics.elem));
        }
        catch (ExecutionException ex) {
            TaskErrorCodeAndMsg taskErrorCodeAndMsg;
            KafkaException kafkaException;
            this.metrics.autoMirrorListTopicsFromSourceFailedSensor().record();
            Throwable throwable = ex.getCause();
            if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                String errMsg = "Unable to list topics on the source cluster due to authentication issues.";
                this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, errMsg);
            } else if (throwable instanceof AuthorizationException) {
                String errMsg = "Unable to list topics on the source cluster. Please enable DESCRIBE ACLs on the source cluster to proceed.";
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex.getCause()).toString());
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg);
            } else {
                String errMsg = "Unable to list topics on the source cluster due to unexpected execution exception. Topics will not be mirrored.";
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex).toString());
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg);
            }
            TaskErrorCodeAndMsg errorCodeAndMsg = taskErrorCodeAndMsg;
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)errorCodeAndMsg, (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        catch (Throwable ex) {
            String errMsg = "Unable to list topics on the source cluster due to unexpected throwable exception. Topics will not be mirrored.";
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex).toString());
            this.metrics.autoMirrorListTopicsFromSourceFailedSensor().record();
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
            taskResult = new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        return taskResult;
    }

    private ClusterLinkScheduler.TaskResult handleListSourceMirrorTopics(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<String> topics, KafkaFuture<Collection<String>> listMirrorsFuture) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        try {
            scala.collection.immutable.Set<String> filteredTopics = this.removeSourceMirrorTopics(topics, (scala.collection.immutable.Set<String>)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)listMirrorsFuture.get()).asScala().toSet());
            return this.handleFilteredTopics(taskContext, filteredTopics);
        }
        catch (ExecutionException ex) {
            TaskErrorCodeAndMsg taskErrorCodeAndMsg;
            KafkaException kafkaException;
            this.metrics.autoMirrorListMirrorsFromSourceFailedSensor().record();
            Throwable throwable = ex.getCause();
            if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                String errMsg = " Unable to list mirrors on the source cluster due to authentication issues.";
                this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, errMsg);
            } else if (throwable instanceof AuthorizationException) {
                String errMsg = "Unable to list mirrors on the source cluster. Please enable Describe:Cluster ACLs on the source cluster to proceed.";
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex.getCause()).toString());
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg);
            } else {
                String errMsg = "Unable to list mirrors on the source cluster due to unexpected execution exception. Topics will not be mirrored.";
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex).toString());
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg);
            }
            TaskErrorCodeAndMsg errorCodeAndMsg = taskErrorCodeAndMsg;
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)errorCodeAndMsg, (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        catch (Throwable ex) {
            String errMsg = "Unable to list mirrors on the source cluster due to unexpected throwable exception. Topics will not be mirrored.";
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex).toString());
            this.metrics.autoMirrorListMirrorsFromSourceFailedSensor().record();
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
    }

    private ClusterLinkScheduler.TaskResult handleFilteredTopics(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<String> filteredTopics) {
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Will attempt to mirror following topics on destination cluster: ").append(filteredTopics).toString());
        if (this.conflictingDestTopics().intersect(filteredTopics).nonEmpty()) {
            ListTopicsResult listTopicsResult = this.localAdmin.listTopics();
            this.scheduleWhenComplete(listTopicsResult.namesToListings(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleListDestTopics((ClusterLinkScheduler.TaskContext)tc, listTopicsResult, filteredTopics), taskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        if (this.conflictingDestTopics().nonEmpty()) {
            this.conflictingDestTopics().clear();
        }
        return this.createTopics(taskContext, filteredTopics);
    }

    private ClusterLinkScheduler.TaskResult handleListDestTopics(ClusterLinkScheduler.TaskContext taskContext, ListTopicsResult result, scala.collection.immutable.Set<String> filteredTopics) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        try {
            java.util.Set destTopics = (java.util.Set)result.names().get();
            if (this.conflictingDestTopics().nonEmpty()) {
                this.conflictingDestTopics().clear();
            }
            this.conflictingDestTopics().$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(destTopics).asScala().intersect(filteredTopics));
            if (this.conflictingDestTopics().nonEmpty()) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Found following conflicting topics on destination: ").append(this.conflictingDestTopics()).toString());
            }
            this.conflictingDestTopics().foreach((Function1 & Serializable)topic -> {
                ClusterLinkAutoCreateMirror.$anonfun$handleListDestTopics$2(this, topic);
                return BoxedUnit.UNIT;
            });
            scala.collection.immutable.Set topicsToCreate = (scala.collection.immutable.Set)filteredTopics.$minus$minus(this.conflictingDestTopics());
            return this.createTopics(taskContext, (scala.collection.immutable.Set<String>)topicsToCreate);
        }
        catch (Throwable ex) {
            String errMsg = "Unable to list topics on destination cluster to check for conflicting topics.";
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex).toString());
            this.metrics.autoMirrorListTopicsFromDestinationFailedSensor().record();
            ClusterLinkScheduler.TaskContext newTaskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$))));
            return this.createTopics(newTaskContext, filteredTopics);
        }
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Set<String> filterTopics(scala.collection.immutable.Set<String> topics) {
        void var3_3;
        void var4_4;
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Filtering source topics ").append(topics).append(" to match topic filters JSON").toString());
        Tuple2<scala.collection.immutable.Set<String>, Seq<ClusterLinkFilterInfo>> tuple2 = ClusterLinkUtils$.MODULE$.doFilterTopics(topics, this.config().topicFilters(), this.linkData.tenantPrefix(), this.config().clusterLinkPrefix());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set filtered = (scala.collection.immutable.Set)tuple2._1();
        Seq unusedFilters = (Seq)tuple2._2();
        var4_4.foreach((Function1 & Serializable)unusedFilter -> {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(197).append("The filter ").append(unusedFilter).append(" does not match any source topic. This filter may not be ").append("required or the topics it referred to may not have the correct DESCRIBE ACL ").append("for the cluster link principal on the source cluster.").toString());
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    private ClusterLinkScheduler.TaskResult createTopics(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<String> topics) {
        int tenantPrefixLength;
        int clusterLinkPrefixLength = ((String)this.config().clusterLinkPrefix().getOrElse((Function0 & Serializable)() -> "")).length();
        Seq batchedTopics = ((scala.collection.immutable.Set)topics.map(arg_0 -> ClusterLinkAutoCreateMirror.$anonfun$createTopics$3(this, clusterLinkPrefixLength, tenantPrefixLength = ((String)this.linkData.tenantPrefix().getOrElse((Function0 & Serializable)() -> "")).length(), arg_0))).grouped(ClusterLinkAutoCreateMirror$.MODULE$.CREATE_TOPICS_BATCH_SIZE()).toSeq();
        if (batchedTopics.nonEmpty()) {
            scala.collection.immutable.Set firstBatch = (scala.collection.immutable.Set)batchedTopics.apply(0);
            Seq remainingBatches = (Seq)batchedTopics.drop(1);
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Creating following topics on destination cluster: ").append(firstBatch).toString());
            CreateTopicsResult result = this.localAdmin.createTopics(CollectionConverters$.MODULE$.SetHasAsJava((Set)firstBatch).asJava());
            this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleBatchCreateTopics((ClusterLinkScheduler.TaskContext)tc, result.values(), (Seq<scala.collection.immutable.Set<NewTopic>>)remainingBatches), taskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    private scala.collection.immutable.Set<String> removeSourceMirrorTopics(scala.collection.immutable.Set<String> topics, scala.collection.immutable.Set<String> mirrorTopics) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(24).append("Mirror topics at source ").append(mirrorTopics).toString());
        scala.collection.immutable.Set filteredTopics = (scala.collection.immutable.Set)topics.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAutoCreateMirror.$anonfun$removeSourceMirrorTopics$2(mirrorTopics, x$4)));
        scala.collection.immutable.Set filteredOutTopics = (scala.collection.immutable.Set)topics.$minus$minus((IterableOnce)filteredTopics);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Filtering out ").append(filteredOutTopics).append(" because they are mirror topics at the source cluster").toString());
        if (filteredOutTopics.nonEmpty()) {
            this.metrics.prefixedAutoMirrorTopicFilteredSensor().record((double)filteredOutTopics.size());
        } else {
            this.metrics.prefixedAutoMirrorTopicFilteredSensor().record(0.0);
        }
        return filteredTopics;
    }

    private ClusterLinkScheduler.TaskResult handleBatchCreateTopics(ClusterLinkScheduler.TaskContext taskContext, Map<String, KafkaFuture<Void>> topicListings, Seq<scala.collection.immutable.Set<NewTopic>> remainingBatches) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        Iterable errs = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(topicListings).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topic = (String)x0$1._1();
                KafkaFuture future = (KafkaFuture)x0$1._2();
                return this.addMirroredTopicAndLogWarnings(topic, (KafkaFuture<Void>)future);
            }
            throw new MatchError(null);
        });
        ClusterLinkScheduler.TaskContext newTaskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((IterableOnce)errs)));
        if (remainingBatches.isEmpty()) {
            Seq<TaskErrorCodeAndMsg> completedTask_errs = newTaskContext.errs();
            return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
        }
        scala.collection.immutable.Set nextBatch = (scala.collection.immutable.Set)remainingBatches.apply(0);
        Seq nextRemainingBatches = (Seq)remainingBatches.drop(1);
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Creating following topics on destination cluster: ").append(nextBatch).toString());
        CreateTopicsResult result = this.localAdmin.createTopics(CollectionConverters$.MODULE$.SetHasAsJava((Set)nextBatch).asJava());
        this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleBatchCreateTopics((ClusterLinkScheduler.TaskContext)tc, result.values(), (Seq<scala.collection.immutable.Set<NewTopic>>)nextRemainingBatches), newTaskContext));
        this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        Seq<TaskErrorCodeAndMsg> inProgressTask_errs = newTaskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    private Seq<TaskErrorCodeAndMsg> addMirroredTopicAndLogWarnings(String topic, KafkaFuture<Void> future) {
        None$ errOpt;
        None$ none$;
        try {
            future.get();
            this.mirrorTopics().$plus$eq((Object)topic);
            this.metrics.autoMirrorCreateSensor().record();
            if (!this.config().clusterLinkPrefix().forall((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isEmpty()))) {
                this.metrics.prefixedAutoMirrorCreateSensor().record();
            }
            none$ = None$.MODULE$;
        }
        catch (ExecutionException ex) {
            KafkaException kafkaException;
            Throwable throwable = ex.getCause();
            if (throwable instanceof TopicExistsException) {
                this.conflictingDestTopics().add((Object)topic);
                String errMsg = new StringBuilder(75).append("Topic ").append(topic).append(" already exists on destination cluster. Will not mirror source").append(" topic.").toString();
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(errMsg).append(ex.getCause()).toString());
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                none$ = new Some((Object)new TaskErrorCodeAndMsg(TopicExistsTaskErrorCode$.MODULE$, errMsg));
            } else if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                String errMsg = new StringBuilder(53).append("Unable to create topic ").append(topic).append(" due to authentication issues.").toString();
                this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                none$ = new Some((Object)new TaskErrorCodeAndMsg(BrokerAuthenticationTaskErrorCode$.MODULE$, errMsg));
            } else if (throwable instanceof AuthorizationException) {
                AuthorizationException authorizationException = (AuthorizationException)throwable;
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                String errMsg = new StringBuilder(52).append("Unable to create topic ").append(topic).append(" due to authorization error. ").append(authorizationException.getMessage()).toString();
                this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
                none$ = new Some((Object)new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg));
            } else if (throwable instanceof PolicyViolationException) {
                PolicyViolationException policyViolationException = (PolicyViolationException)throwable;
                String errMsg = new StringBuilder(47).append("Unable to create topic ").append(topic).append(" on destination cluster.").toString();
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(policyViolationException).toString());
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                none$ = new Some((Object)new TaskErrorCodeAndMsg(PolicyViolationTaskErrorCode$.MODULE$, new StringBuilder(43).append("Failed to create ").append(topic).append(" due to policy violation: ").append(policyViolationException.getMessage()).toString()));
            } else if (throwable instanceof InvalidTopicException) {
                InvalidTopicException invalidTopicException = (InvalidTopicException)throwable;
                String errMsg = new StringBuilder(47).append("Unable to create topic ").append(topic).append(" on destination cluster.").toString();
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append((Object)invalidTopicException).toString());
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                none$ = new Some((Object)new TaskErrorCodeAndMsg(InvalidTopicTaskErrorCode$.MODULE$, new StringBuilder(53).append("Failed to create ").append(topic).append(" due to an invalid topic exception: ").append(invalidTopicException.getMessage()).toString()));
            } else {
                String errMsg = new StringBuilder(47).append("Unable to create topic ").append(topic).append(" on destination cluster.").toString();
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex).toString());
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                none$ = new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
            }
        }
        catch (Throwable ex) {
            String errMsg = new StringBuilder(47).append("Unable to create topic ").append(topic).append(" on destination cluster.").toString();
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex).toString());
            this.metrics.autoMirrorCreateFailedSensor().record();
            this.recordFailedPrefixedAutoMirrorCreateMetrics();
            none$ = errOpt = new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
        }
        if (errOpt instanceof Some) {
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)((Some)errOpt).value();
            return new .colon.colon((Object)err, (List)Nil$.MODULE$);
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private scala.collection.immutable.Set<String> allLinkedTopics() {
        return this.metadataManager().mirrorTopicStatesFromMetadataCache(this.linkData.linkId()).keySet().toSet();
    }

    private void recordFailedPrefixedAutoMirrorCreateMetrics() {
        if (!this.config().clusterLinkPrefix().forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isEmpty()))) {
            this.metrics.prefixedAutoMirrorCreateFailedSensor().record();
            return;
        }
    }

    public scala.collection.mutable.Set<String> getMirrorTopics() {
        return this.mirrorTopics();
    }

    public scala.collection.mutable.Set<String> getConflictingDestTopics() {
        return this.conflictingDestTopics();
    }

    public boolean getInitialized() {
        return this.initialized();
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Completed with task result ").append(result).toString());
        Option<TaskDescription> newTaskDesc = this.metadataManager().isLinkCoordinator(this.linkData.linkName()) ? (this.config().autoMirroringEnable() ? ClusterLinkTask$.MODULE$.handleResult(result, this.metrics, ClusterLinkAutoMirroringTaskType$.MODULE$, false, "run the auto create mirror topic task") : new Some((Object)new TaskDescription(NotConfiguredTaskState$.MODULE$, (Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty())))) : None$.MODULE$;
        this.taskDesc_$eq(newTaskDesc);
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    public static final /* synthetic */ void $anonfun$handleListSourceTopics$3(ClusterLinkAutoCreateMirror $this, scala.collection.mutable.Map namesToListings$1, int prefixLength$1, ObjectRef filteredTopics$1, String topicName) {
        if (ClusterLinkAutoCreateMirror$.MODULE$.checkInternalTopic((scala.collection.mutable.Map<String, TopicListing>)namesToListings$1, prefixLength$1, topicName)) {
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Internal or Confluent topic ").append(topicName).append(" will not be mirrored.").toString());
            filteredTopics$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)filteredTopics$1.elem).$minus((Object)topicName);
        }
        if (ClusterLinkAutoCreateMirror$.MODULE$.checkTopicType((scala.collection.mutable.Map<String, TopicListing>)namesToListings$1, topicName)) {
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Topic ").append(topicName).append(" is of type VIRTUAL or UNKNOWN and will not be mirrored.").toString());
            filteredTopics$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)filteredTopics$1.elem).$minus((Object)topicName);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$handleListDestTopics$2(ClusterLinkAutoCreateMirror $this, String topic) {
        $this.metrics.autoMirrorCreateFailedSensor().record();
        $this.recordFailedPrefixedAutoMirrorCreateMetrics();
    }

    public static final /* synthetic */ NewTopic $anonfun$createTopics$3(ClusterLinkAutoCreateMirror $this, int clusterLinkPrefixLength$1, int tenantPrefixLength$1, String topic) {
        String mirrorTopicName = clusterLinkPrefixLength$1 > 0 ? new StringBuilder(0).append(topic.substring(0, tenantPrefixLength$1)).append(topic.substring(tenantPrefixLength$1 + clusterLinkPrefixLength$1)).toString() : topic;
        return new NewTopic(topic, Optional.empty(), Optional.empty()).mirror(Optional.of(new NewMirrorTopic($this.linkData.linkName(), mirrorTopicName)));
    }

    public static final /* synthetic */ boolean $anonfun$removeSourceMirrorTopics$2(scala.collection.immutable.Set mirrorTopics$1, String x$4) {
        return !mirrorTopics$1.contains((Object)x$4);
    }

    public ClusterLinkAutoCreateMirror(ClusterLinkDestClientManager clientManager, ClusterLinkMetadataManager metadataManager, ClusterLinkData linkData, ClusterLinkBatchAdmin remoteAdmin, ClusterLinkBatchAdmin localAdmin, ClusterLinkMetrics metrics, Time time, ClusterLinkRequestQuota quota) {
        this.clientManager = clientManager;
        this.metadataManager = metadataManager;
        this.linkData = linkData;
        this.remoteAdmin = remoteAdmin;
        this.localAdmin = localAdmin;
        this.metrics = metrics;
        super(clientManager.scheduler(), "ClusterLinkAutoCreateMirror", (int)Predef$.MODULE$.Long2long(clientManager.currentConfig().metadataMaxAgeMs()), time, quota);
        this.config = clientManager.currentConfig();
        this.mirrorTopics = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        this.conflictingDestTopics = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        this.logIdent_$eq(new StringBuilder(4).append("[").append(this.getClass().getSimpleName()).append("-").append(linkData.linkName()).append("] ").toString());
        this.tasksOutstanding = 0;
        this.initialized = false;
        this.taskDesc = None$.MODULE$;
    }
}

