/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Map;
import kafka.server.link.Encoder;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.security.EncryptingPasswordEncoder;
import org.apache.kafka.security.PasswordEncoder;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;

public final class ClusterLinkConfigProvider$ {
    public static final ClusterLinkConfigProvider$ MODULE$ = new ClusterLinkConfigProvider$();
    private static final String ProviderName = "clusterlink";
    private static final String ProviderParamPrefix = new StringBuilder(24).append("config.providers").append(".").append(MODULE$.ProviderName()).append(".param.").toString();
    private static final String EncryptedConfigPrefix = "encrypted.";
    private static final Seq<String> EncryptedSecretPrefixes = new .colon.colon((Object)new StringBuilder(7).append(MODULE$.EncryptedConfigPrefix()).append("secret.").toString(), (List)new .colon.colon((Object)new StringBuilder(11).append(MODULE$.EncryptedConfigPrefix()).append("old.secret.").toString(), (List)Nil$.MODULE$));

    public String ProviderName() {
        return ProviderName;
    }

    public String ProviderParamPrefix() {
        return ProviderParamPrefix;
    }

    public String EncryptedConfigPrefix() {
        return EncryptedConfigPrefix;
    }

    public Seq<String> EncryptedSecretPrefixes() {
        return EncryptedSecretPrefixes;
    }

    public Seq<Encoder> createEncoders(Map<String, ?> configs, boolean includeOldSecret) {
        return ((IterableOnceOps)Option$.MODULE$.option2Iterable(ClusterLinkConfigProvider$.encoderSecret$1("password.encoder.secret", includeOldSecret, configs).map((Function1 & Serializable)secret -> MODULE$.createEncoder(configs, "secret.", (Password)secret))).$plus$plus((IterableOnce)ClusterLinkConfigProvider$.encoderSecret$1("password.encoder.old.secret", includeOldSecret, configs).map((Function1 & Serializable)secret -> MODULE$.createEncoder(configs, "old.secret.", (Password)secret)))).toSeq();
    }

    private Encoder createEncoder(Map<String, ?> configs, String secretPrefix, Password secret) {
        Option algOpt = Option$.MODULE$.apply(configs.get("password.encoder.keyfactory.algorithm")).map((Function1 & Serializable)x$4 -> x$4.toString());
        String alg = algOpt.isDefined() ? (String)algOpt.get() : null;
        EncryptingPasswordEncoder passwordEncoder = new EncryptingPasswordEncoder(secret, alg, configs.get("password.encoder.cipher.algorithm").toString(), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(configs.get("password.encoder.key.length").toString())), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(configs.get("password.encoder.iterations").toString())));
        return new Encoder(secretPrefix, secret, (PasswordEncoder)passwordEncoder);
    }

    public boolean createEncoders$default$2() {
        return true;
    }

    private static final Option encoderSecret$1(String configName, boolean includeOldSecret$1, Map configs$1) {
        String string = configName;
        String string2 = "password.encoder.old.secret";
        if (string != null && string.equals(string2) && !includeOldSecret$1) {
            return None$.MODULE$;
        }
        return Option$.MODULE$.apply(configs$1.get(configName)).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof Password) {
                return (Password)x0$1;
            }
            if (x0$1 instanceof String) {
                String string = (String)x0$1;
                return new Password(string);
            }
            throw new IllegalStateException(new StringBuilder(40).append("Unexpected password encoder secret type ").append(x0$1.getClass()).toString());
        });
    }

    private ClusterLinkConfigProvider$() {
    }
}

