/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.time.Duration;
import java.util.ServiceLoader;
import kafka.server.link.AclBindingFilterTransformer;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkLocalAdmin;
import kafka.server.link.IdentityAclBindingFilterTransformer;
import org.apache.kafka.clients.ClientInterceptor;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ClusterLinkManager$ {
    public static final ClusterLinkManager$ MODULE$ = new ClusterLinkManager$();
    private static final String LocalTenantPrefixProp = "cluster.link.local.tenant.prefix";
    private static final String LinkNameProp = "cluster.link.name";
    private static final String LinkMetricsModeProp = "cluster.link.metrics.mode";
    private static final String IsMultiTenantProp = "multi.tenant.enabled";
    private static final String migrateBootstrapOverrideTaskName = "MigrateBootstrapOverride";

    public Option<String> $lessinit$greater$default$8() {
        return None$.MODULE$;
    }

    public String LocalTenantPrefixProp() {
        return LocalTenantPrefixProp;
    }

    public String LinkNameProp() {
        return LinkNameProp;
    }

    public String LinkMetricsModeProp() {
        return LinkMetricsModeProp;
    }

    public String IsMultiTenantProp() {
        return IsMultiTenantProp;
    }

    public String migrateBootstrapOverrideTaskName() {
        return migrateBootstrapOverrideTaskName;
    }

    public ClientInterceptor prefixInterceptor(String localTenantPrefix, String clusterLinkPrefix, String linkName, ClusterLinkConfig.LinkMode linkModeForMetrics, Metrics metrics, boolean isMultiTenant, boolean clusterLinkPrefixConsumerGroup, boolean clusterLinkEnableMetricsReductionAdvanced, String ccloudIntranetHostSuffixes) {
        if (!linkName.startsWith(localTenantPrefix)) {
            throw new IllegalStateException(new StringBuilder(57).append("Tenant interceptor request for link '").append(linkName).append("' without prefix '").append(localTenantPrefix).append("''").toString());
        }
        String unprefixedLinkName = linkName.substring(localTenantPrefix.length());
        java.util.Map configs = CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.LocalTenantPrefixProp()), (Object)localTenantPrefix), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.LinkNameProp()), (Object)unprefixedLinkName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.LinkMetricsModeProp()), (Object)linkModeForMetrics), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp()), (Object)clusterLinkPrefix), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerGroupPrefixEnableProp()), (Object)BoxesRunTime.boxToBoolean((boolean)clusterLinkPrefixConsumerGroup)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IsMultiTenantProp()), (Object)BoxesRunTime.boxToBoolean((boolean)isMultiTenant)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.cluster.link.enable.metrics.reduction.advanced"), (Object)BoxesRunTime.boxToBoolean((boolean)clusterLinkEnableMetricsReductionAdvanced)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.ccloud.intranet.host.suffixes"), (Object)ccloudIntranetHostSuffixes)}))).asJava();
        if (isMultiTenant) {
            return (ClientInterceptor)CollectionConverters$.MODULE$.IterableHasAsScala(ServiceLoader.load(ClientInterceptor.class)).asScala().find((Function1 & Serializable)interceptor -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkManager$.$anonfun$prefixInterceptor$1(configs, metrics, interceptor))).getOrElse((Function0 & Serializable)() -> {
                throw new InvalidClusterLinkException("Cluster link interceptor not found");
            });
        }
        Some interceptor2 = new Some((Object)((ClientInterceptor)Class.forName("io.confluent.kafka.link.ClusterLinkInterceptor").newInstance()));
        interceptor2.foreach((Function1 & Serializable)x$1 -> {
            x$1.configure(configs);
            return BoxedUnit.UNIT;
        });
        interceptor2.foreach((Function1 & Serializable)x$2 -> {
            x$2.configureMetrics(metrics);
            return BoxedUnit.UNIT;
        });
        return (ClientInterceptor)interceptor2.getOrElse((Function0 & Serializable)() -> {
            throw new InvalidClusterLinkException("Cluster link interceptor not found");
        });
    }

    public int hashValue(String name, int max) {
        return (Utils.murmur2((byte[])name.getBytes()) & Integer.MAX_VALUE) % max;
    }

    public AclBindingFilterTransformer aclBindingFilterTransform(Option<String> tenantPrefix, boolean isMultiTenant) {
        if (isMultiTenant && tenantPrefix.isDefined()) {
            return (AclBindingFilterTransformer)CollectionConverters$.MODULE$.IterableHasAsScala(ServiceLoader.load(AclBindingFilterTransformer.class)).asScala().find((Function1 & Serializable)transformer -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkManager$.$anonfun$aclBindingFilterTransform$1(tenantPrefix, transformer))).getOrElse((Function0 & Serializable)() -> {
                throw new InvalidClusterLinkException("AclBindingFilterTransformer implementation not found.");
            });
        }
        return new IdentityAclBindingFilterTransformer();
    }

    public <T> void runAndCloseAdmin(KafkaFuture<T> result, Function1<KafkaFuture<T>, BoxedUnit> cb, boolean useTemporaryClient, ClusterLinkLocalAdmin admin) {
        try {
            cb.apply(result);
        }
        finally {
            if (useTemporaryClient) {
                admin.close(Duration.ZERO);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$prefixInterceptor$1(java.util.Map configs$1, Metrics metrics$1, ClientInterceptor interceptor) {
        try {
            interceptor.configure(configs$1);
            interceptor.configureMetrics(metrics$1);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static final /* synthetic */ boolean $anonfun$aclBindingFilterTransform$1(Option tenantPrefix$1, AclBindingFilterTransformer transformer) {
        try {
            transformer.configure((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.LocalTenantPrefixProp()), tenantPrefix$1.get())}))));
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private ClusterLinkManager$() {
    }
}

