/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.util.List;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.MirrorTopicConfigSyncRules$;
import org.apache.kafka.common.config.ConfigDef;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;

public final class TopicConfigSyncIncludeValidator$ {
    public static final TopicConfigSyncIncludeValidator$ MODULE$ = new TopicConfigSyncIncludeValidator$();
    private static final ConfigDef.Validator ConfigDefValidator = new ConfigDef.NonEmptyStringWithoutControlChars(){

        private /* synthetic */ void super$ensureValid(String x$1, Object x$2) {
            super.ensureValid(x$1, x$2);
        }

        public void ensureValid(String name, Object value) {
            ((List)value).forEach(str -> this.super$ensureValid(name, str));
        }
    };

    public ConfigDef.Validator ConfigDefValidator() {
        return ConfigDefValidator;
    }

    public Set<String> validate(List<String> value) {
        Set topicConfigs = CollectionConverters$.MODULE$.ListHasAsScala(value).asScala().toSet();
        this.checkUnknownTopicConfigs((Set<String>)topicConfigs);
        this.checkAlwaysConfigs((Set<String>)topicConfigs);
        this.checkIndependentConfigs((Set<String>)topicConfigs);
        return topicConfigs;
    }

    private void checkUnknownTopicConfigs(Set<String> configs) {
        Set diff = (Set)configs.$minus$minus(MirrorTopicConfigSyncRules$.MODULE$.AllConfigs());
        if (diff.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(79).append("Invalid topic configs specified in ").append(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp()).append(": ").append(diff.mkString(",")).append(". Please use the common topic config name.").toString());
        }
    }

    private void checkAlwaysConfigs(Set<String> configs) {
        Set diff = (Set)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().$minus$minus(configs);
        if (diff.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(113).append("To make cluster linking function properly, ").append(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp()).append(" ").append("must include these topic configs: ").append(MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().mkString(",")).append(" ").append("\nThese topic configs are missing: ").append(diff.mkString(",")).toString());
        }
    }

    private void checkIndependentConfigs(Set<String> configs) {
        Set inter = (Set)configs.intersect(MirrorTopicConfigSyncRules$.MODULE$.IndependentConfigs());
        if (inter.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(110).append("To make cluster linking function properly, ").append(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp()).append(" ").append("cannot include these topic configs: ").append(MirrorTopicConfigSyncRules$.MODULE$.IndependentConfigs().mkString(",")).append(" ").append("\nRemove these topic configs: ").append(inter.mkString(",")).toString());
        }
    }

    private TopicConfigSyncIncludeValidator$() {
    }
}

