/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import kafka.server.KafkaConfig;
import kafka.tier.store.TierObjectStoreConfig;
import scala.compat.java8.OptionConverters;

public class AzureBlockBlobTierObjectStoreConfig
extends TierObjectStoreConfig {
    public Optional<AzureCredentialsConfig> azureCredentialsConfig;
    public Optional<String> endpoint;
    public String container;
    public String azureBlobPrefix;
    public int drainThreshold;

    public AzureBlockBlobTierObjectStoreConfig(Optional<String> clusterIdOpt, KafkaConfig config) {
        super(clusterIdOpt, config);
        this.validateConfig(config);
        Optional azureBlockBlobCredFilePath = OptionConverters.toJava(config.confluentConfig().tierAzureBlockBlobCredFilePath());
        this.endpoint = OptionConverters.toJava(config.confluentConfig().tierAzureBlockBlobEndpoint());
        this.azureCredentialsConfig = this.readAzureCredentials(azureBlockBlobCredFilePath, this.endpoint.isPresent());
        this.container = config.confluentConfig().tierAzureBlockBlobContainer();
        this.azureBlobPrefix = config.confluentConfig().tierAzureBlockBlobPrefix();
        this.drainThreshold = config.confluentConfig().tierAzureBlockBlobConnectionDrainSize();
    }

    protected AzureBlockBlobTierObjectStoreConfig(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt, Optional<String> azureBlockBlobCredFilePath, Optional<String> endpoint, String container, String azureBlobPrefix, int drainThreshold) {
        super(clusterIdOpt, brokerIdOpt);
        this.endpoint = endpoint;
        this.azureCredentialsConfig = this.readAzureCredentials(azureBlockBlobCredFilePath, endpoint.isPresent());
        this.container = container;
        this.azureBlobPrefix = azureBlobPrefix;
        this.drainThreshold = drainThreshold;
    }

    public static AzureBlockBlobTierObjectStoreConfig createWithEmptyClusterIdBrokerId(Optional<String> azureBlockBlobCredFilePath, Optional<String> endpoint, String container, String azureBlobPrefix, int drainThreshold) {
        return new AzureBlockBlobTierObjectStoreConfig(Optional.empty(), Optional.empty(), azureBlockBlobCredFilePath, endpoint, container, azureBlobPrefix, drainThreshold);
    }

    private void validateConfig(KafkaConfig config) {
        if (config.confluentConfig().tierAzureBlockBlobCredFilePath().isEmpty() && config.confluentConfig().tierAzureBlockBlobEndpoint().isEmpty()) {
            throw new IllegalArgumentException("At least one of " + KafkaConfig.TierAzureBlockBlobCredFilePathProp() + " or " + KafkaConfig.TierAzureBlockBlobEndpointProp() + " must be set if " + KafkaConfig.TierBackendProp() + " property is set to Azure.");
        }
        if (config.confluentConfig().tierAzureBlockBlobContainer() == null) {
            throw new IllegalArgumentException(KafkaConfig.TierAzureBlockBlobContainerProp() + " must be set if " + KafkaConfig.TierBackendProp() + " property is set to Azure.");
        }
    }

    private Optional<AzureCredentialsConfig> readAzureCredentials(Optional<String> azureBlockBlobCredFilePath, boolean azureBlockBlobEndpointIsPresent) {
        if (!azureBlockBlobCredFilePath.isPresent()) {
            return Optional.empty();
        }
        AzureCredentialsConfig azureCredentials = AzureBlockBlobTierObjectStoreConfig.readCredFilePath(azureBlockBlobCredFilePath.get());
        if (!azureCredentials.connectionStringAuthMethod().booleanValue() && !azureCredentials.servicePrincipalWithSecretAuthMethod().booleanValue()) {
            throw new IllegalArgumentException("No credentials found in file: " + azureBlockBlobCredFilePath.get() + ". One of connectionString or (azureClientId + azureTenantId + azureClientSecret) must be supplied");
        }
        if (azureCredentials.connectionString() != null && (azureCredentials.azureClientId() != null || azureCredentials.azureTenantId() != null || azureCredentials.azureClientSecret() != null)) {
            throw new IllegalArgumentException("Only one of connectionString or (azureClientId + azureTenantId + azureClientSecret) can be set in file " + azureBlockBlobCredFilePath.get());
        }
        if (azureCredentials.servicePrincipalWithSecretAuthMethod().booleanValue() && !azureBlockBlobEndpointIsPresent) {
            throw new IllegalArgumentException(KafkaConfig.TierAzureBlockBlobEndpointProp() + " must be specified when authenticating using a service principal with secret in file: " + azureBlockBlobCredFilePath.get());
        }
        if (azureCredentials.connectionStringAuthMethod().booleanValue() && azureBlockBlobEndpointIsPresent) {
            throw new IllegalArgumentException(KafkaConfig.TierAzureBlockBlobEndpointProp() + " should not be set when using a connection string in file: " + azureBlockBlobCredFilePath.get());
        }
        return Optional.of(azureCredentials);
    }

    private static AzureCredentialsConfig readCredFilePath(String azureBlockBlobCredFilePath) {
        try {
            FileReader reader = new FileReader(azureBlockBlobCredFilePath);
            ObjectMapper objectMapper = new ObjectMapper();
            return (AzureCredentialsConfig)objectMapper.readValue((Reader)reader, AzureCredentialsConfig.class);
        }
        catch (IOException ioException) {
            throw new IllegalArgumentException("Failed to get credential from file: " + azureBlockBlobCredFilePath, ioException);
        }
    }

    static class AzureCredentialsConfig {
        private final String connectionString;
        private final String azureClientId;
        private final String azureTenantId;
        private final String azureClientSecret;

        @JsonCreator
        public AzureCredentialsConfig(@JsonProperty(value="connectionString") String connectionString, @JsonProperty(value="azureClientId") String azureClientId, @JsonProperty(value="azureTenantId") String azureTenantId, @JsonProperty(value="azureClientSecret") String azureClientSecret) {
            this.connectionString = connectionString;
            this.azureClientId = azureClientId;
            this.azureTenantId = azureTenantId;
            this.azureClientSecret = azureClientSecret;
        }

        @JsonProperty
        public String connectionString() {
            return this.connectionString;
        }

        @JsonProperty
        public String azureClientId() {
            return this.azureClientId;
        }

        @JsonProperty
        public String azureTenantId() {
            return this.azureTenantId;
        }

        @JsonProperty
        public String azureClientSecret() {
            return this.azureClientSecret;
        }

        public Boolean connectionStringAuthMethod() {
            return this.connectionString != null;
        }

        public Boolean servicePrincipalWithSecretAuthMethod() {
            return this.azureClientId != null && this.azureTenantId != null && this.azureClientSecret != null;
        }
    }
}

